/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BasisPaymentType;
import noNamespace.CommentType;
import noNamespace.CompetingRenewalType;
import noNamespace.ContactType;
import noNamespace.NonCompetingContType;
import noNamespace.PaymentMethodType;
import noNamespace.ReportTermDetailsType;
import noNamespace.ReportTermType;
import noNamespace.RolodexDetailsType;
import noNamespace.SchoolInfoType;
import noNamespace.SponsorType;
import noNamespace.TemplateDocument;
import noNamespace.TemplateMasterData;
import noNamespace.TemplateStatusType;
import noNamespace.TermDetailsType;
import noNamespace.TermType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.AwardStatus;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateReportTermRecipient;
import org.kuali.kra.award.home.AwardTemplateTerm;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.award.home.Distribution;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.FrequencyBase;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.SponsorTerm;
import org.kuali.kra.printing.util.PrintingUtils;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardTemplateXmlStream
implements XmlStream {
    private static final Log LOG = LogFactory.getLog(AwardTemplateXmlStream.class);
    private BusinessObjectService businessObjectService = null;
    private DateTimeService dateTimeService = null;
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private String previousDescription = "";

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        HashMap<String, XmlObject> awardTemplateXmlStream = new HashMap<String, XmlObject>();
        AwardTemplate awardTemplate = (AwardTemplate)printableBusinessObject;
        TemplateDocument templateDocument = TemplateDocument.Factory.newInstance();
        if (awardTemplate != null) {
            templateDocument.setTemplate(this.getTemplate(awardTemplate));
        }
        awardTemplateXmlStream.put(AwardPrintType.AWARD_TEMPLATE.getAwardPrintType(), (XmlObject)templateDocument);
        return awardTemplateXmlStream;
    }

    private TemplateDocument.Template getTemplate(AwardTemplate awardTemplate) {
        TemplateDocument.Template template = TemplateDocument.Template.Factory.newInstance();
        awardTemplate.refreshNonUpdateableReferences();
        template.setTemplateMaster(this.getTemplateMaster(awardTemplate));
        template.setSchoolInfo(this.getSchoolInfoType());
        template.setCommentArray(this.getCommentType(awardTemplate));
        template.setContactArray(this.getContactType(awardTemplate));
        template.setTermArray(this.getTerms(awardTemplate));
        template.setReportArray(this.getReportTermTypes(awardTemplate));
        return template;
    }

    private TemplateMasterData getTemplateMaster(AwardTemplate awardTemplate) {
        TemplateMasterData templateMasterData = TemplateMasterData.Factory.newInstance();
        templateMasterData.setCurrentDate(this.getDateTimeService().getCurrentCalendar());
        templateMasterData.setDescription(awardTemplate.getDescription());
        templateMasterData.setTemplateCode(awardTemplate.getTemplateCode().intValue());
        if (awardTemplate.getBasisOfPaymentCode() != null) {
            BasisPaymentType basisPayment = templateMasterData.addNewBasisPayment();
            AwardBasisOfPayment awardBasisOfPayment = awardTemplate.getAwardBasisOfPayment();
            if (awardBasisOfPayment != null) {
                basisPayment.setBasisPaymentCode(awardBasisOfPayment.getBasisOfPaymentCode());
                basisPayment.setBasisPaymentDesc(awardBasisOfPayment.getDescription());
            }
        }
        if (awardTemplate.getCompetingRenewalPrpslDueCode() != null) {
            CompetingRenewalType competingRenewal = templateMasterData.addNewCompetingRenewal();
            competingRenewal.setCompetingRenewalCode(awardTemplate.getCompetingRenewalPrpslDueCode());
        }
        if (awardTemplate.getNonCompetingContPrpslDueCode() != null) {
            NonCompetingContType nonCompetingCont = templateMasterData.addNewNonCompetingCont();
            nonCompetingCont.setNonCompetingContCode(awardTemplate.getNonCompetingContPrpslDueCode());
        }
        if (awardTemplate.getMethodOfPaymentCode() != null) {
            AwardMethodOfPayment awardMethodOfPayment = awardTemplate.getAwardMethodOfPayment();
            PaymentMethodType paymentMethod = templateMasterData.addNewPaymentMethod();
            paymentMethod.setPaymentMethodCode(awardMethodOfPayment.getMethodOfPaymentCode());
            paymentMethod.setPaymentMethodDesc(awardMethodOfPayment.getDescription());
        }
        if (awardTemplate.getPrimeSponsorCode() != null) {
            SponsorType sponsorType = templateMasterData.addNewPrimeSponsor();
            Sponsor sponsor = awardTemplate.getPrimeSponsor();
            sponsorType.setSponsorCode(sponsor.getSponsorCode());
            sponsorType.setSponsorName(sponsor.getSponsorName());
        }
        if (awardTemplate.getStatusCode() != null) {
            TemplateStatusType templateStatus = templateMasterData.addNewTemplateStatus();
            AwardStatus awardTemplateStatus = awardTemplate.getAwardTemplateStatus();
            templateStatus.setStatusCode(Integer.parseInt(awardTemplateStatus.getStatusCode()));
            templateStatus.setStatusDesc(awardTemplateStatus.getDescription());
        }
        return templateMasterData;
    }

    private TermType[] getTerms(AwardTemplate awardTemplate) {
        ArrayList<TermType> termTypes = new ArrayList<TermType>();
        for (AwardTemplateTerm awardTemplateTerm : awardTemplate.getAwardSponsorTerms()) {
            TermType termType = TermType.Factory.newInstance();
            this.setTermDetails(termType, awardTemplateTerm);
            termTypes.add(termType);
        }
        return termTypes.toArray(new TermType[0]);
    }

    private void setTermDetails(TermType termType, AwardTemplateTerm awardTemplateTerm) {
        awardTemplateTerm.refreshNonUpdateableReferences();
        SponsorTerm sponsorTerm = awardTemplateTerm.getSponsorTerm();
        if (sponsorTerm != null) {
            if (this.previousDescription.equals("") || !this.previousDescription.equals(awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription())) {
                termType.setDescription(awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription());
                this.previousDescription = awardTemplateTerm.getSponsorTerm().getSponsorTermType().getDescription();
            }
            TermDetailsType termDetails = termType.addNewTermDetails();
            termDetails.setTermCode(Integer.parseInt(sponsorTerm.getSponsorTermCode()));
            termDetails.setTermDescription(sponsorTerm.getDescription());
        }
    }

    private ReportTermType[] getReportTermTypes(AwardTemplate awardTemplate) {
        ArrayList<ReportTermType> reportTermTypes = new ArrayList<ReportTermType>();
        ReportTermType reportTermType = null;
        for (AwardTemplateReportTerm awardTemplateReportTerm : awardTemplate.getTemplateReportTerms()) {
            reportTermType = ReportTermType.Factory.newInstance();
            awardTemplateReportTerm.refreshNonUpdateableReferences();
            ReportClass reportClass = awardTemplateReportTerm.getReportClass();
            if (reportClass != null && reportClass.getDescription() != null) {
                reportTermType.setDescription(reportClass.getDescription());
            }
            reportTermType.setReportTermDetailsArray(this.getReportTermDetails(awardTemplateReportTerm));
            reportTermTypes.add(reportTermType);
        }
        return reportTermTypes.toArray(new ReportTermType[0]);
    }

    private ReportTermDetailsType[] getReportTermDetails(AwardTemplateReportTerm awardTemplateReportTerm) {
        ArrayList<ReportTermDetailsType> reportTermDetailsTypes = new ArrayList<ReportTermDetailsType>();
        ReportTermDetailsType reportTermDetailsType = null;
        reportTermDetailsType = ReportTermDetailsType.Factory.newInstance();
        Date dueDate = awardTemplateReportTerm.getDueDate();
        if (dueDate != null) {
            reportTermDetailsType.setDueDate(this.dateTimeService.getCalendar((java.util.Date)dueDate));
        }
        this.setFrequencyBaseDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setFrequencyDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setOspDistributionDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setReportClassDetails(awardTemplateReportTerm, reportTermDetailsType);
        this.setReportDetails(awardTemplateReportTerm, reportTermDetailsType);
        reportTermDetailsType.setMailCopiesArray(this.getMailCopies(awardTemplateReportTerm));
        reportTermDetailsTypes.add(reportTermDetailsType);
        return reportTermDetailsTypes.toArray(new ReportTermDetailsType[0]);
    }

    private void setReportDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Report report = awardTemplateReportTerm.getReport();
        String reportCode = report.getReportCode();
        String reportDescription = report.getDescription();
        if (reportCode != null) {
            reportTermDetailsType.setReportCode(Integer.valueOf(reportCode).intValue());
        }
        if (reportDescription != null) {
            reportTermDetailsType.setReportCodeDesc(reportDescription);
        }
    }

    private void setReportClassDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        ReportClass reportClass = awardTemplateReportTerm.getReportClass();
        String reportClassCode = reportClass.getReportClassCode();
        String reportClassDescription = reportClass.getDescription();
        if (reportClassCode != null) {
            reportTermDetailsType.setReportClassCode(Integer.valueOf(reportClassCode).intValue());
        }
        if (reportClassDescription != null) {
            reportTermDetailsType.setReportCodeDesc(reportClassDescription);
        }
    }

    private void setOspDistributionDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Distribution distribution;
        String ospDescription;
        String ospDistributionCode = awardTemplateReportTerm.getOspDistributionCode();
        if (ospDistributionCode != null) {
            reportTermDetailsType.setOSPDistributionCode(Integer.valueOf(ospDistributionCode).intValue());
        }
        if ((ospDescription = (distribution = awardTemplateReportTerm.getDistribution()).getDescription()) != null) {
            reportTermDetailsType.setOSPDistributionDesc(ospDescription);
        }
    }

    private void setFrequencyDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        Frequency frequency = awardTemplateReportTerm.getFrequency();
        String frequencyCode = frequency.getFrequencyCode();
        String desription = frequency.getDescription();
        if (frequencyCode != null) {
            reportTermDetailsType.setFrequencyCode(Integer.valueOf(frequencyCode).intValue());
        }
        if (desription != null) {
            reportTermDetailsType.setFrequencyCodeDesc(desription);
        }
    }

    private void setFrequencyBaseDetails(AwardTemplateReportTerm awardTemplateReportTerm, ReportTermDetailsType reportTermDetailsType) {
        String description;
        String frequencyBaseCode = awardTemplateReportTerm.getFrequencyBaseCode();
        if (frequencyBaseCode != null) {
            reportTermDetailsType.setFrequencyBaseCode(Integer.valueOf(frequencyBaseCode).intValue());
        }
        awardTemplateReportTerm.refreshNonUpdateableReferences();
        FrequencyBase frequencyBase = awardTemplateReportTerm.getFrequencyBase();
        if (frequencyBase != null && (description = frequencyBase.getDescription()) != null) {
            reportTermDetailsType.setFrequencyBaseDesc(description);
        }
    }

    private ReportTermDetailsType.MailCopies[] getMailCopies(AwardTemplateReportTerm awardTemplateReportTerm) {
        ArrayList<ReportTermDetailsType.MailCopies> mailCopiesList = new ArrayList<ReportTermDetailsType.MailCopies>();
        ReportTermDetailsType.MailCopies mailCopies = null;
        for (AwardTemplateReportTermRecipient awardTemplateReportTermRecipient : awardTemplateReportTerm.getAwardTemplateReportTermRecipients()) {
            Integer rolodexid;
            Integer numberofmailCopies;
            mailCopies = ReportTermDetailsType.MailCopies.Factory.newInstance();
            awardTemplateReportTermRecipient.refreshNonUpdateableReferences();
            ContactType contactType = awardTemplateReportTermRecipient.getContactType();
            if (contactType != null) {
                String contactTypeCode = contactType.getContactTypeCode();
                String contactTypeDescription = contactType.getDescription();
                if (contactTypeCode != null) {
                    mailCopies.setContactTypeCode(Integer.valueOf(contactTypeCode).intValue());
                }
                if (contactTypeDescription != null) {
                    mailCopies.setContactTypeDesc(contactTypeDescription);
                }
            }
            if ((numberofmailCopies = awardTemplateReportTermRecipient.getNumberOfCopies()) != null) {
                mailCopies.setNumberOfCopies(String.valueOf(numberofmailCopies));
            }
            if ((rolodexid = awardTemplateReportTermRecipient.getRolodexId()) != null) {
                mailCopies.setRolodexId(String.valueOf(rolodexid));
            }
            mailCopiesList.add(mailCopies);
        }
        return mailCopiesList.toArray(new ReportTermDetailsType.MailCopies[0]);
    }

    private noNamespace.ContactType[] getContactType(AwardTemplate awardTemplate) {
        ArrayList<noNamespace.ContactType> contactTypes = new ArrayList<noNamespace.ContactType>();
        noNamespace.ContactType contactType = null;
        for (AwardTemplateContact awardTemplateContact : awardTemplate.getTemplateContacts()) {
            contactType = ContactType.Factory.newInstance();
            awardTemplateContact.refreshNonUpdateableReferences();
            ContactType type = awardTemplateContact.getContactType();
            String contactTypeCode = null;
            String description = null;
            if (type != null) {
                contactTypeCode = type.getContactTypeCode();
                description = type.getDescription();
            }
            if (contactTypeCode != null) {
                contactType.setContactTypeCode(Integer.valueOf(contactTypeCode).intValue());
            }
            if (description != null) {
                contactType.setContactTypeDesc(description);
            }
            this.setRolodexDetails(contactType, awardTemplateContact);
            contactTypes.add(contactType);
        }
        return contactTypes.toArray(new noNamespace.ContactType[0]);
    }

    private void setRolodexDetails(noNamespace.ContactType contactType, AwardTemplateContact awardTemplateContact) {
        Rolodex rolodex;
        if (awardTemplateContact.getRolodexId() != null && (rolodex = awardTemplateContact.getRolodex()) != null) {
            RolodexDetailsType rolodexDetails = contactType.addNewRolodexDetails();
            rolodexDetails.setAddress1(rolodex.getAddressLine1());
            rolodexDetails.setAddress2(rolodex.getAddressLine2());
            rolodexDetails.setAddress3(rolodex.getAddressLine3());
            rolodexDetails.setCity(rolodex.getCity());
            rolodexDetails.setComments(rolodex.getComments());
            rolodexDetails.setCountryCode(rolodex.getCountryCode());
            rolodexDetails.setCountryDescription(rolodex.getCountryCode());
            rolodexDetails.setCounty(rolodex.getCounty());
            rolodexDetails.setEmail(rolodex.getEmailAddress());
            rolodexDetails.setFax(rolodex.getFaxNumber());
            rolodexDetails.setFirstName(rolodex.getFirstName());
            rolodexDetails.setLastName(rolodex.getLastName());
            rolodexDetails.setMiddleName(rolodex.getMiddleName());
            rolodexDetails.setOrganization(rolodex.getOrganization());
            rolodexDetails.setOwnedByUnit(rolodex.getOwnedByUnit());
            if (rolodex.getUnit() != null) {
                rolodexDetails.setOwnedByUnitName(rolodex.getUnit().getUnitName());
            }
            rolodexDetails.setPhoneNumber(rolodex.getPhoneNumber());
            rolodexDetails.setPostalCode(rolodex.getPostalCode());
            rolodexDetails.setPrefix(rolodex.getPrefix());
            rolodexDetails.setRolodexId(rolodex.getRolodexId().toString());
            rolodexDetails.setSponsorCode(rolodex.getSponsorCode());
            if (rolodex.getSponsor() != null) {
                rolodexDetails.setSponsorName(rolodex.getSponsor().getSponsorName());
            }
            rolodexDetails.setStateCode(rolodex.getState());
            rolodexDetails.setStateDescription(rolodex.getSponsorCode());
            rolodexDetails.setSuffix(rolodex.getSuffix());
            rolodexDetails.setTitle(rolodex.getTitle());
        }
    }

    private CommentType[] getCommentType(AwardTemplate awardTemplate) {
        ArrayList<CommentType> commentTypes = new ArrayList<CommentType>();
        List templateComments = awardTemplate.getTemplateComments();
        CommentType commentType = null;
        ArrayList<String> templateCommentList = new ArrayList<String>();
        HashMap<String, String> templateCommentHm = new HashMap<String, String>();
        for (AwardTemplateComment awardTemplateComment : templateComments) {
            String comments;
            String commentTypeCode = awardTemplateComment.getCommentTypeCode();
            AwardTemplate template = awardTemplateComment.getTemplate();
            String description = null;
            if (template != null) {
                awardTemplateComment.refreshReferenceObject("commentType");
                description = awardTemplateComment.getCommentType().getDescription();
                templateCommentList.add(description);
            }
            if ((comments = awardTemplateComment.getComments()) == null || description == null) continue;
            templateCommentHm.put(description, comments);
        }
        Collections.sort(templateCommentList);
        for (int templateComment = 0; templateComment < templateCommentList.size(); ++templateComment) {
            if (templateCommentHm.containsKey(templateCommentList.get(templateComment))) {
                commentType = CommentType.Factory.newInstance();
                String comments = (String)templateCommentHm.get(templateCommentList.get(templateComment));
                String description = templateCommentList.get(templateComment).toString();
                commentType.setDescription(description);
                commentType.setComments(comments);
            }
            commentTypes.add(commentType);
        }
        return commentTypes.toArray(new CommentType[0]);
    }

    private SchoolInfoType getSchoolInfoType() {
        SchoolInfoType schoolInfoType = SchoolInfoType.Factory.newInstance();
        String schoolName = this.getAwardParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getAwardParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private String getAwardParameterValue(String param) {
        String value = null;
        try {
            value = PrintingUtils.getParameterValue((String)param);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

