/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ValidAwardBasisPaymentMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        ValidAwardBasisPayment validAwardBasisPayment = (ValidAwardBasisPayment)document.getNewMaintainableObject().getDataObject();
        if (!document.getNewMaintainableObject().getMaintenanceAction().equals("Delete")) {
            return this.validateUniqueueCodes(validAwardBasisPayment.getAwardType(), validAwardBasisPayment.getBasisOfPayment());
        }
        return true;
    }

    private boolean validateUniqueueCodes(AwardType awardType, AwardBasisOfPayment basisOfPayment) {
        boolean valid = true;
        if (awardType != null && basisOfPayment != null && StringUtils.isNotBlank((String)awardType.getAwardTypeCode().toString()) && StringUtils.isNotBlank((String)basisOfPayment.getBasisOfPaymentCode())) {
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("awardTypeCode", awardType.getAwardTypeCode().toString());
            pkMap.put("basisOfPaymentCode", basisOfPayment.getBasisOfPaymentCode());
            int matchingCount = ((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).countMatching(ValidAwardBasisPayment.class, pkMap);
            if (matchingCount > 0) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.newMaintainableObject.awardTypeCode", "error.awardBasis.exist", new String[]{awardType.getDescription(), basisOfPayment.getDescription()});
                valid = false;
            }
        }
        return valid;
    }
}

