/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.subcontracting.goalsAndExpenditures;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.subcontracting.goalsAndExpenditures.AwardSubcontractingBudgetedGoals;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSubcontractingGoalsExpendituresRule {
    private String awardId;
    private DictionaryValidationService dictionaryValidationService;
    private Lookupable awardLookupable;
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String SUB_PLAN_FLAG = "subPlanFlag";
    private static final String SUB_PLAN_FLAG_VAL = "Y";
    private static final String AWARD_LOOKUPABLE = "awardLookupable";

    public boolean validateAwardNumber(String awardNumber) {
        boolean rulePassed = false;
        String ddEntryName = AwardSubcontractingBudgetedGoals.class.getSimpleName();
        this.getDictionaryValidationService().validateAttributeRequired(ddEntryName, AWARD_NUMBER, (Object)awardNumber, Boolean.valueOf(false), AWARD_NUMBER);
        rulePassed = GlobalVariables.getMessageMap().hasNoErrors();
        if (rulePassed) {
            rulePassed = false;
            this.getDictionaryValidationService().validateAttributeFormat(ddEntryName, AWARD_NUMBER, awardNumber, AWARD_NUMBER);
            rulePassed = GlobalVariables.getMessageMap().hasNoErrors();
        }
        if (rulePassed) {
            rulePassed = false;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(SUB_PLAN_FLAG, SUB_PLAN_FLAG_VAL);
            fieldValues.put(AWARD_NUMBER, awardNumber);
            List awardsFound = this.getAwardLookupable().getSearchResults(fieldValues);
            if (awardsFound != null && !awardsFound.isEmpty()) {
                rulePassed = true;
                this.awardId = ((Award)awardsFound.get(0)).getAwardId().toString();
            } else {
                ErrorReporter reporter = new ErrorReporter();
                reporter.reportError(AWARD_NUMBER, "error.award.subcontracting.goalsAndExpenditures.awardNotFound", new String[]{awardNumber});
            }
        }
        return rulePassed;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public String getAwardId() {
        return this.awardId;
    }

    public void setAwardLookupable(Lookupable awardLookupable) {
        this.awardLookupable = awardLookupable;
    }

    public Lookupable getAwardLookupable() {
        if (this.awardLookupable == null) {
            this.awardLookupable = KNSServiceLocator.getLookupable((String)AWARD_LOOKUPABLE);
            this.awardLookupable.setBusinessObjectClass(Award.class);
        }
        return this.awardLookupable;
    }
}

