/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.AwardLockService;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.AwardTemplateSyncScope;
import org.kuali.kra.award.AwardTemplateSyncService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyBean;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncCreationService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncService;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.award.paymentreports.closeout.CloseoutReportTypeValuesFinder;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.web.struts.action.BudgetParentActionBase;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.AwardPermissionConstants;
import org.kuali.kra.infrastructure.AwardRoleConstants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.service.AwardDirectFandADistributionService;
import org.kuali.kra.service.AwardReportsService;
import org.kuali.kra.service.AwardSponsorTermService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.service.TimeAndMoneyExistenceService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.history.TransactionDetailType;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRuleImpl;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardAction
extends BudgetParentActionBase {
    protected static final String AWARD_ID_PARAMETER_NAME = "awardId";
    private static final String AWARD_NUMBER_SERVICE = "awardNumberService";
    private static final String INITIAL_TRANSACTION_COMMENT = "Initial Time And Money creation transaction";
    private static final String REPORTS_PROPERTY_NAME = "Reports";
    private static final String PAYMENT_INVOICES_PROPERTY_NAME = "Payments and Invoices";
    private static final String COMFIRMATION_PARAM_STRING = "After Award {0} information is synchronized, make sure that the Award Sponsor Contacts information is also synchronized with the same sponsor template. Failing to do so will result in data inconsistency. Are you sure you want to replace current {0} information with selected {1} template information?";
    private static final String SUPER_USER_ACTION_REQUESTS = "superUserActionRequests";
    private ParameterService parameterService;
    private transient AwardBudgetService awardBudgetService;
    private transient AwardService awardService;
    private transient ReportTrackingService reportTrackingService;
    private transient KcNotificationService notificationService;
    private transient SubAwardService subAwardService;
    TimeAndMoneyAwardDateSaveRuleImpl timeAndMoneyAwardDateSaveRuleImpl;
    private static final Log LOG = LogFactory.getLog(AwardAction.class);
    private static final String QUESTION_VERIFY_SYNC = "VerifySync";
    private static final String QUESTION_VERIFY_EMPTY_SYNC = "VerifyEmptySync";
    private static final AwardTemplateSyncScope[] DEFAULT_SCOPES_REQUIRE_VERIFY_FOR_EMPTY = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB, AwardTemplateSyncScope.REPORTS_TAB};
    private static final AwardTemplateSyncScope[] DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.AWARD_PAGE, AwardTemplateSyncScope.COST_SHARE, AwardTemplateSyncScope.PAYMENTS_AND_INVOICES_TAB, AwardTemplateSyncScope.SPONSOR_CONTACTS_TAB, AwardTemplateSyncScope.TERMS_TAB, AwardTemplateSyncScope.REPORTS_TAB, AwardTemplateSyncScope.COMMENTS_TAB};
    private static final int NINE = 9;
    private static final int ZERO = 0;
    private static final String DOCUMENT_ROUTE_QUESTION = "DocRoute";
    private static final String ADD_SYNC_CHANGE_QUESTION = "document.question.awardhierarchy.sync";
    private static final String DEL_SYNC_CHANGE_QUESTION = "document.question.awardhierarchy.sync";

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.cleanUpUserSession();
        ActionForward forward = this.handleDocument(mapping, form, request, response, awardForm);
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        AwardDocument parentSyncAward = this.getAwardSyncService().getAwardLockingHierarchyForSync(awardDocument, GlobalVariables.getUserSession().getPrincipalId());
        if (parentSyncAward != null) {
            KNSGlobalVariables.getMessageList().add("error.award.awardhierarchy.sync.locked", new String[]{parentSyncAward.getDocumentNumber()});
            awardForm.setViewOnly(true);
        }
        this.handlePlaceHolderDocument(awardForm, awardDocument);
        awardForm.initializeFormOrDocumentBasedOnCommand();
        this.setBooleanAwardInMultipleNodeHierarchyOnForm(awardDocument.getAward());
        this.setBooleanAwardHasTandMOrIsVersioned(awardDocument.getAward());
        this.setSubAwardDetails(awardDocument.getAward());
        return forward;
    }

    private void handlePlaceHolderDocument(AwardForm form, AwardDocument awardDocument) {
        if (awardDocument.isPlaceHolderDocument()) {
            Long awardId = form.getPlaceHolderAwardId();
            int currentAwardIndex = -1;
            Award currentAward = null;
            for (Award award : awardDocument.getAwardList()) {
                ++currentAwardIndex;
                if (!ObjectUtils.equals((Object)award.getAwardId(), (Object)awardId)) continue;
                currentAward = award;
                break;
            }
            if (currentAward != null) {
                awardDocument.getAwardList().remove(currentAwardIndex);
                awardDocument.getAwardList().add(0, currentAward);
                form.setViewOnly(true);
            }
        }
    }

    protected void cleanUpUserSession() {
        GlobalVariables.getUserSession().removeObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward actionForward = super.execute(mapping, form, request, response);
        if (awardForm.isAuditActivated()) {
            awardForm.setUnitRulesMessages(this.getUnitRulesMessages(awardForm.getAwardDocument()));
        }
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally((KualiDocumentFormBase)((AwardForm)form));
        }
        return actionForward;
    }

    protected List<String> getUnitRulesMessages(AwardDocument awardDoc) {
        KrmsRulesExecutionService rulesService = (KrmsRulesExecutionService)KraServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(awardDoc.getLeadUnitNumber(), (KrmsRulesContext)awardDoc);
    }

    protected void populateAwardHierarchy(ActionForm form) throws WorkflowException {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        ArrayList order = new ArrayList();
        AwardHierarchyBean helperBean = awardForm.getAwardHierarchyBean();
        AwardHierarchy rootNode = helperBean.getRootNode();
        Map awardHierarchyNodes = helperBean.getAwardHierarchy(rootNode, order);
        HashMap awardHierarchyNodesMap = new HashMap();
        Award currentAward = awardDocument.getAward();
        awardForm.setRootAwardNumber(rootNode.getRootAwardNumber());
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (String str : order) {
            AwardHierarchy tempAwardNode = (AwardHierarchy)awardHierarchyNodes.get(str);
            sb1.append(tempAwardNode.getAwardNumber());
            sb1.append(" ").append("%3A");
            if (this.getVersionHistoryService().findActiveVersion(Award.class, tempAwardNode.getAwardNumber()) == null) continue;
            sb2.append(tempAwardNode.getAwardNumber());
            sb2.append(" ").append("%3A");
        }
        for (int i = 0; i < helperBean.getMaxAwardNumber(); ++i) {
            AwardHierarchyTempObject temp = (AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(i);
            temp.setSelectBox1(sb1.toString());
            temp.setSelectBox2(sb2.toString());
        }
    }

    protected TimeAndMoneyExistenceService getTimeAndMoneyExistenceService() {
        return (TimeAndMoneyExistenceService)KraServiceLocator.getService(TimeAndMoneyExistenceService.class);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AwardForm awardForm = (AwardForm)form;
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            forward = super.approve(mapping, form, request, response);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward("basic");
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", "AwardDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    protected ActionForward submitAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward forward = mapping.findForward("basic");
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            forward = super.route(mapping, form, request, response);
            this.populateAwardHierarchy((ActionForm)awardForm);
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", "AwardDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        awardForm.setAuditActivated(true);
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        AuditActionHelper.ValidationState status = new AuditActionHelper().isValidSubmission((KualiDocumentFormBase)awardForm, true);
        if (status == AuditActionHelper.ValidationState.WARNING) {
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
            }
            if (DOCUMENT_ROUTE_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                return this.submitAward(mapping, form, request, response);
            }
            return forward;
        }
        if (status == AuditActionHelper.ValidationState.OK) {
            return this.submitAward(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return forward;
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        AwardForm awardForm = (AwardForm)form;
        if (this.getTimeAndMoneyExistenceService().validateTimeAndMoneyRule(awardForm.getAwardDocument().getAward(), awardForm.getAwardHierarchyBean().getRootNode().getAwardNumber())) {
            awardForm.setAuditActivated(true);
            AuditActionHelper.ValidationState status = new AuditActionHelper().isValidSubmission((KualiDocumentFormBase)awardForm, true);
            if (status == AuditActionHelper.ValidationState.ERROR) {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
                forward = mapping.findForward("basic");
            } else {
                forward = super.blanketApprove(mapping, form, request, response);
            }
        } else {
            this.getTimeAndMoneyExistenceService().addAwardVersionErrorMessage();
            forward = mapping.findForward("basic");
        }
        String routeHeaderId = awardForm.getDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "awardActions", "AwardDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionForward holdingPageForward = mapping.findForward("kraHoldingPage");
        return this.routeToHoldingPage(basicForward, forward, holdingPageForward, returnLocation);
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardHierarchyBean bean;
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.checkAwardNumber(award);
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        if (award.getAwardApprovedSubawards() != null || !award.getAwardApprovedSubawards().isEmpty()) {
            award.setSubContractIndicator("Y");
        } else {
            award.setSubContractIndicator("N");
        }
        if (award.getAwardTransferringSponsors() != null || !award.getAwardTransferringSponsors().isEmpty()) {
            award.setTransferSponsorIndicator("Y");
        } else {
            award.setTransferSponsorIndicator("N");
        }
        if (award.getKeywords() != null || !award.getKeywords().isEmpty()) {
            award.setScienceCodeIndicator("Y");
        } else {
            award.setScienceCodeIndicator("N");
        }
        forward = super.save(mapping, form, request, response);
        if (awardForm.getMethodToCall().equals("save") && awardForm.isAuditActivated()) {
            forward = mapping.findForward("awardActions");
        }
        if ((bean = awardForm.getAwardHierarchyBean()).saveHierarchyChanges()) {
            ArrayList order = new ArrayList();
            awardForm.setAwardHierarchyNodes(bean.getAwardHierarchy(bean.getRootNode().getAwardNumber(), order));
        }
        for (AwardSyncPendingChangeBean pendingChange : awardForm.getAwardSyncBean().getConfirmedPendingChanges()) {
            pendingChange.getObject().refresh();
            this.getAwardSyncCreationService().addAwardSyncChange(award, pendingChange);
        }
        this.getBusinessObjectService().save(award.getSyncChanges());
        awardForm.getAwardSyncBean().getConfirmedPendingChanges().clear();
        this.getReportTrackingService().generateReportTrackingAndSave(award, false);
        return forward;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        this.getReportTrackingService().refreshReportTracking(awardForm.getAwardDocument().getAward());
        return actionForward;
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.getViewFundingSource()) {
            return mapping.findForward("closePage");
        }
        return super.close(mapping, form, request, response);
    }

    protected Award getAward(ActionForm form) {
        return this.getAwardDocument(form).getAward();
    }

    protected AwardDocument getAwardDocument(ActionForm form) {
        return ((AwardForm)form).getAwardDocument();
    }

    protected void checkAwardNumber(Award award) {
        if ("000000-00000".equals(award.getAwardNumber())) {
            AwardNumberService awardNumberService = this.getAwardNumberService();
            String awardNumber = awardNumberService.getNextAwardNumber();
            award.setAwardNumber(awardNumber);
        }
        if ("000000-00000".equals(((AwardAmountInfo)award.getAwardAmountInfos().get(0)).getAwardNumber())) {
            ((AwardAmountInfo)award.getAwardAmountInfos().get(0)).setAwardNumber(award.getAwardNumber());
        }
        for (AwardApprovedSubaward approvedSubaward : award.getAwardApprovedSubawards()) {
            if (!"000000-00000".equals(approvedSubaward.getAwardNumber())) continue;
            approvedSubaward.setAwardNumber(award.getAwardNumber());
        }
        for (AwardComment comment : award.getAwardComments()) {
            comment.setAward(award);
        }
        for (AwardCustomData customData : award.getAwardCustomDataList()) {
            customData.setAward(award);
        }
    }

    protected AwardNumberService getAwardNumberService() {
        return (AwardNumberService)KraServiceLocator.getService(AwardNumberService.class);
    }

    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        String autoGenerate;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        this.createInitialAwardUsers(awardForm.getAwardDocument().getAward());
        this.populateStaticCloseoutReports(awardForm);
        String userId = GlobalVariables.getUserSession().getPrincipalName();
        Award award = awardDocument.getAward();
        this.getAwardService().updateAwardSequenceStatus(award, VersionStatus.PENDING);
        this.getVersionHistoryService().updateVersionHistory((SequenceOwner)award, VersionStatus.PENDING, userId);
        if (this.isNewAward(awardForm) && award.getAwardEffectiveDate() != null && !StringUtils.equalsIgnoreCase((String)(autoGenerate = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "AUTO_GENERATE_TIME_AND_MONEY_FUNDS_DIST_PERIODS")), (String)"N")) {
            AwardDirectFandADistributionService awardDirectFandADistributionService = this.getAwardDirectFandADistributionService();
            awardForm.getAwardDocument().getAward().setAwardDirectFandADistributions(awardDirectFandADistributionService.generateDefaultAwardDirectFandADistributionPeriods(awardForm.getAwardDocument().getAward()));
        }
        if (!awardForm.getAwardDocument().isDocumentSaveAfterVersioning()) {
            awardForm.getAwardHierarchyBean().createDefaultAwardHierarchy();
            awardForm.getAwardHierarchyBean().saveHierarchyChanges();
        }
    }

    protected void createInitialAwardUsers(Award award) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        if (!kraAuthService.hasRole(userId, "KC-AWARD", AwardRoleConstants.AWARD_MODIFIER.getAwardRole())) {
            kraAuthService.addRole(userId, AwardRoleConstants.AWARD_MODIFIER.getAwardRole(), (Permissionable)award);
        }
    }

    protected void populateStaticCloseoutReports(AwardForm form) {
        CloseoutReportTypeValuesFinder closeoutReportTypeValuesFinder = new CloseoutReportTypeValuesFinder();
        form.getAwardCloseoutBean().addAwardCloseoutStaticItems(closeoutReportTypeValuesFinder.getKeyValues());
    }

    protected AwardHierarchyService getAwardHierarchyService() {
        return (AwardHierarchyService)KraServiceLocator.getService(AwardHierarchyService.class);
    }

    protected boolean isValidSave(AwardForm awardForm) {
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        String leadUnitNumber = awardDocument.getLeadUnitNumber();
        if (StringUtils.isNotEmpty((String)leadUnitNumber) && this.checkNoMoreThanOnePI(awardDocument.getAward())) {
            String userId = GlobalVariables.getUserSession().getPrincipalId();
            UnitAuthorizationService authService = (UnitAuthorizationService)KraServiceLocator.getService(UnitAuthorizationService.class);
            return authService.hasMatchingQualifiedUnits(userId, "KC-AWARD", AwardPermissionConstants.MODIFY_AWARD.getAwardPermission(), leadUnitNumber);
        }
        return false;
    }

    private boolean checkNoMoreThanOnePI(Award award) {
        boolean valid;
        int piCount = 0;
        int counter = 0;
        ArrayList<String> fields = new ArrayList<String>();
        for (AwardPerson p : award.getProjectPersons()) {
            if (p.isPrincipalInvestigator()) {
                ++piCount;
                fields.add("projectPersonnelBean.projectPersonnel[" + counter + "].contactRoleCode");
            }
            ++counter;
        }
        boolean bl = valid = piCount <= 1;
        if (!valid) {
            for (String field : fields) {
                GlobalVariables.getMessageMap().putError(field, "error.awardProjectPerson.pi.exists", new String[0]);
            }
        }
        return valid;
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public String buildForwardStringForActionListCommand(String forwardPath, String docIdRequestParameter) {
        StringBuilder sb = new StringBuilder();
        sb.append(forwardPath);
        sb.append("?");
        sb.append("docId");
        sb.append("=");
        sb.append(docIdRequestParameter);
        return sb.toString();
    }

    public ActionForward home(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = (AwardDocument)awardForm.getDocument();
        this.setBooleanAwardInMultipleNodeHierarchyOnForm(awardDocument.getAward());
        this.setBooleanAwardHasTandMOrIsVersioned(awardDocument.getAward());
        AwardAmountInfoService awardAmountInfoService = (AwardAmountInfoService)KraServiceLocator.getService(AwardAmountInfoService.class);
        int index = awardAmountInfoService.fetchIndexOfAwardAmountInfoWithHighestTransactionId(awardDocument.getAward().getAwardAmountInfos());
        return mapping.findForward("home");
    }

    public void setBooleanAwardInMultipleNodeHierarchyOnForm(Award award) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        String awardNumber = award.getAwardNumber();
        fieldValues.put("awardNumber", awardNumber);
        fieldValues.put("active", Boolean.TRUE);
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        List awardHierarchies = (List)businessObjectService.findMatching(AwardHierarchy.class, fieldValues);
        if (awardHierarchies.size() == 0) {
            award.setAwardInMultipleNodeHierarchy(false);
        } else {
            HashMap<String, Object> newFieldValues = new HashMap<String, Object>();
            String rootAwardNumber = ((AwardHierarchy)awardHierarchies.get(0)).getRootAwardNumber();
            newFieldValues.put("rootAwardNumber", rootAwardNumber);
            newFieldValues.put("active", Boolean.TRUE);
            int matchingValues = businessObjectService.countMatching(AwardHierarchy.class, newFieldValues);
            if (matchingValues > 1) {
                award.setAwardInMultipleNodeHierarchy(true);
            } else {
                award.setAwardInMultipleNodeHierarchy(false);
            }
        }
    }

    public void setBooleanAwardHasTandMOrIsVersioned(Award award) {
        boolean previousVersionHasBeenEditedInTandMDocument = false;
        List awardHistory = this.getVersionHistoryService().findVersionHistory(Award.class, award.getAwardNumber());
        if (awardHistory.size() > 1) {
            if (award.getSequenceNumber() == 1 && award.getAwardAmountInfos().size() > 2) {
                previousVersionHasBeenEditedInTandMDocument = true;
            } else if (award.getSequenceNumber() > 1 && award.getAwardAmountInfos().size() > 1) {
                previousVersionHasBeenEditedInTandMDocument = true;
            }
        }
        award.setAwardHasAssociatedTandMOrIsVersioned(previousVersionHasBeenEditedInTandMDocument);
    }

    public ActionForward contacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SponsorService sponsorService = this.getSponsorService();
        Award award = this.getAward(form);
        AwardForm awardForm = (AwardForm)form;
        award.initCentralAdminContacts();
        return mapping.findForward("contacts");
    }

    public ActionForward commitments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("commitments");
    }

    public ActionForward timeAndMoney(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (!(awardForm.getEditingMode().containsKey("viewOnly") && !awardForm.getEditingMode().containsKey("fullEntry") || awardDocument.getDocumentHeader().getWorkflowDocument().isFinal())) {
            this.save(mapping, form, request, response);
        }
        this.timeAndMoneyAwardDateSaveRuleImpl = new TimeAndMoneyAwardDateSaveRuleImpl();
        this.timeAndMoneyAwardDateSaveRuleImpl.enforceAwardStartDatePopulated(awardDocument.getAward());
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
            boolean firstTimeAndMoneyDocCreation = Boolean.TRUE;
            TransactionDetail transactionDetail = null;
            this.populateAwardHierarchy(form);
            Award currentAward = awardDocument.getAward();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            String rootAwardNumber = ((AwardHierarchy)awardForm.getAwardHierarchyNodes().get(currentAward.getAwardNumber())).getRootAwardNumber();
            fieldValues.put("rootAwardNumber", rootAwardNumber);
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            List timeAndMoneyDocuments = (List)businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues);
            Collections.sort(timeAndMoneyDocuments);
            Award rootAward = this.getAwardVersionService().getWorkingAwardVersion(rootAwardNumber);
            AwardAmountInfo rootAAI = rootAward.getLastAwardAmountInfo();
            TimeAndMoneyDocument timeAndMoneyDocument = this.getLastFinalTandMDocument(timeAndMoneyDocuments);
            if (timeAndMoneyDocuments.size() > 0 && timeAndMoneyDocument != null) {
                firstTimeAndMoneyDocCreation = Boolean.FALSE;
            }
            if (firstTimeAndMoneyDocCreation) {
                timeAndMoneyDocument = (TimeAndMoneyDocument)documentService.getNewDocument(TimeAndMoneyDocument.class);
                timeAndMoneyDocument.getDocumentHeader().setDocumentDescription("timeandmoney document");
                timeAndMoneyDocument.setRootAwardNumber(rootAwardNumber);
                timeAndMoneyDocument.setAwardNumber(rootAward.getAwardNumber());
                timeAndMoneyDocument.setAward(rootAward);
                AwardAmountTransaction aat = new AwardAmountTransaction();
                aat.setAwardNumber("000000-00000");
                aat.setDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                aat.setTransactionTypeCode(Integer.valueOf(9));
                aat.setAwardNumber(rootAward.getAwardNumber());
                transactionDetail = this.addTransactionDetails("000000-00000", rootAward.getAwardNumber(), rootAward.getSequenceNumber(), timeAndMoneyDocument.getDocumentNumber(), INITIAL_TRANSACTION_COMMENT, rootAward);
                if (rootAward.getAwardAmountInfos().size() < 2) {
                    this.addNewAwardAmountInfoForInitialTransaction(rootAward, timeAndMoneyDocument.getDocumentNumber());
                } else {
                    rootAward.getLastAwardAmountInfo().setTimeAndMoneyDocumentNumber(timeAndMoneyDocument.getDocumentNumber());
                    this.getBusinessObjectService().save((PersistableBusinessObject)rootAward);
                }
                timeAndMoneyDocument.getAwardAmountTransactions().add(aat);
                documentService.saveDocument((Document)timeAndMoneyDocument);
                this.getBusinessObjectService().save((PersistableBusinessObject)transactionDetail);
            }
            String routeHeaderId = timeAndMoneyDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
            String forward = this.buildForwardUrl(routeHeaderId);
            actionForward = new ActionForward(forward, true);
            GlobalVariables.getUserSession().addObject("returnToAwardDocument-" + timeAndMoneyDocument.getDocumentNumber(), (Object)awardDocument.getDocumentNumber());
        } else {
            actionForward = mapping.findForward("basic");
        }
        return actionForward;
    }

    protected TimeAndMoneyDocument getLastFinalTandMDocument(List<TimeAndMoneyDocument> timeAndMoneyDocuments) throws WorkflowException {
        TimeAndMoneyDocument returnVal = null;
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        while (timeAndMoneyDocuments.size() > 0) {
            TimeAndMoneyDocument docWithWorkFlowData = (TimeAndMoneyDocument)documentService.getByDocumentHeaderId(timeAndMoneyDocuments.get(timeAndMoneyDocuments.size() - 1).getDocumentNumber());
            if (docWithWorkFlowData.getDocumentHeader().getWorkflowDocument().isCanceled()) {
                timeAndMoneyDocuments.remove(timeAndMoneyDocuments.size() - 1);
                continue;
            }
            returnVal = docWithWorkFlowData;
            break;
        }
        return returnVal;
    }

    protected TransactionDetail addTransactionDetails(String sourceAwardNumber, String destinationAwardNumber, Integer sequenceNumber, String documentNumber, String commentsString, Award rootAward) {
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setSourceAwardNumber(sourceAwardNumber);
        transactionDetail.setSequenceNumber(sequenceNumber);
        transactionDetail.setDestinationAwardNumber(destinationAwardNumber);
        if (this.isDirectIndirectViewEnabled()) {
            transactionDetail.setAnticipatedAmount((KualiDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractKualiDecimal)rootAward.getAnticipatedTotalIndirect()));
            transactionDetail.setAnticipatedDirectAmount(rootAward.getAnticipatedTotalDirect());
            transactionDetail.setAnticipatedIndirectAmount(rootAward.getAnticipatedTotalIndirect());
            transactionDetail.setObligatedAmount((KualiDecimal)rootAward.getObligatedTotalDirect().add((AbstractKualiDecimal)rootAward.getObligatedTotalIndirect()));
            transactionDetail.setObligatedDirectAmount(rootAward.getObligatedTotalDirect());
            transactionDetail.setObligatedIndirectAmount(rootAward.getObligatedTotalIndirect());
        } else {
            transactionDetail.setAnticipatedAmount(rootAward.getAnticipatedTotal());
            transactionDetail.setAnticipatedDirectAmount(rootAward.getAnticipatedTotal());
            transactionDetail.setAnticipatedIndirectAmount(new KualiDecimal(0));
            transactionDetail.setObligatedAmount(rootAward.getObligatedTotal());
            transactionDetail.setObligatedDirectAmount(rootAward.getObligatedTotal());
            transactionDetail.setObligatedIndirectAmount(new KualiDecimal(0));
        }
        transactionDetail.setAwardNumber(rootAward.getAwardNumber());
        transactionDetail.setTransactionId(new Long(0L));
        transactionDetail.setTimeAndMoneyDocumentNumber(documentNumber);
        transactionDetail.setComments(commentsString);
        transactionDetail.setTransactionDetailType(TransactionDetailType.PRIMARY.toString());
        return transactionDetail;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            returnValue = true;
        }
        return returnValue;
    }

    private void addNewAwardAmountInfoForInitialTransaction(Award rootAward, String documentNumber) {
        AwardAmountInfo rootAwardAmountInfo = rootAward.getLastAwardAmountInfo();
        AwardAmountInfo newAwardAmountInfo = new AwardAmountInfo();
        newAwardAmountInfo.setAwardNumber(rootAward.getAwardNumber());
        newAwardAmountInfo.setSequenceNumber(rootAward.getSequenceNumber());
        newAwardAmountInfo.setFinalExpirationDate(rootAwardAmountInfo.getFinalExpirationDate());
        newAwardAmountInfo.setCurrentFundEffectiveDate(rootAwardAmountInfo.getCurrentFundEffectiveDate());
        newAwardAmountInfo.setObligationExpirationDate(rootAwardAmountInfo.getObligationExpirationDate());
        newAwardAmountInfo.setTimeAndMoneyDocumentNumber(documentNumber);
        newAwardAmountInfo.setTransactionId(null);
        newAwardAmountInfo.setAward(rootAward);
        if (this.isDirectIndirectViewEnabled()) {
            newAwardAmountInfo.setAmountObligatedToDate((KualiDecimal)rootAward.getObligatedTotalDirect().add((AbstractKualiDecimal)rootAward.getObligatedTotalIndirect()));
            newAwardAmountInfo.setObligatedTotalDirect(rootAward.getObligatedTotalDirect());
            newAwardAmountInfo.setObligatedTotalIndirect(rootAward.getObligatedTotalIndirect());
            newAwardAmountInfo.setObligatedChange(rootAwardAmountInfo.getObligatedChange());
            newAwardAmountInfo.setObligatedChangeDirect(rootAwardAmountInfo.getObligatedTotalDirect());
            newAwardAmountInfo.setObligatedChangeIndirect(rootAwardAmountInfo.getObligatedTotalIndirect());
            newAwardAmountInfo.setAnticipatedChange(rootAwardAmountInfo.getAnticipatedChange());
            newAwardAmountInfo.setAnticipatedTotalAmount((KualiDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractKualiDecimal)rootAward.getAnticipatedTotalIndirect()));
            newAwardAmountInfo.setAnticipatedTotalDirect(rootAward.getAnticipatedTotalDirect());
            newAwardAmountInfo.setAnticipatedTotalIndirect(rootAward.getAnticipatedTotalIndirect());
            newAwardAmountInfo.setAnticipatedChangeDirect(rootAwardAmountInfo.getAnticipatedTotalDirect());
            newAwardAmountInfo.setAnticipatedChangeIndirect(rootAwardAmountInfo.getAnticipatedTotalIndirect());
            newAwardAmountInfo.setObliDistributableAmount((KualiDecimal)rootAward.getObligatedTotalDirect().add((AbstractKualiDecimal)rootAward.getObligatedTotalIndirect()));
            newAwardAmountInfo.setAntDistributableAmount((KualiDecimal)rootAward.getAnticipatedTotalDirect().add((AbstractKualiDecimal)rootAward.getAnticipatedTotalIndirect()));
        } else {
            newAwardAmountInfo.setAmountObligatedToDate(rootAwardAmountInfo.getAmountObligatedToDate());
            newAwardAmountInfo.setObligatedTotalDirect(rootAward.getObligatedTotalDirect());
            newAwardAmountInfo.setObligatedTotalIndirect(rootAward.getObligatedTotalIndirect());
            newAwardAmountInfo.setObligatedChange(rootAwardAmountInfo.getObligatedChange());
            newAwardAmountInfo.setObligatedChangeDirect(rootAwardAmountInfo.getObligatedChangeDirect());
            newAwardAmountInfo.setObligatedChangeIndirect(rootAwardAmountInfo.getObligatedChangeIndirect());
            newAwardAmountInfo.setAnticipatedChange(rootAwardAmountInfo.getAnticipatedChange());
            newAwardAmountInfo.setAnticipatedTotalAmount(rootAward.getAnticipatedTotal());
            newAwardAmountInfo.setAnticipatedTotalDirect(rootAward.getAnticipatedTotalDirect());
            newAwardAmountInfo.setAnticipatedTotalIndirect(rootAward.getAnticipatedTotalIndirect());
            newAwardAmountInfo.setAnticipatedChangeDirect(rootAwardAmountInfo.getAnticipatedChangeDirect());
            newAwardAmountInfo.setAnticipatedChangeIndirect(rootAwardAmountInfo.getAnticipatedChangeIndirect());
            newAwardAmountInfo.setObliDistributableAmount(rootAward.getObligatedTotal());
            newAwardAmountInfo.setAntDistributableAmount(rootAward.getAnticipatedTotal());
        }
        newAwardAmountInfo.setOriginatingAwardVersion(rootAward.getSequenceNumber());
        rootAward.getAwardAmountInfos().add(newAwardAmountInfo);
        this.getBusinessObjectService().save((PersistableBusinessObject)rootAward);
    }

    public List<Award> getAwardVersions(String awardNumber) {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        List awards = (List)businessObjectService.findMatchingOrderBy(Award.class, this.getHashMapToFindActiveAward(awardNumber), "sequenceNumber", true);
        return awards;
    }

    public AwardVersionService getAwardVersionService() {
        return (AwardVersionService)KraServiceLocator.getService(AwardVersionService.class);
    }

    public ActionForward openWindow(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String documentNumber = request.getParameter("awardDocumentNumber");
        String awardNumber = request.getParameter("awardNumber");
        Award award = this.getActiveAwardVersion(awardNumber);
        AwardForm awardForm = (AwardForm)form;
        awardForm.setCurrentAwardNumber(awardNumber);
        awardForm.setCurrentSeqNumber(award.getSequenceNumber().toString());
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        AwardDocument awardDocument = (AwardDocument)documentService.getByDocumentHeaderId(documentNumber);
        awardDocument.setAward(award);
        awardForm.setDocument((Document)awardDocument);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    protected Award getActiveAwardVersion(String goToAwardNumber) {
        VersionHistoryService vhs = (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
        VersionHistory vh = vhs.findActiveVersion(Award.class, goToAwardNumber);
        Award award = null;
        if (vh != null) {
            award = (Award)vh.getSequenceOwner();
        } else {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            award = (Award)((List)businessObjectService.findMatching(Award.class, this.getHashMapToFindActiveAward(goToAwardNumber))).get(0);
        }
        return award;
    }

    private Map<String, String> getHashMapToFindActiveAward(String goToAwardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("awardNumber", goToAwardNumber);
        return map;
    }

    protected KraWorkflowService getKraWorkflowService() {
        return (KraWorkflowService)KraServiceLocator.getService(KraWorkflowService.class);
    }

    public boolean isNewAward(AwardForm awardForm) {
        return awardForm.getAwardDocument().getAward().getAwardDirectFandADistributions().size() == 0;
    }

    protected AwardDirectFandADistributionService getAwardDirectFandADistributionService() {
        return (AwardDirectFandADistributionService)KraServiceLocator.getService(AwardDirectFandADistributionService.class);
    }

    public ActionForward paymentReportsAndTerms(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        this.setReportsAndTermsOnAwardForm(awardForm);
        return mapping.findForward("paymentReportsAndTerms");
    }

    protected void setReportsAndTermsOnAwardForm(AwardForm awardForm) {
        AwardSponsorTermService awardSponsorTermService = this.getAwardSponsorTermService();
        List sponsorTermTypes = awardSponsorTermService.retrieveSponsorTermTypesToAwardFormForPanelHeaderDisplay();
        awardForm.getSponsorTermFormHelper().setSponsorTermTypes(sponsorTermTypes);
        awardForm.getSponsorTermFormHelper().setNewSponsorTerms(awardSponsorTermService.getEmptyNewSponsorTerms(sponsorTermTypes));
        AwardReportsService awardReportsService = (AwardReportsService)KraServiceLocator.getService(AwardReportsService.class);
        Map initializedObjects = awardReportsService.initializeObjectsForReportsAndPayments(awardForm.getAwardDocument().getAward());
        awardForm.setReportClasses((List)initializedObjects.get("reportClasses"));
        awardForm.getAwardReportsBean().setNewAwardReportTerms((List)initializedObjects.get("newAwardReportTermList"));
        awardForm.getAwardReportsBean().setNewAwardReportTermRecipients((List)initializedObjects.get("newAwardReportTermRecipientsList"));
        awardForm.setReportClassForPaymentsAndInvoices((ReportClass)initializedObjects.get("reportClassForPaymentsAndInvoicesPanel"));
        awardForm.buildReportTrackingBeans();
    }

    protected AwardSponsorTermService getAwardSponsorTermService() {
        return (AwardSponsorTermService)KraServiceLocator.getService(AwardSponsorTermService.class);
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((AwardForm)form).getSpecialReviewHelper().prepareView();
        return mapping.findForward("specialReview");
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getCustomDataHelper().prepareCustomData();
        return mapping.findForward("customData");
    }

    public ActionForward questions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("questions");
    }

    public ActionForward permissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((AwardForm)form).getPermissionsHelper().prepareView();
        return mapping.findForward("permissions");
    }

    public ActionForward notesAndAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardCommentBean().setAwardCommentScreenDisplayTypesOnForm();
        awardForm.getAwardCommentBean().setAwardCommentHistoryFlags();
        return mapping.findForward("notesAndAttachments");
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.getDocument().getDocumentNumber() == null) {
            this.loadDocumentInForm(request, awardForm);
        }
        awardForm.getMedusaBean().setMedusaViewRadio("0");
        awardForm.getMedusaBean().setModuleName("award");
        awardForm.getMedusaBean().setModuleIdentifier(awardForm.getAwardDocument().getAward().getAwardId());
        awardForm.getMedusaBean().generateParentNodes();
        return mapping.findForward("medusa");
    }

    public ActionForward awardActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        if (StringUtils.isNotEmpty((String)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, awardForm);
            WorkflowDocument workflowDoc = awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument();
            if (workflowDoc != null) {
                awardForm.setDocTypeName(workflowDoc.getDocumentTypeName());
            }
            request.setAttribute("selectedAwardNumber", (Object)awardForm.getAwardDocument().getAward().getAwardNumber());
        }
        this.populateAwardHierarchy(form);
        return mapping.findForward("awardActions");
    }

    public ActionForward budgets(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        this.getAwardBudgetService().populateBudgetLimitSummary(awardForm.getBudgetLimitSummary(), awardForm.getAwardDocument());
        return mapping.findForward("budgets");
    }

    ActionForward handleDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, AwardForm awardForm) throws Exception {
        ActionForward forward = null;
        String command = awardForm.getCommand();
        if ("displayActionListInlineView".equals(command)) {
            this.loadDocumentInForm(request, awardForm);
            String docIdRequestParameter = request.getParameter("docId");
            ActionForward baseForward = mapping.findForward("copyProposal");
            forward = new ActionForward(this.buildForwardStringForActionListCommand(baseForward.getPath(), awardForm.getDocument().getDocumentNumber()));
        } else if ("awardActions".equals(command)) {
            this.loadDocument((KualiDocumentFormBase)awardForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("awardActions".equals(command)) {
            forward = this.awardActions(mapping, (ActionForm)awardForm, request, response);
        }
        return forward;
    }

    protected void loadDocument(KualiDocumentFormBase kualiForm) throws WorkflowException {
        super.loadDocument(kualiForm);
        Award award = ((AwardForm)kualiForm).getAwardDocument().getAward();
        award.setSponsorNihMultiplePi(this.getSponsorService().isSponsorNihMultiplePi((Sponsorable)award));
    }

    protected void loadDocumentInForm(HttpServletRequest request, AwardForm awardForm) throws WorkflowException {
        String docIdRequestParameter = request.getParameter("docId");
        AwardDocument retrievedDocument = (AwardDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
        awardForm.setDocument((Document)retrievedDocument);
        request.setAttribute("docId", (Object)docIdRequestParameter);
        this.handlePlaceHolderDocument(awardForm, retrievedDocument);
    }

    protected DocumentService getDocumentService() {
        return KRADServiceLocatorWeb.getDocumentService();
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward syncAwardTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardTemplateSyncService awardTemplateSyncService = (AwardTemplateSyncService)KraServiceLocator.getService(AwardTemplateSyncService.class);
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        String syncScopes = this.getSyncScopesString(request);
        System.err.println("syncScopes: " + syncScopes);
        if (awardDocument.getAward().getTemplateCode() == null || awardDocument.getAward().getAwardTemplate() == null) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError(StringUtils.isBlank((String)syncScopes) ? "document.award.awardTemplate" : String.format("document.award.awardTemplate.%s", StringUtils.substring((String)syncScopes, (int)1)), "error.award.sponsor.template.notFound", new String[0]);
            awardForm.setOldTemplateCode(null);
            awardForm.setTemplateLookup(false);
            return mapping.findForward("basic");
        }
        String question = request.getParameter("questionIndex");
        if (question != null) {
            return this.processSyncAward(mapping, (ActionForm)awardForm, request, response);
        }
        awardForm.setCurrentSyncScopes(null);
        awardForm.setSyncRequiresConfirmationMap(null);
        if (StringUtils.isNotBlank((String)syncScopes) && syncScopes.length() > 1 && syncScopes.indexOf(":") > -1) {
            String[] scopeStrings = StringUtils.split((String)StringUtils.substringAfter((String)syncScopes, (String)":"));
            AwardTemplateSyncScope[] scopes = new AwardTemplateSyncScope[scopeStrings.length];
            for (int i = 0; i < scopeStrings.length; ++i) {
                scopes[i] = Enum.valueOf(AwardTemplateSyncScope.class, scopeStrings[i]);
            }
            awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(scopes, awardDocument, false, false));
            awardForm.setCurrentSyncScopes(scopes);
        } else {
            awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES, awardDocument, false, false));
            awardForm.setCurrentSyncScopes(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES);
        }
        return this.processSyncAward(mapping, form, request, response);
    }

    private Map<AwardTemplateSyncScope, Boolean> generateScopeRequiresConfirmationMap(AwardTemplateSyncScope[] scopes, AwardDocument awardDocument, boolean skipCheck, boolean defaultValue) {
        AwardTemplateSyncService awardTemplateSyncService = (AwardTemplateSyncService)KraServiceLocator.getService(AwardTemplateSyncService.class);
        HashMap<AwardTemplateSyncScope, Boolean> requiresQuestionMap = new HashMap<AwardTemplateSyncScope, Boolean>();
        for (AwardTemplateSyncScope scope : scopes) {
            if (skipCheck) {
                requiresQuestionMap.put(scope, defaultValue);
                continue;
            }
            if (awardTemplateSyncService.syncWillAlterData(awardDocument, scope)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("%s:%s", scope, true));
                }
                requiresQuestionMap.put(scope, true);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)String.format("%s:%s", scope, false));
            }
            requiresQuestionMap.put(scope, false);
        }
        return requiresQuestionMap;
    }

    public ActionForward fullSyncToAwardTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        if (awardDocument.getAward().getTemplateCode() == null) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("document.award.awardTemplate", "error.award.templateCode.notFound", new String[0]);
            awardForm.setOldTemplateCode(null);
            awardForm.setTemplateLookup(false);
            return mapping.findForward("basic");
        }
        awardDocument.getAward().refreshReferenceObject("awardTemplate");
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        boolean proceedToProcessSyncAward = true;
        if (question == null) {
            AwardTemplateSyncScope[] scopes = new AwardTemplateSyncScope[]{AwardTemplateSyncScope.FULL};
            HashMap<AwardTemplateSyncScope, Boolean> confirmMap = new HashMap<AwardTemplateSyncScope, Boolean>();
            confirmMap.put(AwardTemplateSyncScope.FULL, true);
            awardForm.setCurrentSyncScopes(scopes);
            awardForm.setSyncRequiresConfirmationMap(confirmMap);
        } else if (question != null && ("VerifySync:" + AwardTemplateSyncScope.FULL).equals(question)) {
            if ("0".equals(buttonClicked)) {
                if (awardDocument.getAward().getSequenceNumber() > 1) {
                    awardForm.setCurrentSyncScopes(new AwardTemplateSyncScope[0]);
                    proceedToProcessSyncAward = false;
                    awardForm.setTemplateLookup(false);
                    awardForm.setOldTemplateCode(null);
                } else {
                    awardForm.setCurrentSyncScopes(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES);
                    awardForm.setSyncRequiresConfirmationMap(this.generateScopeRequiresConfirmationMap(DEFAULT_AWARD_TEMPLATE_SYNC_SCOPES, awardDocument, false, false));
                }
            } else {
                proceedToProcessSyncAward = false;
                awardDocument.getAward().setTemplateCode(awardForm.getOldTemplateCode());
                awardDocument.getAward().refreshReferenceObject("awardTemplate");
                awardForm.setOldTemplateCode(null);
                awardForm.setTemplateLookup(false);
            }
        }
        return proceedToProcessSyncAward ? this.processSyncAward(mapping, form, request, response) : mapping.findForward("basic");
    }

    protected StrutsConfirmation buildAwardSyncParameterizedConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String configurationId, String ... params) throws Exception {
        StrutsConfirmation retval = new StrutsConfirmation();
        retval.setMapping(mapping);
        retval.setForm(form);
        retval.setRequest(request);
        retval.setResponse(response);
        retval.setQuestionId(questionId);
        retval.setQuestionType("confirmationQuestion");
        String questionText = COMFIRMATION_PARAM_STRING;
        for (int i = 0; i < params.length; ++i) {
            questionText = StringUtils.replace((String)questionText, (String)("{" + i + "}"), (String)params[i]);
        }
        retval.setQuestionText(questionText);
        return retval;
    }

    public ActionForward processSyncAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object[] scopes;
        AwardTemplateSyncService awardTemplateSyncService = (AwardTemplateSyncService)KraServiceLocator.getService(AwardTemplateSyncService.class);
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        Object[] scopesList = scopes = awardForm.getCurrentSyncScopes();
        ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
        for (int i = 0; i < scopes.length; ++i) {
            AwardTemplateSyncScope currentScope = scopes[i];
            if (!(question != null && StringUtils.equals((String)("VerifySync:" + currentScope), (String)question) || !((Boolean)awardForm.getSyncRequiresConfirmationMap().get(currentScope)).booleanValue() || StringUtils.equals((String)("VerifyEmptySync:" + currentScope), (String)question))) {
                String scopeSyncLabel = "";
                StrutsConfirmation confirmationQuestion = new StrutsConfirmation();
                if (StringUtils.isNotEmpty((String)currentScope.getDisplayPropertyName())) {
                    scopeSyncLabel = kualiConfiguration.getPropertyValueAsString(currentScope.getDisplayPropertyName());
                }
                confirmationQuestion = StringUtils.equals((String)scopeSyncLabel, (String)REPORTS_PROPERTY_NAME) || StringUtils.equals((String)scopeSyncLabel, (String)PAYMENT_INVOICES_PROPERTY_NAME) ? this.buildAwardSyncParameterizedConfirmationQuestion(mapping, form, request, response, "VerifySync:" + currentScope, currentScope.equals((Object)AwardTemplateSyncScope.FULL) ? "document.question.syncAll.text" : "document.question.syncPanel.text", new String[]{scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription(), this.getScopeMessageToAddQuestion(currentScope)}) : this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "VerifySync:" + currentScope, currentScope.equals((Object)AwardTemplateSyncScope.FULL) ? "document.question.syncAll.text" : "document.question.syncPanel.text", new String[]{scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription(), this.getScopeMessageToAddQuestion(currentScope)});
                confirmationQuestion.setCaller("processSyncAward");
                awardForm.setCurrentSyncQuestionId("VerifySync:" + currentScope);
                return this.performQuestionWithoutInput(confirmationQuestion, "");
            }
            if (StringUtils.equals((String)awardForm.getCurrentSyncQuestionId(), (String)question) && "0".equals(buttonClicked) || !((Boolean)awardForm.getSyncRequiresConfirmationMap().get(currentScope)).booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("USER ACCEPTED SYNC OR NO CONFIRM REQUIRED FOR:" + currentScope + " CALLING SYNC SERVICE."));
                }
                boolean templateHasScopedData = awardTemplateSyncService.templateContainsScopedData(awardDocument, currentScope);
                boolean scopeRequiresEmptyConfirm = ArrayUtils.contains((Object[])DEFAULT_SCOPES_REQUIRE_VERIFY_FOR_EMPTY, (Object)currentScope);
                if (awardDocument.getAward().getSequenceNumber() > 1 && !templateHasScopedData && StringUtils.equals((String)awardForm.getCurrentSyncQuestionId(), (String)("VerifySync:" + currentScope)) && scopeRequiresEmptyConfirm) {
                    String scopeSyncLabel = "";
                    if (StringUtils.isNotEmpty((String)currentScope.getDisplayPropertyName())) {
                        scopeSyncLabel = kualiConfiguration.getPropertyValueAsString(currentScope.getDisplayPropertyName());
                    }
                    StrutsConfirmation confirmationQuestion = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "VerifyEmptySync:" + currentScope, "document.question.syncPanelToEmpty.text", new String[]{scopeSyncLabel, awardDocument.getAward().getAwardTemplate().getDescription()});
                    awardForm.setCurrentSyncQuestionId("VerifyEmptySync:" + currentScope);
                    confirmationQuestion.setCaller("processSyncAward");
                    return this.performQuestionWithoutInput(confirmationQuestion, "");
                }
                AwardTemplateSyncScope[] s = new AwardTemplateSyncScope[]{currentScope};
                awardTemplateSyncService.syncAwardToTemplate(awardDocument, s);
                scopesList = (AwardTemplateSyncScope[])ArrayUtils.remove((Object[])scopesList, (int)0);
                awardForm.setCurrentSyncScopes((AwardTemplateSyncScope[])scopesList);
                continue;
            }
            if (StringUtils.equals((String)awardForm.getCurrentSyncQuestionId(), (String)question) && "1".equals(buttonClicked)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("USER DECLINED " + currentScope + ", SKIPPING."));
                }
                scopesList = (AwardTemplateSyncScope[])ArrayUtils.remove((Object[])scopesList, (int)0);
                awardForm.setCurrentSyncScopes((AwardTemplateSyncScope[])scopesList);
                continue;
            }
            throw new RuntimeException("Do not know what to do in this case!");
        }
        awardForm.setOldTemplateCode(null);
        awardForm.setTemplateLookup(false);
        awardForm.setCurrentSyncScopes(null);
        awardForm.setCurrentSyncQuestionId(null);
        return mapping.findForward("basic");
    }

    private String getScopeMessageToAddQuestion(AwardTemplateSyncScope scope) {
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        String result = configurationService.getPropertyValueAsString("document.question.syncPanel.add.text." + scope);
        return result == null ? "" : result;
    }

    protected String getSyncScopesString(HttpServletRequest request) {
        String syncScopesList = null;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName) && parameterName.indexOf(".scopes") != -1) {
            syncScopesList = StringUtils.substringBetween((String)parameterName, (String)".scopes", (String)".anchor");
        }
        return syncScopesList;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        return (KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class);
    }

    protected SponsorService getSponsorService() {
        return (SponsorService)KraServiceLocator.getService(SponsorService.class);
    }

    protected PessimisticLockService getPessimisticLockService() {
        return (PessimisticLockService)KraServiceLocator.getService(AwardLockService.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
    }

    protected String getModuleIdentifierForOpeningDocument(HttpServletRequest request) {
        String moduleIdentifier = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            moduleIdentifier = StringUtils.substringBetween((String)parameterName, (String)".moduleIdentifier", (String)".");
        }
        return moduleIdentifier;
    }

    private String getDocumentType(HttpServletRequest request) {
        String documentType = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            documentType = StringUtils.substringBetween((String)parameterName, (String)".documentType", (String)".");
        }
        return documentType;
    }

    public ActionForward performLookup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName) && parameterName.indexOf(".performLookup") != -1 && parameterName.contains("templateCode:document.award.templateCode")) {
            AwardForm awardForm = (AwardForm)form;
            awardForm.setTemplateLookup(true);
            ((AwardForm)form).setOldTemplateCode(((AwardForm)form).getAwardDocument().getAward().getTemplateCode());
        }
        return super.performLookup(mapping, form, request, response);
    }

    protected ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, AwardSyncType syncType, PersistableBusinessObject object, String awardAttrName, String attrName, ActionForward returnForward) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.isSyncMode()) {
            awardForm.getAwardSyncBean().setCurrentForward(returnForward);
            awardForm.getAwardSyncBean().addPendingChange(syncType, object, awardAttrName, attrName);
            return this.syncActionCaller(mapping, form, request, response);
        }
        return returnForward;
    }

    protected ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, List<AwardSyncPendingChangeBean> pendingChanges, ActionForward returnForward) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.isSyncMode()) {
            awardForm.getAwardSyncBean().setCurrentForward(returnForward);
            awardForm.getAwardSyncBean().getPendingChanges().addAll(pendingChanges);
            return this.syncActionCaller(mapping, form, request, response);
        }
        return returnForward;
    }

    public ActionForward syncActionCaller(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String message = "document.question.awardhierarchy.sync";
        if (((AwardSyncPendingChangeBean)awardForm.getAwardSyncBean().getPendingChanges().get(0)).getSyncType().equals((Object)AwardSyncType.DELETE_SYNC.getSyncValue())) {
            message = "document.question.awardhierarchy.sync";
        }
        request.setAttribute("methodToCallAttribute", (Object)"methodToCall.syncActionCaller");
        ActionForward confirmAction = this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmSyncActionKey", message, new String[0]), "confirmSyncAction", "refuseSyncAction");
        if (confirmAction != null) {
            return confirmAction;
        }
        return awardForm.getAwardSyncBean().getCurrentForward();
    }

    public ActionForward confirmSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().confirmPendingChanges();
        return null;
    }

    public ActionForward refuseSyncAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().getPendingChanges().clear();
        return null;
    }

    protected AwardSyncCreationService getAwardSyncCreationService() {
        return (AwardSyncCreationService)KraServiceLocator.getService(AwardSyncCreationService.class);
    }

    protected AwardSyncService getAwardSyncService() {
        return (AwardSyncService)KraServiceLocator.getService(AwardSyncService.class);
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        super.populateAuthorizationFields(formBase);
        AwardForm awardForm = (AwardForm)formBase;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        Map documentActions = formBase.getDocumentActions();
        if (award.getAwardAmountInfos().size() > 1 && (award.getAwardAmountInfos().size() != 2 || ((AwardAmountInfo)award.getAwardAmountInfos().get(0)).getOriginatingAwardVersion() != null) && documentActions.containsKey("canCancel")) {
            documentActions.remove("canCancel");
        }
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = (AwardService)KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public ReportTrackingService getReportTrackingService() {
        if (this.reportTrackingService == null) {
            this.reportTrackingService = (ReportTrackingService)KraServiceLocator.getService(ReportTrackingService.class);
        }
        return this.reportTrackingService;
    }

    protected void setSubAwardDetails(Award award) {
        award.setSubAwardList(this.getSubAwardService().getLinkedSubAwards(award));
    }

    protected KcNotificationService getNotificationService() {
        if (this.notificationService == null) {
            this.notificationService = (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
        }
        return this.notificationService;
    }

    public void setNotificationService(KcNotificationService notificationService) {
        this.notificationService = notificationService;
    }

    protected SubAwardService getSubAwardService() {
        if (this.subAwardService == null) {
            this.subAwardService = (SubAwardService)KraServiceLocator.getService(SubAwardService.class);
        }
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionForward superUserActionHelper(SuperUserAction actionName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ActionForward forward = mapping.findForward("basic");
        AwardForm awardForm = (AwardForm)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        awardForm.setAuditActivated(true);
        AuditActionHelper.ValidationState status = AuditActionHelper.ValidationState.OK;
        if (!awardForm.getDocument().getDocumentHeader().getWorkflowDocument().isEnroute()) {
            status = new AuditActionHelper().isValidSubmission((KualiDocumentFormBase)awardForm, true);
        }
        if (status == AuditActionHelper.ValidationState.WARNING) {
            if (question == null) {
                List selectedActionRequests = awardForm.getSelectedActionRequests();
                GlobalVariables.getUserSession().addObject(SUPER_USER_ACTION_REQUESTS, (Object)selectedActionRequests);
                try {
                    return this.performQuestionWithoutInput(mapping, form, request, response, DOCUMENT_ROUTE_QUESTION, "Validation Warning Exists. Are you sure want to submit to workflow routing.", "confirmationQuestion", methodToCall, "");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return forward;
                }
            } else {
                if (!DOCUMENT_ROUTE_QUESTION.equals(question) || !"0".equals(buttonClicked)) return forward;
                awardForm.setSelectedActionRequests((List)GlobalVariables.getUserSession().retrieveObject(SUPER_USER_ACTION_REQUESTS));
                GlobalVariables.getUserSession().removeObject(SUPER_USER_ACTION_REQUESTS);
                switch (1.$SwitchMap$org$kuali$kra$award$web$struts$action$AwardAction$SuperUserAction[actionName.ordinal()]) {
                    case 1: {
                        return super.superUserApprove(mapping, (ActionForm)awardForm, request, response);
                    }
                    case 2: {
                        return super.takeSuperUserActions(mapping, (ActionForm)awardForm, request, response);
                    }
                }
            }
            return forward;
        } else if (status == AuditActionHelper.ValidationState.OK) {
            switch (1.$SwitchMap$org$kuali$kra$award$web$struts$action$AwardAction$SuperUserAction[actionName.ordinal()]) {
                case 1: {
                    return super.superUserApprove(mapping, (ActionForm)awardForm, request, response);
                }
                case 2: {
                    return super.takeSuperUserActions(mapping, (ActionForm)awardForm, request, response);
                }
            }
            return forward;
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            return forward;
        }
    }

    public ActionForward superUserApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.SUPER_USER_APPROVE, mapping, form, request, response);
    }

    public ActionForward takeSuperUserActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.superUserActionHelper(SuperUserAction.TAKE_SUPER_USER_ACTIONS, mapping, form, request, response);
    }
}

