/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyTempObject;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposal;
import org.kuali.kra.award.notification.AwardNotificationContext;
import org.kuali.kra.award.printing.AwardPrintParameters;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.service.AwardPrintingService;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.external.award.AccountCreationClient;
import org.kuali.kra.external.award.AwardAccountValidationService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardActionsAction
extends AwardAction
implements AuditModeAction {
    private static final String ZERO = "0";
    private static final String NEW_CHILD_SELECTED_AWARD_OPTION = "c";
    private static final String NEW_CHILD_COPY_FROM_PARENT_OPTION = "b";
    private static final String ERROR_CANCEL_PENDING_PROPOSALS = "error.cancel.fundingproposal.pendingVersion";
    private static final String ACCOUNT_ALREADY_CREATED = "error.award.createAccount.account.already.created";
    private static final String AWARD_ACCOUNT_NUMBER_NOT_SPECIFIED = "error.award.createAccount.invalid.accountNumber";
    private static final String NO_PERMISSION_TO_CREATE_ACCOUNT = "error.award.createAccount.noPermission";
    public static final String NEW_CHILD_NEW_OPTION = "a";
    public static final String AWARD_COPY_NEW_OPTION = "a";
    public static final String AWARD_COPY_CHILD_OF_OPTION = "d";

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        ActionForward forward = mapping.findForward("basic");
        if (StringUtils.isNotEmpty((String)command) && "displayDocSearchView".equals(command)) {
            this.loadDocumentInForm(request, awardForm);
            WorkflowDocument workflowDoc = awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument();
            if (workflowDoc != null) {
                awardForm.setDocTypeName(workflowDoc.getDocumentTypeName());
            }
            request.setAttribute("selectedAwardNumber", (Object)awardForm.getAwardDocument().getAward().getAwardNumber());
        } else {
            forward = super.docHandler(mapping, (ActionForm)awardForm, request, response);
        }
        this.populateAwardHierarchy(form);
        return forward;
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        String command = request.getParameter("command");
        String awardDocumentNumber = request.getParameter("awardDocumentNumber");
        String awardNumber = request.getParameter("awardNumber");
        if (StringUtils.isNotBlank((String)command) && "redirectAwardHierarchyFullViewForPopup".equals(command)) {
            forward = this.redirectAwardHierarchyFullViewForPopup(mapping, form, request, response, awardDocumentNumber, awardNumber);
        }
        return forward;
    }

    private ActionForward redirectAwardHierarchyFullViewForPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String awardDocumentNumber, String awardNumber) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        response.sendRedirect("awardHierarchyFullView.do?methodToCall=openWindow&awardDocumentNumber=" + awardDocumentNumber + "&awardNumber=" + awardNumber + "&docTypeName=" + awardForm.getDocTypeName());
        return null;
    }

    protected void validateLookupInquiryFullParameter(HttpServletRequest request, ActionForm form, String fullParameter) {
        if (fullParameter.startsWith("methodToCall.performLookup.(!!org.kuali.kra.award.home.Award!!).(((awardNumber:awardHierarchyTempObject")) {
            return;
        }
        super.validateLookupInquiryFullParameter(request, form, fullParameter);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setUnitRulesMessages(this.getUnitRulesMessages(awardForm.getAwardDocument()));
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardForm)form), true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((AwardForm)form).clearUnitRulesMessages();
        return new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardForm)form), false);
    }

    public ActionForward copyAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardNumber = this.getAwardNumber(request);
        int index = Integer.parseInt(StringUtils.split((String)awardNumber, (String)"-")[1]);
        ActionForward forward = null;
        AwardHierarchy newRootNode = null;
        if (!StringUtils.isEmpty((String)((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCopyAwardRadio())) {
            String radio = ((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCopyAwardRadio();
            Boolean copyDescendants = ((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCopyDescendants();
            AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
            if (StringUtils.equalsIgnoreCase((String)radio, (String)"a")) {
                if (copyDescendants != null && copyDescendants.booleanValue()) {
                    newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndAllDescendantsAsNewHierarchy(targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewFinalChildAward(mapping, awardForm, request, response, targetNode, newRootNode);
                } else {
                    newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsNewHierarchy(targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
                }
            } else if (StringUtils.equalsIgnoreCase((String)radio, (String)AWARD_COPY_CHILD_OF_OPTION)) {
                String awardNumberOfNodeToBeParent = ((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCopyAwardPanelTargetAward();
                if (!StringUtils.isEmpty((String)awardNumberOfNodeToBeParent) && !StringUtils.equalsIgnoreCase((String)awardNumberOfNodeToBeParent, (String)ZERO)) {
                    if (copyDescendants != null && copyDescendants.booleanValue()) {
                        if (!StringUtils.isEmpty((String)awardNumberOfNodeToBeParent)) {
                            newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
                            forward = this.prepareToForwardToNewFinalChildAward(mapping, awardForm, request, response, targetNode, newRootNode);
                        }
                    } else {
                        newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
                        forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
                    }
                } else {
                    GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].copyAwardPanelTargetAward", "error.copy.award.childOf.award.not.selected", new String[]{awardNumber});
                    awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
                    forward = mapping.findForward("basic");
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].copyAwardPanelTargetAward", "error.copy.award.no.option.selected", new String[]{awardNumber});
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        String awardNumber = this.getAwardNumber(request);
        int index = Integer.parseInt(StringUtils.split((String)awardNumber, (String)"-")[1]);
        ActionForward forward = null;
        if (((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCreateNewChildRadio() != null) {
            AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
            String radio = ((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getCreateNewChildRadio();
            if (StringUtils.equalsIgnoreCase((String)radio, (String)"a")) {
                AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAward(targetNode.getAwardNumber());
                forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
            } else if (StringUtils.equalsIgnoreCase((String)radio, (String)NEW_CHILD_COPY_FROM_PARENT_OPTION)) {
                AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewAwardBasedOnParent(targetNode.getAwardNumber());
                forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
            } else if (StringUtils.equalsIgnoreCase((String)radio, (String)NEW_CHILD_SELECTED_AWARD_OPTION)) {
                String awardNumberOfNodeToCopyFrom = ((AwardHierarchyTempObject)awardForm.getAwardHierarchyTempObjects().get(index)).getNewChildPanelTargetAward();
                if (StringUtils.isEmpty((String)awardNumberOfNodeToCopyFrom) || StringUtils.equalsIgnoreCase((String)awardNumberOfNodeToCopyFrom, (String)ZERO)) {
                    GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].newChildPanelTargetAward", "error.create.new.child.other.award.not.selected", new String[]{awardNumber});
                    forward = mapping.findForward("basic");
                } else {
                    AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAwardBasedOnAnotherAwardInHierarchy(awardNumberOfNodeToCopyFrom, targetNode.getAwardNumber());
                    forward = this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError("awardHierarchyTempObject[" + index + "].newChildPanelTargetAward", "error.create.new.child.no.option.selected", new String[]{awardNumber});
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward createANewChildAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAward(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward createANewChildAwardBasedOnParent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewAwardBasedOnParent(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward createANewChildAwardBasedOnAnotherAwardInHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String awardNumberOfNodeToCopyFrom = this.getHierarchyTargetAwardNumber(request);
        if (StringUtils.isEmpty((String)awardNumberOfNodeToCopyFrom)) {
            return mapping.findForward("basic");
        }
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newChildNode = awardForm.getAwardHierarchyBean().createNewChildAwardBasedOnAnotherAwardInHierarchy(awardNumberOfNodeToCopyFrom, targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newChildNode);
    }

    public ActionForward copyAwardAsANewHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newRootNode = awardForm.getAwardHierarchyBean().copyAwardAsNewHierarchy(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
    }

    public ActionForward copyAwardAsANewHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        AwardHierarchy newRootNode = awardForm.getAwardHierarchyBean().copyAwardAndAllDescendantsAsNewHierarchy(targetNode.getAwardNumber());
        return this.prepareToForwardToNewChildAward(mapping, awardForm, targetNode, newRootNode);
    }

    public ActionForward copyAwardAsChildOfAnotherAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAndDescendantsAsChildOfAnotherAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        if (!StringUtils.isEmpty((String)awardNumberOfNodeToBeParent)) {
            awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnotherAward(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildInCurrentHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnAwardInCurrentHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildInCurrentHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        this.populateAwardHierarchy((ActionForm)awardForm);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildOfAwardInAnotherHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        awardForm.getAwardHierarchyBean().copyAwardAsChildOfAnAwardInAnotherHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        return mapping.findForward("basic");
    }

    public ActionForward copyAwardAsAChildOfAwardInAnotherHierarchyWithDescendants(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardHierarchy targetNode = this.findTargetNode(request, awardForm);
        String awardNumberOfNodeToBeParent = this.getHierarchyTargetAwardNumber(request);
        if (!StringUtils.isEmpty((String)awardNumberOfNodeToBeParent)) {
            awardForm.getAwardHierarchyBean().copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(targetNode.getAwardNumber(), awardNumberOfNodeToBeParent);
        }
        return mapping.findForward("basic");
    }

    public ActionForward selectAllAwardPrintNoticeItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardPrintNotice().selectAllItems();
        return mapping.findForward("basic");
    }

    public ActionForward deselectAllAwardPrintNoticeItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardPrintNotice().deselectAllItems();
        return mapping.findForward("basic");
    }

    public ActionForward printNotice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Boolean> reportParameters = new HashMap<String, Boolean>();
        reportParameters.put(AwardPrintParameters.ADDRESS_LIST.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getSponsorContacts());
        reportParameters.put(AwardPrintParameters.FOREIGN_TRAVEL.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getForeignTravel());
        reportParameters.put(AwardPrintParameters.REPORTING.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getReports());
        reportParameters.put(AwardPrintParameters.CLOSEOUT.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getCloseout());
        reportParameters.put(AwardPrintParameters.FUNDING_SUMMARY.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getFundingSummary());
        reportParameters.put(AwardPrintParameters.SPECIAL_REVIEW.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getSpecialReview());
        reportParameters.put(AwardPrintParameters.COMMENTS.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getComments());
        reportParameters.put(AwardPrintParameters.HIERARCHY_INFO.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getHierarchy());
        reportParameters.put(AwardPrintParameters.SUBCONTRACT.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getSubAward());
        reportParameters.put(AwardPrintParameters.COST_SHARING.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getCostShare());
        reportParameters.put(AwardPrintParameters.KEYWORDS.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getKeywords());
        reportParameters.put(AwardPrintParameters.TECHNICAL_REPORTING.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getTechnicalReports());
        reportParameters.put(AwardPrintParameters.EQUIPMENT.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getEquipment());
        reportParameters.put(AwardPrintParameters.OTHER_DATA.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getOtherData());
        reportParameters.put(AwardPrintParameters.TERMS.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getTerms());
        reportParameters.put(AwardPrintParameters.FA_COST.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getFaRates());
        reportParameters.put(AwardPrintParameters.PAYMENT.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getPayment());
        reportParameters.put(AwardPrintParameters.FLOW_THRU.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getFlowThru());
        reportParameters.put(AwardPrintParameters.PROPOSAL_DUE.getAwardPrintParameter(), false);
        reportParameters.put(AwardPrintParameters.SIGNATURE_REQUIRED.getAwardPrintParameter(), awardForm.getAwardPrintNotice().getRequireSignature());
        AwardPrintingService awardPrintService = (AwardPrintingService)KraServiceLocator.getService(AwardPrintingService.class);
        AttachmentDataSource dataStream = awardPrintService.printAwardReport((KraPersistableBusinessObjectBase)awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_NOTICE_REPORT, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printChangeReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Comparable<Boolean>> reportParameters = new HashMap<String, Comparable<Boolean>>();
        reportParameters.put(AwardPrintParameters.SIGNATURE_REQUIRED.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getRequireSignature());
        reportParameters.put(AwardPrintParameters.SEQUENCE_NUMBER.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getAwardVersion());
        reportParameters.put(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter(), awardForm.getAwardPrintChangeReport().getAmountInfoIndex());
        AwardPrintingService awardPrintService = (AwardPrintingService)KraServiceLocator.getService(AwardPrintingService.class);
        AttachmentDataSource dataStream = awardPrintService.printAwardReport((KraPersistableBusinessObjectBase)awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_DELTA_REPORT, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap reportParameters = new HashMap();
        AwardPrintingService awardPrintService = (AwardPrintingService)KraServiceLocator.getService(AwardPrintingService.class);
        AttachmentDataSource dataStream = awardPrintService.printAwardReport((KraPersistableBusinessObjectBase)awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_BUDGET_HIERARCHY, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printHierarchyModification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        return mapping.findForward("basic");
    }

    public ActionForward printBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        return mapping.findForward("basic");
    }

    public ActionForward printTimeMoneyHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap reportParameters = new HashMap();
        AwardPrintingService awardPrintService = (AwardPrintingService)KraServiceLocator.getService(AwardPrintingService.class);
        AttachmentDataSource dataStream = awardPrintService.printAwardReport((KraPersistableBusinessObjectBase)awardForm.getAwardDocument().getAward(), AwardPrintType.MONEY_AND_END_DATES_HISTORY, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward printTransactionDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        HashMap<String, Integer> reportParameters = new HashMap<String, Integer>();
        if (awardForm.getAwardTimeAndMoneyTransactionReport().getAmountInfoIndex() == null) {
            GlobalVariables.getMessageMap().putError("awardTimeAndMoneyTransactionReport.amountInfoIndex", "error.award.print.transactionId.required", new String[0]);
            return mapping.findForward("basic");
        }
        reportParameters.put(AwardPrintParameters.SEQUENCE_NUMBER.getAwardPrintParameter(), awardForm.getAwardTimeAndMoneyTransactionReport().getAwardVersion());
        reportParameters.put(AwardPrintParameters.TRANSACTION_ID_INDEX.getAwardPrintParameter(), awardForm.getAwardTimeAndMoneyTransactionReport().getAmountInfoIndex());
        AwardPrintingService awardPrintService = (AwardPrintingService)KraServiceLocator.getService(AwardPrintingService.class);
        AttachmentDataSource dataStream = awardPrintService.printAwardReport((KraPersistableBusinessObjectBase)awardForm.getAwardDocument().getAward(), AwardPrintType.AWARD_BUDGET_HISTORY_TRANSACTION, reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public AwardNumberService getAwardNumberService() {
        return (AwardNumberService)KraServiceLocator.getService(AwardNumberService.class);
    }

    protected String getAwardNumber(HttpServletRequest request) {
        String awardNumber = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            awardNumber = StringUtils.substringBetween((String)parameterName, (String)".awardNumber", (String)".");
        }
        return awardNumber;
    }

    private int getActiveHierarchyObjectIndex(HttpServletRequest request) throws Exception {
        Enumeration lookupParameters = request.getParameterNames();
        int index = -1;
        while (lookupParameters.hasMoreElements()) {
            String temp = (String)lookupParameters.nextElement();
            if (!temp.startsWith("awardHierarchyTempObject[")) continue;
            index = temp.indexOf("awardHierarchyTempObject[") + 25;
            temp = temp.substring(index, index + 1);
            index = Integer.parseInt(temp);
            break;
        }
        return index;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        int activeHierarchyObjectIndex = this.getActiveHierarchyObjectIndex(request);
        int loopIndex = 0;
        Award currentAward = awardDocument.getAward();
        for (AwardHierarchyTempObject temp : awardForm.getAwardHierarchyTempObjects()) {
            ArrayList order = new ArrayList();
            if (loopIndex == activeHierarchyObjectIndex - 1) {
                temp.setAwardNumber2(null);
                temp.setAwardNumber(null);
            }
            if (StringUtils.isNotBlank((String)temp.getAwardNumber1())) {
                Map awardHierarchyItems = awardForm.getAwardHierarchyBean().getAwardHierarchy(temp.getAwardNumber1(), order);
                StringBuilder sb = new StringBuilder();
                for (String str : order) {
                    sb.append(((AwardHierarchy)awardHierarchyItems.get(str)).getAwardNumber());
                    sb.append(" ").append("%3A");
                }
                temp.setSelectBox1(sb.toString());
                request.setAttribute("selectedAwardNumber", (Object)temp.getAwardNumber());
            }
            if (StringUtils.isNotBlank((String)temp.getAwardNumber2())) {
                order = new ArrayList();
                HashMap awardHierarchyNodes = new HashMap();
                Map awardHierarchyItems = this.getAwardHierarchyService().getAwardHierarchy(temp.getAwardNumber2(), order);
                this.getAwardHierarchyService().populateAwardHierarchyNodes(awardHierarchyItems, awardHierarchyNodes, currentAward.getAwardNumber(), currentAward.getSequenceNumber().toString());
                StringBuilder sb = new StringBuilder();
                for (String str : order) {
                    AwardHierarchyNode tempAwardNode = (AwardHierarchyNode)awardHierarchyNodes.get(str);
                    if (!tempAwardNode.isAwardDocumentFinalStatus().booleanValue()) continue;
                    sb.append(tempAwardNode.getAwardNumber());
                    sb.append(" ").append("%3A");
                }
                temp.setSelectBox2(sb.toString());
                request.setAttribute("selectedAwardNumber", (Object)temp.getAwardNumber());
            }
            ++loopIndex;
        }
        return super.refresh(mapping, form, request, response);
    }

    private AwardHierarchy findTargetNode(HttpServletRequest request, AwardForm awardForm) {
        return awardForm.getAwardHierarchyBean().getRootNode().findNodeInHierarchy(this.getAwardNumber(request));
    }

    private ActionForward prepareToForwardToNewChildAward(ActionMapping mapping, AwardForm awardForm, AwardHierarchy targetNode, AwardHierarchy newNodeToView) throws WorkflowException {
        ActionForward forward;
        if (newNodeToView != null) {
            awardForm.setCommand("initiate");
            this.createDocument((KualiDocumentFormBase)awardForm);
            Award newChildAward = newNodeToView.getAward();
            if (!newNodeToView.isRootNode()) {
                this.setMultipleNodeHierarchyOnAwardFormTrue(newChildAward);
            }
            awardForm.getAwardDocument().setAward(newChildAward);
            awardForm.getAwardHierarchyBean().recordTargetNodeState(targetNode);
            awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
            forward = mapping.findForward("home");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    private ActionForward prepareToForwardToNewFinalChildAward(ActionMapping mapping, AwardForm awardForm, HttpServletRequest request, HttpServletResponse response, AwardHierarchy targetNode, AwardHierarchy newNodeToView) throws Exception {
        ActionForward forward;
        if (newNodeToView != null) {
            awardForm.setCommand("initiate");
            this.createDocument((KualiDocumentFormBase)awardForm);
            Award newChildAward = newNodeToView.getAward();
            if (!newNodeToView.isRootNode()) {
                this.setMultipleNodeHierarchyOnAwardFormTrue(newChildAward);
            }
            awardForm.getAwardDocument().setAward(newChildAward);
            awardForm.getAwardDocument().getDocumentHeader().setDocumentDescription("Copied Hierarchy");
            awardForm.getAwardHierarchyBean().recordTargetNodeState(targetNode);
            awardForm.getFundingProposalBean().setAllAwardsForAwardNumber(null);
            super.save(mapping, (ActionForm)awardForm, request, response);
            super.submitAward(mapping, (ActionForm)awardForm, request, response);
            forward = mapping.findForward("home");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    private void setMultipleNodeHierarchyOnAwardFormTrue(Award award) {
        award.setAwardInMultipleNodeHierarchy(true);
    }

    private String getHierarchyTargetAwardNumber(HttpServletRequest request) {
        return request.getParameter("awardNumberInputTemp");
    }

    public ActionForward createAccount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = new ActionForward();
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDocument = awardForm.getAwardDocument();
        Award award = awardDocument.getAward();
        if (awardForm.getEditingMode().get("createAwardAccount").equals("true")) {
            AwardAccountValidationService accountValidationService = this.getAwardAccountValidationService();
            boolean rulePassed = accountValidationService.validateAwardAccountDetails(award);
            if (rulePassed) {
                AccountCreationClient client = this.getAccountCreationClient();
                if (award.getFinancialAccountDocumentNumber() == null) {
                    if (StringUtils.isBlank((String)award.getIcrRateCode())) {
                        List validRates = awardForm.getAccountCreationHelper().getMatchingValidRates(award.getCurrentFandaRate());
                        if (validRates.size() > 1) {
                            awardForm.getAccountCreationHelper().setValidRateCandidates(validRates);
                            return mapping.findForward("icrRateCodePrompt");
                        }
                        if (validRates.size() == 1) {
                            award.setIcrRateCode(((ValidRates)validRates.get(0)).getIcrRateCode());
                        } else {
                            award.setIcrRateCode("ICRNONE");
                        }
                    }
                    client.createAwardAccount(award);
                } else {
                    GlobalVariables.getMessageMap().putError(ACCOUNT_ALREADY_CREATED, ACCOUNT_ALREADY_CREATED, new String[0]);
                }
            }
        } else {
            GlobalVariables.getMessageMap().putError(NO_PERMISSION_TO_CREATE_ACCOUNT, NO_PERMISSION_TO_CREATE_ACCOUNT, new String[0]);
        }
        forward = mapping.findForward("awardActions");
        return forward;
    }

    protected AccountCreationClient getAccountCreationClient() {
        return (AccountCreationClient)KraServiceLocator.getService((String)"accountCreationClient");
    }

    protected AwardAccountValidationService getAwardAccountValidationService() {
        return (AwardAccountValidationService)KraServiceLocator.getService((String)"awardAccountValidationService");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        Set linkedPendingProposals = this.getLinkedPendingProposals(award);
        if (!linkedPendingProposals.isEmpty()) {
            String proposalNumbers = StringUtils.join((Collection)linkedPendingProposals, (String)", ");
            GlobalVariables.getMessageMap().putError("noKey", ERROR_CANCEL_PENDING_PROPOSALS, new String[]{proposalNumbers});
            return mapping.findForward("basic");
        }
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("DocCancel".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
        if (award.getSequenceNumber() == 1) {
            AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchy(award.getAwardNumber());
            hierarchy.setActive(Boolean.valueOf(false));
            this.getBusinessObjectService().save((PersistableBusinessObject)hierarchy);
        }
        this.getDocumentService().cancelDocument(kualiDocumentFormBase.getDocument(), kualiDocumentFormBase.getAnnotation());
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    private Map<String, String> getHashMapToFindActiveAward(String goToAwardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("awardNumber", goToAwardNumber);
        return map;
    }

    private Set<String> getLinkedPendingProposals(Award award) {
        HashSet<String> linkedPendingProposals = new HashSet<String>();
        for (AwardFundingProposal awardFundingProposal : award.getFundingProposals()) {
            String proposalNumber = awardFundingProposal.getProposal().getProposalNumber();
            InstitutionalProposal pendingVersion = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(proposalNumber);
            if (pendingVersion == null || !pendingVersion.isFundedByAward(award.getAwardNumber(), award.getSequenceNumber())) continue;
            linkedPendingProposals.add(proposalNumber);
        }
        return linkedPendingProposals;
    }

    protected InstitutionalProposalService getInstitutionalProposalService() {
        return (InstitutionalProposalService)KraServiceLocator.getService(InstitutionalProposalService.class);
    }

    protected VersionHistoryService getVersionHistoryService() {
        return (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
    }

    public ActionForward syncSponsor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardSyncCreationService().addAwardSyncChange(award, new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)award, "sponsorCode", "sponsorCode"));
        return mapping.findForward("basic");
    }

    public ActionForward syncStatusCode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        this.getAwardSyncCreationService().addAwardSyncChange(award, new AwardSyncPendingChangeBean(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)award, "statusCode", "statusCode"));
        return mapping.findForward("basic");
    }

    public ActionForward deleteChanges(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        ListIterator iter = award.getSyncChanges().listIterator();
        while (iter.hasNext()) {
            AwardSyncChange change = (AwardSyncChange)iter.next();
            if (!change.isDelete()) continue;
            this.getBusinessObjectService().delete((PersistableBusinessObject)change);
            iter.remove();
        }
        return mapping.findForward("basic");
    }

    public ActionForward activateSyncMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setSyncMode(true);
        return mapping.findForward("basic");
    }

    public ActionForward deactivateSyncMode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.setSyncMode(false);
        return mapping.findForward("basic");
    }

    public ActionForward clearSyncSelections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        for (AwardSyncChange change : awardForm.getAwardDocument().getAward().getSyncChanges()) {
            change.setSyncDescendants(null);
            change.setSyncFabricated(false);
            change.setSyncCostSharing(false);
        }
        return mapping.findForward("basic");
    }

    public ActionForward rerunValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        awardForm.getAwardSyncBean().getParentAwardStatus().setStatus("Validation In Progress");
        this.getBusinessObjectService().save((PersistableBusinessObject)awardForm.getAwardSyncBean().getParentAwardStatus());
        awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument().returnToPreviousNode("Re-run Hierarchy Sync Validation", "hasSync");
        return mapping.findForward("basic");
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardNotificationContext context = new AwardNotificationContext(award, null, "Ad-Hoc Notification", "awardActions");
        awardForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
        return mapping.findForward("notificationEditor");
    }
}

