/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetsAction
extends AwardAction
implements AuditModeAction {
    private static final String TOGGLE_TAB = "toggleTab";
    private static final String CONFIRM_SYNCH_BUDGET_RATE = "confirmSynchBudgetRate";
    private static final String NO_SYNCH_BUDGET_RATE = "noSynchBudgetRate";
    private transient KualiRuleService ruleService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (!StringUtils.equals((String)awardForm.getMethodToCall(), (String)"save") && awardForm.isSaveAfterCopy()) {
            List overviews = awardForm.getAwardDocument().getBudgetDocumentVersions();
            BudgetDocumentVersion copiedDocumentOverview = (BudgetDocumentVersion)overviews.get(overviews.size() - 1);
            BudgetVersionOverview copiedOverview = copiedDocumentOverview.getBudgetVersionOverview();
            String copiedName = copiedOverview.getDocumentDescription();
            copiedOverview.setDocumentDescription("copied placeholder");
            BufferedLogger.debug((Object[])new Object[]{"validating ", copiedName});
            boolean valid = this.getBudgetService().isBudgetVersionNameValid((BudgetParentDocument)awardForm.getAwardDocument(), copiedName);
            copiedOverview.setDocumentDescription(copiedName);
            awardForm.setSaveAfterCopy(!valid);
            if (!valid) {
                return mapping.findForward("basic");
            }
            awardForm.getAwardDocument().updateDocumentDescriptions(awardForm.getAwardDocument().getBudgetDocumentVersions());
        }
        request.setAttribute("rateClassMap", (Object)this.getBudgetRatesService().getBudgetRateClassMap("O"));
        ActionForward ac = super.execute(mapping, form, request, response);
        this.getAwardBudgetService().populateBudgetLimitSummary(awardForm.getBudgetLimitSummary(), awardForm.getAwardDocument());
        return ac;
    }

    public ActionForward addBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetDocument newBudgetDoc;
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        ActionForward actionForward = this.activate(mapping, form, request, response);
        if (actionForward == mapping.findForward("basic") && (newBudgetDoc = this.getBudgetService().addBudgetVersion((BudgetParentDocument)awardDoc, awardForm.getNewBudgetVersionName())) != null) {
            awardForm.setNewBudgetVersionName("");
        }
        return actionForward;
    }

    public ActionForward rebudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        AwardBudgetDocument newBudgetDoc = this.getAwardBudgetService().rebudget(awardDoc, awardForm.getNewBudgetVersionName());
        if (newBudgetDoc != null) {
            awardForm.setNewBudgetVersionName("");
        }
        return mapping.findForward("basic");
    }

    public ActionForward openBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        AwardBudgetService awardBudgetService = (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
        if ("TRUE".equals(awardForm.getEditingMode().get("modifyAwardBudget"))) {
            this.save(mapping, form, request, response);
        }
        AwardDocument awardDocument = awardForm.getAwardDocument();
        awardDocument.refreshBudgetDocumentVersions();
        BudgetDocumentVersion budgetDocumentToOpen = awardDocument.getBudgetDocumentVersion(this.getSelectedLine(request));
        BudgetVersionOverview budgetToOpen = budgetDocumentToOpen.getBudgetVersionOverview();
        Collection allBudgetRates = budgetService.getSavedProposalRates(budgetToOpen);
        Award newestAward = this.getAwardBudgetService().getActiveOrNewestAward(awardDocument.getAward().getAwardNumber());
        newestAward.refreshReferenceObject("awardFandaRate");
        List fandaRates = newestAward.getAwardFandaRate();
        ArrayList<KualiDecimal> ebRates = new ArrayList<KualiDecimal>();
        if (newestAward.getSpecialEbRateOffCampus() != null) {
            ebRates.add(newestAward.getSpecialEbRateOffCampus());
        }
        if (newestAward.getSpecialEbRateOnCampus() != null) {
            ebRates.add(newestAward.getSpecialEbRateOnCampus());
        }
        if (newestAward.getRequestedStartDateInitial() == null || newestAward.getRequestedEndDateInitial() == null) {
            return mapping.findForward("basic");
        }
        if (awardBudgetService.checkRateChange(allBudgetRates, newestAward)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchAwardRates.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        if (budgetService.checkActivityTypeChange(allBudgetRates, newestAward.getActivityTypeCode())) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.synchBudgetRate.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        if (CollectionUtils.isEmpty((Collection)allBudgetRates)) {
            return this.confirm(this.syncBudgetRateConfirmationQuestion(mapping, form, request, response, "document.question.noRatesSynch.text"), CONFIRM_SYNCH_BUDGET_RATE, NO_SYNCH_BUDGET_RATE);
        }
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToOpen.getDocumentNumber());
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        Budget budget = budgetDocument.getBudget();
        String forward = this.buildForwardUrl(routeHeaderId);
        if (!budget.getActivityTypeCode().equals(newestAward.getActivityTypeCode()) || budget.isRateClassTypesReloaded()) {
            budget.setActivityTypeCode(newestAward.getActivityTypeCode());
            forward = forward.replace("awardBudgetParameters.do?", "awardBudgetParameters.do?syncBudgetRate=Y&");
        }
        if (awardForm.isAuditActivated()) {
            forward = StringUtils.replace((String)forward, (String)"awardBudgetParameters.do?", (String)"awardBudgetParameters.do?auditActivated=true&");
        }
        forward = StringUtils.replace((String)forward, (String)"Parameters.do?", (String)("Parameters.do?showAllBudgetVersions=" + awardForm.isShowAllBudgetVersions() + "&"));
        return new ActionForward(forward, true);
    }

    private BudgetSummaryService getBudgetSummaryService() {
        return (BudgetSummaryService)KraServiceLocator.getService(BudgetSummaryService.class);
    }

    private BudgetRatesService<Award> getBudgetRateService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public ActionForward confirmSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, true);
    }

    public ActionForward noSynchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchBudgetRate(mapping, form, request, response, false);
    }

    private ActionForward synchBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean confirm) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        BudgetDocumentVersion budgetDocumentToOpen = awardDoc.getBudgetDocumentVersion(this.getSelectedLine(request));
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocument = (BudgetDocument)documentService.getByDocumentHeaderId(budgetDocumentToOpen.getDocumentNumber());
        String routeHeaderId = budgetDocument.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            budgetDocument.getBudget().setActivityTypeCode(awardDoc.getBudgetParent().getActivityTypeCode());
            Budget budget = budgetDocument.getBudget();
            budget.setRateClassTypesReloaded(false);
            forward = forward.replace("awardBudgetParameters.do?", "awardBudgetParameters.do?syncBudgetRate=Y&");
        }
        if (awardForm.isAuditActivated()) {
            forward = StringUtils.replace((String)forward, (String)"budgetParameters.do?", (String)"budgetParameters.do?auditActivated=true&");
        }
        return new ActionForward(forward, true);
    }

    public ActionForward copyBudgetVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm pdForm = (AwardForm)form;
        BudgetVersionOverview versionToCopy = this.getSelectedVersion(pdForm, request);
        if (!this.getAwardBudgetService().validateAddingNewBudget((BudgetParentDocument)pdForm.getAwardDocument())) {
            return mapping.findForward("basic");
        }
        if (StringUtils.isNotBlank((String)request.getParameter("questionIndex"))) {
            String buttonClicked = request.getParameter("buttonClicked");
            if ("1".equals(buttonClicked)) {
                pdForm.setSaveAfterCopy(true);
                return this.copyBudgetPeriodOne(mapping, form, request, response);
            }
            if ("0".equals(buttonClicked)) {
                pdForm.setSaveAfterCopy(true);
                return this.copyBudgetAllPeriods(mapping, form, request, response);
            }
            return mapping.findForward("basic");
        }
        return this.performQuestionWithoutInput(mapping, form, request, response, "copyBudgetQuestion", "A new version of the budget will be created based on version " + versionToCopy.getBudgetVersionNumber() + ".", "copyPeriodsQuestion", pdForm.getMethodToCall(), "");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        boolean valid = true;
        if (awardForm.isSaveAfterCopy()) {
            List overviews = awardForm.getAwardDocument().getBudgetDocumentVersions();
            BudgetDocumentVersion copiedDocumentOverview = (BudgetDocumentVersion)overviews.get(overviews.size() - 1);
            BudgetVersionOverview copiedOverview = copiedDocumentOverview.getBudgetVersionOverview();
            String copiedName = copiedOverview.getDocumentDescription();
            copiedOverview.setDocumentDescription("copied placeholder");
            BufferedLogger.debug((Object[])new Object[]{"validating ", copiedName});
            valid = this.getBudgetService().isBudgetVersionNameValid((BudgetParentDocument)awardForm.getAwardDocument(), copiedName);
            copiedOverview.setDocumentDescription(copiedName);
            awardForm.setSaveAfterCopy(!valid);
        }
        if (awardForm.isAuditActivated() && !(valid &= this.getBudgetService().validateBudgetAuditRuleBeforeSaveBudgetVersion((BudgetParentDocument)awardForm.getAwardDocument()))) {
            int errorBudgetVersion = this.getTentativeFinalBudgetVersion(awardForm);
            if (errorBudgetVersion != -1) {
                GlobalVariables.getMessageMap().putError("document.developmentProposalList[0].budgetVersionOverview[" + (errorBudgetVersion - 1) + "].budgetStatus", "clear.audit.error.before.change.status.to.complete", new String[0]);
            }
            return mapping.findForward("basic");
        }
        ActionForward forward = super.save(mapping, form, request, response);
        if (forward != null && forward.getName().equalsIgnoreCase("actions")) {
            awardForm.setMethodToCall("actions");
        }
        if (awardForm.getAwardDocument().getBudgetDocumentVersions() != null && !awardForm.getAwardDocument().getBudgetDocumentVersions().isEmpty()) {
            this.getBusinessObjectService().save(awardForm.getAwardDocument().getBudgetDocumentVersions());
        }
        return forward;
    }

    private int getTentativeFinalBudgetVersion(AwardForm awardForm) {
        if (awardForm.getFinalBudgetVersion() != null) {
            return awardForm.getFinalBudgetVersion();
        }
        AwardDocument document = awardForm.getAwardDocument();
        if (document != null && CollectionUtils.isNotEmpty((Collection)document.getBudgetDocumentVersions())) {
            List awardBudgetDocuments = document.getBudgetDocumentVersions();
            for (BudgetDocumentVersion budgetDocumentVersion : awardBudgetDocuments) {
                BudgetVersionOverview budget = budgetDocumentVersion.getBudgetVersionOverview();
                if (!budget.isFinalVersionFlag()) continue;
                return budget.getBudgetVersionNumber();
            }
        }
        return -1;
    }

    protected void updateAwardDocument(AwardForm awardForm) {
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        AwardDocument awardDocument = awardForm.getAwardDocument();
        boService.save(awardDocument.getBudgetDocumentVersions());
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        AwardForm awardForm = (AwardForm)form;
        awardForm.setFinalBudgetVersion(this.getFinalBudgetVersion(awardForm.getAwardDocument().getBudgetDocumentVersions()));
        this.setBudgetStatuses((BudgetParentDocument)awardForm.getAwardDocument());
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        tdcValidator.validateGeneratingWarnings((BudgetParentDocument)awardForm.getAwardDocument());
        return forward;
    }

    public ActionForward copyBudgetPeriodOne(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward copyBudgetAllPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("copyBudgetQuestion".equals(question)) {
            this.copyBudget(form, request, false);
        }
        return mapping.findForward("basic");
    }

    private BudgetVersionOverview getSelectedVersion(AwardForm proposalDevelopmentForm, HttpServletRequest request) {
        return proposalDevelopmentForm.getAwardDocument().getBudgetDocumentVersion(this.getSelectedLine(request)).getBudgetVersionOverview();
    }

    private void copyBudget(ActionForm form, HttpServletRequest request, boolean copyPeriodOneOnly) throws WorkflowException {
        AwardForm awardForm = (AwardForm)form;
        AwardDocument awardDoc = awardForm.getAwardDocument();
        BudgetVersionOverview budgetToCopy = this.getSelectedVersion(awardForm, request);
        this.copyBudget((BudgetParentDocument)awardDoc, budgetToCopy, copyPeriodOneOnly);
    }

    private StrutsConfirmation syncBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNCH_BUDGET_RATE, message, new String[]{""});
    }

    private BudgetRatesService getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public BudgetService getBudgetService() {
        return (BudgetService)KraServiceLocator.getService(BudgetService.class);
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardForm)form), true);
        AuditActionHelper.ValidationState state = new AuditActionHelper().isValidSubmission((KualiDocumentFormBase)((AwardForm)form), false);
        if (state == AuditActionHelper.ValidationState.ERROR) {
            actionForward = mapping.findForward("awardActions");
        }
        return actionForward;
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return null;
    }
}

