/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.contacts.AwardCreditSplitBean;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardProjectPersonnelBean;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardSponsorContactsBean;
import org.kuali.kra.award.contacts.AwardUnitContactsBean;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardContactsAction
extends AwardAction {
    private static final String PROJECT_PERSON_PREFIX = ".personIndex";
    private static final String LINE_SUFFIX = ".line";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS = "confirmSyncUnitContacts";
    private static final String CONFIRM_SYNC_UNIT_DETAILS = "confirmSyncUnitDetails";
    private static final String ADD_SYNC_UNIT_DETAILS = "addSyncUnitDetails";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS_KEY = "confirmSyncUnitContactsKey";

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        if (this.isValidSave(awardForm)) {
            this.setLeadUnitOnAwardFromPILeadUnit(award, awardForm);
            award.initCentralAdminContacts();
            forward = super.save(mapping, form, request, response);
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward forward = super.reload(mapping, form, request, response);
        awardForm.getAwardDocument().getAward().initCentralAdminContacts();
        return forward;
    }

    private void setLeadUnitOnAwardFromPILeadUnit(Award award, AwardForm awardForm) {
        for (AwardPerson person : award.getProjectPersons()) {
            if (!person.isPrincipalInvestigator() || person.getUnits().size() < 1) continue;
            AwardPersonUnit selectedUnit = null;
            for (AwardPersonUnit unit : person.getUnits()) {
                if (!unit.isLeadUnit()) continue;
                selectedUnit = unit;
            }
            if (selectedUnit == null) {
                selectedUnit = person.getUnit(0);
            }
            if (selectedUnit != null) {
                award.setUnitNumber(selectedUnit.getUnitNumber());
                award.setLeadUnit(selectedUnit.getUnit());
                continue;
            }
            award.setUnitNumber(null);
            award.setLeadUnit(null);
        }
    }

    public ActionForward addNewProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Award award = ((AwardForm)form).getAwardDocument().getAward();
        AwardPersonUnit newPersonUnit = this.getProjectPersonnelBean(form).getNewAwardPersonUnit(this.getSelectedLine(request));
        if (newPersonUnit.isLeadUnit() && award.getLeadUnit() != null) {
            return this.confirm(this.buildSyncUnitDetailsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_UNIT_DETAILS, ADD_SYNC_UNIT_DETAILS);
        }
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildSyncUnitDetailsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_UNIT_CONTACTS_KEY, "document.question.syncUnitContacts.text", new String[0]);
    }

    public ActionForward confirmSyncUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            AwardForm awardForm = (AwardForm)form;
            this.getUnitContactsBean((ActionForm)awardForm).syncAwardUnitContactsToLeadUnitContacts();
            this.getAward(form).initCentralAdminContacts();
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addSyncUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            this.getAward((ActionForm)awardForm).initCentralAdminContacts();
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPerson awardPerson = this.getProjectPersonnelBean(form).addProjectPerson();
        if (awardPerson != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)awardPerson, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardSponsorContact contact = this.getSponsorContactsBean(form).addSponsorContact();
        if (contact != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)contact, "sponsorContacts", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).addUnitContact();
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPerson awardPerson = (AwardPerson)this.getProjectPersonnelBean(form).getProjectPersonnel().get(this.getLineToDelete(request));
        this.getProjectPersonnelBean(form).deleteProjectPerson(this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)awardPerson, "projectPersons", null, mapping.findForward("basic"));
    }

    public ActionForward deleteProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPersonUnit unit = ((AwardPerson)this.getProjectPersonnelBean(form).getProjectPersonnel().get(this.getProjectPersonIndex(request))).getUnit(this.getLineToDelete(request));
        this.getProjectPersonnelBean(form).deleteProjectPersonUnit(this.getProjectPersonIndex(request), this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
    }

    public ActionForward deleteUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).deleteUnitContact(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardSponsorContact contact = (AwardSponsorContact)this.getSponsorContactsBean(form).getSponsorContacts().get(this.getLineToDelete(request));
        this.getSponsorContactsBean(form).deleteSponsorContact(this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)contact, "sponsorContacts", null, mapping.findForward("basic"));
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        SponsorService sponsorService = this.getSponsorService();
        Award award = this.getAward(form);
        return actionForward;
    }

    public ActionForward recalculateCreditSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getAwardCreditSplitBean(form).recalculateCreditSplit();
        return mapping.findForward("basic");
    }

    public ActionForward syncDefaultUnitContactsToLeadUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncUnitContactsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_UNIT_CONTACTS, "");
    }

    private StrutsConfirmation buildSyncUnitContactsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_UNIT_CONTACTS_KEY, "document.question.syncUnitContacts.text", new String[0]);
    }

    public ActionForward confirmSyncUnitContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.getUnitContactsBean((ActionForm)awardForm).syncAwardUnitContactsToLeadUnitContacts();
        this.getAward((ActionForm)awardForm).initCentralAdminContacts();
        return mapping.findForward("basic");
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private int getProjectPersonIndex(HttpServletRequest request) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)PROJECT_PERSON_PREFIX, (String)LINE_SUFFIX));
        }
        return selectedPersonIndex;
    }

    private AwardCreditSplitBean getAwardCreditSplitBean(ActionForm form) {
        return ((AwardForm)form).getAwardCreditSplitBean();
    }

    private AwardProjectPersonnelBean getProjectPersonnelBean(ActionForm form) {
        return ((AwardForm)form).getProjectPersonnelBean();
    }

    private AwardSponsorContactsBean getSponsorContactsBean(ActionForm form) {
        return ((AwardForm)form).getSponsorContactsBean();
    }

    private AwardUnitContactsBean getUnitContactsBean(ActionForm form) {
        return ((AwardForm)form).getUnitContactsBean();
    }

    public ActionForward syncProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardPerson person = award.getProjectPerson(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)person, "projectPersons");
        return mapping.findForward("basic");
    }

    public ActionForward syncProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardPersonUnit unit = award.getProjectPerson(this.getProjectPersonIndex(request)).getUnit(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons");
        return mapping.findForward("basic");
    }

    public ActionForward syncSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardSponsorContact contact = (AwardSponsorContact)award.getSponsorContacts().get(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)contact, "sponsorContacts");
        return mapping.findForward("basic");
    }

    public ActionForward addUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPerson person = (AwardPerson)awardForm.getProjectPersonnelBean().getProjectPersonnel().get(this.getSelectedLine(request));
        awardForm.getProjectPersonnelBean().addUnitDetails(person);
        return mapping.findForward("basic");
    }

    public ActionForward removeUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPerson person = (AwardPerson)awardForm.getProjectPersonnelBean().getProjectPersonnel().get(this.getSelectedLine(request));
        awardForm.getProjectPersonnelBean().removeUnitDetails(person);
        return mapping.findForward("basic");
    }
}

