/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.employment.EntityEmploymentContract;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifierContract;
import org.kuali.rice.kim.api.identity.name.EntityNameContract;
import org.kuali.rice.kim.api.identity.personal.EntityBioDemographicsContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfo;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;

/*
 * Exception performing whole class analysis ignored.
 */
public class KcPerson
implements Contactable,
BusinessObject {
    private static final long serialVersionUID = 1L;
    private String personId;
    private transient IdentityService identityService;
    private EntityContract entity = Entity.Builder.create();
    private transient BusinessObjectService boService;
    private KcPersonExtendedAttributes extendedAttributes = new KcPersonExtendedAttributes();
    private transient CountryService countryService;

    public static KcPerson fromPersonId(String personId) {
        if (StringUtils.isEmpty((String)personId)) {
            throw new IllegalArgumentException("the principalId is empty");
        }
        KcPerson person = new KcPerson();
        person.personId = personId;
        person.refreshEntity();
        person.refreshExtendedAttributes();
        return person;
    }

    public static KcPerson fromExtendedAttributes(KcPersonExtendedAttributes extendedAttributes) {
        if (extendedAttributes == null) {
            throw new IllegalArgumentException("the extendedAttributes is null");
        }
        if (StringUtils.isEmpty((String)extendedAttributes.getPersonId())) {
            throw new IllegalArgumentException("the extendedAttributes.personId is empty");
        }
        KcPerson person = new KcPerson();
        person.personId = extendedAttributes.getPersonId();
        person.extendedAttributes = extendedAttributes;
        person.refreshEntity();
        return person;
    }

    public static KcPerson fromEntityAndPersonId(EntityContract entity, String personId) {
        if (entity == null) {
            throw new IllegalArgumentException("the entity is null");
        }
        if (StringUtils.isEmpty((String)personId)) {
            throw new IllegalArgumentException("the personId is empty");
        }
        KcPerson person = new KcPerson();
        boolean contains = false;
        for (PrincipalContract principal : entity.getPrincipals()) {
            if (!personId.equals(principal.getPrincipalId())) continue;
            contains = true;
            break;
        }
        if (!contains) {
            throw new IllegalArgumentException("the entity " + entity + " does not have a principal with id " + personId);
        }
        person.personId = personId;
        person.entity = entity;
        person.refreshExtendedAttributes();
        return person;
    }

    public static KcPerson fromEntityAndUserName(EntityContract entity, String userName) {
        if (entity == null) {
            throw new IllegalArgumentException("the entity is null");
        }
        if (StringUtils.isEmpty((String)userName)) {
            throw new IllegalArgumentException("the userName is empty");
        }
        KcPerson person = new KcPerson();
        boolean contains = false;
        for (PrincipalContract principal : entity.getPrincipals()) {
            if (!userName.equalsIgnoreCase(principal.getPrincipalName())) continue;
            contains = true;
            person.personId = principal.getPrincipalId();
            break;
        }
        if (!contains) {
            throw new IllegalArgumentException("the entity " + entity + " does not have a principal name " + userName);
        }
        person.entity = entity;
        person.refreshExtendedAttributes();
        return person;
    }

    public void refresh() {
        this.refreshEntity();
        this.refreshExtendedAttributes();
    }

    private void refreshEntity() {
        this.entity = this.getIdentityService().getEntityByPrincipalId(this.personId);
        if (this.entity == null) {
            this.entity = Entity.Builder.create();
        }
    }

    private void refreshExtendedAttributes() {
        this.extendedAttributes = (KcPersonExtendedAttributes)this.getBusinessObjectService().findByPrimaryKey(KcPersonExtendedAttributes.class, Collections.singletonMap("personId", this.personId));
        if (this.extendedAttributes == null) {
            this.extendedAttributes = new KcPersonExtendedAttributes();
        }
    }

    public void prepareForWorkflow() {
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        this.refreshEntity();
        this.refreshExtendedAttributes();
    }

    public String getSocialSecurityNumber() {
        return this.getExternalId("SSN");
    }

    public String getLastName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getLastName() != null ? name.getLastName() : "";
    }

    public String getFirstName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getFirstName() != null ? name.getFirstName() : "";
    }

    public String getMiddleName() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getMiddleName() != null ? name.getMiddleName() : "";
    }

    public String getFullName() {
        String middleName = this.getMiddleName() != null ? this.getMiddleName() + " " : "";
        return (this.getFirstName() + " " + middleName + this.getLastName()).trim();
    }

    public String getPriorName() {
        return (String)KcPerson.selectSingleValue((Collection)this.entity.getNames(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getUserName() {
        String userName = this.getPrincipal() != null ? this.getPrincipal().getPrincipalName() : null;
        return userName != null ? userName : "";
    }

    public String getEmailAddress() {
        return (String)KcPerson.selectSingleValue((Collection)this.getEntityType().getEmailAddresses(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getDateOfBirth() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return "";
        }
        return bio.getBirthDate();
    }

    public Integer getAge() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return null;
        }
        Date birthDate = null;
        try {
            birthDate = bio.getBirthDate() != null ? DateUtils.parseDate((String)bio.getBirthDate(), (String[])new String[]{"mm/dd/yyyy"}) : null;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return birthDate != null ? this.calcAge(birthDate) : null;
    }

    public Integer getAgeByFiscalYear() {
        return this.extendedAttributes.getAgeByFiscalYear();
    }

    public String getGender() {
        EntityBioDemographicsContract bio = this.entity.getBioDemographics();
        if (bio == null) {
            return "";
        }
        return bio.getGenderCode() != null ? bio.getGenderCode() : "";
    }

    public String getRace() {
        return this.extendedAttributes.getRace();
    }

    public String getEducationLevel() {
        return this.extendedAttributes.getEducationLevel();
    }

    public String getDegree() {
        return this.extendedAttributes.getDegree();
    }

    public String getMajor() {
        return this.extendedAttributes.getMajor();
    }

    public Boolean getHandicappedFlag() {
        return this.extendedAttributes.getHandicappedFlag();
    }

    public String getHandicapType() {
        return this.extendedAttributes.getHandicapType();
    }

    public Boolean getVeteranFlag() {
        return this.extendedAttributes.getVeteranFlag();
    }

    public String getVeteranType() {
        return this.extendedAttributes.getVeteranType();
    }

    public String getVisaCode() {
        return this.extendedAttributes.getVisaCode();
    }

    public String getVisaType() {
        return this.extendedAttributes.getVisaType();
    }

    public String getVisaRenewalDate() {
        return this.extendedAttributes.getVisaRenewalDate() != null ? this.formatDate((Date)this.extendedAttributes.getVisaRenewalDate()) : null;
    }

    public Boolean getHasVisa() {
        return this.extendedAttributes.getHasVisa();
    }

    public String getOfficeLocation() {
        return this.extendedAttributes.getOfficeLocation();
    }

    public String getOfficePhone() {
        return this.getPhoneNumber("WRK", true);
    }

    public String getSecondaryOfficeLocation() {
        return this.extendedAttributes.getSecondaryOfficeLocation();
    }

    public String getSecondaryOfficePhone() {
        return this.getPhoneNumber("WRK", false);
    }

    public String getSchool() {
        return this.extendedAttributes.getSchool();
    }

    public String getYearGraduated() {
        return this.extendedAttributes.getYearGraduated();
    }

    public String getDirectoryDepartment() {
        return this.extendedAttributes.getDirectoryDepartment();
    }

    public String getSaluation() {
        EntityNameContract name = this.entity.getDefaultName();
        if (name == null) {
            return "";
        }
        return name.getNameTitle() != null ? name.getNameTitle() : "";
    }

    public String getCountryOfCitizenship() {
        return (String)KcPerson.selectSingleValue((Collection)this.entity.getCitizenships(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String getPrimaryTitle() {
        return this.extendedAttributes.getPrimaryTitle();
    }

    public String getDirectoryTitle() {
        return this.extendedAttributes.getDirectoryTitle();
    }

    public Boolean getFacultyFlag() {
        return this.hasAffiliation("FCLTY");
    }

    public Boolean getGraduateStudentStaffFlag() {
        return this.hasAffiliation("GRD_STDNT_STAFF");
    }

    public Boolean getResearchStaffFlag() {
        return this.hasAffiliation("RSRCH_STAFF");
    }

    public Boolean getServiceStaffFlag() {
        return this.hasAffiliation("SRVC_STAFF");
    }

    public Boolean getSupportStaffFlag() {
        return this.hasAffiliation("SUPPRT_STAFF");
    }

    public Boolean getOtherAcademicGroupFlag() {
        return this.hasAffiliation("OTH_ACADMC_GRP");
    }

    public Boolean getMedicalStaffFlag() {
        return this.hasAffiliation("MED_STAFF");
    }

    public Boolean getVacationAccrualFlag() {
        return this.extendedAttributes.getVacationAccrualFlag();
    }

    public Boolean getOnSabbaticalFlag() {
        return this.extendedAttributes.getOnSabbaticalFlag();
    }

    public String getIdProvided() {
        return this.extendedAttributes.getIdProvided();
    }

    public String getIdVerified() {
        return this.extendedAttributes.getIdVerified();
    }

    public String getAddressLine1() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine1() != null ? address.getLine1() : "";
    }

    public String getAddressLine2() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine2() != null ? address.getLine2() : "";
    }

    public String getAddressLine3() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getLine3() != null ? address.getLine3() : "";
    }

    public String getCity() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getCity() != null ? address.getCity() : "";
    }

    public String getCounty() {
        return this.extendedAttributes.getCounty();
    }

    public String getState() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getStateProvinceCode() != null ? address.getStateProvinceCode() : "";
    }

    public String getPostalCode() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getPostalCode() != null ? address.getPostalCode() : "";
    }

    public String getCountryCode() {
        EntityAddressContract address = this.getDefaultActiveAddress();
        return address.getCountryCode() != null ? this.convert2DigitCountryCodeTo3Digit(address.getCountryCode()) : "";
    }

    public String getFaxNumber() {
        return this.getPhoneNumber("FAX");
    }

    public String getPagerNumber() {
        return this.getPhoneNumber("PGR");
    }

    public String getMobilePhoneNumber() {
        return this.getPhoneNumber("MBL");
    }

    public String getEraCommonsUserName() {
        return this.getExternalId("ERAC");
    }

    public Boolean getActive() {
        return this.entity.isActive();
    }

    public String getIdentifier() {
        return this.getPersonId();
    }

    public Unit getUnit() {
        String org = this.getOrganizationIdentifier();
        return org != null ? (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap("unitNumber", org)) : null;
    }

    public String getPhoneNumber() {
        return this.getOfficePhone();
    }

    public String getContactOrganizationName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : null;
    }

    public String getOrganizationIdentifier() {
        EntityEmploymentContract emp = this.entity.getPrimaryEmployment();
        if (emp == null) {
            return "";
        }
        return emp.getPrimaryDepartmentCode() != null ? emp.getPrimaryDepartmentCode() : "";
    }

    public String getCampusCode() {
        return this.getCampusCode(true);
    }

    BusinessObjectService getBusinessObjectService() {
        if (this.boService == null) {
            this.boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.boService;
    }

    IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = (IdentityService)KraServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = (CountryService)KraServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public KcPersonExtendedAttributes getExtendedAttributes() {
        return this.extendedAttributes;
    }

    private String getPhoneNumber(String type) {
        return (String)KcPerson.selectSingleValue((Collection)this.getEntityType().getPhoneNumbers(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getPhoneNumber(String type, boolean isDefault) {
        return (String)KcPerson.selectSingleValue((Collection)this.getEntityType().getPhoneNumbers(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    private boolean hasAffiliation(String affilTypeCode) {
        return (Boolean)KcPerson.selectSingleValue((Collection)this.entity.getAffiliations(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getCampusCode(boolean isDefault) {
        return (String)KcPerson.selectSingleValue((Collection)this.entity.getAffiliations(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String formatDate(Date dte) {
        assert (dte != null) : "the date is null";
        return this.getKCDateFormat().format(dte);
    }

    private String getExternalId(String type) {
        EntityExternalIdentifierContract extId = this.entity.getEntityExternalIdentifier(type);
        return extId != null ? extId.getExternalId() : "";
    }

    private EntityAddressContract getDefaultActiveAddress() {
        return (EntityAddressContract)KcPerson.selectSingleValue((Collection)this.getEntityType().getAddresses(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    private EntityTypeContactInfoContract getEntityType() {
        EntityTypeContactInfoContract ent = this.entity.getEntityTypeContactInfoByTypeCode("PERSON");
        return ent != null ? ent : EntityTypeContactInfo.Builder.create((String)"", (String)"");
    }

    private Integer calcAge(Date dob) {
        return Integer.getInteger(DurationFormatUtils.formatPeriod((long)dob.getTime(), (long)new Date().getTime(), (String)"y"));
    }

    private String convert2DigitCountryCodeTo3Digit(String digit2) {
        Country country = this.getCountryService().getCountry(digit2);
        return country != null && country.getAlternateCode() != null ? country.getAlternateCode() : "";
    }

    private DateFormat getKCDateFormat() {
        return new SimpleDateFormat("MM/dd/yyyy");
    }

    private PrincipalContract getPrincipal() {
        return (PrincipalContract)KcPerson.selectSingleValue((Collection)this.entity.getPrincipals(), (Selector)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer(50);
        retVal.append("getAddressLine1:'").append(this.getAddressLine1()).append("'\n");
        retVal.append("getAddressLine2:'").append(this.getAddressLine2()).append("'\n");
        retVal.append("getAddressLine3:'").append(this.getAddressLine3()).append("'\n");
        retVal.append("city:'").append(this.getCity()).append("'\n");
        retVal.append("org name:'").append(this.getContactOrganizationName()).append("'\n");
        retVal.append("userName:'").append(this.getUserName()).append("'\n");
        retVal.append("first name:'").append(this.getFirstName()).append("'\n");
        retVal.append("last name:'").append(this.getLastName()).append("'\n");
        retVal.append("full name:'").append(this.getFullName()).append("'\n");
        retVal.append("personID:'").append(this.getPersonId()).append("'\n");
        retVal.append("entity type:'").append(this.getEntityType()).append("'\n");
        return retVal.toString();
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }

    private static <A, B> B selectSingleValue(Collection<? extends A> values, Selector<A, ? extends B> selector) {
        assert (selector != null) : "selector is null";
        if (values == null) {
            return (B)selector.notFoundValue();
        }
        for (A a : values) {
            if (a == null || !selector.shouldSelect(a)) continue;
            return (B)selector.select(a);
        }
        return (B)selector.notFoundValue();
    }

    static /* synthetic */ String access$000(KcPerson x0, String x1) {
        return x0.convert2DigitCountryCodeTo3Digit(x1);
    }

    static /* synthetic */ String access$100(KcPerson x0) {
        return x0.personId;
    }
}

