/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.CustomDataHelper;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;

public class KcPersonExtendedAttributesMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private CustomDataHelper customDataHelper = new CustomDataHelper(this);

    public CustomDataHelper getCustomDataHelper() {
        return this.customDataHelper;
    }

    public void setCustomDataHelper(CustomDataHelper customDataHelper) {
        this.customDataHelper = customDataHelper;
    }

    public void processAfterNew(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterEdit(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> requestParameters) {
        this.loadCustomData();
    }

    public void processAfterRetrieve() {
        this.loadCustomData();
    }

    private void loadCustomData() {
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getDataObject();
        this.getCustomDataHelper().prepareCustomData();
    }

    public void prepareForSave() {
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getDataObject();
        if (!this.isValidPrincipalId(kcPersonExtendedAttributes.getPersonId())) {
            this.reportInvalidPrincipalId(kcPersonExtendedAttributes);
        }
        if (!this.isValidCitizenshipTypeCode(kcPersonExtendedAttributes)) {
            this.reportInvalidCitizenshipTypeCode(kcPersonExtendedAttributes);
        }
        super.prepareForSave();
    }

    public void saveDataObject() {
        KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getDataObject();
        if (kcPersonExtendedAttributes.getCitizenshipType() == null && kcPersonExtendedAttributes.getCitizenshipTypeCode() != null) {
            kcPersonExtendedAttributes.refreshReferenceObject("citizenshipType");
        }
        super.saveDataObject();
        this.getCustomDataHelper().setCustomAttributeContent(this.getDocumentNumber(), "PersonCustomDataAttribute");
    }

    private void reportInvalidPrincipalId(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.personId", "error.person.principalId.notExist", new String[]{"Principal ID does not exist."});
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        PersonService personService = KimApiServiceLocator.getPersonService();
        if (StringUtils.isEmpty((String)principalId)) {
            valid = false;
        } else if (personService.getPerson(principalId) == null) {
            valid = false;
        }
        return valid;
    }

    private void reportInvalidCitizenshipTypeCode(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.citizenshipTypeCode", "error.missingcitizenship", new String[]{"Please select a citizenship type."});
    }

    private boolean isValidCitizenshipTypeCode(KcPersonExtendedAttributes kcPersonExtendedAttributes) {
        Integer citizenshipType = kcPersonExtendedAttributes.getCitizenshipTypeCode();
        return citizenshipType != null;
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            block1: for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.isNotEmpty((String)field.getPropertyName()) || !field.getPropertyName().equalsIgnoreCase("personId")) continue;
                    field.setFieldConversions("principalId:personId");
                    field.setQuickFinderClassNameImpl("org.kuali.rice.kim.api.identity.Person");
                    field.setFieldDirectInquiryEnabled(true);
                    field.setInquiryParameters("personId:principalId");
                    continue block1;
                }
            }
        }
        return this.filterPersonCustomDataSection(sections);
    }

    private List<Section> filterPersonCustomDataSection(List<Section> sections) {
        ArrayList<Section> filteredSections = new ArrayList<Section>();
        for (Section section : sections) {
            if (StringUtils.equals((String)section.getSectionTitle(), (String)"Edit Person Custom Data")) continue;
            filteredSections.add(section);
        }
        return filteredSections;
    }
}

