/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.krad.service.BusinessObjectService;

public class UnitAdministratorMaintainableImpl
extends KraMaintainableImpl
implements Maintainable {
    private static final long serialVersionUID = -4267900712064482626L;
    private static final String KIM_PERSON_LOOKUPABLE_REFRESH_CALLER = "kimPersonLookupable";
    private static final String UNIT_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.unitId";
    private static final String PRINCIPAL_ID_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.principalId";
    private static final String UNIT_ADMINISTRATOR_TYPE_CODE_INVALID_ERROR_KEY = "error.invalid.unitAdministrator.unitAdministratorTypeCode";

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
        if (KIM_PERSON_LOOKUPABLE_REFRESH_CALLER.equals(refreshCaller)) {
            UnitAdministrator unitAdministrator = (UnitAdministrator)this.getBusinessObject();
            String principalId = (String)fieldValues.get("principalId");
            unitAdministrator.setPersonId(principalId);
        }
    }

    public void prepareForSave() {
        UnitAdministrator unitAdministrator = (UnitAdministrator)this.businessObject;
        if (!this.isUnitIdValid(unitAdministrator.getUnitNumber())) {
            this.reportInvalidUnitId(unitAdministrator);
        }
        if (!this.isUnitAdministratorTypeCodeValid(unitAdministrator.getUnitAdministratorTypeCode())) {
            this.reportInvalidUnitAdministratorTypeCode(unitAdministrator);
        }
        if (!this.isValidPrincipalId(unitAdministrator.getPersonId())) {
            this.reportInvalidPrincipalId(unitAdministrator);
        }
        super.prepareForSave();
    }

    private void reportInvalidUnitId(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.unitNumber", UNIT_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidPrincipalId(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.person.userName", PRINCIPAL_ID_INVALID_ERROR_KEY, new String[0]);
    }

    private void reportInvalidUnitAdministratorTypeCode(UnitAdministrator unitAdministrator) {
        ErrorReporter errorReporter = new ErrorReporter();
        errorReporter.reportError("document.newMaintainableObject.unitAdministratorTypeCode", UNIT_ADMINISTRATOR_TYPE_CODE_INVALID_ERROR_KEY, new String[0]);
    }

    private boolean isValidPrincipalId(String principalId) {
        boolean valid = true;
        KcPersonService personService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        if (StringUtils.isEmpty((String)principalId)) {
            valid = false;
        } else {
            KcPerson person = personService.getKcPersonByPersonId(principalId);
            if (person == null) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isUnitIdValid(String unitNumber) {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validUnitParams = new HashMap<String, String>();
        validUnitParams.put("unitNumber", unitNumber);
        Collection units = businessObjectService.findMatching(Unit.class, validUnitParams);
        return !units.isEmpty();
    }

    private boolean isUnitAdministratorTypeCodeValid(String unitAdministratorTypeCode) {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validParams = new HashMap<String, String>();
        validParams.put("unitAdministratorTypeCode", unitAdministratorTypeCode);
        Collection units = businessObjectService.findMatching(UnitAdministratorType.class, validParams);
        return !units.isEmpty();
    }
}

