/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import org.kuali.kra.bo.PersonSignature;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class ValidPersonSignatureMaintenanceDocumentRule
extends KraMaintenanceDocumentRuleBase {
    private static final String PERSON_SIGNATURE_FILE_INVALID_ERROR_KEY = "error.invalid.personSignature.invalid.fileName";

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.isPersonSignatureValidForSave(document);
    }

    public boolean isPersonSignatureValidForSave(MaintenanceDocument document) {
        boolean result = super.isDocumentValidForSave(document);
        return result &= this.isSignatureValid(document);
    }

    private boolean isSignatureValid(MaintenanceDocument document) {
        boolean isSignatureValid = true;
        PersonSignature personSignature = (PersonSignature)document.getNewMaintainableObject().getDataObject();
        if (personSignature.getTemplateFile() == null && personSignature.getFileName() == null) {
            ErrorReporter errorReporter = new ErrorReporter();
            errorReporter.reportError("document.newMaintainableObject.templateFile", PERSON_SIGNATURE_FILE_INVALID_ERROR_KEY, new String[0]);
            isSignatureValid = false;
        }
        return isSignatureValid;
    }
}

