/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BreakUpInterval;
import org.kuali.kra.budget.calculator.BreakupIntervalService;
import org.kuali.kra.budget.calculator.BreakupIntervalServiceImpl;
import org.kuali.kra.budget.calculator.Node;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateAndCost;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.NotEquals;
import org.kuali.kra.budget.calculator.query.Operator;
import org.kuali.kra.budget.rates.AbstractBudgetRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateClassBaseExclusion;
import org.kuali.kra.budget.rates.RateClassBaseInclusion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BreakupIntervalServiceImpl
implements BreakupIntervalService {
    private BusinessObjectService businessObjectService;
    private List<RateClassBaseInclusion> rateClassBaseInclusions;
    private List<RateClassBaseExclusion> rateClassBaseExclusions;

    public List<RateClassBaseInclusion> getRateClassBaseInclusions() {
        return this.rateClassBaseInclusions;
    }

    public void setRateClassBaseInclusions(List<RateClassBaseInclusion> rateClassBaseInclusions) {
        this.rateClassBaseInclusions = rateClassBaseInclusions;
    }

    public List<RateClassBaseExclusion> getRateClassBaseExclusions() {
        return this.rateClassBaseExclusions;
    }

    public void setRateClassBaseExclusions(List<RateClassBaseExclusion> rateClassBaseExclusions) {
        this.rateClassBaseExclusions = rateClassBaseExclusions;
    }

    private void initializeRateClassBases() {
        this.setRateClassBaseInclusions((List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class));
        this.setRateClassBaseExclusions((List)this.getBusinessObjectService().findAll(RateClassBaseExclusion.class));
    }

    public void calculate(BreakUpInterval breakupInterval) {
        this.initializeRateClassBases();
        QueryList rateAndCosts = breakupInterval.getRateAndCosts();
        List rateClassInclusions = (List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class);
        for (RateClassBaseInclusion rateClassBaseInclusion : rateClassInclusions) {
            if (!this.canApplyRate(rateClassBaseInclusion, rateAndCosts)) continue;
            this.findAndApplyRateRecursively(breakupInterval, rateClassBaseInclusion, rateAndCosts);
        }
        breakupInterval.setUnderRecovery(rateAndCosts.sumObjects("underRecovery"));
    }

    private boolean canApplyRate(RateClassBaseInclusion rateClassBaseInclusion, QueryList<RateAndCost> rateAndCosts) {
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateClassBaseInclusion.getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateClassBaseInclusion.getRateTypeCode()));
        QueryList applicableRateList = rateAndCosts.filter((Operator)(rateClassBaseInclusion.getRateTypeCode() == null ? eqRateClassCode : new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode)));
        return !applicableRateList.isEmpty();
    }

    private void findAndApplyRateRecursively(BreakUpInterval breakupInterval, RateClassBaseInclusion rateClassBaseInclusion, QueryList<RateAndCost> rateAndCosts) {
        RateClassInclusionTree rateClassInclusionTree = this.getRateClassInclusionTree(rateClassBaseInclusion.getRateClassBaseInclusionId());
        List rateClassInclusions = rateClassInclusionTree.toList();
        int numberOfNodes = rateClassInclusions.size();
        BudgetDecimal baseCost = breakupInterval.getApplicableAmt();
        BudgetDecimal baseCostSharing = breakupInterval.getApplicableAmtCostSharing();
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCostSharing = BudgetDecimal.ZERO;
        for (int i = numberOfNodes - 1; i >= 0; --i) {
            Node rateClassInclusionNode = (Node)rateClassInclusions.get(i);
            RateClassBaseInclusion rcbi = (RateClassBaseInclusion)rateClassInclusionNode.getData();
            QueryList applicableRateList = this.filterApplicableRates(rateAndCosts, rcbi);
            if (!applicableRateList.isEmpty()) {
                for (RateAndCost rateAndCost : applicableRateList) {
                    if (!rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType()) && !rateAndCost.isApplyRateFlag().booleanValue()) continue;
                    BudgetDecimal rate = this.getAppliedRate(breakupInterval, rateAndCost);
                    calculatedCost = baseCost.percentage(rate);
                    calculatedCostSharing = baseCostSharing.percentage(rate);
                    if (i != 0) continue;
                    rateAndCost.setAppliedRate(rate);
                    rateAndCost.setCalculatedCost((BudgetDecimal)rateAndCost.getCalculatedCost().add((AbstractKualiDecimal)calculatedCost));
                    rateAndCost.setCalculatedCostSharing((BudgetDecimal)rateAndCost.getCalculatedCostSharing().add((AbstractKualiDecimal)calculatedCostSharing));
                    rateAndCost.setBaseAmount((BudgetDecimal)rateAndCost.getBaseAmount().add((AbstractKualiDecimal)baseCost));
                    rateAndCost.setBaseCostSharingAmount((BudgetDecimal)rateAndCost.getBaseCostSharingAmount().add((AbstractKualiDecimal)baseCostSharing));
                    rateAndCost.setCalculated(true);
                    if (!rateAndCost.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    this.calculateUnderRecovery(breakupInterval, rateAndCost);
                }
                baseCost = calculatedCost;
                baseCostSharing = calculatedCostSharing;
                continue;
            }
            baseCost = BudgetDecimal.ZERO;
            baseCostSharing = BudgetDecimal.ZERO;
        }
    }

    private BudgetDecimal getAppliedRate(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateAndCost.getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateAndCost.getRateTypeCode()));
        And rcAndRt = new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode);
        QueryList breakupIntervalRates = breakupInterval.getBudgetProposalRates();
        QueryList breakupIntervalLaRates = breakupInterval.getBudgetProposalLaRates();
        QueryList applicableRates = breakupIntervalRates.filter((Operator)rcAndRt);
        if (applicableRates.isEmpty()) {
            applicableRates = breakupIntervalLaRates.filter((Operator)rcAndRt);
        }
        return applicableRates.isEmpty() ? BudgetDecimal.ZERO : ((AbstractBudgetRate)applicableRates.get(0)).getApplicableRate();
    }

    private void calculateUnderRecovery(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        BudgetDecimal underRecoveryRate = BudgetDecimal.ZERO;
        BudgetDecimal instituteRate = BudgetDecimal.ZERO;
        instituteRate = breakupInterval.getURRatesBean() != null ? breakupInterval.getURRatesBean().getInstituteRate() : this.filterInstituteRate(breakupInterval, rateAndCost);
        if (!rateAndCost.isApplyRateFlag().booleanValue()) {
            underRecoveryRate = instituteRate;
            rateAndCost.setCalculatedCost(BudgetDecimal.ZERO);
            rateAndCost.setCalculatedCostSharing(BudgetDecimal.ZERO);
        } else {
            underRecoveryRate = (BudgetDecimal)instituteRate.subtract((AbstractKualiDecimal)this.getAppliedRate(breakupInterval, rateAndCost));
        }
        BudgetDecimal underRecovery = rateAndCost.getBaseAmount().percentage(underRecoveryRate);
        BudgetDecimal underRecoveryCostShare = rateAndCost.getBaseCostSharingAmount().percentage(underRecoveryRate);
        rateAndCost.setUnderRecovery((BudgetDecimal)underRecovery.add((AbstractKualiDecimal)underRecoveryCostShare));
    }

    private BudgetDecimal filterInstituteRate(BreakUpInterval breakupInterval, RateAndCost rateAndCost) {
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateAndCost.getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateAndCost.getRateTypeCode()));
        And rcAndRt = new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode);
        QueryList breakupIntervalRates = breakupInterval.getBudgetProposalRates();
        QueryList applicableRates = breakupIntervalRates.filter((Operator)rcAndRt);
        return applicableRates.isEmpty() ? BudgetDecimal.ZERO : ((BudgetRate)applicableRates.get(0)).getInstituteRate();
    }

    private QueryList<RateAndCost> filterApplicableRates(QueryList<RateAndCost> rateAndCosts, RateClassBaseInclusion rcbi) {
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rcbi.getRateClassCode()));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rcbi.getRateTypeCode()));
        Equals rcAndRt = rcbi.getRateTypeCode() == null ? eqRateClassCode : new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode);
        QueryList applicableRateList = rateAndCosts.filter((Operator)rcAndRt);
        List rateClassInclusions = (List)this.getBusinessObjectService().findAll(RateClassBaseInclusion.class);
        for (RateClassBaseInclusion rateClassInclusion : rateClassInclusions) {
            if (!rcbi.getRateClassCode().equals(rateClassInclusion.getRateClassCode()) || rcbi.getRateTypeCode() != null || rateClassInclusion.getRateTypeCode() == null) continue;
            NotEquals neRateTypeCode = new NotEquals("rateTypeCode", (Comparable)((Object)rateClassInclusion.getRateTypeCode()));
            applicableRateList = applicableRateList.filter((Operator)neRateTypeCode);
        }
        return applicableRateList;
    }

    public RateClassInclusionTree getRateClassInclusionTree(Long id) {
        RateClassInclusionTree taskTree = new RateClassInclusionTree(this);
        Node rootElement = new Node((Object)this.getBusinessObjectFactory().findBySinglePrimaryKey(RateClassBaseInclusion.class, (Object)id));
        this.getRecursive(rootElement, taskTree);
        taskTree.setRootElement(rootElement);
        return taskTree;
    }

    private BusinessObjectService getBusinessObjectFactory() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private void getRecursive(Node<RateClassBaseInclusion> taskElement, RateClassInclusionTree tree) {
        List children = this.findRateClassInclusions(((RateClassBaseInclusion)taskElement.getData()).getRateClassCodeIncl(), ((RateClassBaseInclusion)taskElement.getData()).getRateTypeCodeIncl());
        ArrayList<Node> childElements = new ArrayList<Node>();
        for (RateClassBaseInclusion childTask : children) {
            Node childElement = new Node((Object)childTask);
            if (this.isExcluded(((RateClassBaseInclusion)taskElement.getData()).getRateClassCode(), ((RateClassBaseInclusion)taskElement.getData()).getRateTypeCode(), childElement)) continue;
            childElements.add(childElement);
            this.getRecursive(childElement, tree);
        }
        taskElement.setChildren(childElements);
    }

    private boolean isExcluded(String rateClassCode, String rateTypeCode, Node<RateClassBaseInclusion> childElement) {
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateTypeCode));
        Equals rcAndRt = rateTypeCode == null ? eqRateClassCode : new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode);
        Equals eqRateClassCodeExcl = new Equals("rateClassCodeExcl", (Comparable)((Object)((RateClassBaseInclusion)childElement.getData()).getRateClassCode()));
        Equals eqRateTypeCodeExcl = new Equals("rateTypeCodeExcl", (Comparable)((Object)((RateClassBaseInclusion)childElement.getData()).getRateTypeCode()));
        Equals rcExclAndRtExcl = eqRateTypeCodeExcl == null ? eqRateClassCodeExcl : new And((Operator)eqRateClassCodeExcl, (Operator)eqRateTypeCodeExcl);
        And rcAndRcExcl = new And((Operator)rcAndRt, (Operator)rcExclAndRtExcl);
        QueryList rateClassQueryList = new QueryList((Collection)this.getRateClassBaseExclusions());
        QueryList filteredRateClasses = rateClassQueryList.filter((Operator)rcAndRcExcl);
        return !filteredRateClasses.isEmpty();
    }

    private List<RateClassBaseInclusion> findRateClassInclusions(String rateClassCode, String rateTypeCode) {
        QueryList rateInclusions = new QueryList((Collection)this.getRateClassBaseInclusions());
        rateInclusions.sort("rateClassCodeIncl");
        Equals eqRateClassCode = new Equals("rateClassCode", (Comparable)((Object)rateClassCode));
        Equals eqRateTypeCode = new Equals("rateTypeCode", (Comparable)((Object)rateTypeCode));
        Equals rcAndRt = rateTypeCode == null ? eqRateClassCode : new And((Operator)eqRateClassCode, (Operator)eqRateTypeCode);
        QueryList inclusions = rateInclusions.filter((Operator)rcAndRt);
        for (RateClassBaseInclusion rateClassBaseInclusion : inclusions) {
            List dependentInclusions = this.findRateClassInclusions(rateClassBaseInclusion.getRateClassCodeIncl(), rateClassBaseInclusion.getRateTypeCodeIncl());
            for (RateClassBaseInclusion rateClassBaseInclusion2 : dependentInclusions) {
                rateClassBaseInclusion2.setParentRateClassBaseInclusionId(rateClassBaseInclusion.getRateClassBaseInclusionId());
            }
        }
        return inclusions;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

