/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemCalculatedAmountExt;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.BudgetPeriodCalculator;
import org.kuali.kra.budget.calculator.LineItemCalculator;
import org.kuali.kra.budget.calculator.PersonnelLineItemCalculator;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.SalaryCalculator;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.Operator;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyStatusConstants;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class BudgetCalculationServiceImpl
implements BudgetCalculationService {
    private static final String EQUIPMENT = "E";
    private static final String TRAVEL = "T";
    private static final String PARTICIPANT_SUPPORT = "S";
    private static final String OTHER_DIRECT = "O";
    private static final String CALCULATED_COST = "CalculatedCost";
    private static final String INDIRECT_COST = "IndirectCost";
    private static final String SALARY = "Salary";
    private static final String FRINGE = "Fringe";
    private BusinessObjectService businessObjectService;
    private BudgetDistributionAndIncomeService budgetDistributionAndIncomeService;

    public void calculateBudget(Budget budget) {
        List budgetPeriods = budget.getBudgetPeriods();
        String ohRateClassCodePrevValue = null;
        BudgetForm form = this.getBudgetFormFromGlobalVariables();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (!this.isCalculationRequired(budget, budgetPeriod)) continue;
            String workOhCode = null;
            if (budget.getOhRateClassCode() != null && form != null && budget.getBudgetPeriods().size() > budgetPeriod.getBudgetPeriod()) {
                workOhCode = form.getOhRateClassCodePrevValue();
            }
            this.calculateBudgetPeriod(budget, budgetPeriod);
            if (budget.getOhRateClassCode() == null || form == null || budget.getBudgetPeriods().size() <= budgetPeriod.getBudgetPeriod()) continue;
            ohRateClassCodePrevValue = form.getOhRateClassCodePrevValue();
            form.setOhRateClassCodePrevValue(workOhCode);
        }
        if (form != null && form.getOhRateClassCodePrevValue() == null && ohRateClassCodePrevValue != null) {
            form.setOhRateClassCodePrevValue(ohRateClassCodePrevValue);
        }
        if (budgetPeriods != null && !budgetPeriods.isEmpty()) {
            this.syncCostsToBudget(budget);
        }
    }

    protected boolean isCalculationRequired(Budget budget, BudgetPeriod budgetPeriod) {
        assert (budgetPeriod != null) : "The budget period is null";
        boolean budgetLineItemDeleted = budget.isBudgetLineItemDeleted();
        if (this.getBudgetCommonService(budget).isRateOverridden(budgetPeriod)) {
            return false;
        }
        if (StringUtils.equals((String)budgetPeriod.getBudget().getBudgetParent().getHierarchyStatus(), (String)HierarchyStatusConstants.Parent.code())) {
            return true;
        }
        boolean isLineItemsEmpty = budgetPeriod.getBudgetLineItems().isEmpty();
        if (isLineItemsEmpty && !budgetLineItemDeleted) {
            HashMap<String, Number> fieldValues = new HashMap<String, Number>();
            fieldValues.put("budgetId", budgetPeriod.getBudgetId());
            fieldValues.put("budgetPeriod", budgetPeriod.getBudgetPeriod());
            Collection deletedLineItems = this.businessObjectService.findMatching(BudgetLineItem.class, fieldValues);
            return !deletedLineItems.isEmpty();
        }
        return true;
    }

    protected void copyLineItemToPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
        budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
        budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
        budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
        budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
        budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
        budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
    }

    public void calculateBudgetLineItem(Budget budget, BudgetPersonnelDetails budgetLineItem) {
        new PersonnelLineItemCalculator(budget, (BudgetLineItemBase)budgetLineItem).calculate();
    }

    public void calculateBudgetLineItem(Budget budget, BudgetLineItem budgetLineItem) {
        BudgetLineItem budgetLineItemToCalc = budgetLineItem;
        List budgetPersonnelDetList = budgetLineItemToCalc.getBudgetPersonnelDetailsList();
        if (budgetLineItemToCalc.isBudgetPersonnelLineItemDeleted() || budgetPersonnelDetList != null && !budgetPersonnelDetList.isEmpty()) {
            List budgetLineItemCalculatedAmounts;
            String rateKey;
            this.updatePersonnelBudgetRate(budgetLineItemToCalc);
            BudgetDecimal personnelLineItemTotal = BudgetDecimal.ZERO;
            BudgetDecimal personnelTotalCostSharing = BudgetDecimal.ZERO;
            HashMap<String, BudgetDecimal> totalCalculatedCost = new HashMap<String, BudgetDecimal>();
            HashMap<String, BudgetDecimal> totalCalculatedCostSharing = new HashMap<String, BudgetDecimal>();
            BudgetDecimal newTotalUrAmount = BudgetDecimal.ZERO;
            budgetLineItem.getBudgetRateAndBaseList().clear();
            int rateNumber = 0;
            boolean resetTotalUnderRecovery = false;
            BudgetDecimal calcDirectCost = BudgetDecimal.ZERO;
            BudgetDecimal calcIndirectCost = BudgetDecimal.ZERO;
            BudgetDecimal calcTotalCostSharing = BudgetDecimal.ZERO;
            for (BudgetPersonnelDetails budgetPersonnelDetails : budgetPersonnelDetList) {
                this.copyLineItemToPersonnelDetails(budgetLineItemToCalc, budgetPersonnelDetails);
                new PersonnelLineItemCalculator(budget, (BudgetLineItemBase)budgetPersonnelDetails).calculate();
                personnelLineItemTotal = (BudgetDecimal)personnelLineItemTotal.add((AbstractKualiDecimal)budgetPersonnelDetails.getLineItemCost());
                personnelTotalCostSharing = (BudgetDecimal)personnelTotalCostSharing.add((AbstractKualiDecimal)budgetPersonnelDetails.getCostSharingAmount());
                newTotalUrAmount = (BudgetDecimal)newTotalUrAmount.add((AbstractKualiDecimal)budgetPersonnelDetails.getUnderrecoveryAmount());
                resetTotalUnderRecovery = true;
                List calAmts = budgetPersonnelDetails.getBudgetCalculatedAmounts();
                if (CollectionUtils.isNotEmpty((Collection)calAmts)) {
                    for (BudgetPersonnelCalculatedAmount personnelCalAmt : calAmts) {
                        rateKey = personnelCalAmt.getRateClassCode() + ":" + personnelCalAmt.getRateTypeCode();
                        if (!totalCalculatedCost.containsKey(rateKey)) {
                            totalCalculatedCost.put(rateKey, personnelCalAmt.getCalculatedCost());
                            totalCalculatedCostSharing.put(rateKey, personnelCalAmt.getCalculatedCostSharing());
                        } else {
                            BudgetDecimal value = (BudgetDecimal)totalCalculatedCost.get(rateKey);
                            value = (BudgetDecimal)value.add((AbstractKualiDecimal)personnelCalAmt.getCalculatedCost());
                            totalCalculatedCost.put(rateKey, value);
                            value = (BudgetDecimal)totalCalculatedCostSharing.get(rateKey);
                            value = (BudgetDecimal)value.add((AbstractKualiDecimal)personnelCalAmt.getCalculatedCostSharing());
                            totalCalculatedCostSharing.put(rateKey, value);
                        }
                        if (personnelCalAmt.getRateClass() == null) {
                            personnelCalAmt.refreshReferenceObject("rateClass");
                        }
                        if (!personnelCalAmt.getRateClass().getRateClassType().equals(OTHER_DIRECT)) {
                            calcDirectCost = (BudgetDecimal)calcDirectCost.add((AbstractKualiDecimal)personnelCalAmt.getCalculatedCost());
                        } else {
                            calcIndirectCost = (BudgetDecimal)calcIndirectCost.add((AbstractKualiDecimal)personnelCalAmt.getCalculatedCost());
                        }
                        calcTotalCostSharing = (BudgetDecimal)calcTotalCostSharing.add((AbstractKualiDecimal)personnelCalAmt.getCalculatedCostSharing());
                    }
                }
                this.populateRateAndBase(budgetLineItem, budgetPersonnelDetails, rateNumber);
            }
            if (resetTotalUnderRecovery) {
                budgetLineItem.setUnderrecoveryAmount(newTotalUrAmount);
            }
            budgetLineItem.setLineItemCost(personnelLineItemTotal);
            budgetLineItem.setCostSharingAmount(personnelTotalCostSharing);
            budgetLineItem.setDirectCost((BudgetDecimal)calcDirectCost.add((AbstractKualiDecimal)personnelLineItemTotal));
            budgetLineItem.setTotalCostSharingAmount((BudgetDecimal)calcTotalCostSharing.add((AbstractKualiDecimal)personnelTotalCostSharing));
            budgetLineItem.setIndirectCost(calcIndirectCost);
            boolean lineItemCalcAmntsOutOfDate = false;
            if (budgetLineItem.getBudgetCalculatedAmounts().size() == totalCalculatedCost.size()) {
                for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    rateKey = lineItemCalAmt.getRateClassCode() + ":" + lineItemCalAmt.getRateTypeCode();
                    if (totalCalculatedCost.containsKey(rateKey)) continue;
                    lineItemCalcAmntsOutOfDate = true;
                    break;
                }
            } else {
                lineItemCalcAmntsOutOfDate = true;
            }
            if (lineItemCalcAmntsOutOfDate) {
                this.rePopulateCalculatedAmount(budget, budgetLineItemToCalc);
            }
            if (CollectionUtils.isNotEmpty((Collection)(budgetLineItemCalculatedAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts()))) {
                for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItemCalculatedAmounts) {
                    String rateKey2 = lineItemCalAmt.getRateClassCode() + ":" + lineItemCalAmt.getRateTypeCode();
                    if (!totalCalculatedCost.containsKey(rateKey2)) continue;
                    lineItemCalAmt.setCalculatedCost((BudgetDecimal)totalCalculatedCost.get(rateKey2));
                    lineItemCalAmt.setCalculatedCostSharing((BudgetDecimal)totalCalculatedCostSharing.get(rateKey2));
                }
            }
        } else {
            new LineItemCalculator(budget, budgetLineItem).calculate();
        }
    }

    protected void populateRateAndBase(BudgetLineItem bli, BudgetPersonnelDetails budgetPersonnelDetails, int rateNumber) {
        List budgetRateAndBaseList = bli.getBudgetRateAndBaseList();
        List budgetPersonnelRateBaseList = budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList();
        for (BudgetPersonnelRateAndBase budgetPersonnelRateAndBase : budgetPersonnelRateBaseList) {
            BudgetRateAndBase budgetRateBase = new BudgetRateAndBase();
            BudgetDecimal appliedRate = budgetPersonnelRateAndBase.getAppliedRate();
            budgetRateBase.setAppliedRate(BudgetDecimal.returnZeroIfNull((BudgetDecimal)appliedRate));
            BudgetDecimal calculatedCost = budgetPersonnelRateAndBase.getCalculatedCost();
            BudgetDecimal calculatedCostSharing = budgetPersonnelRateAndBase.getCalculatedCostSharing();
            budgetRateBase.setBaseCostSharing(budgetPersonnelRateAndBase.getBaseCostSharing());
            budgetRateBase.setBaseCost(budgetPersonnelRateAndBase.getSalaryRequested());
            budgetRateBase.setBudgetPeriodId(budgetPersonnelRateAndBase.getBudgetPeriodId());
            budgetRateBase.setBudgetPeriod(budgetPersonnelRateAndBase.getBudgetPeriod());
            budgetRateBase.setCalculatedCost(calculatedCost);
            budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
            budgetRateBase.setEndDate(budgetPersonnelRateAndBase.getEndDate());
            budgetRateBase.setLineItemNumber(budgetPersonnelRateAndBase.getLineItemNumber());
            budgetRateBase.setOnOffCampusFlag(budgetPersonnelRateAndBase.getOnOffCampusFlag());
            budgetRateBase.setBudgetId(budgetPersonnelRateAndBase.getBudgetId());
            budgetRateBase.setRateClassCode(budgetPersonnelRateAndBase.getRateClassCode());
            budgetRateBase.setRateNumber(Integer.valueOf(++rateNumber));
            budgetRateBase.setRateTypeCode(budgetPersonnelRateAndBase.getRateTypeCode());
            budgetRateBase.setStartDate(budgetPersonnelRateAndBase.getStartDate());
            budgetRateAndBaseList.add(budgetRateBase);
        }
    }

    public void calculateAndSyncBudgetLineItem(Budget budget, BudgetLineItem budgetLineItem) {
        new LineItemCalculator(budget, budgetLineItem).calculate();
        this.syncCostsToBudget(budget);
    }

    public void populateCalculatedAmount(Budget budget, BudgetLineItem budgetLineItem) {
        new LineItemCalculator(budget, budgetLineItem).populateCalculatedAmountLineItems();
    }

    public void populateCalculatedAmount(Budget budget, BudgetPersonnelDetails budgetPersonnelDetails) {
        new PersonnelLineItemCalculator(budget, (BudgetLineItemBase)budgetPersonnelDetails).populateCalculatedAmountLineItems();
    }

    public void calculateSalary(Budget budget, BudgetPersonnelDetails budgetPersonnelLineItem) {
        new SalaryCalculator(budget, budgetPersonnelLineItem).calculate();
    }

    public void calculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        if (this.isCalculationRequired(budget, budgetPeriod)) {
            new BudgetPeriodCalculator().calculate(budget, budgetPeriod);
        }
    }

    public void calculateAndSyncBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.calculateBudgetPeriod(budget, budgetPeriod);
        this.syncCostsToBudget(budget);
    }

    protected void syncCostsToBudget(Budget budget) {
        assert (budget != null) : "The budget was null";
        this.initCostDependentItems(budget);
        this.ensureBudgetPeriodHasSyncedCosts(budget);
        this.setBudgetCostsFromPeriods(budget);
    }

    protected void initCostDependentItems(Budget budget) {
        assert (budget != null) : "The budget was null";
        if (!this.isPositiveTotalUnderreoveryAmount(budget)) {
            this.initUnrecoveredFandAs(budget);
        }
        if (!this.isPositiveTotalCostSharingAmount(budget)) {
            this.initCostSharing(budget);
        }
    }

    protected void initUnrecoveredFandAs(Budget document) {
        assert (document != null) : "the document was null";
        document.getBudgetUnrecoveredFandAs().clear();
        this.getBudgetDistributionAndIncomeService().initializeUnrecoveredFandACollectionDefaults(document);
    }

    protected void initCostSharing(Budget document) {
        assert (document != null) : "the document was null";
        document.getBudgetCostShares().clear();
        this.getBudgetDistributionAndIncomeService().initializeCostSharingCollectionDefaults(document);
    }

    protected void ensureBudgetPeriodHasSyncedCosts(Budget budget) {
        assert (budget != null) : "the document was null";
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (!this.isCalculationRequired(budget, budgetPeriod)) continue;
            this.setBudgetPeriodCostsFromLineItems(budgetPeriod);
        }
    }

    protected void setBudgetCostsFromPeriods(Budget budget) {
        assert (budget != null) : "The document is null";
        budget.setTotalDirectCost(budget.getSumDirectCostAmountFromPeriods());
        budget.setTotalIndirectCost(budget.getSumIndirectCostAmountFromPeriods());
        budget.setTotalCost(budget.getSumTotalCostAmountFromPeriods());
        budget.setUnderrecoveryAmount(budget.getSumUnderreoveryAmountFromPeriods());
        budget.setCostSharingAmount(budget.getSumCostSharingAmountFromPeriods());
    }

    protected void setBudgetPeriodCostsFromLineItems(BudgetPeriod budgetPeriod) {
        assert (budgetPeriod != null) : "The period is null";
        budgetPeriod.setTotalDirectCost(budgetPeriod.getSumDirectCostAmountFromLineItems());
        budgetPeriod.setTotalIndirectCost(budgetPeriod.getSumIndirectCostAmountFromLineItems());
        budgetPeriod.setTotalCost(budgetPeriod.getSumTotalCostAmountFromLineItems());
        budgetPeriod.setUnderrecoveryAmount(budgetPeriod.getSumUnderreoveryAmountFromLineItems());
        budgetPeriod.setCostSharingAmount(budgetPeriod.getSumTotalCostSharingAmountFromLineItems());
    }

    protected final boolean isPositiveTotalUnderreoveryAmount(Budget document) {
        assert (document != null) : "The periods is null";
        BudgetDecimal lineItemsAmount = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : document.getBudgetPeriods()) {
            lineItemsAmount = (BudgetDecimal)lineItemsAmount.add((AbstractKualiDecimal)budgetPeriod.getSumUnderreoveryAmountFromLineItems());
        }
        return lineItemsAmount.isPositive() || document.getSumUnderreoveryAmountFromPeriods().isPositive();
    }

    protected final boolean isPositiveTotalCostSharingAmount(Budget document) {
        assert (document != null) : "The document is null";
        BudgetDecimal lineItemsAmount = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : document.getBudgetPeriods()) {
            lineItemsAmount = (BudgetDecimal)lineItemsAmount.add((AbstractKualiDecimal)budgetPeriod.getSumTotalCostSharingAmountFromLineItems());
        }
        return lineItemsAmount.isPositive() || document.getSumCostSharingAmountFromPeriods().isPositive();
    }

    protected SortedMap<BudgetCategoryType, List<CostElement>> categorizeObjectCodesByCategory(Budget budget) {
        SortedMap objectCodeTotals = budget.getObjectCodeTotals();
        TreeMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType = new TreeMap<BudgetCategoryType, List<CostElement>>();
        for (CostElement objectCode : objectCodeTotals.keySet()) {
            objectCode.refreshReferenceObject("budgetCategory");
            if (objectCode.getBudgetCategory() != null) {
                objectCode.getBudgetCategory().refreshReferenceObject("budgetCategoryType");
                objectCode.setBudgetCategoryTypeCode(objectCode.getBudgetCategory().getBudgetCategoryTypeCode());
            }
            if (objectCodeListByBudgetCategoryType.containsKey(objectCode.getBudgetCategory().getBudgetCategoryType())) continue;
            List filteredObjectCodes = this.filterObjectCodesByBudgetCategoryType(objectCodeTotals.keySet(), objectCode.getBudgetCategoryTypeCode());
            objectCodeListByBudgetCategoryType.put(objectCode.getBudgetCategory().getBudgetCategoryType(), filteredObjectCodes);
        }
        return objectCodeListByBudgetCategoryType;
    }

    protected BudgetCategoryType getPersonnelCategoryType() {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("budgetCategoryTypeCode", "P");
        return (BudgetCategoryType)this.getBusinessObjectService().findByPrimaryKey(BudgetCategoryType.class, primaryKeys);
    }

    public void calculateBudgetSummaryTotals(Budget budget) {
        this.calculateBudgetTotals(budget);
        SortedMap objectCodeListByBudgetCategoryType = this.categorizeObjectCodesByCategory(budget);
        TreeMap objectCodeUniquePersonnelList = new TreeMap();
        TreeMap objectCodePersonnelSalaryTotals = new TreeMap();
        TreeMap objectCodePersonnelFringeTotals = new TreeMap();
        TreeSet<String> objectCodePersonnelSalaryTotalsByPeriod = new TreeSet<String>();
        TreeSet<String> objectCodePersonnelFringeTotalsByPeriod = new TreeSet<String>();
        SortedMap personnelCalculatedExpenseTotals = new TreeMap();
        SortedMap nonPersonnelCalculatedExpenseTotals = new TreeMap();
        ArrayList<BudgetDecimal> periodSummarySalaryTotals = new ArrayList<BudgetDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            periodSummarySalaryTotals.add(i, BudgetDecimal.ZERO);
        }
        ArrayList<BudgetDecimal> periodSummaryFringeTotals = new ArrayList<BudgetDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            periodSummaryFringeTotals.add(i, BudgetDecimal.ZERO);
        }
        TreeMap<String, ArrayList<BudgetDecimal>> subTotalsBySubSection = new TreeMap<String, ArrayList<BudgetDecimal>>();
        subTotalsBySubSection.put("personnelSalaryTotals", periodSummarySalaryTotals);
        subTotalsBySubSection.put("personnelFringeTotals", periodSummaryFringeTotals);
        BudgetCategoryType personnelCategory = this.getPersonnelCategoryType();
        List personnelObjectCodes = (List)objectCodeListByBudgetCategoryType.get(personnelCategory);
        if (CollectionUtils.isNotEmpty((Collection)personnelObjectCodes)) {
            for (CostElement personnelCostElement : personnelObjectCodes) {
                if (!objectCodeUniquePersonnelList.containsKey(personnelCostElement)) {
                    objectCodeUniquePersonnelList.put(personnelCostElement, new ArrayList());
                }
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    budgetPeriod.setBudget(budget);
                    QueryList lineItemQueryList = new QueryList();
                    lineItemQueryList.addAll((Collection)budgetPeriod.getBudgetLineItems());
                    Equals objectCodeEquals = new Equals("costElement", (Comparable)((Object)personnelCostElement.getCostElement()));
                    QueryList filteredLineItems = lineItemQueryList.filter((Operator)objectCodeEquals);
                    QueryList personnelQueryList = new QueryList();
                    for (BudgetLineItem matchingLineItem : filteredLineItems) {
                        personnelQueryList.addAll((Collection)matchingLineItem.getBudgetPersonnelDetailsList());
                    }
                    int matchingLineItemIndex = 0;
                    for (BudgetLineItem matchingLineItem : filteredLineItems) {
                        for (BudgetPersonnelDetails budgetPersonnelDetails : matchingLineItem.getBudgetPersonnelDetailsList()) {
                            int i;
                            budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                            Equals personIdEquals = new Equals("personId", (Comparable)((Object)budgetPersonnelDetails.getPersonId()));
                            QueryList personOccurrencesForSameObjectCode = personnelQueryList.filter((Operator)personIdEquals);
                            BudgetDecimal personSalaryTotalsForCurrentPeriod = personOccurrencesForSameObjectCode.sumObjects("salaryRequested");
                            if (!objectCodePersonnelSalaryTotals.containsKey(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())) {
                                ((List)objectCodeUniquePersonnelList.get(matchingLineItem.getCostElementBO())).add(budgetPersonnelDetails);
                                ArrayList<BudgetDecimal> periodTotals = new ArrayList<BudgetDecimal>();
                                for (i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodTotals.add(i, BudgetDecimal.ZERO);
                                }
                                objectCodePersonnelSalaryTotals.put(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId(), periodTotals);
                            }
                            ((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())).set(budgetPeriod.getBudgetPeriod() - 1, personSalaryTotalsForCurrentPeriod);
                            if (objectCodePersonnelSalaryTotalsByPeriod.add(budgetPeriod.getBudgetPeriod().toString() + "," + matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())) {
                                ((List)subTotalsBySubSection.get("personnelSalaryTotals")).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)subTotalsBySubSection.get("personnelSalaryTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)personSalaryTotalsForCurrentPeriod));
                            }
                            if (!objectCodePersonnelFringeTotals.containsKey(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())) {
                                ArrayList<BudgetDecimal> periodFringeTotals = new ArrayList<BudgetDecimal>();
                                for (i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodFringeTotals.add(i, BudgetDecimal.ZERO);
                                }
                                objectCodePersonnelFringeTotals.put(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId(), periodFringeTotals);
                            }
                            BudgetDecimal personFringeTotalsForCurrentPeriod = BudgetDecimal.ZERO;
                            for (Object person : personOccurrencesForSameObjectCode) {
                                BudgetPersonnelDetails personOccurrence = (BudgetPersonnelDetails)person;
                                for (BudgetPersonnelCalculatedAmount calcExpenseAmount : personOccurrence.getBudgetPersonnelCalculatedAmounts()) {
                                    calcExpenseAmount.refreshReferenceObject("rateClass");
                                    if (!calcExpenseAmount.getRateClass().getRateClassType().equalsIgnoreCase(EQUIPMENT)) continue;
                                    personFringeTotalsForCurrentPeriod = (BudgetDecimal)personFringeTotalsForCurrentPeriod.add((AbstractKualiDecimal)calcExpenseAmount.getCalculatedCost());
                                }
                            }
                            ((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())).set(budgetPeriod.getBudgetPeriod() - 1, personFringeTotalsForCurrentPeriod);
                            if (!objectCodePersonnelFringeTotalsByPeriod.add(budgetPeriod.getBudgetPeriod().toString() + "," + matchingLineItem.getCostElement() + "," + budgetPersonnelDetails.getPersonId())) continue;
                            ((List)subTotalsBySubSection.get("personnelFringeTotals")).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)subTotalsBySubSection.get("personnelFringeTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)personFringeTotalsForCurrentPeriod));
                        }
                        if (CollectionUtils.isEmpty((Collection)matchingLineItem.getBudgetPersonnelDetailsList())) {
                            if (!objectCodePersonnelSalaryTotals.containsKey(matchingLineItem.getCostElement())) {
                                ArrayList<BudgetDecimal> periodTotals = new ArrayList<BudgetDecimal>();
                                for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodTotals.add(i, BudgetDecimal.ZERO);
                                }
                                objectCodePersonnelSalaryTotals.put(matchingLineItem.getCostElement(), periodTotals);
                            }
                            ((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement())).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)matchingLineItem.getLineItemCost()));
                            BudgetDecimal summaryFringeTotalsForCurrentPeriod = BudgetDecimal.ZERO;
                            if (!objectCodePersonnelFringeTotals.containsKey(matchingLineItem.getCostElement())) {
                                ArrayList<BudgetDecimal> periodFringeTotals = new ArrayList<BudgetDecimal>();
                                for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                                    periodFringeTotals.add(i, BudgetDecimal.ZERO);
                                }
                                objectCodePersonnelFringeTotals.put(matchingLineItem.getCostElement(), periodFringeTotals);
                            }
                            for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : matchingLineItem.getBudgetLineItemCalculatedAmounts()) {
                                lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                                if (!lineItemCalculatedAmount.getRateClass().getRateClassType().equalsIgnoreCase(EQUIPMENT)) continue;
                                summaryFringeTotalsForCurrentPeriod = (BudgetDecimal)summaryFringeTotalsForCurrentPeriod.add((AbstractKualiDecimal)lineItemCalculatedAmount.getCalculatedCost());
                            }
                            ((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement())).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)summaryFringeTotalsForCurrentPeriod));
                            ((List)subTotalsBySubSection.get("personnelSalaryTotals")).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)subTotalsBySubSection.get("personnelSalaryTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)((BudgetDecimal)((List)objectCodePersonnelSalaryTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1))));
                            ((List)subTotalsBySubSection.get("personnelFringeTotals")).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)subTotalsBySubSection.get("personnelFringeTotals")).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)((BudgetDecimal)((List)objectCodePersonnelFringeTotals.get(matchingLineItem.getCostElement())).get(budgetPeriod.getBudgetPeriod() - 1))));
                        }
                        ++matchingLineItemIndex;
                    }
                }
            }
        }
        budget.setBudgetSummaryTotals(subTotalsBySubSection);
        personnelCalculatedExpenseTotals = this.calculateExpenseTotals(budget, true);
        nonPersonnelCalculatedExpenseTotals = this.calculateExpenseTotals(budget, false);
        budget.setObjectCodeListByBudgetCategoryType(objectCodeListByBudgetCategoryType);
        budget.setObjectCodePersonnelList(objectCodeUniquePersonnelList);
        budget.setObjectCodePersonnelSalaryTotals(objectCodePersonnelSalaryTotals);
        budget.setObjectCodePersonnelFringeTotals(objectCodePersonnelFringeTotals);
        budget.setPersonnelCalculatedExpenseTotals(personnelCalculatedExpenseTotals);
        budget.setNonPersonnelCalculatedExpenseTotals(nonPersonnelCalculatedExpenseTotals);
        this.calculateNonPersonnelSummaryTotals(budget);
        this.populateBudgetPeriodSummaryCalcAmounts(budget);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(Budget budget) {
        return BudgetCommonServiceFactory.createInstance((BudgetParentDocument)budget.getBudgetDocument().getParentDocument());
    }

    private boolean isRateOveridden(Budget budget, BudgetPeriod budgetPeriod) {
        BudgetCommonService budgetService = this.getBudgetCommonService(budget);
        return budgetService.isRateOverridden(budgetPeriod);
    }

    private void populateBudgetPeriodSummaryCalcAmounts(Budget budget) {
        List budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (this.isRateOveridden(budget, budgetPeriod)) continue;
            this.getBudgetCommonService(budget).populateSummaryCalcAmounts(budget, budgetPeriod);
        }
    }

    protected void calculateNonPersonnelSummaryTotals(Budget budget) {
        for (BudgetCategoryType budgetCategoryType : budget.getObjectCodeListByBudgetCategoryType().keySet()) {
            if (StringUtils.equals((String)budgetCategoryType.getBudgetCategoryTypeCode(), (String)"P")) continue;
            ArrayList<BudgetDecimal> nonPersonnelTotals = new ArrayList<BudgetDecimal>();
            for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                nonPersonnelTotals.add(i, BudgetDecimal.ZERO);
            }
            budget.getBudgetSummaryTotals().put(budgetCategoryType.getBudgetCategoryTypeCode(), nonPersonnelTotals);
            List objectCodes = (List)budget.getObjectCodeListByBudgetCategoryType().get(budgetCategoryType);
            for (CostElement objectCode : objectCodes) {
                if (StringUtils.equalsIgnoreCase((String)objectCode.getCostElement(), (String)((ParameterService)KraServiceLocator.getService(ParameterService.class)).getParameterValueAsString(BudgetDocument.class, "proposalHierarchySubProjectIndirectCostElement"))) continue;
                List objectCodePeriodTotals = (List)budget.getObjectCodeTotals().get(objectCode);
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    ((List)budget.getBudgetSummaryTotals().get(budgetCategoryType.getBudgetCategoryTypeCode())).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)budget.getBudgetSummaryTotals().get(budgetCategoryType.getBudgetCategoryTypeCode())).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)objectCodePeriodTotals.get(budgetPeriod.getBudgetPeriod() - 1)));
                }
            }
        }
    }

    protected List<CostElement> filterObjectCodesByBudgetCategoryType(Set<CostElement> objectCodes, String budgetCategoryType) {
        ArrayList<CostElement> filteredObjectCodes = new ArrayList<CostElement>();
        for (CostElement costElement : objectCodes) {
            if (!costElement.getBudgetCategory().getBudgetCategoryTypeCode().equalsIgnoreCase(budgetCategoryType)) continue;
            filteredObjectCodes.add(costElement);
        }
        return filteredObjectCodes;
    }

    protected SortedMap<RateType, List<BudgetDecimal>> calculateExpenseTotals(Budget budget, boolean personnelFlag) {
        TreeMap<RateType, List<BudgetDecimal>> calculatedExpenseTotals = new TreeMap<RateType, List<BudgetDecimal>>();
        ArrayList<BudgetDecimal> calculatedDirectCostSummaryTotals = new ArrayList<BudgetDecimal>();
        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
            calculatedDirectCostSummaryTotals.add(i, BudgetDecimal.ZERO);
        }
        String totalsMapKey = null;
        totalsMapKey = personnelFlag ? "personnelCalculatedExpenseSummaryTotals" : "nonPersonnelCalculatedExpenseSummaryTotals";
        budget.getBudgetSummaryTotals().put(totalsMapKey, calculatedDirectCostSummaryTotals);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if ((!personnelFlag || !StringUtils.equals((String)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (String)"P")) && (personnelFlag || StringUtils.equals((String)budgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode(), (String)"P"))) continue;
                QueryList lineItemCalcAmtQueryList = new QueryList();
                lineItemCalcAmtQueryList.addAll((Collection)budgetLineItem.getBudgetLineItemCalculatedAmounts());
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                for (Object item : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount = (BudgetLineItemCalculatedAmount)item;
                    RateType rateType = this.createRateType(budgetLineItemCalculatedAmount);
                    RateClass rateClass = null;
                    if (rateType != null) {
                        rateType.refreshReferenceObject("rateClass");
                        rateClass = rateType.getRateClass();
                    }
                    if ((!personnelFlag || rateClass == null || StringUtils.equals((String)rateClass.getRateClassType(), (String)EQUIPMENT)) && personnelFlag || rateTypes.contains(rateType)) continue;
                    rateTypes.add(rateType);
                    Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateClassCode()));
                    Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateTypeCode()));
                    And RCandRT = new And((Operator)equalsRC, (Operator)equalsRT);
                    BudgetDecimal rateTypeTotalInThisPeriod = lineItemCalcAmtQueryList.sumObjects("calculatedCost", (Operator)RCandRT);
                    if (!calculatedExpenseTotals.containsKey(rateType)) {
                        ArrayList<BudgetDecimal> rateTypePeriodTotals = new ArrayList<BudgetDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            rateTypePeriodTotals.add(i, BudgetDecimal.ZERO);
                        }
                        calculatedExpenseTotals.put(rateType, rateTypePeriodTotals);
                    }
                    ((List)calculatedExpenseTotals.get(rateType)).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)calculatedExpenseTotals.get(rateType)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)rateTypeTotalInThisPeriod));
                    if (!StringUtils.equals((String)rateClass.getRateClassType(), (String)OTHER_DIRECT)) {
                        ((List)budget.getBudgetSummaryTotals().get(totalsMapKey)).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)budget.getBudgetSummaryTotals().get(totalsMapKey)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)rateTypeTotalInThisPeriod));
                    }
                    budgetPeriod.setExpenseTotal((BudgetDecimal)budgetPeriod.getExpenseTotal().add((AbstractKualiDecimal)rateTypeTotalInThisPeriod));
                }
            }
        }
        return calculatedExpenseTotals;
    }

    protected RateType createRateType(BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount) {
        RateType rateType = new RateType();
        rateType.setRateClassCode(budgetLineItemCalculatedAmount.getRateClassCode());
        rateType.setRateTypeCode(budgetLineItemCalculatedAmount.getRateTypeCode());
        rateType.setDescription(budgetLineItemCalculatedAmount.getRateTypeDescription());
        rateType.setRateClass(budgetLineItemCalculatedAmount.getRateClass());
        return rateType;
    }

    public void calculateBudgetTotals(Budget budget) {
        TreeMap objectCodeTotals = new TreeMap();
        TreeMap calculatedExpenseTotals = new TreeMap();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            ArrayList<CostElement> objectCodes = new ArrayList<CostElement>();
            QueryList lineItemQueryList = new QueryList();
            lineItemQueryList.addAll((Collection)budgetPeriod.getBudgetLineItems());
            budgetPeriod.setExpenseTotal(BudgetDecimal.ZERO);
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                CostElement costElement;
                if (budgetLineItem.getCostElementBO() == null) {
                    budgetLineItem.refreshReferenceObject("costElementBO");
                }
                if (!objectCodes.contains(costElement = budgetLineItem.getCostElementBO())) {
                    objectCodes.add(costElement);
                    Equals equalsCostElement = new Equals("costElement", (Comparable)((Object)budgetLineItem.getCostElement()));
                    BudgetDecimal objectCodeTotalInThisPeriod = lineItemQueryList.sumObjects("lineItemCost", (Operator)equalsCostElement);
                    if (!objectCodeTotals.containsKey(costElement)) {
                        ArrayList<BudgetDecimal> periodTotals = new ArrayList<BudgetDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            periodTotals.add(i, BudgetDecimal.ZERO);
                        }
                        objectCodeTotals.put(costElement, periodTotals);
                    }
                    ((List)objectCodeTotals.get(costElement)).set(budgetPeriod.getBudgetPeriod() - 1, objectCodeTotalInThisPeriod);
                    budgetPeriod.setExpenseTotal((BudgetDecimal)budgetPeriod.getExpenseTotal().add((AbstractKualiDecimal)objectCodeTotalInThisPeriod));
                }
                QueryList lineItemCalcAmtQueryList = new QueryList();
                lineItemCalcAmtQueryList.addAll((Collection)budgetLineItem.getBudgetLineItemCalculatedAmounts());
                ArrayList<RateType> rateTypes = new ArrayList<RateType>();
                for (Object item : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount = (BudgetLineItemCalculatedAmount)item;
                    RateType rateType = this.createRateType(budgetLineItemCalculatedAmount);
                    if (rateTypes.contains(rateType)) continue;
                    rateTypes.add(rateType);
                    Equals equalsRC = new Equals("rateClassCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateClassCode()));
                    Equals equalsRT = new Equals("rateTypeCode", (Comparable)((Object)budgetLineItemCalculatedAmount.getRateTypeCode()));
                    And RCandRT = new And((Operator)equalsRC, (Operator)equalsRT);
                    BudgetDecimal rateTypeTotalInThisPeriod = lineItemCalcAmtQueryList.sumObjects("calculatedCost", (Operator)RCandRT);
                    if (!calculatedExpenseTotals.containsKey(rateType)) {
                        ArrayList<BudgetDecimal> rateTypePeriodTotals = new ArrayList<BudgetDecimal>();
                        for (int i = 0; i < budget.getBudgetPeriods().size(); ++i) {
                            rateTypePeriodTotals.add(i, BudgetDecimal.ZERO);
                        }
                        calculatedExpenseTotals.put(rateType, rateTypePeriodTotals);
                    }
                    ((List)calculatedExpenseTotals.get(rateType)).set(budgetPeriod.getBudgetPeriod() - 1, ((BudgetDecimal)((List)calculatedExpenseTotals.get(rateType)).get(budgetPeriod.getBudgetPeriod() - 1)).add((AbstractKualiDecimal)rateTypeTotalInThisPeriod));
                    budgetPeriod.setExpenseTotal((BudgetDecimal)budgetPeriod.getExpenseTotal().add((AbstractKualiDecimal)rateTypeTotalInThisPeriod));
                }
            }
        }
        budget.setObjectCodeTotals(objectCodeTotals);
        budget.setCalculatedExpenseTotals(calculatedExpenseTotals);
    }

    public void syncToPeriodCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        periodCalculator.syncToPeriodCostLimit(budget, budgetPeriod, budgetLineItem);
        List errors = periodCalculator.getErrorMessages();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!errors.isEmpty()) {
            for (String error : errors) {
                errorMap.putError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + (budgetLineItem.getLineItemNumber() - 1) + "].lineItemCost", error, new String[0]);
            }
        }
    }

    public void syncToPeriodDirectCostLimit(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        periodCalculator.syncToPeriodDirectCostLimit(budget, budgetPeriod, budgetLineItem);
        List errors = periodCalculator.getErrorMessages();
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!errors.isEmpty()) {
            for (String error : errors) {
                errorMap.putError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + (budgetLineItem.getLineItemNumber() - 1) + "].lineItemCost", error, new String[0]);
            }
        }
    }

    public void applyToLaterPeriods(Budget budget, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem) {
        BudgetPeriodCalculator periodCalculator = new BudgetPeriodCalculator();
        periodCalculator.applyToLaterPeriods(budget, budgetPeriod, budgetLineItem);
        List errors = periodCalculator.getErrorMessages();
        if (!errors.isEmpty()) {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            for (String error : errors) {
                errorMap.putError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + (budgetLineItem.getLineItemNumber() - 1) + "].costElement", error, new String[0]);
            }
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BudgetDistributionAndIncomeService getBudgetDistributionAndIncomeService() {
        return this.budgetDistributionAndIncomeService;
    }

    public void setBudgetDistributionAndIncomeService(BudgetDistributionAndIncomeService service) {
        this.budgetDistributionAndIncomeService = service;
    }

    public void rePopulateCalculatedAmount(Budget budget, BudgetLineItem budgetLineItem) {
        budgetLineItem.getBudgetCalculatedAmounts().clear();
        new LineItemCalculator(budget, budgetLineItem).setCalculatedAmounts(budget, (BudgetLineItemBase)budgetLineItem);
    }

    public void rePopulateCalculatedAmount(Budget budget, BudgetPersonnelDetails newBudgetPersonnelDetails) {
        newBudgetPersonnelDetails.getBudgetCalculatedAmounts().clear();
        new PersonnelLineItemCalculator(budget, (BudgetLineItemBase)newBudgetPersonnelDetails).setCalculatedAmounts(budget, (BudgetLineItemBase)newBudgetPersonnelDetails);
    }

    public void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        int j = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            if (budgetPersonnelDetails.getCostElement() == null) {
                budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
            }
            j = 0;
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                Boolean updatedApplyRateFlag = null;
                for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmout : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (!budgetLineItemCalculatedAmout.getRateClassCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateClassCode()) || !budgetLineItemCalculatedAmout.getRateTypeCode().equalsIgnoreCase(budgetPersonnelCalculatedAmount.getRateTypeCode())) continue;
                    updatedApplyRateFlag = budgetLineItemCalculatedAmout.getApplyRateFlag();
                }
                budgetPersonnelCalculatedAmount.setApplyRateFlag(updatedApplyRateFlag);
                ++j;
            }
        }
    }

    public BudgetForm getBudgetFormFromGlobalVariables() {
        BudgetForm budgetForm = null;
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form != null && form instanceof BudgetForm) {
            budgetForm = (BudgetForm)form;
        }
        return budgetForm;
    }

    public List<Map<String, List<BudgetDecimal>>> getBudgetLimitsTotals(String budgetId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        ArrayList<Map<String, List<BudgetDecimal>>> retList = new ArrayList<Map<String, List<BudgetDecimal>>>();
        fieldValues.put("budgetId", budgetId);
        Budget budget = (Budget)this.businessObjectService.findByPrimaryKey(AwardBudgetExt.class, fieldValues);
        this.calculateBudgetTotals(budget);
        Map personnelBudgetLimits = this.getPersonnelMap();
        Map nonPersonnelBudgetLimits = this.getNonPersonnelMap();
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                AwardBudgetLineItemExt awardBudgetLineItem = (AwardBudgetLineItemExt)budgetLineItem;
                if (!"P".equals(awardBudgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode())) {
                    this.addBudgetLimits((List)nonPersonnelBudgetLimits.get(awardBudgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode()), awardBudgetLineItem, false);
                    this.getNonPersonnelCalAmt(nonPersonnelBudgetLimits, awardBudgetLineItem, false);
                    continue;
                }
                this.addBudgetLimits((List)personnelBudgetLimits.get(SALARY), awardBudgetLineItem, false);
                this.getFringeAndCalculatedCost(personnelBudgetLimits, awardBudgetLineItem, false);
            }
        }
        if (((AwardBudgetExt)budget).getPrevBudget().getBudgetId() != null) {
            this.getPreviousBudgetLimits(((AwardBudgetExt)budget).getPrevBudget().getBudgetId(), personnelBudgetLimits, nonPersonnelBudgetLimits);
        }
        Map totallBudgetLimits = this.getTotalMap();
        this.addTotals(personnelBudgetLimits, totallBudgetLimits);
        this.addTotals(nonPersonnelBudgetLimits, totallBudgetLimits);
        retList.add(personnelBudgetLimits);
        retList.add(nonPersonnelBudgetLimits);
        retList.add(totallBudgetLimits);
        return retList;
    }

    protected void getPreviousBudgetLimits(Long budgetId, Map<String, List<BudgetDecimal>> personnelBudgetLimits, Map<String, List<BudgetDecimal>> nonPersonnelBudgetLimits) {
        HashMap<String, Long> keyMap = new HashMap<String, Long>();
        keyMap.put("budgetId", budgetId);
        AwardBudgetExt budget = (AwardBudgetExt)this.getBusinessObjectService().findByPrimaryKey(AwardBudgetExt.class, keyMap);
        if (budget != null) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                    AwardBudgetLineItemExt awardBudgetLineItem = (AwardBudgetLineItemExt)budgetLineItem;
                    if (!"P".equals(awardBudgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode())) {
                        this.addBudgetLimits(nonPersonnelBudgetLimits.get(awardBudgetLineItem.getCostElementBO().getBudgetCategory().getBudgetCategoryTypeCode()), awardBudgetLineItem, true);
                        this.getNonPersonnelCalAmt(nonPersonnelBudgetLimits, awardBudgetLineItem, true);
                        continue;
                    }
                    this.addBudgetLimits(personnelBudgetLimits.get(SALARY), awardBudgetLineItem, true);
                    this.getFringeAndCalculatedCost(personnelBudgetLimits, awardBudgetLineItem, true);
                }
            }
        }
    }

    protected List<BudgetDecimal> initBudgetLimits() {
        ArrayList<BudgetDecimal> budgetLimits = new ArrayList<BudgetDecimal>();
        budgetLimits.add(BudgetDecimal.ZERO);
        budgetLimits.add(BudgetDecimal.ZERO);
        budgetLimits.add(BudgetDecimal.ZERO);
        return budgetLimits;
    }

    protected void addTotals(Map<String, List<BudgetDecimal>> budgetLimitMap, Map<String, List<BudgetDecimal>> totalsMap) {
        List budgetLimits = this.initBudgetLimits();
        for (Map.Entry<String, List<BudgetDecimal>> entry : budgetLimitMap.entrySet()) {
            List<BudgetDecimal> limit = entry.getValue();
            if (!INDIRECT_COST.equalsIgnoreCase(entry.getKey())) {
                this.addToLimit(budgetLimits, limit);
                continue;
            }
            this.addToLimit(totalsMap.get("FAndA"), limit);
            this.addToLimit(totalsMap.get("Totals"), limit);
        }
        budgetLimitMap.put("Totals", budgetLimits);
        this.addToLimit(totalsMap.get("Direct"), budgetLimits);
        this.addToLimit(totalsMap.get("Totals"), budgetLimits);
    }

    protected void addToLimit(List<BudgetDecimal> budgetLimits, List<BudgetDecimal> limits) {
        budgetLimits.set(0, (BudgetDecimal)budgetLimits.get(0).add((AbstractKualiDecimal)limits.get(0)));
        budgetLimits.set(1, (BudgetDecimal)budgetLimits.get(1).add((AbstractKualiDecimal)limits.get(1)));
        budgetLimits.set(2, (BudgetDecimal)budgetLimits.get(2).add((AbstractKualiDecimal)limits.get(2)));
    }

    protected void addBudgetLimits(List<BudgetDecimal> budgetLimits, AwardBudgetLineItemExt awardBudgetLineItem, boolean isPrevBudget) {
        if (isPrevBudget) {
            budgetLimits.set(1, (BudgetDecimal)budgetLimits.get(1).add((AbstractKualiDecimal)awardBudgetLineItem.getLineItemCost()));
        } else {
            budgetLimits.set(0, (BudgetDecimal)budgetLimits.get(0).add((AbstractKualiDecimal)awardBudgetLineItem.getLineItemCost()));
        }
        budgetLimits.set(2, (BudgetDecimal)budgetLimits.get(2).add((AbstractKualiDecimal)awardBudgetLineItem.getLineItemCost()));
    }

    protected void addBudgetLimits(List<BudgetDecimal> budgetLimits, AwardBudgetLineItemCalculatedAmountExt awardCalcAmt, boolean isPrevBudget) {
        if (isPrevBudget) {
            budgetLimits.set(1, (BudgetDecimal)budgetLimits.get(1).add((AbstractKualiDecimal)awardCalcAmt.getCalculatedCost()));
        } else {
            budgetLimits.set(0, (BudgetDecimal)budgetLimits.get(0).add((AbstractKualiDecimal)awardCalcAmt.getCalculatedCost()));
        }
        budgetLimits.set(2, (BudgetDecimal)budgetLimits.get(2).add((AbstractKualiDecimal)awardCalcAmt.getCalculatedCost()));
    }

    protected Map<String, List<BudgetDecimal>> getNonPersonnelMap() {
        HashMap<String, List<BudgetDecimal>> nonPersonnelBudgetLimits = new HashMap<String, List<BudgetDecimal>>();
        nonPersonnelBudgetLimits.put(EQUIPMENT, this.initBudgetLimits());
        nonPersonnelBudgetLimits.put(TRAVEL, this.initBudgetLimits());
        nonPersonnelBudgetLimits.put(PARTICIPANT_SUPPORT, this.initBudgetLimits());
        nonPersonnelBudgetLimits.put(OTHER_DIRECT, this.initBudgetLimits());
        nonPersonnelBudgetLimits.put(CALCULATED_COST, this.initBudgetLimits());
        nonPersonnelBudgetLimits.put(INDIRECT_COST, this.initBudgetLimits());
        return nonPersonnelBudgetLimits;
    }

    protected Map<String, List<BudgetDecimal>> getPersonnelMap() {
        HashMap<String, List<BudgetDecimal>> personnelBudgetLimits = new HashMap<String, List<BudgetDecimal>>();
        personnelBudgetLimits.put(SALARY, this.initBudgetLimits());
        personnelBudgetLimits.put(FRINGE, this.initBudgetLimits());
        personnelBudgetLimits.put(CALCULATED_COST, this.initBudgetLimits());
        personnelBudgetLimits.put(INDIRECT_COST, this.initBudgetLimits());
        return personnelBudgetLimits;
    }

    protected Map<String, List<BudgetDecimal>> getTotalMap() {
        HashMap<String, List<BudgetDecimal>> personnelBudgetLimits = new HashMap<String, List<BudgetDecimal>>();
        personnelBudgetLimits.put("Direct", this.initBudgetLimits());
        personnelBudgetLimits.put("FAndA", this.initBudgetLimits());
        personnelBudgetLimits.put("Totals", this.initBudgetLimits());
        return personnelBudgetLimits;
    }

    protected void getFringeAndCalculatedCost(Map<String, List<BudgetDecimal>> personnelBudgetLimits, AwardBudgetLineItemExt awardBudgetLineItem, boolean isPrevBudget) {
        for (BudgetLineItemCalculatedAmount calcExpenseAmount : awardBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            calcExpenseAmount.refreshReferenceObject("rateClass");
            AwardBudgetLineItemCalculatedAmountExt awardCalcAmt = (AwardBudgetLineItemCalculatedAmountExt)calcExpenseAmount;
            if (calcExpenseAmount.getRateClass().getRateClassType().equalsIgnoreCase(EQUIPMENT)) {
                this.addBudgetLimits(personnelBudgetLimits.get(FRINGE), awardCalcAmt, isPrevBudget);
                continue;
            }
            if (!calcExpenseAmount.getRateClass().getRateClassType().equalsIgnoreCase(OTHER_DIRECT)) {
                this.addBudgetLimits(personnelBudgetLimits.get(CALCULATED_COST), awardCalcAmt, isPrevBudget);
                continue;
            }
            this.addBudgetLimits(personnelBudgetLimits.get(INDIRECT_COST), awardCalcAmt, isPrevBudget);
        }
    }

    protected void getNonPersonnelCalAmt(Map<String, List<BudgetDecimal>> personnelBudgetLimits, AwardBudgetLineItemExt awardBudgetLineItem, boolean isPrevBudget) {
        for (BudgetLineItemCalculatedAmount calcExpenseAmount : awardBudgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            calcExpenseAmount.refreshReferenceObject("rateClass");
            AwardBudgetLineItemCalculatedAmountExt awardCalcAmt = (AwardBudgetLineItemCalculatedAmountExt)calcExpenseAmount;
            if (!calcExpenseAmount.getRateClass().getRateClassType().equalsIgnoreCase(OTHER_DIRECT)) {
                this.addBudgetLimits(personnelBudgetLimits.get(CALCULATED_COST), awardCalcAmt, isPrevBudget);
                continue;
            }
            this.addBudgetLimits(personnelBudgetLimits.get(INDIRECT_COST), awardCalcAmt, isPrevBudget);
        }
    }
}

