/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.AbstractBudgetCalculator;
import org.kuali.kra.budget.calculator.Boundary;
import org.kuali.kra.budget.calculator.BreakUpInterval;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateAndCost;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class LineItemCalculator
extends AbstractBudgetCalculator {
    private Budget budget;
    private BudgetLineItem bli;
    private DateTimeService dateTimeService;
    private BudgetCalculationService budgetCalculationService;

    public LineItemCalculator(Budget budget, BudgetLineItem bli) {
        super(budget, (BudgetLineItemBase)bli);
        this.bli = bli;
        this.budget = budget;
        this.dateTimeService = this.getDateTimeService();
        this.budgetCalculationService = (BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class);
    }

    private boolean isDocumentOhRateSameAsFormOhRate() {
        return this.budget.getOhRateClassCode() != null && this.getBudgetFormFromGlobalVariables() != null && StringUtils.equalsIgnoreCase((String)this.budget.getOhRateClassCode(), (String)this.getBudgetFormFromGlobalVariables().getOhRateClassCodePrevValue());
    }

    private Map<String, Boolean> saveApplyRateFlagsForReset() {
        HashMap<String, Boolean> applyRateFlags = new HashMap<String, Boolean>();
        if (this.bli != null && CollectionUtils.isNotEmpty((Collection)this.bli.getBudgetLineItemCalculatedAmounts())) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : this.bli.getBudgetLineItemCalculatedAmounts()) {
                applyRateFlags.put(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode(), budgetLineItemCalculatedAmount.getApplyRateFlag());
            }
        }
        return applyRateFlags;
    }

    public void populateCalculatedAmountLineItems() {
        if (this.bli.getBudgetLineItemCalculatedAmounts().size() <= 0) {
            this.bli.refreshReferenceObject("budgetLineItemCalculatedAmounts");
        }
        if (this.bli.getBudgetLineItemCalculatedAmounts().size() <= 0) {
            this.setCalculatedAmounts(this.budget, (BudgetLineItemBase)this.bli);
        }
        if (!this.isDocumentOhRateSameAsFormOhRate() || this.getBudgetRateService().performSyncFlag(this.budget.getBudgetDocument())) {
            Long versionNumber = null;
            if (CollectionUtils.isNotEmpty((Collection)this.bli.getBudgetLineItemCalculatedAmounts())) {
                versionNumber = ((BudgetLineItemCalculatedAmount)this.bli.getBudgetLineItemCalculatedAmounts().get(0)).getVersionNumber();
            }
            Map applyRateFlags = this.saveApplyRateFlagsForReset();
            this.bli.setBudgetLineItemCalculatedAmounts(new ArrayList());
            this.setCalculatedAmounts(this.budget, (BudgetLineItemBase)this.bli);
            for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : this.bli.getBudgetLineItemCalculatedAmounts()) {
                if (versionNumber != null) {
                    budgetLineItemCalculatedAmount.setVersionNumber(versionNumber);
                }
                if (applyRateFlags == null || applyRateFlags.get(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode()) == null) continue;
                budgetLineItemCalculatedAmount.setApplyRateFlag((Boolean)applyRateFlags.get(budgetLineItemCalculatedAmount.getRateClassCode() + budgetLineItemCalculatedAmount.getRateTypeCode()));
            }
        }
    }

    public void populateApplicableCosts(Boundary boundary) {
        int totalNumOfDays = this.dateTimeService.dateDiff((java.util.Date)this.bli.getStartDate(), (java.util.Date)this.bli.getEndDate(), true);
        int boundaryNumOfDays = boundary.getNumberOfDays();
        List personnelDetailsList = this.bli.getBudgetPersonnelDetailsList();
        BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
        BudgetDecimal costSharingRequested = BudgetDecimal.ZERO;
        if (!personnelDetailsList.isEmpty()) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : personnelDetailsList) {
                this.budgetCalculationService.calculateBudgetLineItem(this.budget, budgetPersonnelDetails);
                salaryRequested = (BudgetDecimal)salaryRequested.add((AbstractKualiDecimal)budgetPersonnelDetails.getSalaryRequested());
                costSharingRequested = (BudgetDecimal)costSharingRequested.add((AbstractKualiDecimal)budgetPersonnelDetails.getCostSharingAmount());
            }
            this.bli.setLineItemCost(salaryRequested);
            this.bli.setCostSharingAmount(costSharingRequested);
        } else {
            BudgetDecimal lineItemCost = this.bli.getLineItemCost();
            BudgetDecimal lineItemCostSharing = this.bli.getCostSharingAmount();
            boundary.setApplicableCost(lineItemCost == null ? BudgetDecimal.ZERO : new BudgetDecimal(lineItemCost.bigDecimalValue().multiply(new BigDecimal(boundaryNumOfDays)).divide(new BigDecimal(totalNumOfDays), 2, RoundingMode.HALF_UP)));
            boundary.setApplicableCostSharing(lineItemCostSharing == null ? BudgetDecimal.ZERO : new BudgetDecimal(lineItemCostSharing.bigDecimalValue().multiply(new BigDecimal(boundaryNumOfDays)).divide(new BigDecimal(totalNumOfDays), 2, RoundingMode.HALF_UP)));
        }
    }

    protected void addCalculatedAmount(AbstractBudgetCalculatedAmount budgetCalculatedAmount) {
        this.bli.getBudgetLineItemCalculatedAmounts().add((BudgetLineItemCalculatedAmount)budgetCalculatedAmount);
    }

    protected void populateBudgetRateBaseList() {
        List budgetRateAndBaseList = this.bli.getBudgetRateAndBaseList();
        List breakupIntervals = this.getBreakupIntervals();
        if (!budgetRateAndBaseList.isEmpty()) {
            budgetRateAndBaseList.clear();
        }
        Integer rateNumber = 0;
        for (BreakUpInterval breakUpInterval : breakupIntervals) {
            QueryList vecAmountBean = breakUpInterval.getRateAndCosts();
            for (RateAndCost rateAndCost : vecAmountBean) {
                BudgetRateAndBase budgetRateBase = new BudgetRateAndBase();
                BudgetDecimal appliedRate = rateAndCost.getAppliedRate();
                budgetRateBase.setAppliedRate(BudgetDecimal.returnZeroIfNull((BudgetDecimal)appliedRate));
                BudgetDecimal calculatedCost = rateAndCost.getCalculatedCost();
                BudgetDecimal calculatedCostSharing = rateAndCost.getCalculatedCostSharing();
                budgetRateBase.setBaseCostSharing(rateAndCost.getBaseCostSharingAmount());
                budgetRateBase.setBaseCost(rateAndCost.getBaseAmount());
                budgetRateBase.setBudgetPeriodId(this.bli.getBudgetPeriodId());
                budgetRateBase.setBudgetPeriod(this.bli.getBudgetPeriod());
                budgetRateBase.setCalculatedCost(calculatedCost);
                budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
                java.util.Date endDate = breakUpInterval.getBoundary().getEndDate();
                budgetRateBase.setEndDate(new Date(endDate.getTime()));
                budgetRateBase.setLineItemNumber(this.bli.getLineItemNumber());
                budgetRateBase.setOnOffCampusFlag(this.bli.getOnOffCampusFlag());
                budgetRateBase.setBudgetId(this.bli.getBudgetId());
                budgetRateBase.setRateClassCode(rateAndCost.getRateClassCode());
                rateNumber = rateNumber + 1;
                budgetRateBase.setRateNumber(rateNumber);
                budgetRateBase.setRateTypeCode(rateAndCost.getRateTypeCode());
                java.util.Date startDate = breakUpInterval.getBoundary().getStartDate();
                budgetRateBase.setStartDate(new Date(startDate.getTime()));
                budgetRateAndBaseList.add(budgetRateBase);
            }
        }
    }

    protected AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance() {
        return this.bli.getNewBudgetLineItemCalculatedAmount();
    }
}

