/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.AbstractBudgetCalculator;
import org.kuali.kra.budget.calculator.Boundary;
import org.kuali.kra.budget.calculator.BreakUpInterval;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateAndCost;
import org.kuali.kra.budget.calculator.SalaryCalculator;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.logging.BufferedLogger;

public class PersonnelLineItemCalculator
extends AbstractBudgetCalculator {
    private BudgetPersonnelDetails budgetPersonnelLineItem;
    private Budget budget;
    private SalaryCalculator salaryCalculator;

    public PersonnelLineItemCalculator(Budget budget, BudgetLineItemBase bli) {
        super(budget, bli);
        this.budgetPersonnelLineItem = (BudgetPersonnelDetails)bli;
        this.budget = budget;
        this.salaryCalculator = new SalaryCalculator(budget, this.budgetPersonnelLineItem);
    }

    public void populateApplicableCosts(Boundary boundary) {
        this.salaryCalculator.setInflationRates(this.getInflationRates());
        this.salaryCalculator.calculate(boundary);
    }

    private boolean isDocumentOhRateSameAsFormOhRate() {
        return this.budget.getOhRateClassCode() != null && this.getBudgetFormFromGlobalVariables() != null && StringUtils.equalsIgnoreCase((String)this.budget.getOhRateClassCode(), (String)this.getBudgetFormFromGlobalVariables().getOhRateClassCodePrevValue());
    }

    private Map<String, Boolean> saveApplyRateFlagsForReset() {
        HashMap<String, Boolean> applyRateFlags = new HashMap<String, Boolean>();
        if (this.budgetPersonnelLineItem != null && CollectionUtils.isNotEmpty((Collection)this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts())) {
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
                applyRateFlags.put(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode(), budgetPersonnelCalculatedAmount.getApplyRateFlag());
            }
        }
        return applyRateFlags;
    }

    public void populateCalculatedAmountLineItems() {
        if (CollectionUtils.isEmpty((Collection)this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts())) {
            this.budgetPersonnelLineItem.refreshReferenceObject("budgetPersonnelCalculatedAmounts");
        }
        Long versionNumber = -1L;
        Map applyRateFlags = null;
        if (!this.isDocumentOhRateSameAsFormOhRate() || this.getBudgetRateService().performSyncFlag(this.budget.getBudgetDocument())) {
            if (this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().size() > 0) {
                versionNumber = ((BudgetPersonnelCalculatedAmount)this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().get(0)).getVersionNumber();
            }
            applyRateFlags = this.saveApplyRateFlagsForReset();
            this.budgetPersonnelLineItem.setBudgetPersonnelCalculatedAmounts(new ArrayList());
            this.setCalculatedAmounts(this.budget, (BudgetLineItemBase)this.budgetPersonnelLineItem);
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
                if (versionNumber == null || versionNumber <= -1L) continue;
                budgetPersonnelCalculatedAmount.setVersionNumber(versionNumber);
            }
        }
        if (this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().size() <= 0) {
            this.setCalculatedAmounts(this.budget, (BudgetLineItemBase)this.budgetPersonnelLineItem);
        }
        for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts()) {
            budgetPersonnelCalculatedAmount.refreshReferenceObject("rateClass");
            if (applyRateFlags != null && applyRateFlags.get(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode()) != null) {
                budgetPersonnelCalculatedAmount.setApplyRateFlag((Boolean)applyRateFlags.get(budgetPersonnelCalculatedAmount.getRateClassCode() + budgetPersonnelCalculatedAmount.getRateTypeCode()));
            }
            BufferedLogger.debug((Object[])new Object[]{budgetPersonnelCalculatedAmount});
            BufferedLogger.debug((Object[])new Object[]{budgetPersonnelCalculatedAmount.getRateClass()});
        }
    }

    protected void updateBudgetLineItemCalculatedAmounts() {
        Boundary liBoundary = new Boundary((java.util.Date)this.budgetPersonnelLineItem.getStartDate(), (java.util.Date)this.budgetPersonnelLineItem.getEndDate());
        this.salaryCalculator.calculate();
        this.budgetPersonnelLineItem.setLineItemCost(this.budgetPersonnelLineItem.getSalaryRequested());
        super.updateBudgetLineItemCalculatedAmounts();
    }

    protected void addCalculatedAmount(AbstractBudgetCalculatedAmount budgetCalculatedAmount) {
        BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmt = (BudgetPersonnelCalculatedAmount)budgetCalculatedAmount;
        budgetPersonnelCalculatedAmt.setPersonNumber(this.budgetPersonnelLineItem.getPersonNumber());
        this.budgetPersonnelLineItem.getBudgetPersonnelCalculatedAmounts().add(budgetPersonnelCalculatedAmt);
    }

    protected AbstractBudgetCalculatedAmount getNewCalculatedAmountInstance() {
        return this.budgetPersonnelLineItem.getNewBudgetPersonnelCalculatedAmount();
    }

    protected void populateBudgetRateBaseList() {
        List budgetRateAndBaseList = this.budgetPersonnelLineItem.getBudgetPersonnelRateAndBaseList();
        List breakupIntervals = this.getBreakupIntervals();
        if (!budgetRateAndBaseList.isEmpty()) {
            budgetRateAndBaseList.clear();
        }
        Integer rateNumber = 0;
        for (BreakUpInterval breakUpInterval : breakupIntervals) {
            QueryList vecAmountBean = breakUpInterval.getRateAndCosts();
            for (RateAndCost rateAndCost : vecAmountBean) {
                BudgetPersonnelRateAndBase budgetRateBase = new BudgetPersonnelRateAndBase();
                BudgetDecimal appliedRate = rateAndCost.getAppliedRate();
                budgetRateBase.setAppliedRate(BudgetDecimal.returnZeroIfNull((BudgetDecimal)appliedRate));
                BudgetDecimal calculatedCost = rateAndCost.getCalculatedCost();
                BudgetDecimal calculatedCostSharing = rateAndCost.getCalculatedCostSharing();
                budgetRateBase.setSalaryRequested(rateAndCost.getBaseAmount());
                budgetRateBase.setBaseCostSharing(rateAndCost.getBaseCostSharingAmount());
                budgetRateBase.setBudgetPeriodId(this.budgetPersonnelLineItem.getBudgetPeriodId());
                budgetRateBase.setBudgetPeriod(this.budgetPersonnelLineItem.getBudgetPeriod());
                budgetRateBase.setCalculatedCost(calculatedCost);
                budgetRateBase.setCalculatedCostSharing(calculatedCostSharing);
                java.util.Date endDate = breakUpInterval.getBoundary().getEndDate();
                budgetRateBase.setEndDate(new Date(endDate.getTime()));
                budgetRateBase.setLineItemNumber(this.budgetPersonnelLineItem.getLineItemNumber());
                budgetRateBase.setOnOffCampusFlag(this.budgetPersonnelLineItem.getOnOffCampusFlag());
                budgetRateBase.setBudgetId(this.budgetPersonnelLineItem.getBudgetId());
                budgetRateBase.setPersonNumber(this.budgetPersonnelLineItem.getPersonNumber());
                budgetRateBase.setPersonId(this.budgetPersonnelLineItem.getPersonId());
                budgetRateBase.setRateClassCode(rateAndCost.getRateClassCode());
                rateNumber = rateNumber + 1;
                budgetRateBase.setRateNumber(rateNumber);
                budgetRateBase.setRateTypeCode(rateAndCost.getRateTypeCode());
                java.util.Date startDate = breakUpInterval.getBoundary().getStartDate();
                budgetRateBase.setStartDate(new Date(startDate.getTime()));
                budgetRateAndBaseList.add(budgetRateBase);
            }
        }
    }
}

