/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.calculator;

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.Boundary;
import org.kuali.kra.budget.calculator.DateSortable;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.SalaryCalculator;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.GreaterThan;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.Operator;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.AppointmentType;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.ValidCeRateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ObjectUtils;

public class SalaryCalculator {
    private static final Log LOG = LogFactory.getLog(SalaryCalculator.class);
    private static final String STRING_1 = "1";
    private static final int DEFAULT_WORKING_MONTHS = 12;
    private Budget budget;
    private BudgetPersonnelDetails personnelLineItem;
    private java.util.Date startDate;
    private java.util.Date endDate;
    private DateTimeService dateTimeService;
    private List<String> errorList;
    private List<String> warningList;
    private QueryList<BudgetRate> inflationRates;

    public SalaryCalculator(Budget budget, BudgetPersonnelDetails personnelLineItem) {
        this.budget = budget;
        this.personnelLineItem = personnelLineItem;
        this.startDate = personnelLineItem.getStartDate();
        this.endDate = personnelLineItem.getEndDate();
        this.errorList = new ArrayList();
        this.warningList = new ArrayList();
        this.dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
    }

    private QueryList<BudgetRate> filterInflationRates() {
        List costElementRates;
        CostElement costElement = this.personnelLineItem.getCostElementBO();
        if (costElement == null) {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("costElement", this.personnelLineItem.getCostElement());
            costElement = (CostElement)businessObjectService.findByPrimaryKey(CostElement.class, pkMap);
        }
        if ((costElementRates = costElement.getValidCeRateTypes()) == null || costElementRates.isEmpty()) {
            costElement.refreshReferenceObject("validCeRateTypes");
            costElementRates = costElement.getValidCeRateTypes();
        }
        ValidCeRateType inflationRateType = null;
        if (costElementRates != null) {
            for (ValidCeRateType validCeRateType : costElementRates) {
                if (!validCeRateType.getRateClassType().equals(RateClassType.INFLATION.getRateClassType())) continue;
                inflationRateType = validCeRateType;
                break;
            }
        }
        Equals eInflationRC = null;
        Equals eInflationRT = null;
        And inflRCandRT = null;
        if (inflationRateType != null) {
            eInflationRC = new Equals("rateClassCode", (Comparable)((Object)inflationRateType.getRateClassCode()));
            eInflationRT = new Equals("rateTypeCode", (Comparable)((Object)inflationRateType.getRateTypeCode()));
            inflRCandRT = new And((Operator)eInflationRC, (Operator)eInflationRT);
        }
        LesserThan ltEndDate = new LesserThan("startDate", (Comparable)this.endDate);
        Equals eEndDate = new Equals("startDate", (Comparable)this.endDate);
        Or ltOrEqEndDate = new Or((Operator)ltEndDate, (Operator)eEndDate);
        GreaterThan gtStartDate = new GreaterThan("startDate", (Comparable)this.startDate);
        Equals eStartDate = new Equals("startDate", (Comparable)this.startDate);
        Or gtOrEqStartDate = new Or((Operator)gtStartDate, (Operator)eStartDate);
        And gtOrEqStartDateAndltOrEqEndDate = new And((Operator)gtOrEqStartDate, (Operator)ltOrEqEndDate);
        And dateAndRate = new And((Operator)inflRCandRT, (Operator)gtOrEqStartDateAndltOrEqEndDate);
        Equals onOffCampus = new Equals("onOffCampusFlag", (Comparable)costElement.getOnOffCampusFlag());
        And dateAndRateAndOnOffCampusFlag = new And((Operator)dateAndRate, (Operator)onOffCampus);
        if (this.personnelLineItem.getApplyInRateFlag().booleanValue()) {
            return this.getInflationRates() == null ? new QueryList((Collection)this.budget.getBudgetRates()).filter((Operator)dateAndRateAndOnOffCampusFlag) : this.getInflationRates().filter((Operator)dateAndRateAndOnOffCampusFlag);
        }
        return new QueryList();
    }

    private QueryList<BudgetPerson> filterBudgetPersons() {
        QueryList filteredPersons = new QueryList();
        List savedBudgetPersons = new ArrayList();
        BusinessObjectService businessObjectService = KRADServiceLocator.getBusinessObjectService();
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("budgetId", this.budget.getBudgetId());
        savedBudgetPersons = (List)businessObjectService.findMatching(BudgetPerson.class, queryMap);
        if (savedBudgetPersons.isEmpty()) {
            return filteredPersons;
        }
        int i = 0;
        boolean personInDocument = false;
        ArrayList<BudgetPerson> documentBudgetPersons = new ArrayList<BudgetPerson>();
        for (BudgetPerson savedPerson : savedBudgetPersons) {
            personInDocument = false;
            for (BudgetPerson docPerson : this.budget.getBudgetPersons()) {
                if (savedPerson.getPersonSequenceNumber().intValue() != docPerson.getPersonSequenceNumber().intValue()) continue;
                documentBudgetPersons.add(i, docPerson);
                personInDocument = true;
            }
            if (!personInDocument) {
                documentBudgetPersons.add(i, savedPerson);
            }
            ++i;
        }
        QueryList budgetPersons = new QueryList(documentBudgetPersons);
        Equals ePersonSeqNumber = new Equals("personSequenceNumber", (Comparable)this.personnelLineItem.getPersonSequenceNumber());
        QueryList fltdBudgetPersonList = budgetPersons.filter((Operator)ePersonSeqNumber);
        if (fltdBudgetPersonList.isEmpty()) {
            return filteredPersons;
        }
        BudgetPerson budgetPerson = (BudgetPerson)fltdBudgetPersonList.get(0);
        Equals ePersonId = new Equals("personId", (Comparable)((Object)budgetPerson.getPersonId()));
        Equals eJobCode = new Equals("jobCode", (Comparable)((Object)budgetPerson.getJobCode()));
        Equals eRolodexId = new Equals("rolodexId", (Comparable)budgetPerson.getRolodexId());
        And personIdAndJobCode = new And((Operator)ePersonId, (Operator)eJobCode);
        And personIdAndRoldexIdAndJobCode = new And((Operator)personIdAndJobCode, (Operator)eRolodexId);
        LesserThan ltEndDate = new LesserThan("effectiveDate", (Comparable)this.endDate);
        Equals eEndDate = new Equals("effectiveDate", (Comparable)this.endDate);
        Or ltOrEqEndDate = new Or((Operator)ltEndDate, (Operator)eEndDate);
        And personIdAndJobCodeAndltOrEqEndDate = new And((Operator)personIdAndRoldexIdAndJobCode, (Operator)ltOrEqEndDate);
        filteredPersons = budgetPersons.filter((Operator)personIdAndJobCodeAndltOrEqEndDate);
        LOG.debug((Object)("budget persons list size after filtering persons list with oprator" + personIdAndJobCodeAndltOrEqEndDate + " is " + filteredPersons.size()));
        LesserThan ltStartDate = new LesserThan("effectiveDate", (Comparable)this.startDate);
        Equals eStartDate = new Equals("effectiveDate", (Comparable)this.startDate);
        Or ltOrEqStartDate = new Or((Operator)ltStartDate, (Operator)eStartDate);
        QueryList tmpFltdPersons = filteredPersons.filter((Operator)ltOrEqStartDate);
        ArrayList<BudgetPerson> removeList = new ArrayList<BudgetPerson>();
        for (BudgetPerson bgPerson : tmpFltdPersons) {
            if (bgPerson.getEffectiveDate().compareTo(budgetPerson.getEffectiveDate()) != 0 || bgPerson.getPersonSequenceNumber().intValue() == budgetPerson.getPersonSequenceNumber().intValue()) continue;
            removeList.add(bgPerson);
        }
        tmpFltdPersons.removeAll(removeList);
        boolean noCalcBase = false;
        if (tmpFltdPersons.isEmpty()) {
            noCalcBase = true;
        }
        LOG.debug((Object)("budget persons list size after filtering persons list after removing " + ltOrEqStartDate + " is " + filteredPersons.size()));
        if (!tmpFltdPersons.isEmpty()) {
            filteredPersons.clear();
            tmpFltdPersons.sort("effectiveDate", false);
            filteredPersons.add(tmpFltdPersons.get(0));
            LOG.debug((Object)("actual filtered persons list size is" + filteredPersons.size()));
        }
        if (noCalcBase) {
            StringBuffer warningMsg = new StringBuffer("Base salary information is not available for the person ");
            StringBuffer errMsg = new StringBuffer("Error finding the calculation base for the person ");
            errMsg.append(this.personnelLineItem.getPersonId());
            errMsg.append(" with Job Code ");
            errMsg.append(this.personnelLineItem.getJobCode());
            warningMsg.append(this.personnelLineItem.getPersonId());
            warningMsg.append(" with Job Code ");
            warningMsg.append(this.personnelLineItem.getJobCode());
            warningMsg.append(" for the period ");
            warningMsg.append(this.dateTimeService.toDateString(this.startDate));
            warningMsg.append(" to ");
            if (!filteredPersons.isEmpty()) {
                warningMsg.append(this.dateTimeService.toDateString(this.add((java.util.Date)((BudgetPerson)filteredPersons.get(0)).getEffectiveDate(), -1)));
            } else {
                warningMsg.append(this.dateTimeService.toDateString((java.util.Date)this.personnelLineItem.getEndDate()));
            }
            warningMsg.append("\n");
            warningMsg.append("Salary for this period will be set to 0\n");
            warningMsg.append("Please make changes to budget person details and recalculate the budget");
            this.warningList.add(warningMsg.toString());
            this.errorList.add(errMsg.toString());
        }
        return filteredPersons;
    }

    private java.util.Date add(java.util.Date date, int days) {
        Calendar cal = this.dateTimeService.getCalendar(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public void calculate() {
        Boundary boundary = new Boundary((java.util.Date)this.personnelLineItem.getStartDate(), (java.util.Date)this.personnelLineItem.getEndDate());
        this.calculate(boundary);
        this.personnelLineItem.setSalaryRequested(boundary.getApplicableCost());
        this.personnelLineItem.setCostSharingAmount(boundary.getApplicableCostSharing());
        this.personnelLineItem.setCostSharingPercent(this.calculateCostSharingPercentage());
    }

    private BudgetDecimal calculateCostSharingPercentage() {
        BudgetDecimal charged = this.personnelLineItem.getPercentCharged();
        BudgetDecimal effort = this.personnelLineItem.getPercentEffort();
        return (BudgetDecimal)effort.subtract((AbstractKualiDecimal)charged);
    }

    final void calculate(Boundary boundary) {
        this.startDate = boundary.getStartDate();
        this.endDate = boundary.getEndDate();
        BudgetDecimal totalSalary = BudgetDecimal.ZERO;
        QueryList brkupSalaryDetails = this.createSalBreakupIntervals();
        for (SalaryDetails salaryDetails : brkupSalaryDetails) {
            this.startDate = salaryDetails.getBoundary().getStartDate();
            this.endDate = salaryDetails.getBoundary().getEndDate();
            totalSalary = (BudgetDecimal)totalSalary.add((AbstractKualiDecimal)salaryDetails.calculateSalary());
        }
        BudgetDecimal charged = this.personnelLineItem.getPercentCharged();
        BudgetDecimal costSharing = totalSalary.percentage(this.calculateCostSharingPercentage());
        BudgetDecimal requestedSalary = totalSalary.percentage(charged);
        boundary.setApplicableCost(requestedSalary);
        boundary.setApplicableCostSharing(costSharing);
    }

    private QueryList<SalaryDetails> createSalBreakupIntervals() {
        SalaryDetails salaryDetails;
        QueryList combinedList = new QueryList();
        combinedList.addAll((Collection)this.filterBudgetPersons());
        combinedList.addAll((Collection)this.filterInflationRates());
        combinedList.sort("sortableDate");
        if (this.isAnniversarySalaryDateEnabled()) {
            combinedList = this.processAnniversarySalaryDateInflationRates(combinedList);
        }
        QueryList breakUpIntervals = new QueryList();
        BudgetPerson budgetPerson = null;
        BudgetRate budgetRate = null;
        BudgetRate prevBudgetProposalRate = null;
        java.util.Date tempStartDate = this.startDate;
        java.util.Date tempEndDate = this.endDate;
        Date rateChangeDate = null;
        SalaryDetails prevSalaryDetails = new SalaryDetails(this);
        for (int index = 0; index < combinedList.size(); ++index) {
            int compareDateChange;
            Object changedObject = combinedList.get(index);
            boolean personFlag = changedObject instanceof BudgetPerson;
            if (personFlag) {
                budgetPerson = (BudgetPerson)changedObject;
                rateChangeDate = budgetPerson.getStartDate();
                prevSalaryDetails.setActualBaseSalary(budgetPerson.getCalculationBase());
                if (budgetPerson.getAppointmentType() == null) {
                    budgetPerson.refreshReferenceObject("appointmentType");
                }
                prevSalaryDetails.setWorkingMonths(budgetPerson.getAppointmentType().getDuration());
            } else {
                budgetRate = (BudgetRate)changedObject;
                rateChangeDate = budgetRate.getStartDate();
            }
            if (budgetPerson == null || (compareDateChange = rateChangeDate.compareTo(tempStartDate)) <= 0) continue;
            Calendar rateChangeCal = this.dateTimeService.getCalendar((java.util.Date)rateChangeDate);
            rateChangeCal.add(5, -1);
            tempEndDate = rateChangeCal.getTime();
            Boundary boundary = new Boundary(tempStartDate, tempEndDate);
            salaryDetails = new SalaryDetails(this);
            salaryDetails.setBoundary(boundary);
            if (!personFlag && budgetRate != null) {
                salaryDetails.setActualBaseSalary(this.getPrevSalaryBase(budgetPerson, boundary));
                if (prevBudgetProposalRate != null && budgetPerson.getEffectiveDate().before(prevBudgetProposalRate.getStartDate()) && budgetPerson.getEffectiveDate().before(boundary.getStartDate()) && prevBudgetProposalRate.getStartDate().before(boundary.getEndDate()) && (prevBudgetProposalRate.getStartDate().equals(boundary.getStartDate()) || ((BudgetPeriod)this.budget.getBudgetPeriods().get(0)).getEndDate().before(this.startDate))) {
                    salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
                } else if (budgetRate != null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate()) && budgetPerson.getEffectiveDate().before(this.startDate) && budgetRate.getStartDate().before(boundary.getEndDate()) && (budgetRate.getStartDate().compareTo(this.startDate) <= 0 || ((BudgetPeriod)this.budget.getBudgetPeriods().get(0)).getEndDate().before(this.startDate))) {
                    salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
                }
                salaryDetails.setWorkingMonths(prevSalaryDetails.getWorkingMonths());
                salaryDetails.setAltBudgetPerson(this.getSameJobPerson(boundary, budgetPerson));
            }
            if (personFlag && budgetPerson != null) {
                salaryDetails.setActualBaseSalary(budgetPerson.getCalculationBase());
                salaryDetails.setWorkingMonths(budgetPerson.getAppointmentType().getDuration());
                salaryDetails.setAltBudgetPerson(this.getSameJobPerson(boundary, budgetPerson));
            }
            if (budgetPerson.getStartDate().compareTo(tempStartDate) <= 0) {
                breakUpIntervals.add((Object)salaryDetails);
            }
            prevBudgetProposalRate = budgetRate;
            prevSalaryDetails = salaryDetails;
            tempStartDate = rateChangeDate;
        }
        salaryDetails = new SalaryDetails(this);
        Boundary boundary = new Boundary(tempStartDate, this.endDate);
        salaryDetails = new SalaryDetails(this);
        salaryDetails.setBoundary(boundary);
        if (budgetRate != null && budgetPerson != null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate())) {
            salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
            salaryDetails.setWorkingMonths(prevSalaryDetails.getWorkingMonths());
        }
        if (budgetPerson != null) {
            salaryDetails.setActualBaseSalary(this.getPrevSalaryBase(budgetPerson, boundary));
            this.populateAppointmentType(budgetPerson);
            BudgetPerson newBudgetPerson = this.getBudgetPersonApplied(budgetPerson, boundary);
            if (budgetRate != null && (newBudgetPerson == null && budgetPerson.getEffectiveDate().before(budgetRate.getStartDate()) || newBudgetPerson != null && newBudgetPerson.getEffectiveDate().before(budgetRate.getStartDate()))) {
                salaryDetails.calculateActualBaseSalary(budgetRate.getApplicableRate());
            }
            if (newBudgetPerson != null) {
                newBudgetPerson.refreshReferenceObject("appointmentType");
                salaryDetails.setWorkingMonths(Integer.valueOf(newBudgetPerson.getAppointmentType() == null ? 12 : newBudgetPerson.getAppointmentType().getDuration()));
            } else {
                salaryDetails.setWorkingMonths(Integer.valueOf(budgetPerson.getAppointmentType() == null ? 12 : budgetPerson.getAppointmentType().getDuration()));
            }
            salaryDetails.setAltBudgetPerson(this.getSameJobPerson(boundary, budgetPerson));
        }
        breakUpIntervals.add((Object)salaryDetails);
        return breakUpIntervals;
    }

    private QueryList<DateSortable> processAnniversarySalaryDateInflationRates(QueryList<DateSortable> combinedList) {
        QueryList<DateSortable> filteredCombinedList = new QueryList<DateSortable>();
        for (DateSortable dateSortable : combinedList) {
            if (!(dateSortable instanceof BudgetPerson)) continue;
            BudgetPerson budgetPerson = (BudgetPerson)dateSortable;
            if (budgetPerson.getSalaryAnniversaryDate() == null) {
                filteredCombinedList = combinedList;
                continue;
            }
            filteredCombinedList.add((Object)dateSortable);
            filteredCombinedList.addAll((Collection)this.createAnnualInflationRates(budgetPerson));
        }
        return filteredCombinedList;
    }

    private List<BudgetRate> createAnnualInflationRates(BudgetPerson budgetPerson) {
        Calendar endCalendar;
        int endYear;
        Calendar salaryDateCalendar;
        int startYear;
        ArrayList<BudgetRate> budgetRates = new ArrayList<BudgetRate>();
        QueryList inflationRatesList = this.filterInflationRates((java.util.Date)budgetPerson.getEffectiveDate(), this.endDate);
        if (inflationRatesList.isEmpty()) {
            return budgetRates;
        }
        BudgetRate inflationRate = this.getInflationRateToBeApplied((List)inflationRatesList, (java.util.Date)budgetPerson.getSalaryAnniversaryDate());
        BudgetRate budgetRate = null;
        if (inflationRate != null) {
            budgetRate = (BudgetRate)ObjectUtils.deepCopy((Serializable)inflationRate);
            if (!budgetPerson.getSalaryAnniversaryDate().before(budgetPerson.getEffectiveDate())) {
                budgetRate.setStartDate(budgetPerson.getSalaryAnniversaryDate());
            }
            budgetRates.add(budgetRate);
        }
        if ((startYear = (salaryDateCalendar = this.dateTimeService.getCalendar((java.util.Date)budgetPerson.getSalaryAnniversaryDate())).get(1)) != (endYear = (endCalendar = this.dateTimeService.getCalendar(this.endDate)).get(1))) {
            while (salaryDateCalendar.get(1) <= endYear) {
                salaryDateCalendar.add(1, 1);
                java.util.Date nextInflationDate = salaryDateCalendar.getTime();
                if (nextInflationDate.after(this.endDate)) break;
                BudgetRate inflationRateToBeApplied = this.getInflationRateToBeApplied((List)inflationRatesList, nextInflationDate);
                if (inflationRateToBeApplied == null) continue;
                BudgetRate nextBudgetRate = (BudgetRate)ObjectUtils.deepCopy((Serializable)inflationRateToBeApplied);
                try {
                    nextBudgetRate.setStartDate(this.dateTimeService.convertToSqlDate(this.dateTimeService.toDateString(nextInflationDate)));
                    budgetRates.add(nextBudgetRate);
                }
                catch (ParseException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return budgetRates;
    }

    private BudgetRate getInflationRateToBeApplied(List<BudgetRate> inflationRatesList, java.util.Date effectiveDate) {
        Equals eqEffectiveDate = new Equals("startDate", (Comparable)effectiveDate);
        LesserThan ltEffectiveDate = new LesserThan("startDate", (Comparable)effectiveDate);
        Or eqOrltEffectiveDate = new Or((Operator)eqEffectiveDate, (Operator)ltEffectiveDate);
        QueryList qlInflationRates = new QueryList(inflationRatesList);
        QueryList qlFilteredRates = qlInflationRates.filter((Operator)eqOrltEffectiveDate);
        qlFilteredRates.sort("startDate", false);
        return qlFilteredRates.isEmpty() ? null : (BudgetRate)qlFilteredRates.get(0);
    }

    private boolean isAnniversarySalaryDateEnabled() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, "enableSalaryInflationAnniversaryDate").equals(STRING_1);
    }

    private ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    private void populateAppointmentType(BudgetPerson budgetPerson) {
        HashMap<String, String> qPersonMap = new HashMap<String, String>();
        qPersonMap.put("appointmentTypeCode", budgetPerson.getAppointmentTypeCode());
        AppointmentType appointmentType = (AppointmentType)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(AppointmentType.class, qPersonMap);
        budgetPerson.setAppointmentType(appointmentType);
    }

    private BudgetPerson getSameJobPerson(Boundary boundary, BudgetPerson curBudgetPerson) {
        for (BudgetPerson budgetPerson : this.budget.getBudgetPersons()) {
            if (!(curBudgetPerson.getPersonId() != null && curBudgetPerson.getPersonId().equals(budgetPerson.getPersonId()) || curBudgetPerson.getRolodexId() != null && curBudgetPerson.getRolodexId().equals(budgetPerson.getRolodexId())) && (curBudgetPerson.getTbnId() == null || !curBudgetPerson.getTbnId().equals(budgetPerson.getTbnId())) || budgetPerson.getPersonSequenceNumber().equals(curBudgetPerson.getPersonSequenceNumber()) || !StringUtils.equals((String)budgetPerson.getJobCode(), (String)curBudgetPerson.getJobCode()) || budgetPerson.getEffectiveDate() == null || !budgetPerson.getEffectiveDate().after(curBudgetPerson.getEffectiveDate()) || budgetPerson.getEffectiveDate().compareTo(boundary.getStartDate()) < 0 || budgetPerson.getEffectiveDate().compareTo(boundary.getEndDate()) > 0) continue;
            return budgetPerson;
        }
        return null;
    }

    public void setInflationRates(QueryList<BudgetRate> inflationRates) {
        this.inflationRates = inflationRates;
    }

    public QueryList<BudgetRate> getInflationRates() {
        return this.inflationRates;
    }

    private BudgetDecimal getPrevSalaryBase(BudgetPerson budgetPerson, Boundary boundary) {
        Date p1StartDate = ((BudgetPeriod)this.budget.getBudgetPeriods().get(0)).getStartDate();
        BudgetPerson newBudgetPerson = budgetPerson;
        for (BudgetPerson budgetPerson1 : this.budget.getBudgetPersons()) {
            if (!(budgetPerson1.getPersonId() != null && budgetPerson1.getPersonId().equals(budgetPerson.getPersonId()) || budgetPerson1.getRolodexId() != null && budgetPerson1.getRolodexId().equals(budgetPerson.getRolodexId())) && (budgetPerson1.getTbnId() == null || !budgetPerson1.getTbnId().equals(budgetPerson.getTbnId())) || budgetPerson1.getPersonSequenceNumber().equals(newBudgetPerson.getPersonSequenceNumber()) || budgetPerson1.getJobCode() == null || !budgetPerson1.getJobCode().equals(newBudgetPerson.getJobCode()) || !budgetPerson1.getEffectiveDate().after(newBudgetPerson.getEffectiveDate()) || budgetPerson1.getEffectiveDate().compareTo(boundary.getStartDate()) > 0) continue;
            newBudgetPerson = budgetPerson1;
        }
        BudgetDecimal calBase = newBudgetPerson.getCalculationBase();
        if (budgetPerson.getEffectiveDate().before(p1StartDate)) {
            p1StartDate = budgetPerson.getEffectiveDate();
        }
        QueryList qlist = this.filterInflationRates((java.util.Date)p1StartDate, this.startDate);
        for (BudgetRate budgetProposalrate : qlist) {
            if (!budgetProposalrate.getStartDate().after(budgetPerson.getEffectiveDate()) || !budgetProposalrate.getStartDate().before(this.startDate)) continue;
            calBase = (BudgetDecimal)calBase.add((AbstractKualiDecimal)calBase.multiply(budgetProposalrate.getApplicableRate()).divide(new BudgetDecimal(100.0)));
        }
        return calBase;
    }

    private BudgetPerson getBudgetPersonApplied(BudgetPerson budgetPerson, Boundary boundary) {
        BudgetPerson newBudgetPerson = budgetPerson;
        for (BudgetPerson budgetPerson1 : this.budget.getBudgetPersons()) {
            if (!(budgetPerson1.getPersonId() != null && budgetPerson1.getPersonId().equals(budgetPerson.getPersonId()) || budgetPerson1.getRolodexId() != null && budgetPerson1.getRolodexId().equals(budgetPerson.getRolodexId())) && (budgetPerson1.getTbnId() == null || !budgetPerson1.getTbnId().equals(budgetPerson.getTbnId())) || budgetPerson1.getPersonSequenceNumber().equals(newBudgetPerson.getPersonSequenceNumber()) || budgetPerson1.getJobCode() == null || !budgetPerson1.getJobCode().equals(newBudgetPerson.getJobCode()) || !budgetPerson1.getEffectiveDate().after(newBudgetPerson.getEffectiveDate()) || budgetPerson1.getEffectiveDate().compareTo(boundary.getStartDate()) > 0) continue;
            return budgetPerson1;
        }
        return null;
    }

    private QueryList<BudgetRate> filterInflationRates(java.util.Date sDate, java.util.Date eDate) {
        List costElementRates;
        CostElement costElement = this.personnelLineItem.getCostElementBO();
        if (costElement == null) {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> pkMap = new HashMap<String, String>();
            pkMap.put("costElement", this.personnelLineItem.getCostElement());
            costElement = (CostElement)businessObjectService.findByPrimaryKey(CostElement.class, pkMap);
        }
        if ((costElementRates = costElement.getValidCeRateTypes()) == null || costElementRates.isEmpty()) {
            costElement.refreshReferenceObject("validCeRateTypes");
            costElementRates = costElement.getValidCeRateTypes();
        }
        ValidCeRateType inflationRateType = null;
        if (costElementRates != null) {
            for (ValidCeRateType validCeRateType : costElementRates) {
                if (!validCeRateType.getRateClassType().equals(RateClassType.INFLATION.getRateClassType())) continue;
                inflationRateType = validCeRateType;
                LOG.info((Object)("Costelement " + costElement + " gets inflation"));
                break;
            }
        }
        Equals eInflationRC = null;
        Equals eInflationRT = null;
        And inflRCandRT = null;
        if (inflationRateType != null) {
            eInflationRC = new Equals("rateClassCode", (Comparable)((Object)inflationRateType.getRateClassCode()));
            eInflationRT = new Equals("rateTypeCode", (Comparable)((Object)inflationRateType.getRateTypeCode()));
            inflRCandRT = new And((Operator)eInflationRC, (Operator)eInflationRT);
        }
        LesserThan ltStartDate = new LesserThan("startDate", (Comparable)sDate);
        And ltStartDateAndRate = new And(inflRCandRT, (Operator)ltStartDate);
        Equals onOffCampus = new Equals("onOffCampusFlag", (Comparable)costElement.getOnOffCampusFlag());
        And ltStartDateAndRateAndOnOffCampusFlag = new And((Operator)ltStartDateAndRate, (Operator)onOffCampus);
        LesserThan ltEndDate = new LesserThan("startDate", (Comparable)eDate);
        Equals eEndDate = new Equals("startDate", (Comparable)eDate);
        Or ltOrEqEndDate = new Or((Operator)ltEndDate, (Operator)eEndDate);
        GreaterThan gtStartDate = new GreaterThan("startDate", (Comparable)sDate);
        Equals eStartDate = new Equals("startDate", (Comparable)sDate);
        Or gtOrEqStartDate = new Or((Operator)gtStartDate, (Operator)eStartDate);
        And gtOrEqStartDateAndltOrEqEndDate = new And((Operator)gtOrEqStartDate, (Operator)ltOrEqEndDate);
        And dateAndRate = new And((Operator)inflRCandRT, (Operator)gtOrEqStartDateAndltOrEqEndDate);
        And dateAndRateAndOnOffCampusFlag = new And((Operator)dateAndRate, (Operator)onOffCampus);
        if (this.personnelLineItem.getApplyInRateFlag().booleanValue()) {
            QueryList prevInflationRatesList;
            QueryList inflationRatesList;
            if (this.getInflationRates() == null) {
                inflationRatesList = new QueryList((Collection)this.budget.getBudgetRates()).filter((Operator)dateAndRateAndOnOffCampusFlag);
                prevInflationRatesList = new QueryList((Collection)this.budget.getBudgetRates()).filter((Operator)ltStartDateAndRateAndOnOffCampusFlag);
            } else {
                inflationRatesList = this.getInflationRates().filter((Operator)dateAndRateAndOnOffCampusFlag);
                prevInflationRatesList = this.getInflationRates().filter((Operator)ltStartDateAndRateAndOnOffCampusFlag);
            }
            if (!prevInflationRatesList.isEmpty()) {
                prevInflationRatesList.sort("startDate", false);
                BudgetRate prevInflationRate = (BudgetRate)prevInflationRatesList.get(0);
                inflationRatesList.add((Object)prevInflationRate);
                inflationRatesList.sort("startDate");
            }
            return inflationRatesList;
        }
        return new QueryList();
    }

    static /* synthetic */ java.util.Date access$000(SalaryCalculator x0) {
        return x0.startDate;
    }

    static /* synthetic */ DateTimeService access$100(SalaryCalculator x0) {
        return x0.dateTimeService;
    }

    static /* synthetic */ java.util.Date access$200(SalaryCalculator x0) {
        return x0.endDate;
    }
}

