/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.core;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.RateDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.core.RateClassTypeComparator;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeComponent;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.BudgetLaRate;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetPrintForm;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.service.ProposalBudgetNumberOfMonthsService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Budget
extends BudgetVersionOverview {
    private static final String PARAM_VALUE_ENABLED = "1";
    private static final long serialVersionUID = -252470308729741085L;
    private static final String DETAIL_TYPE_CODE = "D";
    private static final String BUDGET_NAMESPACE_CODE = "KC-B";
    private static final String FALSE_FLAG = "N";
    private static final String TRUE_FLAG = "Y";
    private static final String DOCUMENT_TYPE_CODE = "BUDG";
    private static final String DEFAULT_FISCAL_YEAR_START = "01/01/2000";
    private static final Log LOG = LogFactory.getLog(Budget.class);
    private BudgetDocument budgetDocument;
    private String budgetJustification;
    private RateClass rateClass;
    private List<BudgetRate> budgetRates;
    private List<BudgetLaRate> budgetLaRates;
    private List<BudgetPeriod> budgetPeriods;
    private List<BudgetProjectIncome> budgetProjectIncomes;
    private List<BudgetCostShare> budgetCostShares = new ArrayList();
    private List<BudgetUnrecoveredFandA> budgetUnrecoveredFandAs;
    private String activityTypeCode = "x";
    private boolean budgetLineItemDeleted;
    private boolean rateClassTypesReloaded = false;
    private String budgetAdjustmentDocumentNumber;
    private List<BudgetPersonnelDetails> budgetPersonnelDetailsList;
    private List<BudgetPerson> budgetPersons;
    private Date summaryPeriodStartDate;
    private Date summaryPeriodEndDate;
    private List<InstituteRate> instituteRates;
    private List<InstituteLaRate> instituteLaRates;
    private List<RateClass> rateClasses;
    private List<RateClassType> rateClassTypes;
    private SortedMap<CostElement, List<BudgetDecimal>> objectCodeTotals;
    private SortedMap<RateType, List<BudgetDecimal>> calculatedExpenseTotals;
    private SortedMap<RateType, List<BudgetDecimal>> personnelCalculatedExpenseTotals;
    private SortedMap<RateType, List<BudgetDecimal>> nonPersonnelCalculatedExpenseTotals;
    private List<KeyValue> budgetCategoryTypeCodes;
    private SortedMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType;
    private SortedMap<CostElement, List<BudgetPersonnelDetails>> objectCodePersonnelList;
    private SortedMap<String, List<BudgetDecimal>> objectCodePersonnelSalaryTotals;
    private SortedMap<String, List<BudgetDecimal>> objectCodePersonnelFringeTotals;
    private SortedMap<String, List<BudgetDecimal>> budgetSummaryTotals;
    private List<BudgetPrintForm> budgetPrintForms;
    private List<BudgetSubAwards> budgetSubAwards;
    private boolean rateSynced;
    private transient ParameterService parameterService;

    public Budget() {
        this.budgetProjectIncomes = new ArrayList();
        this.budgetRates = new ArrayList();
        this.budgetLaRates = new ArrayList();
        this.budgetPeriods = new ArrayList();
        this.budgetPersonnelDetailsList = new ArrayList();
        this.budgetUnrecoveredFandAs = new ArrayList();
        this.instituteRates = new ArrayList();
        this.instituteLaRates = new ArrayList();
        this.rateClasses = new ArrayList();
        this.rateClassTypes = new ArrayList();
        this.budgetPersons = new ArrayList();
        this.budgetCategoryTypeCodes = new ArrayList();
        this.budgetPrintForms = new ArrayList();
        this.budgetSubAwards = new ArrayList();
        this.setOnOffCampusFlag("D");
    }

    public Boolean getFinalVersionFlag() {
        return this.isFinalVersionFlag();
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void handlePeriodToProjectIncomeRelationship() {
        ArrayList<Long> periodIncomesToDelete = new ArrayList<Long>();
        for (BudgetPeriod persistedPeriod : this.getPersistedBudgetPeriods()) {
            if (this.containsBudgetPeriod(persistedPeriod.getBudgetPeriodId())) continue;
            periodIncomesToDelete.add(persistedPeriod.getBudgetPeriodId());
        }
        this.deletePersistedProjectIncomes(periodIncomesToDelete);
        this.deleteLocalProjectIncomes(periodIncomesToDelete);
    }

    private boolean containsBudgetPeriod(Long periodId) {
        assert (periodId != null) : "the periodId is null";
        for (BudgetPeriod localPeriod : this.getBudgetPeriods()) {
            if (!periodId.equals(localPeriod.getBudgetPeriodId())) continue;
            return true;
        }
        return false;
    }

    public String getBudgetAdjustmentDocumentNumber() {
        return this.budgetAdjustmentDocumentNumber;
    }

    public void setBudgetAdjustmentDocumentNumber(String budgetAdjustmentDocumentNumber) {
        this.budgetAdjustmentDocumentNumber = budgetAdjustmentDocumentNumber;
    }

    private Collection<BudgetPeriod> getPersistedBudgetPeriods() {
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, Long> matchCriteria = new HashMap<String, Long>();
        matchCriteria.put("budgetId", this.getBudgetId());
        Collection periods = service.findMatching(BudgetPeriod.class, matchCriteria);
        return periods != null ? Collections.unmodifiableCollection(periods) : Collections.emptyList();
    }

    private void deletePersistedProjectIncomes(Collection<Long> periodIds) {
        assert (periodIds != null) : "the periodIds are null";
        if (periodIds.isEmpty()) {
            return;
        }
        BusinessObjectService service = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, Collection<Long>> matchCriteria = new HashMap<String, Collection<Long>>();
        matchCriteria.put("budgetPeriodId", periodIds);
        service.deleteMatching(BudgetProjectIncome.class, matchCriteria);
    }

    private void deleteLocalProjectIncomes(Collection<Long> periodIds) {
        assert (periodIds != null) : "the periodIds are null";
        if (periodIds.isEmpty()) {
            return;
        }
        Iterator i = this.getBudgetProjectIncomes().iterator();
        while (i.hasNext()) {
            BudgetProjectIncome budgetProjectIncome = (BudgetProjectIncome)i.next();
            if (!periodIds.contains(budgetProjectIncome.getBudgetPeriodId())) continue;
            i.remove();
        }
    }

    public List<KualiDecimal> getProjectIncomePeriodTotalsForEachBudgetPeriod() {
        Map incomes = this.mapProjectIncomeTotalsToBudgetPeriodNumbers();
        return this.findProjectIncomeTotalsForBudgetPeriods(incomes);
    }

    public List<FiscalYearSummary> getFiscalYearCostShareTotals() {
        Map budgetPeriodFiscalYears = this.mapBudgetPeriodsToFiscalYears();
        return this.findCostShareTotalsForBudgetPeriods(budgetPeriodFiscalYears);
    }

    public List<FiscalYearSummary> getFiscalYearUnrecoveredFandATotals() {
        Map budgetPeriodFiscalYears = this.mapBudgetPeriodsToFiscalYears();
        return this.findCostShareTotalsForBudgetPeriods(budgetPeriodFiscalYears);
    }

    public Boolean isCostSharingApplicable() {
        return this.loadCostSharingApplicability();
    }

    public Boolean isCostSharingEnforced() {
        return this.loadCostSharingEnforcement();
    }

    public boolean isCostSharingAvailable() {
        BudgetPeriod budgetPeriod;
        boolean costSharingAvailable = false;
        Iterator i$ = this.getBudgetPeriods().iterator();
        while (i$.hasNext() && !(costSharingAvailable = (budgetPeriod = (BudgetPeriod)i$.next()).getCostSharingAmount().isPositive())) {
        }
        return costSharingAvailable;
    }

    public Boolean isUnrecoveredFandAEnforced() {
        return this.loadUnrecoveredFandAEnforcement();
    }

    public Boolean isUnrecoveredFandAApplicable() {
        return this.loadUnrecoveredFandAApplicability();
    }

    public boolean isUnrecoveredFandAAvailable() {
        return this.getAvailableUnrecoveredFandA().doubleValue() > 0.0;
    }

    public BudgetDecimal getAllocatedCostSharing() {
        BudgetDecimal costShareTotal = new BudgetDecimal(0.0);
        for (BudgetCostShare budgetCostShare : this.getBudgetCostShares()) {
            if (budgetCostShare.getShareAmount() == null) continue;
            costShareTotal = (BudgetDecimal)costShareTotal.add((AbstractKualiDecimal)budgetCostShare.getShareAmount());
        }
        return costShareTotal;
    }

    public BudgetDecimal getAllocatedUnrecoveredFandA() {
        BudgetDecimal allocatedUnrecoveredFandA = BudgetDecimal.ZERO;
        for (BudgetUnrecoveredFandA unrecoveredFandA : this.getBudgetUnrecoveredFandAs()) {
            if (unrecoveredFandA.getAmount() == null) continue;
            allocatedUnrecoveredFandA = (BudgetDecimal)allocatedUnrecoveredFandA.add((AbstractKualiDecimal)unrecoveredFandA.getAmount());
        }
        return allocatedUnrecoveredFandA;
    }

    public KualiDecimal getProjectIncomeTotal() {
        KualiDecimal projectIncomeTotal = new KualiDecimal(0.0);
        for (BudgetProjectIncome budgetProjectIncome : this.budgetProjectIncomes) {
            if (budgetProjectIncome.getProjectIncome() == null) continue;
            projectIncomeTotal = (KualiDecimal)projectIncomeTotal.add((AbstractKualiDecimal)budgetProjectIncome.getProjectIncome());
        }
        return projectIncomeTotal;
    }

    public BudgetDecimal getUnallocatedCostSharing() {
        return (BudgetDecimal)this.getAvailableCostSharing().subtract((AbstractKualiDecimal)this.getAllocatedCostSharing());
    }

    public BudgetDecimal getUnallocatedUnrecoveredFandA() {
        return (BudgetDecimal)this.getAvailableUnrecoveredFandA().subtract((AbstractKualiDecimal)this.getAllocatedUnrecoveredFandA());
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public List<BudgetPeriod> getBudgetPeriods() {
        if (this.budgetPeriods.isEmpty() && this.getStartDate() != null) {
            this.getBudgetSummaryService().generateBudgetPeriods(this, this.budgetPeriods);
        }
        return this.budgetPeriods;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return (BudgetSummaryService)KraServiceLocator.getService(BudgetSummaryService.class);
    }

    public void setBudgetPeriods(List<BudgetPeriod> budgetPeriods) {
        this.budgetPeriods = budgetPeriods;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getBudgetProjectIncomes());
        managedLists.add(this.getBudgetCostShares());
        managedLists.add(this.getBudgetUnrecoveredFandAs());
        ArrayList budgetLineItems = new ArrayList();
        ArrayList budgetLineItemCalculatedAmounts = new ArrayList();
        ArrayList budgetFormulatedCosts = new ArrayList();
        ArrayList budgetRateAndBaseList = new ArrayList();
        ArrayList bPersonnelDetailsList = new ArrayList();
        ArrayList budgetPersonnelCalculatedAmounts = new ArrayList();
        ArrayList budgetPersonnelRateAndBaseList = new ArrayList();
        ArrayList budgetModularIdcs = new ArrayList();
        ArrayList<BudgetModular> budgetModular = new ArrayList<BudgetModular>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (ObjectUtils.isNotNull((Object)budgetPeriod.getBudgetModular())) {
                budgetModularIdcs.addAll(budgetPeriod.getBudgetModular().getBudgetModularIdcs());
                budgetModular.add(budgetPeriod.getBudgetModular());
            }
            List tempLIs = budgetPeriod.getBudgetLineItems();
            budgetLineItems.addAll(tempLIs);
            for (BudgetLineItem budgetLineItem : tempLIs) {
                budgetFormulatedCosts.addAll(budgetLineItem.getBudgetFormulatedCosts());
                budgetLineItemCalculatedAmounts.addAll(budgetLineItem.getBudgetLineItemCalculatedAmounts());
                budgetRateAndBaseList.addAll(budgetLineItem.getBudgetRateAndBaseList());
                List tempPerList = budgetLineItem.getBudgetPersonnelDetailsList();
                bPersonnelDetailsList.addAll(tempPerList);
                for (BudgetPersonnelDetails budgetPersonnelDetails : tempPerList) {
                    budgetPersonnelCalculatedAmounts.addAll(budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts());
                    budgetPersonnelRateAndBaseList.addAll(budgetPersonnelDetails.getBudgetPersonnelRateAndBaseList());
                }
            }
        }
        ArrayList subAwardFiles = new ArrayList();
        ArrayList subAwardAttachments = new ArrayList();
        ArrayList subAwardPeriodDetails = new ArrayList();
        for (BudgetSubAwards budgetSubAward : this.getBudgetSubAwards()) {
            subAwardFiles.addAll(budgetSubAward.getBudgetSubAwardFiles());
            subAwardAttachments.addAll(budgetSubAward.getBudgetSubAwardAttachments());
            subAwardPeriodDetails.addAll(budgetSubAward.getBudgetSubAwardPeriodDetails());
        }
        managedLists.add(budgetModularIdcs);
        managedLists.add(budgetModular);
        managedLists.add(budgetPersonnelRateAndBaseList);
        managedLists.add(budgetPersonnelCalculatedAmounts);
        managedLists.add(bPersonnelDetailsList);
        managedLists.add(budgetRateAndBaseList);
        managedLists.add(budgetLineItemCalculatedAmounts);
        managedLists.add(budgetFormulatedCosts);
        managedLists.add(budgetLineItems);
        managedLists.add(this.getBudgetPersons());
        managedLists.add(this.getBudgetPeriods());
        managedLists.add(this.getBudgetLaRates());
        managedLists.add(this.getBudgetRates());
        managedLists.add(subAwardAttachments);
        managedLists.add(subAwardFiles);
        managedLists.add(subAwardPeriodDetails);
        managedLists.add(this.getBudgetSubAwards());
        return managedLists;
    }

    public boolean areLineItemJustificationsPresent() {
        boolean justificationFound = false;
        block0: for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                justificationFound = !StringUtils.isEmpty((String)lineItem.getBudgetJustification());
                if (!justificationFound) continue;
                break block0;
            }
        }
        return justificationFound;
    }

    public BudgetPeriod getBudgetPeriod(int index) {
        while (this.getBudgetPeriods().size() <= index) {
            BudgetPeriod budgetPeriod = this.getNewBudgetPeriod();
            budgetPeriod.setBudget(this);
            this.getBudgetPeriods().add(budgetPeriod);
        }
        return (BudgetPeriod)this.getBudgetPeriods().get(index);
    }

    public Date getSummaryPeriodStartDate() {
        this.summaryPeriodStartDate = ((BudgetPeriod)this.getBudgetPeriods().get(0)).getStartDate();
        if (this.summaryPeriodStartDate == null) {
            this.summaryPeriodStartDate = this.getStartDate();
        }
        return this.summaryPeriodStartDate;
    }

    public Date getSummaryPeriodEndDate() {
        this.summaryPeriodEndDate = ((BudgetPeriod)this.getBudgetPeriods().get(this.budgetPeriods.size() - 1)).getEndDate();
        if (this.summaryPeriodEndDate == null) {
            this.summaryPeriodEndDate = this.getEndDate();
        }
        return this.summaryPeriodEndDate;
    }

    public List<BudgetRate> getBudgetRates() {
        return this.budgetRates;
    }

    public void setBudgetRates(List<BudgetRate> budgetRates) {
        this.budgetRates = budgetRates;
    }

    public List<BudgetLaRate> getBudgetLaRates() {
        return this.budgetLaRates;
    }

    public void setBudgetLaRates(List<BudgetLaRate> budgetLaRates) {
        this.budgetLaRates = budgetLaRates;
    }

    public String getActivityTypeCode() {
        return this.activityTypeCode;
    }

    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    public List<InstituteRate> getInstituteRates() {
        return this.instituteRates;
    }

    public void setInstituteRates(List<InstituteRate> instituteRates) {
        this.instituteRates = instituteRates;
    }

    public BudgetRatesService getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public List<RateClass> getRateClasses() {
        return this.rateClasses;
    }

    public void setRateClasses(List<RateClass> rateClasses) {
        this.rateClasses = rateClasses;
    }

    public List<RateClassType> getRateClassTypes() {
        if (!(!this.rateClassTypes.isEmpty() || this.rateClassTypesReloaded || this.getBudgetRates().isEmpty() && this.getBudgetLaRates().isEmpty())) {
            this.getBudgetRatesService().syncBudgetRateCollectionsToExistingRates(this.rateClassTypes, this.getBudgetDocument());
        } else if (this.rateClassTypesReloaded) {
            if (!this.rateClassTypes.isEmpty()) {
                this.rateClassTypes.clear();
            }
            this.rateClassTypesReloaded = false;
            this.getBudgetRatesService().getBudgetRates(this.rateClassTypes, this.getBudgetDocument());
        }
        Collections.sort(this.rateClassTypes, new RateClassTypeComparator());
        return this.rateClassTypes;
    }

    public void setRateClassTypes(List<RateClassType> rateClassTypes) {
        this.rateClassTypes = rateClassTypes;
    }

    public int getBudgetProjectIncomeCount() {
        return this.getCollectionSize((Collection)this.budgetProjectIncomes);
    }

    public List<BudgetProjectIncome> getBudgetProjectIncomes() {
        return this.budgetProjectIncomes;
    }

    public BudgetProjectIncome getBudgetProjectIncome(int index) {
        while (this.getBudgetProjectIncomes().size() <= index) {
            this.getBudgetProjectIncomes().add(new BudgetProjectIncome());
        }
        return (BudgetProjectIncome)this.getBudgetProjectIncomes().get(index);
    }

    public void setBudgetProjectIncomes(List<BudgetProjectIncome> budgetProjectIncomes) {
        this.budgetProjectIncomes = budgetProjectIncomes;
    }

    public void add(BudgetCostShare budgetCostShare) {
        this.addBudgetDistributionAndIncomeComponent(this.getBudgetCostShares(), (BudgetDistributionAndIncomeComponent)budgetCostShare);
    }

    public void add(BudgetProjectIncome budgetProjectIncome) {
        budgetProjectIncome.setBudgetPeriodId(this.getBudgetPeriodId(budgetProjectIncome));
        this.addBudgetDistributionAndIncomeComponent(this.getBudgetProjectIncomes(), (BudgetDistributionAndIncomeComponent)budgetProjectIncome);
    }

    private Long getBudgetPeriodId(BudgetProjectIncome budgetProjectIncome) {
        List bPeriods = this.getBudgetPeriods();
        if (bPeriods != null && bPeriods.size() > 0) {
            for (BudgetPeriod bPeriod : bPeriods) {
                if (bPeriod.getBudgetPeriod() == null || budgetProjectIncome.getBudgetPeriodNumber() == null || bPeriod.getBudgetPeriod().intValue() != budgetProjectIncome.getBudgetPeriodNumber().intValue()) continue;
                return bPeriod.getBudgetPeriodId();
            }
        }
        return null;
    }

    public void add(BudgetRate budgetRate) {
        if (budgetRate != null) {
            this.getBudgetRates().add(budgetRate);
        }
    }

    public void add(BudgetLaRate budgetLaRate) {
        if (budgetLaRate != null) {
            this.getBudgetLaRates().add(budgetLaRate);
        }
    }

    public void add(BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        this.addBudgetDistributionAndIncomeComponent(this.getBudgetUnrecoveredFandAs(), (BudgetDistributionAndIncomeComponent)budgetUnrecoveredFandA);
    }

    public List<BudgetPerson> getBudgetPersons() {
        return this.budgetPersons;
    }

    public void setBudgetPersons(List<BudgetPerson> budgetPersons) {
        this.budgetPersons = budgetPersons;
    }

    public BudgetPerson getBudgetPerson(int index) {
        while (this.getBudgetPersons().size() <= index) {
            this.getBudgetPersons().add(new BudgetPerson());
        }
        return (BudgetPerson)this.getBudgetPersons().get(index);
    }

    public void addBudgetPerson(BudgetPerson budgetPerson) {
        this.getBudgetPersons().add(budgetPerson);
    }

    public void add(BudgetPeriod budgetPeriod) {
        this.getBudgetPeriods().add(budgetPeriod);
    }

    public BudgetCostShare removeBudgetCostShare(int index) {
        return (BudgetCostShare)this.getBudgetCostShares().remove(index);
    }

    public BudgetProjectIncome removeBudgetProjectIncome(int index) {
        return (BudgetProjectIncome)this.getBudgetProjectIncomes().remove(index);
    }

    public BudgetUnrecoveredFandA removeBudgetUnrecoveredFandA(int index) {
        return (BudgetUnrecoveredFandA)this.getBudgetUnrecoveredFandAs().remove(index);
    }

    public final List<InstituteLaRate> getInstituteLaRates() {
        return this.instituteLaRates;
    }

    public final void setInstituteLaRates(List<InstituteLaRate> instituteLaRates) {
        this.instituteLaRates = instituteLaRates;
    }

    public BudgetCostShare getBudgetCostShare(int index) {
        while (this.getBudgetCostShares().size() <= index) {
            this.getBudgetCostShares().add(new BudgetCostShare());
        }
        return (BudgetCostShare)this.getBudgetCostShares().get(index);
    }

    public List<BudgetCostShare> getBudgetCostShares() {
        return this.budgetCostShares;
    }

    public int getBudgetCostShareCount() {
        return this.getCollectionSize((Collection)this.budgetCostShares);
    }

    public BudgetUnrecoveredFandA getBudgetUnrecoveredFandA(int index) {
        while (this.getBudgetUnrecoveredFandAs().size() <= index) {
            this.getBudgetUnrecoveredFandAs().add(new BudgetUnrecoveredFandA());
        }
        return (BudgetUnrecoveredFandA)this.getBudgetUnrecoveredFandAs().get(index);
    }

    public List<BudgetUnrecoveredFandA> getBudgetUnrecoveredFandAs() {
        return this.budgetUnrecoveredFandAs;
    }

    public int getBudgetUnrecoveredFandACount() {
        return this.getCollectionSize((Collection)this.budgetUnrecoveredFandAs);
    }

    public void getBudgetTotals() {
        ((BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class)).calculateBudgetSummaryTotals(this);
    }

    public SortedMap<CostElement, List<BudgetDecimal>> getObjectCodeTotals() {
        return this.objectCodeTotals;
    }

    public void setObjectCodeTotals(SortedMap<CostElement, List<BudgetDecimal>> objectCodeTotals) {
        this.objectCodeTotals = objectCodeTotals;
    }

    public SortedMap<RateType, List<BudgetDecimal>> getCalculatedExpenseTotals() {
        return this.calculatedExpenseTotals;
    }

    public void setCalculatedExpenseTotals(SortedMap<RateType, List<BudgetDecimal>> calculatedExpenseTotals) {
        this.calculatedExpenseTotals = calculatedExpenseTotals;
    }

    public BudgetDecimal getAvailableCostSharing() {
        BudgetDecimal availableCostShare = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (budgetPeriod.getCostSharingAmount() == null) continue;
            availableCostShare = (BudgetDecimal)availableCostShare.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
        }
        return availableCostShare;
    }

    public BudgetDecimal getAvailableUnrecoveredFandA() {
        BudgetDecimal availableUnrecoveredFandA = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            if (budgetPeriod.getUnderrecoveryAmount() == null) continue;
            availableUnrecoveredFandA = (BudgetDecimal)availableUnrecoveredFandA.add((AbstractKualiDecimal)budgetPeriod.getUnderrecoveryAmount());
        }
        return availableUnrecoveredFandA;
    }

    public BudgetDecimal findCostSharingForFiscalYear(Integer fiscalYear) {
        BudgetDecimal costSharing = BudgetDecimal.ZERO;
        List costShareFiscalYears = this.findCostShareTotalsForBudgetPeriods(this.mapBudgetPeriodsToFiscalYears());
        for (FiscalYearSummary costShareFiscalYear : costShareFiscalYears) {
            if (FiscalYearSummary.access$000((FiscalYearSummary)costShareFiscalYear) != fiscalYear) continue;
            costSharing = FiscalYearSummary.access$100((FiscalYearSummary)costShareFiscalYear);
            break;
        }
        return costSharing;
    }

    public BudgetDecimal findUnrecoveredFandAForFiscalYear(Integer fiscalYear) {
        BudgetDecimal unrecoveredFandA = BudgetDecimal.ZERO;
        List fiscalYearSummaries = this.findCostShareTotalsForBudgetPeriods(this.mapBudgetPeriodsToFiscalYears());
        for (FiscalYearSummary fiscalYearSummary : fiscalYearSummaries) {
            if (fiscalYearSummary.getFiscalYear() != fiscalYear.intValue()) continue;
            unrecoveredFandA = fiscalYearSummary.getUnrecoveredFandA();
            break;
        }
        return unrecoveredFandA;
    }

    public Date loadFiscalYearStart() {
        return this.createDateFromString(this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetCurrentFiscalYear"));
    }

    public boolean getSalaryInflationEnabled() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, "enableSalaryInflationAnniversaryDate").equals("1");
    }

    protected Boolean loadCostSharingApplicability() {
        return this.getBooleanValue("budgetCostSharingApplicabilityFlag");
    }

    protected Boolean loadUnrecoveredFandAApplicability() {
        return this.getBooleanValue("budgetUnrecoveredFandAApplicabilityFlag");
    }

    protected Boolean loadCostSharingEnforcement() {
        return this.getBooleanValue("budgetCostSharingEnforcementFlag");
    }

    protected Boolean loadUnrecoveredFandAEnforcement() {
        return this.getBooleanValue("budgetUnrecoveredFandAEnforcementFlag");
    }

    public Date createDateFromString(String budgetFiscalYearStart) {
        if (budgetFiscalYearStart == null) {
            return null;
        }
        String[] dateParts = budgetFiscalYearStart.split("/");
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.valueOf(dateParts[2]), Integer.valueOf(dateParts[0]) - 1, Integer.valueOf(dateParts[1]), 0, 0, 0);
        return new Date(calendar.getTimeInMillis());
    }

    private void addBudgetDistributionAndIncomeComponent(List distributionAndIncomeComponents, BudgetDistributionAndIncomeComponent distributionAndIncomeComponent) {
        if (distributionAndIncomeComponent != null) {
            distributionAndIncomeComponent.setBudgetId(this.getBudgetId());
            distributionAndIncomeComponent.setDocumentComponentId(this.getHackedDocumentNextValue(distributionAndIncomeComponent.getDocumentComponentIdKey()));
            distributionAndIncomeComponents.add(distributionAndIncomeComponent);
        } else {
            LOG.warn((Object)"Attempt to add null distributionAndIncomeComponent was ignored.");
        }
    }

    public Integer getHackedDocumentNextValue(String documentComponentIdKey) {
        return this.budgetDocument.getHackedDocumentNextValue(documentComponentIdKey);
    }

    private FiscalYearApplicableRate findApplicableRatesForFiscalYear(Integer fiscalYear) {
        String unrecoveredFandARateClassCode = this.getUrRateClassCode();
        if (unrecoveredFandARateClassCode == null || unrecoveredFandARateClassCode.trim().length() == 0) {
            return new FiscalYearApplicableRate(fiscalYear, RateDecimal.ZERO_RATE, RateDecimal.ZERO_RATE);
        }
        RateDecimal offCampusRate = this.findApplicableRateForRateClassCode(fiscalYear, unrecoveredFandARateClassCode, false);
        RateDecimal onCampusRate = this.findApplicableRateForRateClassCode(fiscalYear, unrecoveredFandARateClassCode, true);
        return new FiscalYearApplicableRate(fiscalYear, onCampusRate, offCampusRate);
    }

    private RateDecimal findApplicableRateForRateClassCode(Integer fiscalYear, String unrecoveredFandARateClassCode, boolean findOnCampusRate) {
        RateDecimal applicableRate = RateDecimal.ZERO_RATE;
        for (BudgetRate budgetRate : this.getBudgetRates()) {
            if (!Integer.valueOf(budgetRate.getFiscalYear()).equals(fiscalYear) || !budgetRate.getRateClassCode().equalsIgnoreCase(unrecoveredFandARateClassCode) || findOnCampusRate != budgetRate.getOnOffCampusFlag()) continue;
            applicableRate = new RateDecimal(budgetRate.getApplicableRate().bigDecimalValue());
            break;
        }
        return applicableRate;
    }

    private List<FiscalYearSummary> findCostShareTotalsForBudgetPeriods(Map<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears) {
        ArrayList<FiscalYearSummary> fiscalYearSummaries = new ArrayList<FiscalYearSummary>();
        for (Map.Entry<Integer, List<BudgetPeriod>> entry : budgetPeriodFiscalYears.entrySet()) {
            BudgetDecimal fiscalYearCostShareAmount = BudgetDecimal.ZERO;
            BudgetDecimal fiscalYearUnrecoveredFandA = BudgetDecimal.ZERO;
            List<BudgetPeriod> budgetPeriodsInFiscalYear = entry.getValue();
            for (BudgetPeriod budgetPeriod : budgetPeriodsInFiscalYear) {
                fiscalYearCostShareAmount = (BudgetDecimal)fiscalYearCostShareAmount.add((AbstractKualiDecimal)budgetPeriod.getCostSharingAmount());
                fiscalYearUnrecoveredFandA = (BudgetDecimal)fiscalYearUnrecoveredFandA.add((AbstractKualiDecimal)budgetPeriod.getUnderrecoveryAmount());
            }
            fiscalYearSummaries.add(new FiscalYearSummary(budgetPeriodsInFiscalYear.get(0), entry.getKey().intValue(), fiscalYearCostShareAmount, fiscalYearUnrecoveredFandA, this.findApplicableRatesForFiscalYear(entry.getKey())));
        }
        return fiscalYearSummaries;
    }

    private List<KualiDecimal> findProjectIncomeTotalsForBudgetPeriods(Map<Integer, KualiDecimal> incomes) {
        ArrayList<KualiDecimal> periodIncomeTotals = new ArrayList<KualiDecimal>(this.budgetPeriods.size());
        for (BudgetPeriod budgetPeriod : this.budgetPeriods) {
            KualiDecimal periodIncomeTotal = incomes.get(budgetPeriod.getBudgetPeriod());
            if (periodIncomeTotal == null) {
                periodIncomeTotal = KualiDecimal.ZERO;
            }
            periodIncomeTotals.add(periodIncomeTotal);
        }
        return periodIncomeTotals;
    }

    private int getCollectionSize(Collection collection) {
        return collection != null ? collection.size() : 0;
    }

    private Date getFiscalYearStart() {
        return this.loadFiscalYearStart();
    }

    protected Boolean getBooleanValue(String parmName) {
        String parmValue = this.getParameterService().parameterExists(BudgetDocument.class, parmName) == false ? "N" : this.getParameterService().getParameterValueAsString(BudgetDocument.class, parmName);
        return parmValue.equalsIgnoreCase("Y");
    }

    private Map<Integer, KualiDecimal> mapProjectIncomeTotalsToBudgetPeriodNumbers() {
        TreeMap<Integer, KualiDecimal> budgetPeriodProjectIncomeMap = new TreeMap<Integer, KualiDecimal>();
        for (BudgetProjectIncome budgetProjectIncome : this.budgetProjectIncomes) {
            Integer budgetPeriodNumber = budgetProjectIncome.getBudgetPeriodNumber();
            KualiDecimal amount = (KualiDecimal)budgetPeriodProjectIncomeMap.get(budgetPeriodNumber);
            amount = amount == null ? budgetProjectIncome.getProjectIncome() : (KualiDecimal)amount.add((AbstractKualiDecimal)budgetProjectIncome.getProjectIncome());
            budgetPeriodProjectIncomeMap.put(budgetPeriodNumber, amount);
        }
        return budgetPeriodProjectIncomeMap;
    }

    private Map<Integer, List<BudgetPeriod>> mapBudgetPeriodsToFiscalYears() {
        TreeMap<Integer, List<BudgetPeriod>> budgetPeriodFiscalYears = new TreeMap<Integer, List<BudgetPeriod>>();
        for (BudgetPeriod budgetPeriod : this.getBudgetPeriods()) {
            Integer fiscalYear = budgetPeriod.calculateFiscalYear(this.getFiscalYearStart());
            ArrayList<BudgetPeriod> budgetPeriodsInFiscalYear = (ArrayList<BudgetPeriod>)budgetPeriodFiscalYears.get(fiscalYear);
            if (budgetPeriodsInFiscalYear == null) {
                budgetPeriodsInFiscalYear = new ArrayList<BudgetPeriod>();
                budgetPeriodFiscalYears.put(fiscalYear, budgetPeriodsInFiscalYear);
            }
            budgetPeriodsInFiscalYear.add(budgetPeriod);
            Collections.sort(budgetPeriodsInFiscalYear, BudgetPeriod.getBudgetPeriodDateComparator());
        }
        return budgetPeriodFiscalYears;
    }

    public List<KeyValue> getBudgetCategoryTypeCodes() {
        return this.budgetCategoryTypeCodes;
    }

    public void setBudgetCategoryTypeCodes(List<KeyValue> budgetCategoryTypeCodes) {
        this.budgetCategoryTypeCodes = budgetCategoryTypeCodes;
    }

    public List<BudgetPersonnelDetails> getBudgetPersonnelDetailsList() {
        return this.budgetPersonnelDetailsList;
    }

    public void setBudgetPersonnelDetailsList(List<BudgetPersonnelDetails> budgetPersonnelDetailsList) {
        this.budgetPersonnelDetailsList = budgetPersonnelDetailsList;
    }

    public String getBudgetJustification() {
        return this.budgetJustification;
    }

    public void setBudgetJustification(String budgetJustification) {
        this.budgetJustification = budgetJustification;
    }

    public String getOnOffCampusFlagDescription() {
        return this.getBudgetSummaryService().getOnOffCampusFlagDescription(this.getOnOffCampusFlag());
    }

    public boolean isBudgetLineItemDeleted() {
        return this.budgetLineItemDeleted;
    }

    public void setBudgetLineItemDeleted(boolean budgetLineItemDeleted) {
        this.budgetLineItemDeleted = budgetLineItemDeleted;
    }

    public List<BudgetPrintForm> getBudgetPrintForms() {
        return this.budgetPrintForms;
    }

    public void setBudgetPrintForms(List<BudgetPrintForm> budgetPrintForms) {
        this.budgetPrintForms = budgetPrintForms;
    }

    public boolean isRateClassTypesReloaded() {
        return this.rateClassTypesReloaded;
    }

    public void setRateClassTypesReloaded(boolean rateClassTypesReloaded) {
        this.rateClassTypesReloaded = rateClassTypesReloaded;
    }

    public List<BudgetSubAwards> getBudgetSubAwards() {
        return this.budgetSubAwards;
    }

    public void setBudgetSubAwards(List<BudgetSubAwards> budgetSubAwards) {
        this.budgetSubAwards = budgetSubAwards;
    }

    public boolean isRateSynced() {
        return this.rateSynced;
    }

    public void setRateSynced(boolean rateSynced) {
        this.rateSynced = rateSynced;
    }

    public SortedMap<BudgetCategoryType, List<CostElement>> getObjectCodeListByBudgetCategoryType() {
        return this.objectCodeListByBudgetCategoryType;
    }

    public void setObjectCodeListByBudgetCategoryType(SortedMap<BudgetCategoryType, List<CostElement>> objectCodeListByBudgetCategoryType) {
        this.objectCodeListByBudgetCategoryType = objectCodeListByBudgetCategoryType;
    }

    public SortedMap<CostElement, List<BudgetPersonnelDetails>> getObjectCodePersonnelList() {
        return this.objectCodePersonnelList;
    }

    public void setObjectCodePersonnelList(SortedMap<CostElement, List<BudgetPersonnelDetails>> objectCodePersonnelList) {
        this.objectCodePersonnelList = objectCodePersonnelList;
    }

    public SortedMap<String, List<BudgetDecimal>> getObjectCodePersonnelSalaryTotals() {
        return this.objectCodePersonnelSalaryTotals;
    }

    public void setObjectCodePersonnelSalaryTotals(SortedMap<String, List<BudgetDecimal>> objectCodePersonnelSalaryTotals) {
        this.objectCodePersonnelSalaryTotals = objectCodePersonnelSalaryTotals;
    }

    public SortedMap<String, List<BudgetDecimal>> getObjectCodePersonnelFringeTotals() {
        return this.objectCodePersonnelFringeTotals;
    }

    public void setObjectCodePersonnelFringeTotals(SortedMap<String, List<BudgetDecimal>> objectCodePersonnelFringeTotals) {
        this.objectCodePersonnelFringeTotals = objectCodePersonnelFringeTotals;
    }

    public SortedMap<RateType, List<BudgetDecimal>> getPersonnelCalculatedExpenseTotals() {
        return this.personnelCalculatedExpenseTotals;
    }

    public void setPersonnelCalculatedExpenseTotals(SortedMap<RateType, List<BudgetDecimal>> personnelCalculatedExpenseTotals) {
        this.personnelCalculatedExpenseTotals = personnelCalculatedExpenseTotals;
    }

    public SortedMap<RateType, List<BudgetDecimal>> getNonPersonnelCalculatedExpenseTotals() {
        return this.nonPersonnelCalculatedExpenseTotals;
    }

    public void setNonPersonnelCalculatedExpenseTotals(SortedMap<RateType, List<BudgetDecimal>> nonPersonnelCalculatedExpenseTotals) {
        this.nonPersonnelCalculatedExpenseTotals = nonPersonnelCalculatedExpenseTotals;
    }

    public SortedMap<String, List<BudgetDecimal>> getBudgetSummaryTotals() {
        return this.budgetSummaryTotals;
    }

    public void setBudgetSummaryTotals(SortedMap<String, List<BudgetDecimal>> budgetSummaryTotals) {
        this.budgetSummaryTotals = budgetSummaryTotals;
    }

    public final BudgetDecimal getSumUnderreoveryAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getUnderrecoveryAmount());
        }
        return amount;
    }

    public final BudgetDecimal getSumCostSharingAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getCostSharingAmount());
        }
        return amount;
    }

    public BudgetDecimal getSumDirectCostAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getTotalDirectCost());
        }
        return amount;
    }

    public final BudgetDecimal getSumIndirectCostAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getTotalIndirectCost());
        }
        return amount;
    }

    public final BudgetDecimal getSumTotalCostAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getTotalCost());
        }
        return amount;
    }

    public BudgetDocument getBudgetDocument() {
        return this.budgetDocument;
    }

    public void setBudgetDocument(BudgetDocument budgetDocument) {
        this.setDocumentNumber(budgetDocument.getDocumentNumber());
        this.budgetDocument = budgetDocument;
    }

    public boolean getOhRatesNonEditable() {
        return false;
    }

    public boolean getEbRatesNonEditable() {
        return false;
    }

    public BudgetPeriod getNewBudgetPeriod() {
        return new BudgetPeriod();
    }

    public BudgetLineItem getNewBudgetLineItem() {
        return new BudgetLineItem();
    }

    public BudgetParent getBudgetParent() {
        return this.getBudgetDocument().getParentDocument().getBudgetParent();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.activityTypeCode == null ? 0 : this.activityTypeCode.hashCode());
        result = 31 * result + (this.budgetCategoryTypeCodes == null ? 0 : this.budgetCategoryTypeCodes.hashCode());
        result = 31 * result + (this.budgetCostShares == null ? 0 : this.budgetCostShares.hashCode());
        result = 31 * result + (this.budgetDocument == null ? 0 : this.budgetDocument.hashCode());
        result = 31 * result + (this.budgetJustification == null ? 0 : this.budgetJustification.hashCode());
        result = 31 * result + (this.budgetLaRates == null ? 0 : this.budgetLaRates.hashCode());
        result = 31 * result + (this.budgetLineItemDeleted ? 1231 : 1237);
        result = 31 * result + (this.budgetPeriods == null ? 0 : this.budgetPeriods.hashCode());
        result = 31 * result + (this.budgetPersonnelDetailsList == null ? 0 : this.budgetPersonnelDetailsList.hashCode());
        result = 31 * result + (this.budgetPersons == null ? 0 : this.budgetPersons.hashCode());
        result = 31 * result + (this.budgetPrintForms == null ? 0 : this.budgetPrintForms.hashCode());
        result = 31 * result + (this.budgetProjectIncomes == null ? 0 : this.budgetProjectIncomes.hashCode());
        result = 31 * result + (this.budgetRates == null ? 0 : this.budgetRates.hashCode());
        result = 31 * result + (this.budgetSubAwards == null ? 0 : this.budgetSubAwards.hashCode());
        result = 31 * result + (this.budgetSummaryTotals == null ? 0 : this.budgetSummaryTotals.hashCode());
        result = 31 * result + (this.budgetUnrecoveredFandAs == null ? 0 : this.budgetUnrecoveredFandAs.hashCode());
        result = 31 * result + (this.calculatedExpenseTotals == null ? 0 : this.calculatedExpenseTotals.hashCode());
        result = 31 * result + (this.instituteLaRates == null ? 0 : this.instituteLaRates.hashCode());
        result = 31 * result + (this.instituteRates == null ? 0 : this.instituteRates.hashCode());
        result = 31 * result + (this.nonPersonnelCalculatedExpenseTotals == null ? 0 : this.nonPersonnelCalculatedExpenseTotals.hashCode());
        result = 31 * result + (this.objectCodeListByBudgetCategoryType == null ? 0 : this.objectCodeListByBudgetCategoryType.hashCode());
        result = 31 * result + (this.objectCodePersonnelFringeTotals == null ? 0 : this.objectCodePersonnelFringeTotals.hashCode());
        result = 31 * result + (this.objectCodePersonnelList == null ? 0 : this.objectCodePersonnelList.hashCode());
        result = 31 * result + (this.objectCodePersonnelSalaryTotals == null ? 0 : this.objectCodePersonnelSalaryTotals.hashCode());
        result = 31 * result + (this.objectCodeTotals == null ? 0 : this.objectCodeTotals.hashCode());
        result = 31 * result + (this.personnelCalculatedExpenseTotals == null ? 0 : this.personnelCalculatedExpenseTotals.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : this.rateClass.hashCode());
        result = 31 * result + (this.rateClassTypes == null ? 0 : this.rateClassTypes.hashCode());
        result = 31 * result + (this.rateClassTypesReloaded ? 1231 : 1237);
        result = 31 * result + (this.rateClasses == null ? 0 : this.rateClasses.hashCode());
        result = 31 * result + (this.rateSynced ? 1231 : 1237);
        result = 31 * result + (this.summaryPeriodEndDate == null ? 0 : this.summaryPeriodEndDate.hashCode());
        result = 31 * result + (this.summaryPeriodStartDate == null ? 0 : this.summaryPeriodStartDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Budget other = (Budget)obj;
        if (this.activityTypeCode == null ? other.activityTypeCode != null : !this.activityTypeCode.equals(other.activityTypeCode)) {
            return false;
        }
        if (this.budgetCategoryTypeCodes == null ? other.budgetCategoryTypeCodes != null : !this.budgetCategoryTypeCodes.equals(other.budgetCategoryTypeCodes)) {
            return false;
        }
        if (this.budgetCostShares == null ? other.budgetCostShares != null : !this.budgetCostShares.equals(other.budgetCostShares)) {
            return false;
        }
        if (this.budgetDocument == null ? other.budgetDocument != null : !this.budgetDocument.equals(other.budgetDocument)) {
            return false;
        }
        if (this.budgetJustification == null ? other.budgetJustification != null : !this.budgetJustification.equals(other.budgetJustification)) {
            return false;
        }
        if (this.budgetLaRates == null ? other.budgetLaRates != null : !this.budgetLaRates.equals(other.budgetLaRates)) {
            return false;
        }
        if (this.budgetLineItemDeleted != other.budgetLineItemDeleted) {
            return false;
        }
        if (this.budgetPeriods == null ? other.budgetPeriods != null : !this.budgetPeriods.equals(other.budgetPeriods)) {
            return false;
        }
        if (this.budgetPersonnelDetailsList == null ? other.budgetPersonnelDetailsList != null : !this.budgetPersonnelDetailsList.equals(other.budgetPersonnelDetailsList)) {
            return false;
        }
        if (this.budgetPersons == null ? other.budgetPersons != null : !this.budgetPersons.equals(other.budgetPersons)) {
            return false;
        }
        if (this.budgetPrintForms == null ? other.budgetPrintForms != null : !this.budgetPrintForms.equals(other.budgetPrintForms)) {
            return false;
        }
        if (this.budgetProjectIncomes == null ? other.budgetProjectIncomes != null : !this.budgetProjectIncomes.equals(other.budgetProjectIncomes)) {
            return false;
        }
        if (this.budgetRates == null ? other.budgetRates != null : !this.budgetRates.equals(other.budgetRates)) {
            return false;
        }
        if (this.budgetSubAwards == null ? other.budgetSubAwards != null : !this.budgetSubAwards.equals(other.budgetSubAwards)) {
            return false;
        }
        if (this.budgetSummaryTotals == null ? other.budgetSummaryTotals != null : !this.budgetSummaryTotals.equals(other.budgetSummaryTotals)) {
            return false;
        }
        if (this.budgetUnrecoveredFandAs == null ? other.budgetUnrecoveredFandAs != null : !this.budgetUnrecoveredFandAs.equals(other.budgetUnrecoveredFandAs)) {
            return false;
        }
        if (this.calculatedExpenseTotals == null ? other.calculatedExpenseTotals != null : !this.calculatedExpenseTotals.equals(other.calculatedExpenseTotals)) {
            return false;
        }
        if (this.instituteLaRates == null ? other.instituteLaRates != null : !this.instituteLaRates.equals(other.instituteLaRates)) {
            return false;
        }
        if (this.instituteRates == null ? other.instituteRates != null : !this.instituteRates.equals(other.instituteRates)) {
            return false;
        }
        if (this.nonPersonnelCalculatedExpenseTotals == null ? other.nonPersonnelCalculatedExpenseTotals != null : !this.nonPersonnelCalculatedExpenseTotals.equals(other.nonPersonnelCalculatedExpenseTotals)) {
            return false;
        }
        if (this.objectCodeListByBudgetCategoryType == null ? other.objectCodeListByBudgetCategoryType != null : !this.objectCodeListByBudgetCategoryType.equals(other.objectCodeListByBudgetCategoryType)) {
            return false;
        }
        if (this.objectCodePersonnelFringeTotals == null ? other.objectCodePersonnelFringeTotals != null : !this.objectCodePersonnelFringeTotals.equals(other.objectCodePersonnelFringeTotals)) {
            return false;
        }
        if (this.objectCodePersonnelList == null ? other.objectCodePersonnelList != null : !this.objectCodePersonnelList.equals(other.objectCodePersonnelList)) {
            return false;
        }
        if (this.objectCodePersonnelSalaryTotals == null ? other.objectCodePersonnelSalaryTotals != null : !this.objectCodePersonnelSalaryTotals.equals(other.objectCodePersonnelSalaryTotals)) {
            return false;
        }
        if (this.objectCodeTotals == null ? other.objectCodeTotals != null : !this.objectCodeTotals.equals(other.objectCodeTotals)) {
            return false;
        }
        if (this.personnelCalculatedExpenseTotals == null ? other.personnelCalculatedExpenseTotals != null : !this.personnelCalculatedExpenseTotals.equals(other.personnelCalculatedExpenseTotals)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !this.rateClass.equals(other.rateClass)) {
            return false;
        }
        if (this.rateClassTypes == null ? other.rateClassTypes != null : !this.rateClassTypes.equals(other.rateClassTypes)) {
            return false;
        }
        if (this.rateClassTypesReloaded != other.rateClassTypesReloaded) {
            return false;
        }
        if (this.rateClasses == null ? other.rateClasses != null : !this.rateClasses.equals(other.rateClasses)) {
            return false;
        }
        if (this.rateSynced != other.rateSynced) {
            return false;
        }
        if (this.summaryPeriodEndDate == null ? other.summaryPeriodEndDate != null : !this.summaryPeriodEndDate.equals(other.summaryPeriodEndDate)) {
            return false;
        }
        return !(this.summaryPeriodStartDate == null ? other.summaryPeriodStartDate != null : !this.summaryPeriodStartDate.equals(other.summaryPeriodStartDate));
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new BudgetPersonnelDetails();
    }

    public boolean isCostSharingSubmissionEnabled() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, "ENABLE_COST_SHARE_SUBMIT").equals("1");
    }

    public String getSummaryNumberOfMonths() {
        return String.valueOf(this.getProposalBudgetNumberOfMonthsService().getNumberOfMonth(this.getSummaryPeriodStartDate(), this.getSummaryPeriodEndDate()));
    }

    protected ProposalBudgetNumberOfMonthsService getProposalBudgetNumberOfMonthsService() {
        return (ProposalBudgetNumberOfMonthsService)KraServiceLocator.getService(ProposalBudgetNumberOfMonthsService.class);
    }
}

