/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.core;

import java.util.Collection;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.ValidCeJobCode;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.rice.kew.api.exception.WorkflowException;

public interface BudgetService<T extends BudgetParent> {
    public BudgetDocument<T> addBudgetVersion(BudgetParentDocument<T> var1, String var2) throws WorkflowException;

    public void updateDocumentDescription(BudgetVersionOverview var1);

    public boolean checkActivityTypeChange(BudgetParentDocument<T> var1, Budget var2);

    public boolean checkActivityTypeChange(Collection<BudgetRate> var1, String var2);

    public Collection<BudgetRate> getSavedBudgetRates(Budget var1);

    public boolean ValidInflationCeRate(BudgetLineItemBase var1);

    public String getActivityTypeForBudget(BudgetDocument<T> var1);

    public List<ValidCeJobCode> getApplicableCostElements(Long var1, String var2);

    public String getApplicableCostElementsForAjaxCall(Long var1, String var2, String var3);

    public List<String> getExistingGroupNames(String var1, String var2);

    public String getExistingGroupNamesForAjaxCall(String var1, String var2);

    public String getBudgetExpensePanelName(BudgetPeriod var1, BudgetLineItem var2);

    public String getParticipantSupportCategoryCode();

    public List<BudgetLineItem> getMatchingLineItems(List<BudgetLineItem> var1, List<String> var2);

    public Collection<BudgetRate> getSavedProposalRates(BudgetVersionOverview var1);

    public boolean validateBudgetAuditRuleBeforeSaveBudgetVersion(BudgetParentDocument<T> var1) throws Exception;

    public boolean isBudgetVersionNameValid(BudgetParentDocument<T> var1, String var2);

    public boolean validateBudgetAuditRule(BudgetParentDocument<T> var1) throws Exception;

    public BudgetDocument<T> copyBudgetVersion(BudgetDocument<T> var1, boolean var2) throws WorkflowException;

    public String populateBudgetPersonSalaryDetailsInPeriods(String var1, String var2, String var3);

    public BudgetDecimal getBaseSalaryByPeriod(Long var1, int var2, KeyPersonInfo var3);

    public void populateNewBudgetLineItem(BudgetLineItem var1, BudgetPeriod var2);
}

