/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeComponent;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyMaintainable;

public class BudgetCostShare
extends BudgetDistributionAndIncomeComponent
implements HierarchyMaintainable {
    private static final long serialVersionUID = 6199797319981907016L;
    public static final String DOCUMENT_COMPONENT_ID_KEY = "BUDGET_COST_SHARE_KEY";
    private Integer projectPeriod;
    private BudgetDecimal shareAmount;
    private BudgetDecimal sharePercentage;
    private String sourceAccount;
    private String sourceUnit;
    private String hierarchyProposalNumber;
    private boolean hiddenInHierarchy;

    public BudgetCostShare() {
    }

    public BudgetCostShare(Integer projectPeriod, BudgetDecimal shareAmount, BudgetDecimal sharePercentage, String sourceAccount) {
        this();
        this.projectPeriod = projectPeriod;
        this.sharePercentage = sharePercentage;
        this.shareAmount = shareAmount;
        this.sourceAccount = sourceAccount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetCostShare)) {
            return false;
        }
        BudgetCostShare other = (BudgetCostShare)obj;
        if (this.projectPeriod == null ? other.projectPeriod != null : !this.projectPeriod.equals(other.projectPeriod)) {
            return false;
        }
        if (this.shareAmount == null ? other.shareAmount != null : !this.shareAmount.equals((Object)other.shareAmount)) {
            return false;
        }
        return !(this.sourceAccount == null ? other.sourceAccount != null : !this.sourceAccount.equals(other.sourceAccount));
    }

    public String getDocumentComponentIdKey() {
        return DOCUMENT_COMPONENT_ID_KEY;
    }

    public Integer getProjectPeriod() {
        return this.projectPeriod;
    }

    public BudgetDecimal getShareAmount() {
        return BudgetDecimal.returnZeroIfNull((BudgetDecimal)this.shareAmount);
    }

    public BudgetDecimal getSharePercentage() {
        return BudgetDecimal.returnZeroIfNull((BudgetDecimal)this.sharePercentage);
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectPeriod == null ? 0 : this.projectPeriod.hashCode());
        result = 31 * result + (this.shareAmount == null ? 0 : this.shareAmount.hashCode());
        result = 31 * result + (this.sourceAccount == null ? 0 : this.sourceAccount.hashCode());
        return result;
    }

    public void setProjectPeriod(Integer projectPeriod) {
        this.projectPeriod = projectPeriod;
    }

    public void setShareAmount(BudgetDecimal shareAmount) {
        this.shareAmount = shareAmount;
    }

    public void setSharePercentage(BudgetDecimal sharePercentage) {
        this.sharePercentage = sharePercentage;
    }

    public void setSourceAccount(String sourceAcocunt) {
        this.sourceAccount = sourceAcocunt;
    }

    public String getSourceUnit() {
        return this.sourceUnit;
    }

    public void setSourceUnit(String sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }
}

