/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class BudgetUnrecoveredFandAAuditRule
implements DocumentAuditRule {
    public static final String BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY = "budgetUnrecoveredFandAAuditErrors";
    public static final String BUDGET_UNRECOVERED_F_AND_A_WARNING_KEY = "budgetUnrecoveredFandAAuditWarnings";
    String[] params = new String[]{"Unrecovered F and A"};
    private static final int YEAR_CONSTANT = 1900;

    public boolean processRunAuditBusinessRules(Document document) {
        Budget budget = ((BudgetDocument)document).getBudget();
        if (KNSGlobalVariables.getAuditErrorMap().containsKey(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY)) {
            List auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY)).getAuditErrorList();
            auditErrors.clear();
        }
        if (!budget.isUnrecoveredFandAApplicable().booleanValue()) {
            return true;
        }
        List unrecoveredFandAs = budget.getBudgetUnrecoveredFandAs();
        boolean retval = true;
        if (budget.getUnallocatedUnrecoveredFandA().isGreaterThan((AbstractKualiDecimal)BudgetDecimal.ZERO) && budget.isUnrecoveredFandAEnforced().booleanValue()) {
            retval = false;
            if (unrecoveredFandAs.size() == 0) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
            }
            for (int i = 0; i < unrecoveredFandAs.size(); ++i) {
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].amount", "error.budget.distribution.unallocatedMustBeZero", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
            }
        }
        String source = null;
        Integer fiscalYear = null;
        int i = 0;
        int j = 0;
        BudgetParent budgetParent = ((BudgetDocument)document).getParentDocument().getBudgetParent();
        Date projectStartDate = budgetParent.getRequestedStartDateInitial();
        Date projectEndDate = budgetParent.getRequestedEndDateInitial();
        boolean duplicateEntryFound = false;
        for (BudgetUnrecoveredFandA unrecoveredFandA : unrecoveredFandAs) {
            source = unrecoveredFandA.getSourceAccount();
            fiscalYear = unrecoveredFandA.getFiscalYear();
            if (null == source || source.length() == 0) {
                retval = false;
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].sourceAccount", "error.budget.distribution.sourceMissing", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
            }
            if (null == fiscalYear || fiscalYear <= 0) {
                retval = false;
                this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].fiscalYear", "error.budget.distribution.fiscalYearMissing", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
            }
            if (fiscalYear != null && (fiscalYear < projectStartDate.getYear() + 1900 || fiscalYear > projectEndDate.getYear() + 1900)) {
                this.getAuditWarnings().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "].fiscalYear", "warning.budget.distribution.fiscalYearInconsistent", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
            }
            if (!duplicateEntryFound) {
                j = 0;
                for (BudgetUnrecoveredFandA unrecoveredFandAForComparison : unrecoveredFandAs) {
                    if (i != j && unrecoveredFandA.getFiscalYear() != null && unrecoveredFandAForComparison.getFiscalYear() != null && unrecoveredFandA.getFiscalYear().intValue() == unrecoveredFandAForComparison.getFiscalYear().intValue() && unrecoveredFandA.getApplicableRate().equals((Object)unrecoveredFandAForComparison.getApplicableRate()) && unrecoveredFandA.getOnCampusFlag().equalsIgnoreCase(unrecoveredFandAForComparison.getOnCampusFlag()) && StringUtils.equalsIgnoreCase((String)unrecoveredFandA.getSourceAccount(), (String)unrecoveredFandAForComparison.getSourceAccount()) && unrecoveredFandA.getAmount().equals((Object)unrecoveredFandAForComparison.getAmount())) {
                        retval = false;
                        this.getAuditErrors().add(new AuditError("document.budget.budgetUnrecoveredFandA[" + i + "]", "error.budget.distribution.duplicate.unrecoveredFA", "budgetDistributionAndIncome.budgetUnrecoveredFandA", this.params));
                        duplicateEntryFound = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return retval;
    }

    private List<AuditError> getAuditErrors() {
        return this.getAuditProblems(BUDGET_UNRECOVERED_F_AND_A_ERROR_KEY, "Validation Errors");
    }

    private List<AuditError> getAuditWarnings() {
        return this.getAuditProblems(BUDGET_UNRECOVERED_F_AND_A_WARNING_KEY, "Warnings");
    }

    private List<AuditError> getAuditProblems(String key, String problemType) {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(key)) {
            KNSGlobalVariables.getAuditErrorMap().put(key, new AuditCluster("Budget Unrecovered F and A", auditErrors, problemType));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key)).getAuditErrorList();
        }
        return auditErrors;
    }
}

