/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.distributionincome;

import java.util.Iterator;
import java.util.List;
import org.kuali.kra.budget.distributionincome.AddBudgetUnrecoveredFandAEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetUnrecoveredFandARule;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandAAllocationEvent;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandAAllocationRule;
import org.kuali.kra.budget.distributionincome.BudgetValidationUnrecoveredFandAEvent;
import org.kuali.kra.budget.distributionincome.BudgetValidationUnrecoveredFandARule;
import org.kuali.kra.budget.distributionincome.ValidationHelper;
import org.kuali.kra.budget.document.BudgetDocumentContainer;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetUnrecoveredFandARuleImpl
implements AddBudgetUnrecoveredFandARule,
BudgetValidationUnrecoveredFandARule,
BudgetUnrecoveredFandAAllocationRule {
    private static final String ADD_ERROR_KEY = "error.custom";
    private ValidationHelper validationHelper = new ValidationHelper();

    public boolean processAddBudgetUnrecoveredFandABusinessRules(AddBudgetUnrecoveredFandAEvent budgetUnrecoveredFandAEvent) {
        return !this.areDuplicatesPresent(budgetUnrecoveredFandAEvent.getBudgetUnrecoveredFandA());
    }

    public boolean processBudgetValidationUnrecoveredFandABusinessRules(BudgetValidationUnrecoveredFandAEvent budgetUnrecoveredFandAEvent) {
        return this.areRequiredRulesSatisfied(budgetUnrecoveredFandAEvent.getBudgetUnrecoveredFandA());
    }

    private boolean areDuplicatesPresent(BudgetUnrecoveredFandA testBudgetUnrecoveredFandA) {
        boolean duplicate;
        block2: {
            BudgetUnrecoveredFandA budgetUnrecoveredFandA;
            duplicate = false;
            if (testBudgetUnrecoveredFandA == null) {
                return duplicate;
            }
            KualiForm form = KNSGlobalVariables.getKualiForm();
            if (!(form instanceof BudgetDocumentContainer)) break block2;
            BudgetDocumentContainer budgetContainerForm = (BudgetDocumentContainer)form;
            List budgetUnrecoveredFandAs = budgetContainerForm.getBudgetDocument().getBudget().getBudgetUnrecoveredFandAs();
            Iterator i$ = budgetUnrecoveredFandAs.iterator();
            while (i$.hasNext() && !(duplicate = this.checkForDuplicateFields(testBudgetUnrecoveredFandA, budgetUnrecoveredFandA = (BudgetUnrecoveredFandA)i$.next()))) {
            }
        }
        return duplicate;
    }

    private boolean areRequiredRulesSatisfied(BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        boolean valid = this.validationHelper.checkRequiredField((Object)budgetUnrecoveredFandA.getFiscalYear(), "budgetUnrecoveredFandA.fiscalYear", new String[]{"Fiscal Year"});
        valid &= this.validationHelper.checkRequiredField((Object)budgetUnrecoveredFandA.getAmount(), "budgetUnrecoveredFandA.amount", new String[]{"Amount"});
        valid &= this.validationHelper.checkRequiredField((Object)budgetUnrecoveredFandA.getOnCampusFlag(), "budgetUnrecoveredFandA.campus", new String[]{"Campus"});
        valid &= this.validationHelper.checkRequiredField((Object)budgetUnrecoveredFandA.getApplicableRate(), "budgetUnrecoveredFandA.applicableRate", new String[]{"ApplicableRate"});
        return valid &= this.validationHelper.checkRequiredField((Object)budgetUnrecoveredFandA.getSourceAccount(), "budgetUnrecoveredFandA.sourceAccount", new String[]{"Source Account"});
    }

    private boolean checkForDuplicateFields(BudgetUnrecoveredFandA testBudgetUnrecoveredFandA, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        boolean duplicate = testBudgetUnrecoveredFandA.equals((Object)budgetUnrecoveredFandA);
        if (duplicate) {
            GlobalVariables.getMessageMap().putError("newUnrecoveredFandA.*", ADD_ERROR_KEY, new String[]{"A duplicate Unrecovered F&A exists in the table"});
        }
        return duplicate;
    }

    public boolean processBudgetUnrecoveredFandAAllocationBusinessRules(BudgetUnrecoveredFandAAllocationEvent budgetUnrecoveredFandAEvent) {
        boolean result = budgetUnrecoveredFandAEvent.getBudgetDocument().getBudget().getUnallocatedUnrecoveredFandA().isNonZero();
        if (result) {
            GlobalVariables.getMessageMap().putError("unrecoveredFandA*", ADD_ERROR_KEY, new String[]{"Unrecovered F&A allocation doesn't total available unrecovered F&A"});
        }
        return result;
    }
}

