/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.document.authorization.BudgetTask;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        BudgetDocument budgetDoc = (BudgetDocument)document;
        BudgetParentDocument parentDocument = budgetDoc.getParentDocument();
        String userId = user.getPrincipalId();
        if (this.canExecuteBudgetTask(userId, budgetDoc, "viewSalaries")) {
            editModes.add("viewSalaries");
            this.setPermissions(userId, parentDocument, editModes);
        }
        if (this.canExecuteBudgetTask(userId, budgetDoc, "modifyBudget")) {
            editModes.add("fullEntry");
            editModes.add("modifyBudgets");
            editModes.add("viewBudgets");
            if (this.canExecuteBudgetTask(userId, budgetDoc, "modifyProposalBudgetRates")) {
                editModes.add("modifyProposalBudgetRates");
            }
            this.setPermissions(userId, parentDocument, editModes);
        } else if (this.canExecuteBudgetTask(userId, budgetDoc, "viewBudget")) {
            editModes.add("viewOnly");
            editModes.add("viewBudgets");
            this.setPermissions(userId, parentDocument, editModes);
        } else {
            editModes.add("unviewable");
        }
        if (this.canExecuteBudgetTask(userId, budgetDoc, "maintainProposalHierarchy")) {
            editModes.add("maintainProposalHierarchy");
        }
        if (this.isBudgetComplete(parentDocument, budgetDoc)) {
            editModes.remove("modifyBudgets");
            editModes.remove("addBudget");
            if (editModes.contains("modifyBudgets")) {
                editModes.add("modifyCompletedBudgets");
            }
        }
        return editModes;
    }

    protected void setPermissions(String userId, BudgetParentDocument doc, Set<String> editModes) {
        if (this.canExecuteParentDocumentTask(userId, doc, "addBudget")) {
            editModes.add("addBudget");
        }
        if (this.canExecuteParentDocumentTask(userId, doc, "openBudgets")) {
            editModes.add("openBudgets");
        }
        if (this.canExecuteParentDocumentTask(userId, doc, "modifyBudget")) {
            editModes.add("modifyProposalBudget");
        }
        if (this.canExecuteParentDocumentTask(userId, doc, "printProposal")) {
            editModes.add("printProposal");
        }
    }

    private boolean canExecuteParentDocumentTask(String userId, BudgetParentDocument doc, String taskName) {
        Task task = doc.getParentAuthZTask(taskName);
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    private boolean canExecuteBudgetTask(String userId, BudgetDocument budgetDocument, String taskName) {
        this.reloadParentIfNoWorkflow(budgetDocument);
        String taskGroupName = this.getTaskGroupName();
        Task task = this.createNewBudgetTask(taskGroupName, taskName, budgetDocument);
        TaskAuthorizationService taskAuthenticationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        return taskAuthenticationService.isAuthorized(userId, task);
    }

    protected Task createNewBudgetTask(String taskGroupName, String taskName, BudgetDocument budgetDocument) {
        return new BudgetTask(taskGroupName, taskName, budgetDocument);
    }

    protected String getTaskGroupName() {
        return "proposalBudget";
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return true;
    }

    public boolean canOpen(Document document, Person user) {
        BudgetDocument budgetDocument = (BudgetDocument)document;
        return this.canExecuteBudgetTask(user.getPrincipalId(), budgetDocument, "viewBudget");
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteBudgetTask(user.getPrincipalId(), (BudgetDocument)document, "modifyBudget");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCancel(Document document, Person user) {
        return false;
    }

    public boolean canReload(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canRoute(Document document, Person user) {
        return true;
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    private boolean isBudgetComplete(BudgetParentDocument parentDocument, BudgetDocument budgetDocument) {
        if (!parentDocument.isComplete()) {
            return false;
        }
        for (BudgetDocumentVersion budgetVersion : parentDocument.getBudgetDocumentVersions()) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag() || !budgetVersion.getBudgetVersionOverview().getBudgetVersionNumber().equals(budgetDocument.getBudget().getBudgetVersionNumber())) continue;
            return true;
        }
        return false;
    }

    private void reloadParentIfNoWorkflow(BudgetDocument budgetDocument) {
        BudgetParentDocument parentDoc = budgetDocument.getParentDocument();
        WorkflowDocument workflowDocument = this.getWorkflowDocument((Document)parentDoc);
        if (workflowDocument == null) {
            try {
                parentDoc = (BudgetParentDocument)((DocumentService)KraServiceLocator.getService(DocumentService.class)).getByDocumentHeaderId(parentDoc.getDocumentNumber());
                if (parentDoc != null) {
                    budgetDocument.setParentDocument(parentDoc);
                }
            }
            catch (WorkflowException e) {
                // empty catch block
            }
        }
    }

    private WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

