/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.lookup.keyvalue.BudgetPeriodValuesFinder;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.MultipleValueLookupForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetExpensePeriodValuesFinder
extends BudgetPeriodValuesFinder {
    protected Log LOG = LogFactory.getLog(BudgetExpensePeriodValuesFinder.class);
    protected KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KraServiceLocator.getService((String)"keyValueFinderService");
    protected AwardBudgetService awardBudgetService = (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
    protected DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);

    public List<KeyValue> getKeyValues() {
        List KeyValues = null;
        KualiForm form = KNSGlobalVariables.getKualiForm();
        if (form instanceof KualiDocumentFormBase) {
            List budgetPeriods;
            Document doc = ((KualiDocumentFormBase)form).getDocument();
            if (doc instanceof BudgetDocument && (budgetPeriods = ((BudgetDocument)doc).getBudget().getBudgetPeriods()).size() > 0) {
                KeyValues = this.buildKeyValues(budgetPeriods);
            }
        } else if (form instanceof MultipleValueLookupForm) {
            try {
                BudgetDocument doc = (BudgetDocument)this.getDocumentService().getByDocumentHeaderId(((MultipleValueLookupForm)form).getDocNum());
                List budgetPeriods = this.getAwardBudgetService().findBudgetPeriodsFromLinkedProposal(((AwardDocument)doc.getParentDocument()).getAward().getAwardNumber());
                if (budgetPeriods.size() > 0) {
                    KeyValues = this.buildKeyValuesForPeriodSearch(budgetPeriods);
                }
            }
            catch (WorkflowException e) {
                this.LOG.error((Object)"Unable to load document for budget period values finder.", (Throwable)e);
            }
        }
        if (KeyValues != null) {
            return KeyValues;
        }
        return new ArrayList<KeyValue>();
    }

    private List<KeyValue> buildKeyValues(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() == null) continue;
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getLabel()));
        }
        return KeyValues;
    }

    private List<KeyValue> buildKeyValuesForPeriodSearch(List<BudgetPeriod> budgetPeriods) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        ArrayList<Integer> uniqueKeys = new ArrayList<Integer>();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetPeriod() == null || uniqueKeys.contains(budgetPeriod.getBudgetPeriod())) continue;
            uniqueKeys.add(budgetPeriod.getBudgetPeriod());
            KeyValues.add((KeyValue)new ConcreteKeyValue(budgetPeriod.getBudgetPeriod().toString(), budgetPeriod.getBudgetPeriod().toString()));
        }
        return KeyValues;
    }

    protected KeyValueFinderService getKeyValueFinderService() {
        return this.keyValueFinderService;
    }

    public void setKeyValueFinderService(KeyValueFinderService keyValueFinderService) {
        this.keyValueFinderService = keyValueFinderService;
    }

    protected AwardBudgetService getAwardBudgetService() {
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

