/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.lookup.keyvalue.CostElementValuesFinder;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class CostElementValuesFinder
extends KeyValuesBase {
    KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KraServiceLocator.getService((String)"keyValueFinderService");
    private String budgetCategoryTypeCode;

    public List<KeyValue> getKeyValues() {
        KeyValuesService keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        Collection costElements = keyValuesService.findAll(CostElement.class);
        Collection budgetCategoryCodes = keyValuesService.findAll(BudgetCategory.class);
        KualiForm form = KNSGlobalVariables.getKualiForm();
        BudgetForm budgetForm = (BudgetForm)form;
        for (CostElement costElement : costElements) {
            for (BudgetCategory budgetCategory : budgetCategoryCodes) {
                if (!costElement.getBudgetCategoryCode().equalsIgnoreCase(budgetCategory.getBudgetCategoryCode()) || !StringUtils.equalsIgnoreCase((String)budgetCategory.getBudgetCategoryTypeCode(), (String)this.getBudgetCategoryTypeCode()) || !costElement.isActive()) continue;
                keyValues.add((KeyValue)new ConcreteKeyValue(costElement.getCostElement().toString(), costElement.getDescription()));
            }
        }
        Collections.sort(keyValues, new KeyValueComparator(this));
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        return keyValues;
    }

    public String getBudgetCategoryTypeCode() {
        return this.budgetCategoryTypeCode;
    }

    public void setBudgetCategoryTypeCode(String budgetCategoryTypeCode) {
        this.budgetCategoryTypeCode = budgetCategoryTypeCode;
    }
}

