/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.keyvalue.KeyValueFinderService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KeyValuesService;

public class GroupNameValuesFinder
extends KeyValuesBase {
    KeyValueFinderService keyValueFinderService = (KeyValueFinderService)KraServiceLocator.getService((String)"keyValueFinderService");

    public List<KeyValue> getKeyValues() {
        KeyValuesService keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add((KeyValue)new ConcreteKeyValue("", "select"));
        HashSet<String> distinctGroupNames = new HashSet<String>();
        KualiForm form = KNSGlobalVariables.getKualiForm();
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        HashMap<String, Number> fieldValues = new HashMap<String, Number>();
        fieldValues.put("budgetId", budgetDocument.getBudget().getBudgetId());
        int budgetPeriodNumber = -1;
        budgetPeriodNumber = budgetForm.getViewBudgetPeriod() == null ? 1 : budgetForm.getViewBudgetPeriod();
        fieldValues.put("budgetPeriod", budgetPeriodNumber);
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        List budgetPeriods = (List)businessObjectService.findMatching(BudgetPeriod.class, fieldValues);
        BudgetPeriod budgetPeriod = null;
        if (CollectionUtils.isNotEmpty((Collection)budgetPeriods)) {
            budgetPeriod = (BudgetPeriod)budgetPeriods.get(0);
        }
        fieldValues.remove("budgetPeriod");
        fieldValues.put("budgetPeriodId", budgetPeriod.getBudgetPeriodId());
        List budgetLineItems = (List)keyValuesService.findMatching(BudgetLineItem.class, fieldValues);
        boolean distinct = false;
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (!StringUtils.isNotEmpty((String)budgetLineItem.getGroupName()) || !(distinct = distinctGroupNames.add(budgetLineItem.getGroupName()))) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(budgetLineItem.getGroupName(), budgetLineItem.getGroupName()));
        }
        for (BudgetLineItem newBudgetLineItem : budgetDocument.getBudget().getBudgetPeriod(budgetPeriodNumber - 1).getBudgetLineItems()) {
            if (!StringUtils.isNotEmpty((String)newBudgetLineItem.getGroupName()) || !(distinct = distinctGroupNames.add(newBudgetLineItem.getGroupName()))) continue;
            keyValues.add((KeyValue)new ConcreteKeyValue(newBudgetLineItem.getGroupName(), newBudgetLineItem.getGroupName()));
        }
        return keyValues;
    }
}

