/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class BudgetExpensesAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(BudgetExpensesAuditRule.class);

    public boolean processRunAuditBusinessRules(Document document) {
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        BudgetDocument budgetDocument = (BudgetDocument)document;
        boolean retval = true;
        boolean i = false;
        if (budgetDocument.getBudget().getTotalCostLimit().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(0)) && budgetDocument.getBudget().getTotalCost().isGreaterThan((AbstractKualiDecimal)budgetDocument.getBudget().getTotalCostLimit())) {
            ArrayList<AuditError> auditErrors;
            String key = "budgetParametersOverviewWarnings";
            AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
            if (auditCluster == null) {
                auditErrors = new ArrayList<AuditError>();
                auditCluster = new AuditCluster("Budget Overview", auditErrors, "Warnings");
                KNSGlobalVariables.getAuditErrorMap().put(key, auditCluster);
            }
            auditErrors = auditCluster.getAuditErrorList();
            auditErrors.add(new AuditError("document.budget.totalCostLimit", "warning.budgetCostLimit.exceeded", "summary.topOfForm"));
            retval = false;
        }
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            if (budgetPeriod.getTotalCostLimit().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(0)) && budgetPeriod.getTotalCost().isGreaterThan((AbstractKualiDecimal)budgetPeriod.getTotalCostLimit())) {
                ArrayList<AuditError> auditErrors;
                String key = "budgetPeriodProjectDateAuditWarnings";
                AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
                if (auditCluster == null) {
                    auditErrors = new ArrayList<AuditError>();
                    auditCluster = new AuditCluster("Budget Periods & Totals", auditErrors, "Warnings");
                    KNSGlobalVariables.getAuditErrorMap().put(key, auditCluster);
                }
                auditErrors = auditCluster.getAuditErrorList();
                auditErrors.add(new AuditError("document.budget.budgetPeriods[" + (budgetPeriod.getBudgetPeriod() - 1) + "].totalCostLimit", "warning.periodCostLimit.exceeded", "summary.BudgetPeriodsTotals"));
                retval = false;
            }
            int j = 0;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String panelName = budgetService.getBudgetExpensePanelName(budgetPeriod, budgetLineItem);
                if (budgetLineItem.getUnderrecoveryAmount() != null && budgetLineItem.getUnderrecoveryAmount().isNegative()) {
                    ArrayList<AuditError> auditErrors;
                    String key = "budgetNonPersonnelAuditWarnings" + budgetPeriod.getBudgetPeriod() + panelName;
                    AuditCluster auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
                    if (auditCluster == null) {
                        auditErrors = new ArrayList<AuditError>();
                        auditCluster = new AuditCluster(panelName + " Budget Period " + budgetPeriod.getBudgetPeriod(), auditErrors, "Warnings");
                        KNSGlobalVariables.getAuditErrorMap().put(key, auditCluster);
                    }
                    auditErrors = auditCluster.getAuditErrorList();
                    auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].underrecoveryAmount", "warning.unrecoveredFA.negative", "budgetExpenses." + budgetLineItem.getBudgetCategory().getBudgetCategoryType().getDescription() + "&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&activePanelName=" + panelName));
                    retval = false;
                }
                int k = 0;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    List<AuditError> auditErrors;
                    AuditCluster auditCluster;
                    String key;
                    if (StringUtils.isNotEmpty((String)budgetPersonnelDetails.getEffdtAfterStartdtMsg())) {
                        key = "budgetPersonnelBudgetAuditWarnings" + budgetPeriod.getBudgetPeriod();
                        auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
                        if (auditCluster == null) {
                            auditErrors = new ArrayList<AuditError>();
                            auditCluster = new AuditCluster("Personnel Budget (Period " + budgetPeriod.getBudgetPeriod() + ")", auditErrors, "Warnings");
                            KNSGlobalVariables.getAuditErrorMap().put(key, auditCluster);
                        }
                        auditErrors = auditCluster.getAuditErrorList();
                        auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].budgetPersonnelDetailsList[" + k + "].salaryRequested", "warning.effdt.after.periodStartDate", "budgetExpenses.BudgetOvervieV&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&personnelDetailLine=" + k, new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()}));
                        retval = false;
                    }
                    if (budgetPersonnelDetails.getBudgetPerson().getCalculationBase().equals((Object)BudgetDecimal.ZERO)) {
                        key = "budgetPersonnelBudgetAuditWarnings" + budgetPeriod.getBudgetPeriod();
                        auditCluster = (AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(key);
                        if (auditCluster == null) {
                            auditErrors = new ArrayList();
                            auditCluster = new AuditCluster("Personnel Budget (Period " + budgetPeriod.getBudgetPeriod() + ")", auditErrors, "Warnings");
                            KNSGlobalVariables.getAuditErrorMap().put(key, auditCluster);
                        }
                        auditErrors = auditCluster.getAuditErrorList();
                        auditErrors.add(new AuditError("document.budgetPeriod[" + (budgetPeriod.getBudgetPeriod() - 1) + "].budgetLineItem[" + j + "].budgetPersonnelDetailsList[" + k + "].salaryRequested", "warning..base.salary.zero", "budgetExpenses.BudgetOvervieV&viewBudgetPeriod=" + budgetPeriod.getBudgetPeriod() + "&selectedBudgetLineItemIndex=" + j + "&personnelDetailLine=" + k, new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()}));
                        retval = false;
                    }
                    ++k;
                }
                ++j;
            }
        }
        return retval;
    }
}

