/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.nonpersonnel;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.sql.Date;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class BudgetJustificationWrapper
implements Serializable {
    private String justificationText;
    private String lastUpdateTime;
    private String lastUpdateUser;
    private static final Log LOG = LogFactory.getLog(BudgetJustificationWrapper.class);

    public BudgetJustificationWrapper(String budgetJustificationAsXML) {
        this.parse(budgetJustificationAsXML);
    }

    public BudgetJustificationWrapper(Date lastUpdateTime, String lastUpdateUser, String justificationText) {
        this.justificationText = justificationText;
        this.lastUpdateUser = lastUpdateUser;
        this.setLastUpdateTime(lastUpdateTime);
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public String getJustificationText() {
        return this.justificationText;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss");
        this.lastUpdateTime = formatter.format(lastUpdateTime);
    }

    public void setJustificationText(String justificationText) {
        this.justificationText = justificationText;
    }

    public String toString() {
        Document document = new Document(new Element("budgetJustification").setAttribute("lastUpdateBy", this.lastUpdateUser).setAttribute("lastUpdateOn", this.lastUpdateTime).addContent((Content)new CDATA(this.justificationText)));
        return new XMLOutputter().outputString(document);
    }

    private void parse(String budgetJustificationAsXML) {
        if (budgetJustificationAsXML == null || budgetJustificationAsXML.trim().length() == 0) {
            return;
        }
        SAXBuilder parser = new SAXBuilder();
        try {
            Document document = parser.build((Reader)new StringReader(budgetJustificationAsXML));
            Element node = document.getRootElement();
            this.lastUpdateUser = node.getAttributeValue("lastUpdateBy");
            this.lastUpdateTime = node.getAttributeValue("lastUpdateOn");
            this.justificationText = node.getText();
        }
        catch (JDOMException e) {
            LOG.warn((Object)"Unable to parse budget justification XML.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"Unable to parse budget justification XML.", (Throwable)e);
        }
    }
}

