/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.parameters;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;

public class BudgetPeriodAuditRule
extends ResearchDocumentRuleBase {
    private static final String BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY = "budgetPeriodProjectDateAuditErrors";
    private static final String BUDGET_PERIOD_DATE_AUDIT_WARNING_KEY = "budgetPeriodProjectDateAuditWarnings";

    public boolean processRunAuditBusinessRules(Document document) {
        if (document == null) {
            throw new NullPointerException("the document is null");
        }
        BudgetDocument budgetDocument = (BudgetDocument)document;
        return this.validatePeriodDates(budgetDocument);
    }

    private boolean validatePeriodDates(BudgetDocument budgetDocument) {
        assert (budgetDocument != null) : "the document is null";
        boolean retval = true;
        BudgetParent budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        Date projectStartDate = budgetParent.getRequestedStartDateInitial();
        Date projectEndDate = budgetParent.getRequestedEndDateInitial();
        int i = 0;
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            Date budgetPeriodStartDate = budgetPeriod.getStartDate();
            Date budgetPeriodEndDate = budgetPeriod.getEndDate();
            if (budgetPeriodStartDate != null && budgetPeriodStartDate.before(projectStartDate)) {
                retval = false;
                this.addBudgetPeriodDateAuditError(new AuditError("document.budgetPeriods[" + i + "].startDate", "error.periodStartDate.before.projectStartDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (budgetPeriodEndDate != null && budgetPeriodEndDate.after(projectEndDate)) {
                retval = false;
                this.addBudgetPeriodDateAuditError(new AuditError("document.budgetPeriods[" + i + "].endDate", "error.periodEndDate.after.projectEndDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (i == 0 && budgetPeriodStartDate != null && budgetPeriodStartDate.after(projectStartDate)) {
                this.addBudgetPeriodDateAuditWarning(new AuditError("document.budgetPeriods[" + i + "].startDate", "warning.budgetStartDate.after.projectStartDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            if (i == budgetDocument.getBudget().getBudgetPeriods().size() - 1 && budgetPeriodEndDate != null && budgetPeriodEndDate.before(projectEndDate)) {
                this.addBudgetPeriodDateAuditWarning(new AuditError("document.budgetPeriods[" + i + "].endDate", "warning.budgetEndDate.before.projectEndDate", "parameters.BudgetPeriodsAmpTotals", new String[]{Integer.toString(i + 1)}));
            }
            ++i;
        }
        return retval;
    }

    private void addBudgetPeriodDateAuditWarning(AuditError warning) {
        assert (warning != null) : "the warning is null";
        this.addAuditError(warning, BUDGET_PERIOD_DATE_AUDIT_WARNING_KEY, "Budget Period And Totals Information", "Warnings");
    }

    private void addBudgetPeriodDateAuditError(AuditError error) {
        assert (error != null) : "the error is null";
        this.addAuditError(error, BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY, "Budget Period And Totals Information", "Validation Errors");
    }

    private List<AuditError> getAuditErrors() {
        ArrayList<AuditError> auditErrors = new ArrayList();
        if (!KNSGlobalVariables.getAuditErrorMap().containsKey(BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY)) {
            KNSGlobalVariables.getAuditErrorMap().put(BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY, new AuditCluster("Budget Period And Totals Information", auditErrors, "Validation Errors"));
        } else {
            auditErrors = ((AuditCluster)KNSGlobalVariables.getAuditErrorMap().get(BUDGET_PERIOD_DATE_AUDIT_ERROR_KEY)).getAuditErrorList();
        }
        return auditErrors;
    }
}

