/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.DateSortable;
import org.kuali.kra.budget.core.BudgetAssociate;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.AppointmentType;
import org.kuali.kra.budget.personnel.BudgetPersonSalaryDetails;
import org.kuali.kra.budget.personnel.JobCode;
import org.kuali.kra.budget.personnel.JobCodeService;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.budget.personnel.TbnPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.hierarchy.HierarchyMaintainable;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetPerson
extends BudgetAssociate
implements HierarchyMaintainable,
DateSortable {
    private static final long serialVersionUID = 1L;
    private Date effectiveDate;
    private String jobCode;
    private JobCode jobCodeRef;
    private String jobTitle;
    private Boolean nonEmployeeFlag;
    private String personId;
    private Integer rolodexId;
    private String tbnId;
    private String appointmentTypeCode;
    private BudgetDecimal calculationBase;
    private String personName;
    private AppointmentType appointmentType;
    private Integer personSequenceNumber;
    private Rolodex rolodex;
    private String role;
    private Date salaryAnniversaryDate;
    private transient KcPersonService kcPersonService;
    private String hierarchyProposalNumber;
    private boolean hiddenInHierarchy;
    private BudgetPersonSalaryDetails personSalaryDetails;
    private List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails;

    public List<BudgetPersonSalaryDetails> getBudgetPersonSalaryDetails() {
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        ArrayList<BudgetPersonSalaryDetails> salaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        if (this.budgetPersonSalaryDetails == null || this.budgetPersonSalaryDetails.isEmpty()) {
            HashMap<String, Long> budgetMap = new HashMap<String, Long>();
            budgetMap.put("budgetId", this.getBudgetId());
            Collection periods = boService.findMatching(BudgetPeriod.class, budgetMap);
            for (BudgetPeriod budgetPeriod : periods) {
                salaryDetails.add(new BudgetPersonSalaryDetails());
            }
            this.budgetPersonSalaryDetails = salaryDetails;
        }
        return this.budgetPersonSalaryDetails;
    }

    public void setBudgetPersonSalaryDetails(List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails) {
        this.budgetPersonSalaryDetails = budgetPersonSalaryDetails;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public BudgetPerson() {
        this.budgetPersonSalaryDetails = new ArrayList();
        this.personSalaryDetails = new BudgetPersonSalaryDetails();
    }

    public BudgetPerson(KcPerson person) {
        this.personId = person.getPersonId();
        this.personName = person.getFullName();
        this.salaryAnniversaryDate = person.getExtendedAttributes().getSalaryAnniversaryDate();
        this.nonEmployeeFlag = false;
    }

    public BudgetPerson(Rolodex rolodex) {
        this.rolodexId = rolodex.getRolodexId();
        this.personName = rolodex.getFirstName() + " " + rolodex.getLastName();
        this.nonEmployeeFlag = true;
    }

    public BudgetPerson(TbnPerson tbn) {
        this.tbnId = tbn.getTbnId();
        this.personName = tbn.getPersonName();
        this.nonEmployeeFlag = true;
        this.jobCode = tbn.getJobCode();
    }

    public BudgetPerson(PersonRolodex proposalPerson) {
        if (proposalPerson.getPersonId() != null) {
            this.personId = proposalPerson.getPersonId();
            this.nonEmployeeFlag = false;
        } else {
            this.rolodexId = proposalPerson.getRolodexId();
            this.nonEmployeeFlag = true;
        }
        this.personName = proposalPerson.getFullName();
    }

    public Date getStartDate() {
        return this.effectiveDate;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public void setJobCode(String jobCode) {
        if (this.jobCode == null || !this.jobCode.equals(jobCode)) {
            this.jobCode = jobCode;
            this.refreshJobTitle();
        }
    }

    public Boolean getNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(Boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public AppointmentType getAppointmentType() {
        return this.appointmentType;
    }

    public void setAppointmentType(AppointmentType appointmentType) {
        this.appointmentType = appointmentType;
    }

    public BudgetDecimal getCalculationBase() {
        return this.calculationBase;
    }

    public void setCalculationBase(BudgetDecimal calculationBase) {
        this.calculationBase = calculationBase;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getAppointmentTypeCode() {
        return this.appointmentTypeCode;
    }

    public void setAppointmentTypeCode(String appointmentTypeCode) {
        this.appointmentTypeCode = appointmentTypeCode;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public KcPerson getPerson() {
        return this.getKcPersonService().getKcPersonByPersonId(this.personId);
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public Rolodex getRoldex() {
        return this.rolodex;
    }

    public void setRoldex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public Integer getPersonSequenceNumber() {
        return this.personSequenceNumber;
    }

    public void setPersonSequenceNumber(Integer personSequenceNumber) {
        this.personSequenceNumber = personSequenceNumber;
    }

    public String getTbnId() {
        return this.tbnId;
    }

    public void setTbnId(String tbnId) {
        this.tbnId = tbnId;
    }

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isDuplicatePerson(BudgetPerson budgetPerson) {
        if (!StringUtils.equals((String)this.getJobCode(), (String)budgetPerson.getJobCode()) || !ObjectUtils.equals((Object)this.getEffectiveDate(), (Object)budgetPerson.getEffectiveDate())) {
            return false;
        }
        if (this.getNonEmployeeFlag() != null && this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag() != null && budgetPerson.getNonEmployeeFlag().booleanValue()) {
            if (this.getRolodexId() != null && budgetPerson.getRolodexId() != null) {
                return this.getRolodexId().equals(budgetPerson.getRolodexId());
            }
            if (this.getTbnId() != null && budgetPerson.getTbnId() != null) {
                return this.getTbnId().equals(budgetPerson.getTbnId());
            }
            return false;
        }
        if (this.getNonEmployeeFlag() != null && !this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag() != null && !budgetPerson.getNonEmployeeFlag().booleanValue()) {
            return this.getPersonId().equals(budgetPerson.getPersonId());
        }
        return false;
    }

    public boolean isSamePerson(BudgetPerson budgetPerson) {
        if (this.getNonEmployeeFlag().booleanValue() && budgetPerson.getNonEmployeeFlag().booleanValue()) {
            if (this.getRolodexId() != null && budgetPerson.getRolodexId() != null) {
                return this.getRolodexId().equals(budgetPerson.getRolodexId());
            }
            if (this.getTbnId() != null && budgetPerson.getTbnId() != null) {
                return this.getTbnId().equals(budgetPerson.getTbnId());
            }
            return false;
        }
        if (!this.getNonEmployeeFlag().booleanValue() && !budgetPerson.getNonEmployeeFlag().booleanValue()) {
            return this.getPersonId().equals(budgetPerson.getPersonId());
        }
        return false;
    }

    public String getPersonRolodexTbnId() {
        String rolodexPersonId = this.getRolodexId() == null ? this.getPersonId() : this.getRolodexId().toString();
        return rolodexPersonId == null ? this.getTbnId() : rolodexPersonId;
    }

    public String getJobTitle() {
        this.getJobTitleFromJobCode();
        String ret = null;
        if (this.jobCodeRef != null) {
            ret = this.jobCodeRef.getJobTitle();
        }
        return ret;
    }

    public void setJobTitle(String jobTitle) {
        this.refreshJobTitle();
    }

    private void refreshJobTitle() {
        this.jobCodeRef = null;
        this.getJobTitleFromJobCode();
    }

    private void getJobTitleFromJobCode() {
        if (StringUtils.isNotBlank((String)this.getJobCode()) && (this.jobCodeRef == null || !StringUtils.isNotBlank((String)this.jobCodeRef.getJobTitle()))) {
            JobCodeService jcService = (JobCodeService)KraServiceLocator.getService(JobCodeService.class);
            this.jobCodeRef = jcService.findJobCodeRef(this.getJobCode());
        }
    }

    public JobCode getJobCodeRef() {
        return this.jobCodeRef;
    }

    public void setJobCodeRef(JobCode jobCodeRef) {
        this.jobCodeRef = jobCodeRef;
    }

    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getBudgetId() == null ? 0 : this.getBudgetId().hashCode());
        result = 31 * result + (this.personSequenceNumber == null ? 0 : this.personSequenceNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetPerson other = (BudgetPerson)obj;
        if (this.getBudgetId() == null ? other.getBudgetId() != null : !this.getBudgetId().equals(other.getBudgetId())) {
            return false;
        }
        return !(this.personSequenceNumber == null ? other.personSequenceNumber != null : !this.personSequenceNumber.equals(other.personSequenceNumber));
    }

    public Date getSalaryAnniversaryDate() {
        return this.salaryAnniversaryDate;
    }

    public void setSalaryAnniversaryDate(Date salaryAnniversaryDate) {
        this.salaryAnniversaryDate = salaryAnniversaryDate;
    }

    public Date getSortableDate() {
        return this.getEffectiveDate();
    }

    public void setPersonSalaryDetails(BudgetPersonSalaryDetails personSalaryDetails) {
        this.personSalaryDetails = personSalaryDetails;
    }

    public BudgetPersonSalaryDetails getPersonSalaryDetails() {
        return this.personSalaryDetails;
    }
}

