/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class BudgetPersonnelAuditRule
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final Log LOG = LogFactory.getLog(BudgetPersonnelAuditRule.class);

    public boolean processRunPersonnelAuditBusinessRules(Document document) {
        boolean valid = true;
        if (!(document instanceof BudgetDocument)) {
            return false;
        }
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        BudgetDocument budgetDocument = (BudgetDocument)document;
        Budget budget = ((BudgetDocument)document).getBudget();
        BudgetParent budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        for (BudgetPerson budgetPerson : budget.getBudgetPersons()) {
            PersonRolodex proposalPerson;
            if (budgetPerson.getRolodexId() != null) {
                ContactRole role = budgetParent.getProposalNonEmployeeRole(budgetPerson.getRolodexId());
                if (role == null) continue;
                budgetPerson.setRole(role.getRoleDescription());
                continue;
            }
            if (budgetPerson.getPersonId() != null) {
                proposalPerson = budgetParent.getProposalEmployee(budgetPerson.getPersonId());
                if (proposalPerson == null || !proposalPerson.isOtherSignificantContributorFlag()) continue;
                auditErrors.add(new AuditError("document.budget.budgetPersonnel.osc." + budgetPerson.getPersonId(), "warning.personnel.osc", "personnel", new String[]{budgetPerson.getPersonName()}));
                continue;
            }
            if (budgetPerson.getRolodexId() == null || (proposalPerson = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId())) == null || !proposalPerson.isOtherSignificantContributorFlag()) continue;
            auditErrors.add(new AuditError("document.budget.budgetPersonnel.osc." + budgetPerson.getRolodexId(), "warning.personnel.osc", "personnel", new String[]{budgetPerson.getPersonName()}));
        }
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("budgetPersonnelAuditWarnings", new AuditCluster("personnel", auditErrors, "Warnings"));
        }
        return valid;
    }
}

