/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonSalaryDetails;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonnelBudgetService;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetPersonnelBudgetServiceImpl
implements BudgetPersonnelBudgetService {
    private BudgetPersonService budgetPersonService;
    private BudgetCalculationService budgetCalculationService;
    private ParameterService parameterService;

    public void addBudgetPersonnelDetails(BudgetDocument budgetDocument, BudgetPeriod budgetPeriod, BudgetLineItem budgetLineItem, BudgetPersonnelDetails newBudgetPersonnelDetails) {
        try {
            ConvertUtils.register((Converter)new SqlDateConverter(null), Date.class);
            ConvertUtils.register((Converter)new SqlTimestampConverter(null), Timestamp.class);
            BeanUtils.copyProperties((Object)newBudgetPersonnelDetails, (Object)budgetLineItem);
            newBudgetPersonnelDetails.setBudgetJustification(null);
        }
        catch (Exception e) {
            this.copyLineItemToPersonnelDetails(budgetLineItem, newBudgetPersonnelDetails);
        }
        newBudgetPersonnelDetails.setPersonNumber(budgetDocument.getHackedDocumentNextValue("budget.budgetPersonnelDetails.personNumber"));
        newBudgetPersonnelDetails.setPersonSequenceNumber(newBudgetPersonnelDetails.getPersonSequenceNumber());
        BudgetPerson budgetPerson = this.budgetPersonService.findBudgetPerson(newBudgetPersonnelDetails);
        if (budgetPerson != null) {
            newBudgetPersonnelDetails.setPersonId(budgetPerson.getPersonRolodexTbnId());
            newBudgetPersonnelDetails.setJobCode(budgetPerson.getJobCode());
            newBudgetPersonnelDetails.setBudgetPerson(budgetPerson);
        }
        newBudgetPersonnelDetails.setSequenceNumber(budgetDocument.getHackedDocumentNextValue("budget.budgetPersonnelDetails.sequenceNumber"));
        newBudgetPersonnelDetails.refreshNonUpdateableReferences();
        budgetLineItem.getBudgetPersonnelDetailsList().add(newBudgetPersonnelDetails);
    }

    public BudgetPersonService getBudgetPersonService() {
        return this.budgetPersonService;
    }

    public void setBudgetPersonService(BudgetPersonService budgetPersonService) {
        this.budgetPersonService = budgetPersonService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public List<BudgetPersonSalaryDetails> calculatePersonSalary(Budget budget, int personIndex) {
        ArrayList<BudgetPersonSalaryDetails> budgetPersonSalaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        String rate = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "DEFAULT_INFLATION_RATE_FOR_SALARY");
        List budgetPeriodList = null;
        BudgetDecimal actualPersonSalary = BudgetDecimal.ZERO;
        BudgetDecimal personSalary = BudgetDecimal.ZERO;
        BudgetDecimal newRate = new BudgetDecimal(rate);
        budgetPeriodList = budget.getBudgetPeriods();
        BudgetPerson budgetPerson = budget.getBudgetPerson(personIndex);
        for (BudgetPeriod budgetPeriodData : budgetPeriodList) {
            BudgetPersonSalaryDetails personSalaryDetails = new BudgetPersonSalaryDetails();
            personSalaryDetails.setBudgetId(budget.getBudgetId());
            personSalaryDetails.setPersonSequenceNumber(budgetPerson.getPersonSequenceNumber());
            personSalaryDetails.setBudgetPeriod(budgetPeriodData.getBudgetPeriod());
            personSalaryDetails.setPersonId(budgetPerson.getPersonId());
            if (budgetPeriodData.getBudgetPeriod() == 1) {
                if (budgetPerson.getEffectiveDate().equals(budgetPerson.getStartDate())) {
                    personSalaryDetails.setBaseSalary(budgetPerson.getCalculationBase());
                    actualPersonSalary = budgetPerson.getCalculationBase();
                } else {
                    actualPersonSalary = ((BudgetDecimal)budgetPerson.getCalculationBase().add((AbstractKualiDecimal)budgetPerson.getCalculationBase().multiply(newRate.divide(new BudgetDecimal(100))))).setScale(2);
                }
            } else {
                personSalary = ((BudgetDecimal)actualPersonSalary.add((AbstractKualiDecimal)actualPersonSalary.multiply(newRate.divide(new BudgetDecimal(100))))).setScale(2);
                personSalaryDetails.setBaseSalary(personSalary);
                actualPersonSalary = personSalary;
            }
            budgetPersonSalaryDetails.add(personSalaryDetails);
        }
        return budgetPersonSalaryDetails;
    }

    public void calculateBudgetPersonnelBudget(Budget budget, BudgetLineItem selectedBudgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int lineNumber) {
        this.copyLineItemToPersonnelDetails(selectedBudgetLineItem, budgetPersonnelDetails);
        this.budgetCalculationService.calculateBudgetLineItem(budget, budgetPersonnelDetails);
        if (budgetPersonnelDetails.getSalaryRequested().equals((Object)BudgetDecimal.ZERO)) {
            int budgetPeriodNumber = budgetPersonnelDetails.getBudgetPeriod() - 1;
            BudgetPeriod budgetPeriod = budget.getBudgetPeriod(budgetPeriodNumber);
            Date personEffectiveDate = budgetPersonnelDetails.getBudgetPerson().getEffectiveDate();
            if (personEffectiveDate.after(budgetPeriod.getEndDate())) {
                MessageMap errorMap = GlobalVariables.getMessageMap();
                errorMap.putError("document.budgetPeriod[" + budgetPeriodNumber + "].budgetLineItems[" + budgetPeriodNumber + "].budgetPersonnelDetailsList[" + lineNumber + "].personSequenceNumber", "error.effective.date.out.of.range", new String[]{budgetPersonnelDetails.getBudgetPerson().getPersonName()});
            }
        }
    }

    protected void copyLineItemToPersonnelDetails(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails) {
        budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
        budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
        budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
        budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
        budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
        budgetPersonnelDetails.setApplyInRateFlag(budgetLineItem.getApplyInRateFlag());
        budgetPersonnelDetails.setOnOffCampusFlag(budgetLineItem.getOnOffCampusFlag());
    }

    public void deleteBudgetPersonnelDetails(Budget budget, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int lineToDelete) {
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        selectedBudgetLineItem.getBudgetPersonnelDetailsList().remove(lineToDelete);
        selectedBudgetLineItem.setBudgetPersonnelLineItemDeleted(true);
    }

    public void deleteBudgetPersonnelDetailsForPerson(Budget document, BudgetPerson person) {
        boolean personFound = false;
        BudgetPersonnelDetails toRemove = null;
        BudgetLineItem lineItem = null;
        Iterator period_it = document.getBudgetPeriods().iterator();
        while (period_it.hasNext() && !personFound) {
            BudgetPeriod period = (BudgetPeriod)period_it.next();
            Iterator lineItem_it = period.getBudgetLineItems().iterator();
            while (lineItem_it.hasNext() && !personFound) {
                lineItem = (BudgetLineItem)lineItem_it.next();
                Iterator personnelDetails_it = lineItem.getBudgetPersonnelDetailsList().iterator();
                while (personnelDetails_it.hasNext() && !personFound) {
                    BudgetPersonnelDetails personnelDetails = (BudgetPersonnelDetails)personnelDetails_it.next();
                    if (personnelDetails.getBudgetPerson() == null) {
                        personnelDetails.refreshReferenceObject("budgetPerson");
                    }
                    if (!ObjectUtils.equalByKeys((PersistableBusinessObject)personnelDetails.getBudgetPerson(), (PersistableBusinessObject)person)) continue;
                    BufferedLogger.debug((Object[])new Object[]{"Comparing ", personnelDetails.getBudgetPerson().getPersonId(), " and ", person.getPersonId()});
                    lineItem.setBudgetPersonnelLineItemDeleted(true);
                    personFound = true;
                    toRemove = personnelDetails;
                }
            }
        }
        if (personFound && toRemove != null && lineItem != null) {
            BufferedLogger.debug((Object[])new Object[]{"Removing ", toRemove});
            lineItem.getBudgetPersonnelDetailsList().remove(toRemove);
        }
    }
}

