/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.personnel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonSalaryDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class BudgetPersonnelDetails
extends BudgetLineItemBase {
    @DeepCopyIgnore
    private Long budgetPersonnelLineItemId;
    private Integer personNumber;
    private BudgetDecimal costSharingPercent = BudgetDecimal.ZERO;
    private String jobCode;
    private Boolean nonEmployeeFlag;
    private BudgetDecimal percentCharged = BudgetDecimal.ZERO;
    private BudgetDecimal percentEffort = BudgetDecimal.ZERO;
    private String periodTypeCode;
    private String personId;
    private BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
    private Integer sequenceNumber;
    private Integer personSequenceNumber;
    private BudgetPerson budgetPerson;
    private List<BudgetPersonnelCalculatedAmount> budgetPersonnelCalculatedAmounts;
    private List<BudgetPersonnelRateAndBase> budgetPersonnelRateAndBaseList;
    private List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails;
    private String effdtAfterStartdtMsg;
    private BudgetDecimal calculatedBaseSalary = BudgetDecimal.ZERO;

    public BudgetPersonnelDetails() {
        this.budgetPersonnelCalculatedAmounts = new ArrayList();
        this.budgetPersonnelRateAndBaseList = new ArrayList();
        this.budgetPersonSalaryDetails = new ArrayList();
    }

    public Integer getPersonNumber() {
        return this.personNumber;
    }

    public void setPersonNumber(Integer personNumber) {
        this.personNumber = personNumber;
    }

    public BudgetDecimal getCostSharingPercent() {
        return this.costSharingPercent;
    }

    public void setCostSharingPercent(BudgetDecimal costSharingPercent) {
        this.costSharingPercent = costSharingPercent;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public void setJobCode(String jobCode) {
        this.jobCode = jobCode;
    }

    public BudgetDecimal getPercentCharged() {
        return BudgetDecimal.returnZeroIfNull((BudgetDecimal)this.percentCharged);
    }

    public void setPercentCharged(BudgetDecimal percentCharged) {
        this.percentCharged = percentCharged;
    }

    public BudgetDecimal getPercentEffort() {
        return BudgetDecimal.returnZeroIfNull((BudgetDecimal)this.percentEffort);
    }

    public void setPercentEffort(BudgetDecimal percentEffort) {
        this.percentEffort = percentEffort;
    }

    public String getPeriodTypeCode() {
        return this.periodTypeCode;
    }

    public void setPeriodTypeCode(String periodTypeCode) {
        this.periodTypeCode = periodTypeCode;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public BudgetDecimal getSalaryRequested() {
        return this.salaryRequested;
    }

    public void setSalaryRequested(BudgetDecimal salaryRequested) {
        this.salaryRequested = salaryRequested;
    }

    public BudgetDecimal getCalculatedBaseSalary() {
        return this.calculatedBaseSalary;
    }

    public void setCalculatedBaseSalary(BudgetDecimal calculatedBaseSalary) {
        this.calculatedBaseSalary = calculatedBaseSalary;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Boolean getNonEmployeeFlag() {
        return this.getBudgetPerson() == null ? false : this.getBudgetPerson().getNonEmployeeFlag();
    }

    public void setNonEmployeeFlag(Boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    public Integer getPersonSequenceNumber() {
        return this.personSequenceNumber;
    }

    public void setPersonSequenceNumber(Integer personSequenceNumber) {
        this.personSequenceNumber = personSequenceNumber;
    }

    public BudgetPerson getBudgetPerson() {
        return this.budgetPerson;
    }

    public void setBudgetPerson(BudgetPerson budgetPerson) {
        this.budgetPerson = budgetPerson;
    }

    public List<BudgetPersonnelCalculatedAmount> getBudgetPersonnelCalculatedAmounts() {
        return this.budgetPersonnelCalculatedAmounts;
    }

    public void setBudgetPersonnelCalculatedAmounts(List<BudgetPersonnelCalculatedAmount> budgetPersonnelCalculatedAmounts) {
        this.budgetPersonnelCalculatedAmounts = budgetPersonnelCalculatedAmounts;
    }

    public List getBudgetCalculatedAmounts() {
        return this.getBudgetPersonnelCalculatedAmounts();
    }

    public List<BudgetPersonnelRateAndBase> getBudgetPersonnelRateAndBaseList() {
        return this.budgetPersonnelRateAndBaseList;
    }

    public void setBudgetPersonnelRateAndBaseList(List<BudgetPersonnelRateAndBase> budgetPersonnelRateAndBaseList) {
        this.budgetPersonnelRateAndBaseList = budgetPersonnelRateAndBaseList;
    }

    public List<BudgetPersonSalaryDetails> getBudgetPersonSalaryDetails() {
        return this.budgetPersonSalaryDetails;
    }

    public void setBudgetPersonSalaryDetails(List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails) {
        this.budgetPersonSalaryDetails = budgetPersonSalaryDetails;
    }

    public String getEffdtAfterStartdtMsg() {
        this.refreshReferenceObject("budgetPerson");
        if (this.getStartDate() != null && this.budgetPerson.getEffectiveDate().after(this.getStartDate())) {
            return "Earning Period Start Date is before " + this.budgetPerson.getPersonName() + "'s Salary Effective Date. Salary is calculated based on Effective Date.";
        }
        return "";
    }

    public void setEffdtAfterStartdtMsg(String effdtAfterStartdtMsg) {
        this.effdtAfterStartdtMsg = effdtAfterStartdtMsg;
    }

    public KualiDecimal getPersonMonths() {
        KualiDecimal result = null;
        if (this.getStartDate() != null && this.getEndDate() != null) {
            Calendar startDateCalendar = Calendar.getInstance();
            startDateCalendar.setTime(this.getStartDate());
            int startMonth = startDateCalendar.get(2);
            Calendar endDateCalendar = Calendar.getInstance();
            endDateCalendar.setTime(this.getEndDate());
            double personMonths = 0.0;
            while (startDateCalendar.compareTo(endDateCalendar) <= 0) {
                double noOfDaysInMonth = startDateCalendar.getActualMaximum(5);
                double noOfActualDays = 0.0;
                noOfActualDays = startDateCalendar.get(2) == endDateCalendar.get(2) && startDateCalendar.get(1) == endDateCalendar.get(1) ? (double)(endDateCalendar.get(5) - startDateCalendar.get(5) + 1) : (startDateCalendar.get(2) == startMonth ? noOfDaysInMonth - (double)startDateCalendar.get(5) + 1.0 : noOfDaysInMonth);
                startDateCalendar.add(2, 1);
                startDateCalendar.set(5, 1);
                personMonths += noOfActualDays / noOfDaysInMonth;
            }
            result = new KualiDecimal(new BudgetDecimal(personMonths).multiply(this.getPercentEffort()).divide(new BudgetDecimal(100)).bigDecimalValue());
        }
        return result;
    }

    public Long getBudgetPersonnelLineItemId() {
        return this.budgetPersonnelLineItemId;
    }

    public void setBudgetPersonnelLineItemId(Long budgetPersonnelLineItemId) {
        this.budgetPersonnelLineItemId = budgetPersonnelLineItemId;
    }

    public AbstractBudgetCalculatedAmount getNewBudgetPersonnelCalculatedAmount() {
        return new BudgetPersonnelCalculatedAmount();
    }
}

