/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetPeriodData;
import noNamespace.BudgetSalaryDocument;
import noNamespace.SalaryType;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.BudgetCategory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.util.BudgetDataPeriodVO;
import org.kuali.kra.budget.printing.util.SalaryTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseStream;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public abstract class BudgetBaseSalaryStream
extends BudgetBaseStream {
    protected static final String SEPARATER_STRING = " - ";
    protected static final String OVERHEAD_RATE_PREFIX = "OH - ";
    protected static final String EMPTY_STRING = "";
    protected static final String PERIOD_COST_TOTAL = "Total";
    protected static final String CALCULATED_AMOUNT_COST_ELEMENT_DESC = "Calculated Amount";
    private static final String RATE_CLASS_CODE_PARAMETER = "rateClassCode";

    protected BudgetSalaryDocument.BudgetSalary getBudgetSalaryTypeXmlObject() {
        BudgetSalaryDocument.BudgetSalary budgetSalary = BudgetSalaryDocument.BudgetSalary.Factory.newInstance();
        BudgetParent bdP = this.budget.getBudgetParent();
        String parentNumber = bdP.getParentNumber();
        if (parentNumber != null) {
            budgetSalary.setProposalNumber(parentNumber);
            budgetSalary.setParentTypeName(bdP.getParentTypeName());
        }
        this.setBudgetSalaryTypeBasicInformation(budgetSalary);
        String principleInvestigatorName = bdP.getParentPIName();
        if (principleInvestigatorName != null) {
            budgetSalary.setPIName(principleInvestigatorName);
        }
        if (bdP != null && bdP.getParentTitle() != null) {
            budgetSalary.setTitle(bdP.getParentTitle());
        }
        return budgetSalary;
    }

    private void setBudgetSalaryTypeBasicInformation(BudgetSalaryDocument.BudgetSalary budgetSalary) {
        if (this.budget.getBudgetVersionNumber() != null) {
            budgetSalary.setBudgetVersion(this.budget.getBudgetVersionNumber().intValue());
        }
        budgetSalary.setCurrentDate(this.dateTimeService.getCurrentCalendar());
        if (this.budget.getStartDate() != null) {
            budgetSalary.setStartDate(this.dateTimeService.getCalendar((Date)this.budget.getStartDate()));
        }
        if (this.budget.getEndDate() != null) {
            budgetSalary.setEndDate(this.dateTimeService.getCalendar((Date)this.budget.getEndDate()));
        }
        if (this.budget.getBudgetPeriods() != null) {
            budgetSalary.setTotalPeriod(this.budget.getBudgetPeriods().size());
        }
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            budgetSalary.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
    }

    protected SalaryType getSalaryTypeXmlObject(String costElementDesc, String costElementCode, String name, BudgetPeriodData[] budgetPeriodArray, BudgetDecimal total) {
        SalaryType salaryType = SalaryType.Factory.newInstance();
        if (costElementDesc != null) {
            salaryType.setCostElementDesc(costElementDesc);
        }
        if (costElementCode != null) {
            salaryType.setCostElementCode(costElementCode);
        }
        if (name != null) {
            salaryType.setName(name);
        }
        if (budgetPeriodArray != null) {
            salaryType.setPeriodArray(budgetPeriodArray);
        }
        if (total != null) {
            salaryType.setTotal(total.bigDecimalValue());
        }
        return salaryType;
    }

    protected SalaryType[] getBudgetTotalAndSummarySalaryTypes(boolean includeNonPersonnel) {
        ArrayList<SalaryTypeVO> salaryTypeVoList = new ArrayList<SalaryTypeVO>();
        ArrayList budgetLineItemCalcAmountsList = new ArrayList();
        Map lineItems = this.getListOfCostElementDescription(budgetLineItemCalcAmountsList);
        for (String costElemetDesc : lineItems.keySet()) {
            salaryTypeVoList.add(this.getSalaryTypeVOForCostElement(costElemetDesc, (String)lineItems.get(costElemetDesc)));
        }
        this.setSalaryTypesForLineItemCalcuAmount(salaryTypeVoList, includeNonPersonnel);
        List salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        return salaryTypeList.toArray(new SalaryType[0]);
    }

    private Map<String, String> getListOfCostElementDescription(List<List<BudgetLineItemCalculatedAmount>> budgetLineItemCalcAmountsList) {
        HashMap<String, String> lineItems = new HashMap<String, String>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            List budgetLineItemCalcAmounts = new ArrayList();
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String costElementDesc;
                budgetLineItemCalcAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
                budgetLineItemCalcAmountsList.add(budgetLineItemCalcAmounts);
                if (budgetLineItem.getCostElementBO() == null || (costElementDesc = budgetLineItem.getCostElementBO().getDescription()) == null || lineItems.containsKey(costElementDesc) || budgetLineItem.getCostElementBO().getCostElement() == null) continue;
                lineItems.put(costElementDesc, budgetLineItem.getCostElementBO().getCostElement());
            }
        }
        return lineItems;
    }

    protected SalaryTypeVO getSalaryTypeVOForCostElement(String costElemetDesc, String costElementCode) {
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(costElemetDesc);
        salaryTypeVO.setCostElementCode(costElementCode);
        salaryTypeVO.setName(costElemetDesc);
        salaryTypeVO.setBudgetPeriodVOs(this.getBudgetDataPeriodVOsForCostElement(costElemetDesc));
        return salaryTypeVO;
    }

    private List<BudgetDataPeriodVO> getBudgetDataPeriodVOsForCostElement(String costElementDesc) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetDataPeriodVO = new BudgetDataPeriodVO();
            budgetDataPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            BudgetDecimal periodCost = BudgetDecimal.ZERO;
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                if (lineItem.getCostElementBO() == null || lineItem.getCostElementBO().getDescription() == null || !lineItem.getCostElementBO().getDescription().equals(costElementDesc)) continue;
                periodCost = (BudgetDecimal)periodCost.add((AbstractKualiDecimal)lineItem.getLineItemCost());
            }
            budgetDataPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetDataPeriodVO);
        }
        return budgetPeriodDataList;
    }

    protected void setSalaryTypesForLineItemCalcuAmount(List<SalaryTypeVO> salaryTypeVoList, boolean includeNonPersonnel) {
        ArrayList<String> calculatedAmountDescList = new ArrayList<String>();
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(CALCULATED_AMOUNT_COST_ELEMENT_DESC);
        salaryTypeVoList.add(salaryTypeVO);
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                List budgetLineItemCalculatedAmounts = budgetLineItem.getBudgetLineItemCalculatedAmounts();
                for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItemCalculatedAmounts) {
                    String rateClassCode = budgetLineItemCalcAmount.getRateClassCode();
                    String rateTypeCode = budgetLineItemCalcAmount.getRateTypeCode();
                    RateClass rateClass = this.getRateClassBo(rateClassCode);
                    String costElementDesc = this.getCostElementDescriptionForLineItem(budgetLineItemCalcAmount, rateClass);
                    if (costElementDesc == null || calculatedAmountDescList.contains(costElementDesc)) continue;
                    calculatedAmountDescList.add(costElementDesc);
                    SalaryTypeVO salaryTypeVOForCalculatedAmount = new SalaryTypeVO();
                    salaryTypeVOForCalculatedAmount.setName(costElementDesc);
                    List budgetPeriodDataList = this.getBudgetDataPeriodsForCalculatedAmounts(rateClassCode, rateTypeCode, includeNonPersonnel);
                    salaryTypeVOForCalculatedAmount.setBudgetPeriodVOs(budgetPeriodDataList);
                    salaryTypeVoList.add(salaryTypeVOForCalculatedAmount);
                }
            }
        }
    }

    private String getBudgetCategoryTypeCode(BudgetLineItem budgetLineItem) {
        String budgetCategoryType = null;
        BudgetCategory budgetCategory = budgetLineItem.getBudgetCategory();
        if (budgetCategory != null) {
            budgetCategoryType = budgetCategory.getBudgetCategoryTypeCode();
        }
        return budgetCategoryType;
    }

    protected boolean isPersonnel(String budgetCategoryType) {
        boolean personnelFound = false;
        if (budgetCategoryType.equalsIgnoreCase("P")) {
            personnelFound = true;
        }
        return personnelFound;
    }

    protected List<BudgetDataPeriodVO> getBudgetDataPeriodsForCalculatedAmounts(String rateClassCode, String rateTypeCode, boolean includeNonPersonnel) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetPeriodVO = new BudgetDataPeriodVO();
            budgetPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            BudgetDecimal periodCost = BudgetDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String budgetCategoryType = this.getBudgetCategoryTypeCode(budgetLineItem);
                if (!includeNonPersonnel && !this.isPersonnel(budgetCategoryType)) continue;
                for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (budgetLineItemCalcAmount.getRateClassCode() == null || !budgetLineItemCalcAmount.getRateClassCode().equals(rateClassCode) || budgetLineItemCalcAmount.getRateTypeCode() == null || !budgetLineItemCalcAmount.getRateTypeCode().equals(rateTypeCode)) continue;
                    periodCost = (BudgetDecimal)periodCost.add((AbstractKualiDecimal)budgetLineItemCalcAmount.getCalculatedCost());
                }
            }
            budgetPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetPeriodVO);
        }
        return budgetPeriodDataList;
    }

    private String getCostElementDescriptionForLineItem(BudgetLineItemCalculatedAmount budgetLineItemCalcAmount, RateClass rateClass) {
        String costElementDesc = null;
        if (budgetLineItemCalcAmount.getRateTypeDescription() != null) {
            if (rateClass != null && rateClass.getRateClassType() != null && rateClass.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) {
                costElementDesc = OVERHEAD_RATE_PREFIX + budgetLineItemCalcAmount.getRateTypeDescription();
            } else if (rateClass != null && rateClass.getDescription() != null) {
                costElementDesc = rateClass.getDescription() + SEPARATER_STRING + budgetLineItemCalcAmount.getRateTypeDescription();
            }
        }
        return costElementDesc;
    }

    private RateClass getRateClassBo(String rateClassCode) {
        RateClass rateClass = null;
        HashMap<String, String> personMap = new HashMap<String, String>();
        personMap.put(RATE_CLASS_CODE_PARAMETER, rateClassCode);
        List rateClassList = (List)this.businessObjectService.findMatching(RateClass.class, personMap);
        if (rateClassList != null && !rateClassList.isEmpty()) {
            rateClass = (RateClass)rateClassList.get(0);
        }
        return rateClass;
    }

    protected List<SalaryType> getListOfSalaryTypeXmlObjects(List<SalaryTypeVO> salaryTypeVoList) {
        ArrayList<SalaryType> salaryTypeList = new ArrayList<SalaryType>();
        HashMap budgetPeriodWiseTotalMap = new HashMap();
        if (!salaryTypeVoList.isEmpty()) {
            for (SalaryTypeVO salaryTypeVO : salaryTypeVoList) {
                BudgetPeriodData[] budgetPeriodArray = null;
                List budgetDataPeriodVOs = salaryTypeVO.getBudgetPeriodVOs();
                if (budgetDataPeriodVOs != null) {
                    BudgetDecimal total = BudgetDecimal.ZERO;
                    budgetPeriodArray = this.getBudgetDataPeriodXmlObjects(budgetDataPeriodVOs, budgetPeriodWiseTotalMap);
                    total = this.getTotalForCostElementOfAllPeriodsCost(budgetDataPeriodVOs);
                    salaryTypeVO.setTotal(total);
                }
                salaryTypeList.add(this.getSalaryTypeXmlObject(salaryTypeVO.getCostElement(), salaryTypeVO.getCostElementCode(), salaryTypeVO.getName(), budgetPeriodArray, salaryTypeVO.getTotal()));
            }
            this.setTotalForPeriodWise(salaryTypeList, budgetPeriodWiseTotalMap);
        }
        Collections.sort(salaryTypeList, new /* Unavailable Anonymous Inner Class!! */);
        return salaryTypeList;
    }

    private void setTotalForPeriodWise(List<SalaryType> salaryTypeList, Map<Integer, BudgetDecimal> budgetPeriodWiseTotalMap) {
        BudgetPeriodData[] budgetPeriodArray = null;
        BudgetDecimal budgetSalaryTotal = BudgetDecimal.ZERO;
        if (!budgetPeriodWiseTotalMap.isEmpty()) {
            ArrayList<BudgetPeriodData> budgetPeriodList = new ArrayList<BudgetPeriodData>();
            for (Integer periodId : budgetPeriodWiseTotalMap.keySet()) {
                BudgetPeriodData budgetPeriodData = BudgetPeriodData.Factory.newInstance();
                budgetPeriodData.setBudgetPeriodID(periodId.intValue());
                BudgetDecimal periodCost = budgetPeriodWiseTotalMap.get(periodId);
                budgetPeriodData.setPeriodCost(periodCost.bigDecimalValue());
                budgetSalaryTotal = (BudgetDecimal)budgetSalaryTotal.add((AbstractKualiDecimal)periodCost);
                budgetPeriodList.add(budgetPeriodData);
            }
            budgetPeriodArray = budgetPeriodList.toArray(new BudgetPeriodData[0]);
        }
        salaryTypeList.add(this.getSalaryTypeXmlObject(null, null, PERIOD_COST_TOTAL, budgetPeriodArray, budgetSalaryTotal));
    }

    private BudgetDecimal getTotalForCostElementOfAllPeriodsCost(List<BudgetDataPeriodVO> budgetDataPeriodVOs) {
        BudgetDecimal total = BudgetDecimal.ZERO;
        for (BudgetDataPeriodVO budgetDataPeriodVO : budgetDataPeriodVOs) {
            total = (BudgetDecimal)total.add((AbstractKualiDecimal)budgetDataPeriodVO.getPeriodCost());
        }
        return total;
    }

    private BudgetPeriodData[] getBudgetDataPeriodXmlObjects(List<BudgetDataPeriodVO> budgetDataPeriods, Map<Integer, BudgetDecimal> budgetPeriodWiseTotalMap) {
        ArrayList<BudgetPeriodData> budgetPeriodList = null;
        budgetPeriodList = new ArrayList<BudgetPeriodData>();
        for (BudgetDataPeriodVO budgetPeriodVO : budgetDataPeriods) {
            BudgetPeriodData budgetPeriodData = BudgetPeriodData.Factory.newInstance();
            int budgetPeriodId = budgetPeriodVO.getBudgetPeriodId();
            budgetPeriodData.setBudgetPeriodID(budgetPeriodId);
            BudgetDecimal periodCost = budgetPeriodVO.getPeriodCost();
            budgetPeriodData.setPeriodCost(periodCost.bigDecimalValue());
            if (budgetPeriodWiseTotalMap.containsKey(budgetPeriodId)) {
                BudgetDecimal periodTotal = budgetPeriodWiseTotalMap.get(budgetPeriodId);
                periodTotal = (BudgetDecimal)periodTotal.add((AbstractKualiDecimal)periodCost);
                budgetPeriodWiseTotalMap.put(budgetPeriodId, periodTotal);
            } else {
                budgetPeriodWiseTotalMap.put(budgetPeriodId, periodCost);
            }
            budgetPeriodList.add(budgetPeriodData);
        }
        BudgetPeriodData[] budgetPeriodArray = budgetPeriodList.toArray(new BudgetPeriodData[0]);
        return budgetPeriodArray;
    }
}

