/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noNamespace.GroupsType;
import noNamespace.ReportHeaderType;
import noNamespace.ReportPageType;
import noNamespace.ReportType;
import noNamespace.SubReportType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.calculator.ValidCalcType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.BudgetPersonnelRateAndBase;
import org.kuali.kra.budget.printing.util.ReportTypeVO;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class BudgetBaseStream
implements XmlStream {
    private static final String RATE_CLASS_TYPE = "rateClassType";
    private static final String DEPENDENT_RATE_CLASS_TYPE = "dependentRateClassType";
    private static final String RATE_CLASS_CODE = "rateClassCode";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String PROPOSAL_NUMBER = "proposalNumber";
    private static final String GET_METHOD_PREFIX = "get";
    private static final String RATE_TYPE_CODE = "rateTypeCode";
    private static final String CLOSE_BRACES = ")";
    private static final String OPEN_BRACES = "(";
    private static final String PERSONNEL_SUMMARY_LINE_ITEM_NAME = "Summary";
    protected static final String TOTAL_EMPLOYEE_BENEFITS = "Total Employee Benefits";
    protected static final String ALLOCATED_LAB_EXPENSE = "Allocated Lab Expense";
    protected static final String EMPLOYEE_BENEFITS_ON_ALLOCATED_ADMINISTRATIVE_SUPPORT = "Employee Benefits on Allocated Administrative Support";
    protected static final String ALLOCATED_ADMINISTRATIVE_SUPPORT = "Allocated Administrative Support";
    protected static final String OTHER_DIRECT_COSTS = "Other Direct Costs";
    protected static final String ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    protected static final String PERCENTAGE = "%";
    protected static final String LAB_ALLOCATION = "Lab Allocation";
    protected static final String CATEGORY_CODE_LA_SALARY = "99";
    protected static final String RATE_TYPE_CODE_VACATION_ON_LA = "2";
    protected static final String RATE_CLASS_CODE_VACATION_ON_LA = "8";
    protected static final String RATE_TYPE_CODE_LA_SALARY = "1";
    protected static final String RATE_CLASS_CODE_LA_SALARY = "10";
    protected static final String DEFAULT_RATE_TYPE_CODE_FOR_LI = "3";
    protected static final String RATE_CLASS_CODE_EB_ON_LA = "5";
    protected static final String PRINCIPAL_INVESTIGATOR_ROLE = "PI";
    private static final String RATE_CLASS = "rateClass";
    private static final String STRING_SEPRATOR = "-";
    private static final String EMPTY_STRING = "";
    protected List<BudgetPersonnelRateAndBase> budgetPersRateAndBases;
    protected BusinessObjectService businessObjectService = null;
    protected Budget budget;
    protected List<BudgetPersonnelRateAndBase> budgetPersRateAndBaseList = new ArrayList();
    protected String[] category = new String[]{"budgetCategoryDescription"};
    protected String[] rateType = new String[]{"rateTypeDesc"};
    protected String[] rateClass = new String[]{"rateClassDesc"};
    protected String[] rateClassRateType = new String[]{"rateClassDesc", "rateTypeDesc"};
    protected BudgetPeriod budgetPeriod;
    protected DateTimeService dateTimeService;
    protected static final String DATE_FORMAT = "dd MMM yyyy";
    protected static final String DATE_FORMAT_MMDDYY = "MM/dd/yy";
    protected static final String BUDGET_PERIOD = "Period";
    protected static final String BUDGET_CATEGORY_PERSONNEL = "P";
    private static final Log LOG = LogFactory.getLog(BudgetBaseStream.class);

    protected ReportHeaderType getReportHeaderTypeForCumulativeReport(BudgetParent budgetParent) {
        String principleInvestigatorName;
        ReportHeaderType reportHeaderType = ReportHeaderType.Factory.newInstance();
        if (budgetParent != null) {
            reportHeaderType.setParentTypeName(budgetParent.getParentTypeName());
            reportHeaderType.setProposalNumber(budgetParent.getParentNumber());
        }
        if (budgetParent != null && budgetParent.getParentTitle() != null) {
            reportHeaderType.setProposalTitle(budgetParent.getParentTitle());
        }
        if ((principleInvestigatorName = budgetParent.getParentPIName()) != null) {
            reportHeaderType.setPIName(principleInvestigatorName);
        }
        if (this.budgetPeriod.getVersionNumber() != null) {
            reportHeaderType.setBudgetVersion(this.budget.getBudgetVersionNumber().intValue());
        }
        if (this.budgetPeriod.getStartDate() != null) {
            reportHeaderType.setPeriodStartDate(DateFormatUtils.format((java.util.Date)this.budgetPeriod.getStartDate(), (String)DATE_FORMAT));
        }
        if (this.budgetPeriod.getEndDate() != null) {
            reportHeaderType.setPeriodEndDate(DateFormatUtils.format((java.util.Date)this.budgetPeriod.getEndDate(), (String)DATE_FORMAT));
        }
        if (this.budgetPeriod.getBudgetPeriod() != null) {
            reportHeaderType.setPeriod(this.budgetPeriod.getBudgetPeriod().intValue());
        }
        reportHeaderType.setCreateDate(this.dateTimeService.getCurrentDate().toString());
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            reportHeaderType.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
        return reportHeaderType;
    }

    protected ReportType getReportTypeForNonPersonnel(String categoryDesc, String costElementDesc, BudgetDecimal calculatedCost, BudgetDecimal costSharingAmount) {
        ReportType reportType = ReportType.Factory.newInstance();
        if (categoryDesc != null) {
            reportType.setBudgetCategoryDescription(categoryDesc);
        }
        if (costElementDesc != null) {
            reportType.setCostElementDescription(costElementDesc);
        }
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        if (costSharingAmount != null) {
            reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        } else {
            reportType.setCostSharingAmount(0.0);
        }
        return reportType;
    }

    protected ReportType getReportTypeForBudgetIndirectCostsForReport(Boolean onOffCampus, BudgetDecimal calculatedCost, BudgetDecimal costSharingAmount) {
        ReportType reportType = ReportType.Factory.newInstance();
        if (onOffCampus != null) {
            reportType.setOnOffCampus(onOffCampus.booleanValue());
        }
        if (costSharingAmount != null) {
            reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        } else {
            reportType.setCostSharingAmount(0.0);
        }
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        return reportType;
    }

    protected ReportType getReportTypeForExclusions(int sortId, String categoryDesc, BudgetDecimal calculatedCost) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setSortId(sortId);
        reportType.setCostElementDescription(categoryDesc);
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        return reportType;
    }

    protected BudgetDecimal getTotalCalculatedCostByRateClassTypeFromLineItem(String rateClassType, BudgetLineItem budgetLineItem) {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            lineItemCalAmt.refreshReferenceObject(RATE_CLASS);
            if (!lineItemCalAmt.getRateClass().getRateClassType().equals(rateClassType) || lineItemCalAmt.getCalculatedCost() == null) continue;
            calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)lineItemCalAmt.getCalculatedCost());
        }
        return calculatedCost;
    }

    protected BudgetDecimal getTotalCostSharingAmountByRateClassTypeFromLineItem(BudgetLineItem budgetLineItem, String rateClassType) {
        BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            lineItemCalAmt.refreshReferenceObject(RATE_CLASS);
            if (!lineItemCalAmt.getRateClass().getRateClassType().equals(rateClassType) || lineItemCalAmt.getCalculatedCostSharing() == null) continue;
            costSharingAmount = (BudgetDecimal)costSharingAmount.add((AbstractKualiDecimal)lineItemCalAmt.getCalculatedCostSharing());
        }
        return costSharingAmount;
    }

    protected BudgetDecimal getCalculatedCostForBudgetExclusionsSortId1() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null || !this.isRateAndBaseOfRateClassTypeLAwithEBVA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
                Date startDate = budgetRateAndBase.getStartDate();
                Date endDate = budgetRateAndBase.getEndDate();
                String key = startDate.toString() + endDate.toString();
                if (laRateBaseMap.containsKey(key)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCost());
                laRateBaseMap.put(key, budgetRateAndBase);
            }
        }
        return calculatedCost;
    }

    protected BudgetDecimal getCalculatedCostForBudgetLAExclusionsSortId2() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null) continue;
                budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
                if (!this.isRateAndBaseOfRateClassTypeEB((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseOfRateClassTypeVacation((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected BudgetDecimal getCalculatedCostForBudgetOHExclusionsSortId2() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null) continue;
                budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
                if (!this.isRateAndBaseEBonLA((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseVAonLA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected BudgetDecimal getCalculatedCostForBudgetExclusionsSortId4() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                if (budgetLineItemCalcAmount.getCalculatedCost() == null) continue;
                budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
                if (!this.isLineItemCalAmountOfRateClassTypeLabAllocation(budgetLineItemCalcAmount)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)budgetLineItemCalcAmount.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected void setReportTypeBudgetLASalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String budgetLASalaryKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetLASalaryKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            BudgetDecimal fringe = BudgetDecimal.ZERO;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            BudgetDecimal calculatedCostSharing = BudgetDecimal.ZERO;
            BudgetDecimal salary = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String budgetLASalaryTempKey = tempReportTypeVO.getCostElementDesc();
                if (!budgetLASalaryTempKey.equals(budgetLASalaryKey)) continue;
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (endDate.before(tempReportTypeVO.getEndDate())) {
                    endDate = tempReportTypeVO.getEndDate();
                }
                fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)tempReportTypeVO.getFringe());
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)tempReportTypeVO.getCalculatedCost());
                calculatedCostSharing = (BudgetDecimal)calculatedCostSharing.add((AbstractKualiDecimal)tempReportTypeVO.getCostSharingAmount());
                salary = (BudgetDecimal)salary.add((AbstractKualiDecimal)tempReportTypeVO.getSalaryRequested());
            }
            ReportType reportType = this.getReportTypeForLASalary(fringe, salary, calculatedCost, calculatedCostSharing, reportTypeVO, startDate, endDate);
            reportTypeList.add(reportType);
            reportTypeMap.put(budgetLASalaryKey, reportTypeVO);
        }
    }

    private ReportType getReportTypeForLASalary(BudgetDecimal fringe, BudgetDecimal salary, BudgetDecimal calculatedCost, BudgetDecimal calculatedCostSharing, ReportTypeVO reportTypeVO, Date startDate, Date endDate) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(LAB_ALLOCATION);
        reportType.setPersonName(ALLOCATED_ADMIN_SUPPORT);
        reportType.setPercentEffort(100.0);
        reportType.setPercentCharged(100.0);
        reportType.setBudgetCategoryCode(99);
        reportType.setInvestigatorFlag(3);
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT_MMDDYY));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT_MMDDYY));
        reportType.setCostSharingAmount(calculatedCostSharing.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setSalaryRequested(salary.doubleValue());
        return reportType;
    }

    protected void setBudgetLASalaryForBudgetRateAndBase(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (!this.isRateAndBaseOfRateClassTypeLAwithEBVA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
                Date startDate = budgetRateAndBase.getStartDate();
                Date endDate = budgetRateAndBase.getEndDate();
                String key = startDate.toString() + endDate.toString();
                if (laRateBaseMap.containsKey(key)) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
                reportTypeVOList.add(reportTypeVO);
                laRateBaseMap.put(key, budgetRateAndBase);
            }
        }
        this.setReportTypeBudgetLASalary(reportTypeList, reportTypeVOList);
    }

    protected ReportTypeVO getReportTypeVOForBudgetLASalaryForRateBase(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setCostElementDesc(budgetLineItem.getCostElementBO().getDescription());
        Date startDate = budgetRateAndBase.getStartDate();
        Date endDate = budgetRateAndBase.getEndDate();
        reportTypeVO.setStartDate(startDate);
        reportTypeVO.setEndDate(endDate);
        reportTypeVO.setSalaryRequested(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setCostSharingAmount(budgetRateAndBase.getCalculatedCostSharing());
        reportTypeVO.setFringe(this.getFringeForLASalaryForRateAndBase(budgetLineItem, startDate, endDate));
        reportTypeVO.setCalculatedCost(this.getFringeCostSharingLASalaryRateAndBase(budgetLineItem, startDate, endDate));
        return reportTypeVO;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private String getLiVacOnLaRateTypeCode() {
        String liVacOnLaRateTypeCode = DEFAULT_RATE_TYPE_CODE_FOR_LI;
        HashMap<String, String> liVacOnLaRateTypeCodeMap = new HashMap<String, String>();
        liVacOnLaRateTypeCodeMap.put(RATE_CLASS_TYPE, RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        liVacOnLaRateTypeCodeMap.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        ValidCalcType validCalcType = (ValidCalcType)this.businessObjectService.findByPrimaryKey(ValidCalcType.class, liVacOnLaRateTypeCodeMap);
        if (validCalcType != null) {
            liVacOnLaRateTypeCode = validCalcType.getRateTypeCode();
        }
        return liVacOnLaRateTypeCode;
    }

    private String getLiEbOnLaRateTypeCode() {
        String liEbOnLaRateTypeCode = DEFAULT_RATE_TYPE_CODE_FOR_LI;
        HashMap<String, String> liVacOnLaRateTypeCodeMap = new HashMap<String, String>();
        liVacOnLaRateTypeCodeMap.put(RATE_CLASS_TYPE, RateClassType.VACATION.getRateClassType());
        liVacOnLaRateTypeCodeMap.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        ValidCalcType validCalcType = (ValidCalcType)this.businessObjectService.findByPrimaryKey(ValidCalcType.class, liVacOnLaRateTypeCodeMap);
        if (validCalcType != null) {
            liEbOnLaRateTypeCode = validCalcType.getRateTypeCode();
        }
        return liEbOnLaRateTypeCode;
    }

    protected int getUnitNumber() {
        String lsOwnedByUnit = this.budgetPeriod.getBudget().getBudgetParent().getIsOwnedByUnit();
        HashMap<String, String> lsOwnedByUnitMap = new HashMap<String, String>();
        lsOwnedByUnitMap.put(UNIT_NUMBER, lsOwnedByUnit);
        int liCount = this.businessObjectService.findMatching(InstituteLaRate.class, lsOwnedByUnitMap).size();
        return liCount;
    }

    private String getRateTypeDesc(String rateClassCode, String rateTypeCode) {
        HashMap<String, String> rateTypeCodeMap = new HashMap<String, String>();
        rateTypeCodeMap.put(RATE_TYPE_CODE, rateTypeCode);
        rateTypeCodeMap.put(RATE_CLASS_CODE, rateClassCode);
        RateType rateType = (RateType)this.businessObjectService.findByPrimaryKey(RateType.class, rateTypeCodeMap);
        return rateType.getDescription();
    }

    private void addReportTypeToGroupType(GroupsType groupsType, ReportType reportType) {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        reportTypeList.add(reportType);
        groupsType.setDetailsArray(reportTypeList.toArray(new ReportType[0]));
    }

    protected GroupsType[] getGroupsType(List<ReportType> reportTypeList) {
        GroupsType groupsType = null;
        ArrayList<GroupsType> groupTypeList = new ArrayList<GroupsType>();
        for (ReportType reportType : reportTypeList) {
            groupsType = GroupsType.Factory.newInstance();
            this.addReportTypeToGroupType(groupsType, reportType);
            groupTypeList.add(groupsType);
        }
        return groupTypeList.toArray(new GroupsType[0]);
    }

    protected GroupsType[] getGroupsType(List<ReportType> reportTypeList, String[] groupBy) {
        GroupsType groupsType = null;
        String presentGroup = EMPTY_STRING;
        String lastGroup = EMPTY_STRING;
        ArrayList<ReportType> reportTypeListForGroup = null;
        ArrayList<GroupsType> groupTypeList = new ArrayList<GroupsType>();
        for (ReportType reportType : reportTypeList) {
            presentGroup = EMPTY_STRING;
            for (int count = 0; count < groupBy.length; ++count) {
                presentGroup = presentGroup + this.getFieldValue(groupBy[count], reportType);
            }
            if (!presentGroup.equals(lastGroup)) {
                groupsType = GroupsType.Factory.newInstance();
                reportTypeListForGroup = new ArrayList<ReportType>();
                Object fieldValue = this.getFieldValue(groupBy[0], reportType);
                if (fieldValue != null) {
                    groupsType.setDescription(this.getFieldValue(groupBy[0], reportType).toString());
                }
                groupTypeList.add(groupsType);
                lastGroup = presentGroup;
            }
            reportTypeListForGroup.add(reportType);
            groupsType.setDetailsArray(reportTypeListForGroup.toArray(new ReportType[0]));
        }
        return groupTypeList.toArray(new GroupsType[0]);
    }

    private Object getFieldValue(String fieldName, ReportType baseBean) {
        Class<?> dataClass = baseBean.getClass();
        Object value = null;
        try {
            StringBuilder methodName = new StringBuilder(GET_METHOD_PREFIX);
            methodName.append(String.valueOf(fieldName.charAt(0)).toUpperCase()).append(fieldName.substring(1));
            Method method = dataClass.getMethod(methodName.toString(), null);
            value = method.invoke((Object)baseBean, (Object[])null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error((Object)("Method not Found " + noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error((Object)("Error while Invoking the Method " + invocationTargetException));
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error((Object)("Illegal Access Exception" + illegalAccessException));
        }
        return value;
    }

    protected SubReportType getBudgetIndirectCostsForReport() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        BudgetDecimal calculatedCostForOn = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCostForOff = BudgetDecimal.ZERO;
        BudgetDecimal costSharingAmountForOn = BudgetDecimal.ZERO;
        BudgetDecimal costSharingAmountForOff = BudgetDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (budgetLineItem.getOnOffCampusFlag().booleanValue()) {
                calculatedCostForOn = (BudgetDecimal)calculatedCostForOn.add((AbstractKualiDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
                costSharingAmountForOn = (BudgetDecimal)costSharingAmountForOn.add((AbstractKualiDecimal)this.getTotalCostSharingAmountByRateClassTypeFromLineItem(budgetLineItem, RateClassType.OVERHEAD.getRateClassType()));
                continue;
            }
            calculatedCostForOff = (BudgetDecimal)calculatedCostForOff.add((AbstractKualiDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
            costSharingAmountForOff = (BudgetDecimal)costSharingAmountForOff.add((AbstractKualiDecimal)this.getTotalCostSharingAmountByRateClassTypeFromLineItem(budgetLineItem, RateClassType.OVERHEAD.getRateClassType()));
        }
        if (!calculatedCostForOn.equals((Object)BudgetDecimal.ZERO) || !costSharingAmountForOn.equals((Object)BudgetDecimal.ZERO)) {
            ReportType reportTypeForOn = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.TRUE, calculatedCostForOn, costSharingAmountForOn);
            reportTypeList.add(reportTypeForOn);
        }
        if (!calculatedCostForOff.equals((Object)BudgetDecimal.ZERO) || !costSharingAmountForOff.equals((Object)BudgetDecimal.ZERO)) {
            ReportType reportTypeForOff = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.FALSE, calculatedCostForOff, costSharingAmountForOff);
            reportTypeList.add(reportTypeForOff);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    protected ReportPageType.CalculationMethodology getCalculationMethodology() {
        ReportPageType.CalculationMethodology calculationMethodology = ReportPageType.CalculationMethodology.Factory.newInstance();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        subReportType = this.getBudgetOHExclusions();
        calculationMethodology.setBudgetOHExclusions(subReportType);
        subReportType = this.getBudgetLAExclusions();
        calculationMethodology.setBudgetLAExclusions(subReportType);
        subReportType = this.getBudgetOHRateBaseForPeriod();
        calculationMethodology.setBudgetOHRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetEBRateBaseForPeriod();
        calculationMethodology.setBudgetEBRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetLARateBaseForPeriod();
        calculationMethodology.setBudgetLARateBaseForPeriod(subReportType);
        subReportType = this.getBudgetVacRateBaseForPeriod();
        calculationMethodology.setBudgetVacRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetOtherRateBaseForPeriod();
        calculationMethodology.setBudgetOtherRateBaseForPeriod(subReportType);
        return calculationMethodology;
    }

    private SubReportType getBudgetOHExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String categoryDesc = null;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.budget.getBudgetLaRates().size() > 0) {
            int sortId = 1;
            categoryDesc = ALLOCATED_ADMINISTRATIVE_SUPPORT;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = EMPLOYEE_BENEFITS_ON_ALLOCATED_ADMINISTRATIVE_SUPPORT;
            calculatedCost = this.getCalculatedCostForBudgetOHExclusionsSortId2();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            sortId = 3;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
            sortId = 4;
            categoryDesc = ALLOCATED_LAB_EXPENSE;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId4);
        } else {
            int sortId = 1;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getBudgetLAExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String categoryDesc = null;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.budget.getBudgetLaRates().size() > 0) {
            int sortId = 1;
            categoryDesc = ALLOCATED_ADMINISTRATIVE_SUPPORT;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = TOTAL_EMPLOYEE_BENEFITS;
            calculatedCost = this.getCalculatedCostForBudgetLAExclusionsSortId2();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            this.setReportTypeForBudgetLAExclusionsSortId3(reportTypeList);
            sortId = 4;
            categoryDesc = ALLOCATED_LAB_EXPENSE;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId4);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    protected void setReportTypeOHExclusionForSortId(List<ReportType> reportTypeList, int sortId) {
        ArrayList tempReportTypeVOList = new ArrayList();
        this.setReportTypeVOListForOHExclusionSortId(tempReportTypeVOList);
        this.setReportTypeListOHExclusionForSortId(reportTypeList, sortId, tempReportTypeVOList);
    }

    protected void setReportTypeVOListForOHExclusionSortId(List<ReportTypeVO> tempReportTypeVOList) {
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.checkLineItemNumberAvailableForOHExclusion(budgetLineItem)) continue;
            ReportTypeVO reportTypeVO = new ReportTypeVO();
            reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
            reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
            tempReportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setReportTypeListOHExclusionForSortId(List<ReportType> reportTypeList, int sortId, List<ReportTypeVO> tempReportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetOHExclusionKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetOHExclusionKey)) continue;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String budgetOHExclusionTempKey = reportTypeVO1.getCostElementDesc();
                if (!budgetOHExclusionTempKey.equals(budgetOHExclusionKey)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)reportTypeVO1.getCalculatedCost());
            }
            reportTypeMap.put(budgetOHExclusionKey, reportTypeVO);
            ReportType reportType = ReportType.Factory.newInstance();
            reportType.setSortId(sortId);
            reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
            reportType.setCalculatedCost(calculatedCost.doubleValue());
            reportTypeList.add(reportType);
        }
    }

    protected void setReportTypeForBudgetLAExclusionsSortId3(List<ReportType> reportTypeList) {
        ArrayList tempReportTypeVOList = new ArrayList();
        this.setReportTypeVOListForLAExclusionSortId3(tempReportTypeVOList);
        this.setReportTypeList(reportTypeList, tempReportTypeVOList);
    }

    protected void setReportTypeVOListForLAExclusionSortId3(List<ReportTypeVO> tempReportTypeVOList) {
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem) || this.checkLineItemNumberAvailableForLAExclusion(budgetLineItem)) continue;
            ReportTypeVO tempReportTypeVO = new ReportTypeVO();
            tempReportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
            tempReportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
            tempReportTypeVOList.add(tempReportTypeVO);
        }
    }

    protected void setReportTypeList(List<ReportType> reportTypeList, List<ReportTypeVO> tempReportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetLAExclusionsKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetLAExclusionsKey)) continue;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String budgetLAExclusionTempKey = reportTypeVO1.getCostElementDesc();
                if (!budgetLAExclusionTempKey.equals(budgetLAExclusionsKey)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)reportTypeVO1.getCalculatedCost());
            }
            reportTypeMap.put(budgetLAExclusionsKey, reportTypeVO);
            ReportType reportType = ReportType.Factory.newInstance();
            reportType.setSortId(3);
            reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
            reportType.setCalculatedCost(calculatedCost.doubleValue());
            reportTypeList.add(reportType);
        }
    }

    private boolean checkLineItemNumberAvailableForLAExclusion(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !this.isLineItemCalAmountOfRateClassTypeLabAllocation(budgetLineItemCalcAmount) && !this.isLineItemCalAmountOfRateClassTypeLAWithEBVA(budgetLineItemCalcAmount) || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            availabe = true;
        }
        return availabe;
    }

    private boolean checkLineItemNumberAvailableForOHExclusion(BudgetLineItem budgetLineItem) {
        boolean availabe = false;
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount) || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            availabe = true;
        }
        return availabe;
    }

    protected String getCostElementDescription(BudgetLineItem budgetLineItem) {
        String costElementDesc = budgetLineItem.getCostElementBO().getDescription().concat(budgetLineItem.getLineItemDescription() == null ? EMPTY_STRING : STRING_SEPRATOR.concat(budgetLineItem.getLineItemDescription()));
        return costElementDesc;
    }

    private SubReportType getBudgetOHRateBaseForPeriod() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        List reportTypeList = this.getReportTypeListForBudgetOHRateAndBase(RateClassType.OVERHEAD.getRateClassType());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getBudgetEBRateBaseForPeriod() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        List reportTypeList = this.getReportTypeListForBudgetEBRateAndBase(RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetEBRateAndBase(String rateClassType) {
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    private SubReportType getBudgetLARateBaseForPeriod() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        List reportTypeList = this.getReportTypeListForBudgetLARateAndBase(RateClassType.LAB_ALLOCATION.getRateClassType());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetLARateAndBase(String rateClassType) {
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType, RateClassType.LA_SALARIES.getRateClassType());
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType, RateClassType.LA_SALARIES.getRateClassType());
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    private SubReportType getBudgetVacRateBaseForPeriod() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        List reportTypeList = this.getReportTypeListForBudgetVACRateAndBase(RateClassType.VACATION.getRateClassType());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetVACRateAndBase(String rateClassType) {
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected void setReportTypeMapFromReportTypeVOList(List<ReportTypeVO> tempReportTypeVOList, Map<String, ReportType> reportTypeMap) {
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String reportTypeKey = this.getKeyForRateBase(reportTypeVO);
            if (reportTypeMap.containsKey(reportTypeKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : tempReportTypeVOList) {
                String reportTypeTempKey = this.getKeyForRateBase(tempReportTypeVO);
                if (!reportTypeTempKey.equals(reportTypeKey)) continue;
                salaryRequested = (BudgetDecimal)salaryRequested.add((AbstractKualiDecimal)tempReportTypeVO.getSalaryRequested());
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)tempReportTypeVO.getCalculatedCost());
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (!endDate.before(tempReportTypeVO.getEndDate())) continue;
                endDate = tempReportTypeVO.getEndDate();
            }
            ReportType reportType = this.getReportTypeForRateAndBase(startDate, endDate, calculatedCost, salaryRequested, reportTypeVO);
            reportTypeMap.put(reportTypeKey, reportType);
        }
    }

    private ReportType getReportTypeForRateAndBase(Date startDate, Date endDate, BudgetDecimal calculatedCost, BudgetDecimal salaryRequested, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setSalaryRequested(salaryRequested.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT));
        reportType.setAppliedRate(reportTypeVO.getAppliedRate().doubleValue());
        reportType.setRateClassDesc(reportTypeVO.getRateClassDesc());
        reportType.setRateTypeDesc(reportTypeVO.getRateTypeDesc());
        reportType.setOnOffCampus(reportTypeVO.getOnOffCampusFlag().booleanValue());
        return reportType;
    }

    private SubReportType getBudgetOtherRateBaseForPeriod() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        List reportTypeList = this.getReportTypeListForBudgetOtherRateAndBase(RateClassType.OTHER.getRateClassType());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetOtherRateAndBase(String rateClassType) {
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected List<ReportType> getReportTypeListForBudgetOHRateAndBase(String rateClassType) {
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
        }
        this.setReportTypeMapForBudgetOHRateAndBase(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected void setReportTypeMapForBudgetOHRateAndBase(List<ReportTypeVO> tempReportTypeVOList, Map<String, ReportType> reportTypeMap) {
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetOHRateBaseKey = this.getKeyForBudgetOHRateBase(reportTypeVO);
            if (reportTypeMap.containsKey(budgetOHRateBaseKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : tempReportTypeVOList) {
                String budgetOHRateBaseTempKey = this.getKeyForBudgetOHRateBase(tempReportTypeVO);
                if (!budgetOHRateBaseTempKey.equals(budgetOHRateBaseKey)) continue;
                salaryRequested = (BudgetDecimal)salaryRequested.add((AbstractKualiDecimal)(tempReportTypeVO.getSalaryRequested() == null ? BudgetDecimal.ZERO : tempReportTypeVO.getSalaryRequested()));
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)tempReportTypeVO.getCalculatedCost());
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (!endDate.before(tempReportTypeVO.getEndDate())) continue;
                endDate = tempReportTypeVO.getEndDate();
            }
            ReportType reportType = this.getReportTypeForBudgetOHRateAndBase(startDate, endDate, calculatedCost, salaryRequested, reportTypeVO);
            reportTypeMap.put(budgetOHRateBaseKey, reportType);
        }
    }

    private ReportType getReportTypeForBudgetOHRateAndBase(Date startDate, Date endDate, BudgetDecimal calculatedCost, BudgetDecimal salaryRequested, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setSalaryRequested(salaryRequested.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT));
        reportType.setAppliedRate(reportTypeVO.getAppliedRate().doubleValue());
        reportType.setRateClassDesc(reportTypeVO.getRateClassDesc());
        reportType.setOnOffCampus(reportTypeVO.getOnOffCampusFlag().booleanValue());
        return reportType;
    }

    private String getKeyForRateBase(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getRateClassDesc()).append(reportTypeVO.getRateTypeDesc()).append(reportTypeVO.getOnOffCampusFlag().toString()).append(reportTypeVO.getAppliedRate().toString());
        return key.toString();
    }

    private String getKeyForBudgetOHRateBase(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getOnOffCampusFlag().toString()).append(reportTypeVO.getAppliedRate().toString()).append(reportTypeVO.getRateClassDesc());
        return key.toString();
    }

    protected void setBudgetRateAndBaseListForBudgetOtherRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || laRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            laRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetVacRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetRateAndBase> vacBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || budgetRateAndBase.getRateClass().getRateClassType().equals(this.getLiVacOnLaRateTypeCode()) || vacBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            vacBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetLARateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType1, String rateClassType2) {
        HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType1) && !budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType2) || laRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            laRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    private String getBudgetRateAndBaseKey(BudgetRateAndBase budgetRateAndBase) {
        String key = budgetRateAndBase.getStartDate().toString() + budgetRateAndBase.getEndDate().toString() + budgetRateAndBase.getRateTypeCode() + budgetRateAndBase.getRateClassCode();
        return key;
    }

    protected void setBudgetRateAndBaseListForBudgetEBRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetRateAndBase> ebBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || budgetRateAndBase.getRateClass().getRateClassType().equals(this.getLiEbOnLaRateTypeCode()) || ebBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            ebBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetOHRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetRateAndBase> ohBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || ohBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseListForBudgetOHRateBase(budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            ohBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    private ReportTypeVO getBudgetRateAndBaseList(BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetRateAndBase.getRateClass().getDescription());
        reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetRateAndBase.getRateClassCode(), budgetRateAndBase.getRateTypeCode()));
        reportTypeVO.setStartDate(budgetRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetRateAndBase.getAppliedRate());
        reportTypeVO.setSalaryRequested(budgetRateAndBase.getBaseCost());
        reportTypeVO.setCalculatedCost(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setOnOffCampusFlag(budgetRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    private ReportTypeVO getBudgetRateAndBaseListForBudgetOHRateBase(BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetRateAndBase.getRateClass().getDescription());
        reportTypeVO.setStartDate(budgetRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetRateAndBase.getAppliedRate());
        reportTypeVO.setSalaryRequested(budgetRateAndBase.getBaseCost());
        reportTypeVO.setCalculatedCost(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setOnOffCampusFlag(budgetRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    protected void setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetPersonnelRateAndBase> otherBudgetPersRateBaseMap = new HashMap<String, BudgetPersonnelRateAndBase>();
        for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            for (BudgetPersonnelRateAndBase budgetPersRateAndBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
                String budgetPersRateBaseKey;
                budgetPersRateAndBase.refreshNonUpdateableReferences();
                if (budgetPersRateAndBase.getRateClass() == null || !rateClassType.equals(budgetPersRateAndBase.getRateClass().getRateClassType()) || otherBudgetPersRateBaseMap.containsKey(budgetPersRateBaseKey = this.getBudgetPersRateAndBaseKey(budgetPersRateAndBase))) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetPersRateAndBase);
                reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
                reportTypeVOList.add(reportTypeVO);
                otherBudgetPersRateBaseMap.put(budgetPersRateBaseKey, budgetPersRateAndBase);
            }
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetVacRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetPersonnelRateAndBase> vacBudgetPersRateBaseMap = new HashMap<String, BudgetPersonnelRateAndBase>();
        for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            for (BudgetPersonnelRateAndBase budgetPersRateAndBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
                String budgetPersRateBaseKey;
                budgetPersRateAndBase.refreshNonUpdateableReferences();
                if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassType() == null || !budgetPersRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || vacBudgetPersRateBaseMap.containsKey(budgetPersRateBaseKey = this.getBudgetPersRateAndBaseKey(budgetPersRateAndBase))) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetPersRateAndBase);
                reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
                reportTypeVOList.add(reportTypeVO);
                vacBudgetPersRateBaseMap.put(budgetPersRateBaseKey, budgetPersRateAndBase);
            }
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetLARateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType1, String rateClassType2) {
        HashMap<String, BudgetPersonnelRateAndBase> laRateBaseMap = new HashMap<String, BudgetPersonnelRateAndBase>();
        for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            for (BudgetPersonnelRateAndBase budgetPersRateAndBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
                String budgetPersRateBaseKey;
                budgetPersRateAndBase.refreshNonUpdateableReferences();
                if (budgetPersRateAndBase.getRateClass() == null || !rateClassType1.equals(budgetPersRateAndBase.getRateClass().getRateClassType()) && !rateClassType2.equals(budgetPersRateAndBase.getRateClass().getRateClassType()) || laRateBaseMap.containsKey(budgetPersRateBaseKey = this.getBudgetPersRateAndBaseKey(budgetPersRateAndBase))) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetPersRateAndBase);
                reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
                reportTypeVOList.add(reportTypeVO);
                laRateBaseMap.put(budgetPersRateBaseKey, budgetPersRateAndBase);
            }
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetEBRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetPersonnelRateAndBase> ebBudgetPersRateBaseMap = new HashMap<String, BudgetPersonnelRateAndBase>();
        for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            for (BudgetPersonnelRateAndBase budgetPersRateAndBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
                String budgetPersRateBaseKey;
                budgetPersRateAndBase.refreshNonUpdateableReferences();
                if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassType() == null || !budgetPersRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || ebBudgetPersRateBaseMap.containsKey(budgetPersRateBaseKey = this.getBudgetPersRateAndBaseKey(budgetPersRateAndBase))) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetPersRateAndBase);
                reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
                reportTypeVOList.add(reportTypeVO);
                ebBudgetPersRateBaseMap.put(budgetPersRateBaseKey, budgetPersRateAndBase);
            }
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetOHRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, String rateClassType) {
        HashMap<String, BudgetPersonnelRateAndBase> ohBudgetPersRateBaseMap = new HashMap<String, BudgetPersonnelRateAndBase>();
        for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            for (BudgetPersonnelRateAndBase budgetPersRateAndBase : budgetPersDetails.getBudgetPersonnelRateAndBaseList()) {
                String budgetPersRateBaseKey;
                budgetPersRateAndBase.refreshNonUpdateableReferences();
                if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassType() == null || !budgetPersRateAndBase.getRateClass().getRateClassType().equals(rateClassType) || ohBudgetPersRateBaseMap.containsKey(budgetPersRateBaseKey = this.getBudgetPersRateAndBaseKey(budgetPersRateAndBase))) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetPersRateAndBase);
                reportTypeVOList.add(reportTypeVO);
                ohBudgetPersRateBaseMap.put(budgetPersRateBaseKey, budgetPersRateAndBase);
            }
        }
    }

    private String getBudgetPersRateAndBaseKey(BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        String key = budgetPersRateAndBase.getStartDate().toString() + budgetPersRateAndBase.getEndDate().toString() + budgetPersRateAndBase.getRateTypeCode() + budgetPersRateAndBase.getRateClassCode();
        return key;
    }

    private ReportTypeVO getReportTypeVOForBudgetPersonnelRateAndBase(BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetPersRateAndBase.getRateClass().getDescription());
        reportTypeVO.setStartDate(budgetPersRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetPersRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetPersRateAndBase.getAppliedRate());
        reportTypeVO.setSalaryRequested(budgetPersRateAndBase.getSalaryRequested());
        reportTypeVO.setCalculatedCost(budgetPersRateAndBase.getCalculatedCost());
        reportTypeVO.setOnOffCampusFlag(budgetPersRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    protected String getBudgetCategoryDescForSalarySummary(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, AbstractBudgetRateAndBase budgetRateAndBase) {
        budgetDetails.refreshReferenceObject("costElementBO");
        budgetLineItem.refreshReferenceObject("budgetCategory");
        String category = null;
        if (budgetRateAndBase != null && this.isRateAndBaseLASalary(budgetRateAndBase)) {
            category = LAB_ALLOCATION;
        } else if (budgetLineItem.getBudgetCategory() != null) {
            category = budgetLineItem.getBudgetCategory().getDescription();
        } else if (budgetDetails.getCostElementBO() != null && budgetDetails.getCostElementBO().getBudgetCategory() != null) {
            category = budgetDetails.getCostElementBO().getBudgetCategory().getDescription();
        }
        return category;
    }

    protected BudgetDecimal getFringeForBudgetSalarySummaryFromPersonnelRateAndBase(AbstractBudgetRateAndBase budgetPersRateAndBase) {
        BudgetDecimal fringeCostSharing = BudgetDecimal.ZERO;
        if (this.isRateAndBaseOfRateClassTypeEB(budgetPersRateAndBase) || this.isRateAndBaseOfRateClassTypeVacation(budgetPersRateAndBase)) {
            fringeCostSharing = budgetPersRateAndBase.getCalculatedCost();
        }
        return fringeCostSharing;
    }

    private BudgetDecimal getFringeForLASalaryForRateAndBase(BudgetLineItem budgetLineItem, Date startDate, Date endDate) {
        BudgetDecimal fringe = BudgetDecimal.ZERO;
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getStartDate().equals(startDate) || !budgetRateAndBase.getEndDate().equals(endDate) || budgetRateAndBase.getCalculatedCost() == null || !this.isRateAndBaseEBonLA((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseVAonLA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
            fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCost());
        }
        return fringe;
    }

    private BudgetDecimal getFringeCostSharingLASalaryRateAndBase(BudgetLineItem budgetLineItem, Date startDate, Date endDate) {
        BudgetDecimal fringeCostSharing = BudgetDecimal.ZERO;
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getStartDate().equals(startDate) || !budgetRateAndBase.getEndDate().equals(endDate) || budgetRateAndBase.getCalculatedCostSharing() == null || !this.isRateAndBaseEBonLA((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseVAonLA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
            fringeCostSharing = (BudgetDecimal)fringeCostSharing.add((AbstractKualiDecimal)budgetRateAndBase.getCalculatedCostSharing());
        }
        return fringeCostSharing;
    }

    protected Integer getInvestigatorFlag(BudgetPersonnelDetails budgetPersonDetails) {
        Integer flag = 3;
        String personId = budgetPersonDetails.getPersonId();
        flag = this.budget.getBudgetParent().getParentInvestigatorFlag(personId, flag);
        return flag;
    }

    protected BudgetDecimal getVacationAppliedRateForPersonnel(AbstractBudgetRateAndBase budgetPersRateAndBase) {
        BudgetDecimal appliedRate = BudgetDecimal.ZERO;
        if (this.isRateAndBaseOfRateClassTypeVacation(budgetPersRateAndBase)) {
            appliedRate = budgetPersRateAndBase.getAppliedRate();
        }
        return appliedRate;
    }

    protected BudgetDecimal getEmpBenefitAppliedRateForPersonnel(AbstractBudgetRateAndBase budgetPersRateAndBase) {
        BudgetDecimal appliedRate = BudgetDecimal.ZERO;
        if (this.isRateAndBaseOfRateClassTypeEB(budgetPersRateAndBase)) {
            appliedRate = budgetPersRateAndBase.getAppliedRate();
        }
        return appliedRate;
    }

    protected String getKeyForBudgetSalarySummary(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getStartDate().toString()).append(reportTypeVO.getEndDate().toString()).append(reportTypeVO.getPersonName()).append(reportTypeVO.getInvestigatorFlag().toString()).append(reportTypeVO.getBudgetCategoryCode()).append(reportTypeVO.getBudgetCategoryDesc()).append(reportTypeVO.getSalaryRequested());
        return key.toString();
    }

    protected String getPersonNameFromBudgetPersonByRateAndBase(BudgetPerson budgetPerson, BudgetPersonnelRateAndBase budgetPersRateAndBase, Integer quantity) {
        String personName = EMPTY_STRING;
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary((AbstractBudgetRateAndBase)budgetPersRateAndBase)) {
            personName = ALLOCATED_ADMIN_SUPPORT;
        } else if (budgetPerson != null) {
            if (budgetPerson.getPersonId() == null && budgetPerson.getRolodexId() == null) {
                StringBuilder pNmae = new StringBuilder();
                personName = pNmae.append(budgetPerson.getPersonName()).append(OPEN_BRACES).append(quantity.toString()).append(CLOSE_BRACES).toString();
            } else {
                personName = budgetPerson.getPersonName();
            }
        }
        return personName;
    }

    protected BudgetDecimal getPercentEffortForBudgetPersonnelRateBase(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersDetails, BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        BudgetDecimal percentEffort = BudgetDecimal.ZERO;
        Integer personNumber = budgetPersDetails.getPersonNumber();
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary((AbstractBudgetRateAndBase)budgetPersRateAndBase)) {
            percentEffort = new BudgetDecimal(100);
        } else {
            for (BudgetPersonnelDetails budgetPersDetail : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!budgetPersDetail.getPersonNumber().equals(personNumber) || budgetPersDetails.getPercentEffort() == null) continue;
                percentEffort = (BudgetDecimal)percentEffort.add((AbstractKualiDecimal)budgetPersDetail.getPercentEffort());
            }
        }
        return percentEffort;
    }

    protected BudgetDecimal getPercentChargedForBudgetPersonnelRateBase(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersDetails, BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        BudgetDecimal percentCharged = BudgetDecimal.ZERO;
        Integer personNumber = budgetPersDetails.getPersonNumber();
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary((AbstractBudgetRateAndBase)budgetPersRateAndBase)) {
            percentCharged = new BudgetDecimal(100);
        } else {
            for (BudgetPersonnelDetails budgetPersDetail : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!budgetPersDetail.getPersonNumber().equals(personNumber) || budgetPersDetails.getPercentEffort() == null) continue;
                percentCharged = (BudgetDecimal)percentCharged.add((AbstractKualiDecimal)budgetPersDetail.getPercentCharged());
            }
        }
        return percentCharged;
    }

    protected String getBudgetCategoryCodeFroBudgetSalarySummary(AbstractBudgetRateAndBase budgetPersRateAndBase, BudgetLineItemBase budgetPersonnelDetails) {
        String categoryCode = null;
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary(budgetPersRateAndBase)) {
            categoryCode = CATEGORY_CODE_LA_SALARY;
        } else if (budgetPersonnelDetails.getCostElementBO() != null && budgetPersonnelDetails.getCostElementBO().getBudgetCategory() != null) {
            categoryCode = budgetPersonnelDetails.getCostElementBO().getBudgetCategory().getBudgetCategoryCode();
        }
        return categoryCode;
    }

    protected boolean isBudgetCategoryPersonnel(BudgetLineItemBase budgetDetails) {
        budgetDetails.refreshNonUpdateableReferences();
        return budgetDetails.getBudgetCategory() != null && BUDGET_CATEGORY_PERSONNEL.equals(budgetDetails.getBudgetCategory().getBudgetCategoryTypeCode());
    }

    protected boolean isRateAndBaseLASalary(AbstractBudgetRateAndBase rateAndBase) {
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass().getRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType());
    }

    protected boolean isRateAndBaseEBonLA(AbstractBudgetRateAndBase rateAndBase) {
        ValidCalcType ebOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        return ebOnLaValidCalcType != null && rateAndBase.getRateClassCode().equals(ebOnLaValidCalcType.getRateClassCode()) && rateAndBase.getRateTypeCode().equals(ebOnLaValidCalcType.getRateTypeCode());
    }

    private ValidCalcType getDependentValidRateClassTypeForLA(String rateClassType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(RATE_CLASS_TYPE, rateClassType);
        param.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        List result = (List)this.getBusinessObjectService().findMatching(ValidCalcType.class, param);
        return result.isEmpty() ? null : (ValidCalcType)result.get(0);
    }

    protected boolean isRateAndBaseVAonLA(AbstractBudgetRateAndBase rateAndBase) {
        ValidCalcType vacationOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(RateClassType.VACATION.getRateClassType());
        return vacationOnLaValidCalcType != null && rateAndBase.getRateClassCode().equals(vacationOnLaValidCalcType.getRateClassCode()) && rateAndBase.getRateTypeCode().equals(vacationOnLaValidCalcType.getRateTypeCode());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeLAWithEBVA(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeLabAllocation(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassType().equals(RateClassType.LAB_ALLOCATION.getRateClassType());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeOverhead(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType());
    }

    protected boolean isRateAndBaseOfRateClassTypeLAwithEBVA(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassType().equals(RateClassType.LA_SALARIES.getRateClassType());
        }
        return status;
    }

    protected boolean isRateAndBaseOfRateClassTypeEB(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassType().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        }
        return status;
    }

    protected boolean isRateAndBaseOfRateClassTypeOverhead(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType());
        }
        return status;
    }

    protected boolean isRateAndBaseOfRateClassTypeVacation(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassType().equals(RateClassType.VACATION.getRateClassType());
        }
        return status;
    }

    protected List<ReportTypeVO> getReportTypeVOList(BudgetPeriod budgetPeriod) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            if (!StringUtils.equals((String)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (String)BUDGET_CATEGORY_PERSONNEL)) continue;
            if (!budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) {
                for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    this.addReportTypeVO(reportTypeVOList, budgetLineItem, (BudgetLineItemBase)budgetPersDetails, this.getRatesApplicableToVOList(budgetPersDetails.getBudgetPersonnelRateAndBaseList()));
                }
                continue;
            }
            this.addReportTypeVO(reportTypeVOList, budgetLineItem, (BudgetLineItemBase)budgetLineItem, this.getRatesApplicableToVOList(budgetLineItem.getBudgetRateAndBaseList()));
        }
        return reportTypeVOList;
    }

    private void addReportTypeVO(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, List<? extends AbstractBudgetRateAndBase> rates) {
        List fringeRates = this.getVAAndEBRates(rates);
        if (fringeRates != null && !fringeRates.isEmpty()) {
            for (AbstractBudgetRateAndBase rate : fringeRates) {
                ReportTypeVO reportTypeVO = this.getReportTypeVO(budgetLineItem, budgetDetails, rate);
                reportTypeVOList.add(reportTypeVO);
            }
        } else {
            ReportTypeVO reportTypeVO = this.getReportTypeVO(budgetLineItem, budgetDetails);
            reportTypeVOList.add(reportTypeVO);
        }
    }

    private List<AbstractBudgetRateAndBase> getVAAndEBRates(List<? extends AbstractBudgetRateAndBase> rates) {
        ArrayList<AbstractBudgetRateAndBase> result = new ArrayList<AbstractBudgetRateAndBase>();
        for (AbstractBudgetRateAndBase abstractBudgetRateAndBase : rates) {
            if (this.isRateAndBaseEBonLA(abstractBudgetRateAndBase) || this.isRateAndBaseVAonLA(abstractBudgetRateAndBase) || this.isRateAndBaseLASalary(abstractBudgetRateAndBase) || !this.isRateAndBaseOfRateClassTypeEB(abstractBudgetRateAndBase) && !this.isRateAndBaseOfRateClassTypeVacation(abstractBudgetRateAndBase)) continue;
            result.add(abstractBudgetRateAndBase);
        }
        return result;
    }

    protected List<AbstractBudgetRateAndBase> getRatesApplicableToVOList(List<? extends AbstractBudgetRateAndBase> rates) {
        return this.getVAAndEBRates(rates);
    }

    private ReportTypeVO getReportTypeVO(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, AbstractBudgetRateAndBase rate) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        budgetDetails.refreshNonUpdateableReferences();
        reportTypeVO.setStartDate(rate.getStartDate());
        reportTypeVO.setEndDate(rate.getEndDate());
        reportTypeVO.setBudgetCategoryDesc(this.getBudgetCategoryDescForSalarySummary(budgetLineItem, budgetDetails, rate));
        if (budgetDetails instanceof BudgetPersonnelDetails) {
            BudgetPersonnelDetails budgetPersDetails = (BudgetPersonnelDetails)budgetDetails;
            BudgetPersonnelRateAndBase budgetPersRateAndBase = (BudgetPersonnelRateAndBase)rate;
            reportTypeVO.setPersonName(this.getPersonNameFromBudgetPersonByRateAndBase(budgetPersDetails.getBudgetPerson(), budgetPersRateAndBase, budgetLineItem.getQuantity()));
            reportTypeVO.setPercentEffort(this.getPercentEffortForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, budgetPersRateAndBase));
            reportTypeVO.setPercentCharged(this.getPercentChargedForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, budgetPersRateAndBase));
            reportTypeVO.setInvestigatorFlag(this.getInvestigatorFlag(budgetPersDetails));
            reportTypeVO.setSalaryRequested(budgetPersRateAndBase.getSalaryRequested());
        } else {
            BudgetRateAndBase budgetRate = (BudgetRateAndBase)rate;
            reportTypeVO.setPersonName(PERSONNEL_SUMMARY_LINE_ITEM_NAME);
            reportTypeVO.setInvestigatorFlag(Integer.valueOf(3));
            reportTypeVO.setSalaryRequested(budgetRate.getBaseCost());
        }
        if (this.isRateAndBaseOfRateClassTypeVacation(rate)) {
            reportTypeVO.setVacationRate(rate.getAppliedRate());
        } else {
            reportTypeVO.setVacationRate(BudgetDecimal.ZERO);
        }
        if (this.isRateAndBaseOfRateClassTypeEB(rate)) {
            reportTypeVO.setEmployeeBenefitRate(rate.getAppliedRate());
        } else {
            reportTypeVO.setEmployeeBenefitRate(BudgetDecimal.ZERO);
        }
        reportTypeVO.setCostSharingAmount(rate.getBaseCostSharing());
        reportTypeVO.setCalculatedCost(rate.getCalculatedCostSharing());
        reportTypeVO.setFringe(rate.getCalculatedCost());
        reportTypeVO.setCostElementDesc(budgetDetails.getCostElementBO().getDescription());
        reportTypeVO.setBudgetCategoryCode(this.getBudgetCategoryCodeFroBudgetSalarySummary(rate, budgetDetails));
        return reportTypeVO;
    }

    private ReportTypeVO getReportTypeVO(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        budgetDetails.refreshNonUpdateableReferences();
        reportTypeVO.setStartDate(budgetDetails.getStartDate());
        reportTypeVO.setEndDate(budgetDetails.getEndDate());
        reportTypeVO.setBudgetCategoryDesc(this.getBudgetCategoryDescForSalarySummary(budgetLineItem, budgetDetails, null));
        if (budgetDetails instanceof BudgetPersonnelDetails) {
            BudgetPersonnelDetails budgetPersDetails = (BudgetPersonnelDetails)budgetDetails;
            reportTypeVO.setPersonName(this.getPersonNameFromBudgetPersonByRateAndBase(budgetPersDetails.getBudgetPerson(), null, budgetLineItem.getQuantity()));
            reportTypeVO.setPercentEffort(this.getPercentEffortForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, null));
            reportTypeVO.setPercentCharged(this.getPercentChargedForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, null));
            reportTypeVO.setInvestigatorFlag(this.getInvestigatorFlag(budgetPersDetails));
            reportTypeVO.setSalaryRequested(budgetPersDetails.getSalaryRequested());
        } else {
            reportTypeVO.setPersonName(PERSONNEL_SUMMARY_LINE_ITEM_NAME);
            reportTypeVO.setInvestigatorFlag(Integer.valueOf(3));
            reportTypeVO.setSalaryRequested(budgetLineItem.getLineItemCost());
        }
        reportTypeVO.setVacationRate(BudgetDecimal.ZERO);
        reportTypeVO.setEmployeeBenefitRate(BudgetDecimal.ZERO);
        reportTypeVO.setCostSharingAmount(budgetDetails.getCostSharingAmount());
        reportTypeVO.setCalculatedCost(budgetDetails.getCostSharingAmount());
        reportTypeVO.setFringe(BudgetDecimal.ZERO);
        reportTypeVO.setCostElementDesc(budgetDetails.getCostElementBO().getDescription());
        reportTypeVO.setBudgetCategoryCode(this.getBudgetCategoryCodeFroBudgetSalarySummary(null, budgetDetails));
        return reportTypeVO;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

