/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetSummaryReportDocument;
import noNamespace.ReportHeaderType;
import noNamespace.ReportPageType;
import noNamespace.ReportType;
import noNamespace.SubReportType;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemBase;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.util.ReportTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseStream;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class BudgetCumilativeXmlStream
extends BudgetBaseStream {
    private static final String CUMULATIVE_BUDGET = "Cumulative Budget";

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        this.budget = (Budget)printableBusinessObject;
        if (this.budget != null) {
            BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
            BudgetSummaryReportDocument budgetSummaryReportDocument = BudgetSummaryReportDocument.Factory.newInstance();
            budgetSummaryReport = this.getBudgetCumulativeReport();
            budgetSummaryReportDocument.setBudgetSummaryReport(budgetSummaryReport);
            xmlObjectList.put(CUMULATIVE_BUDGET, (XmlObject)budgetSummaryReportDocument);
        }
        return xmlObjectList;
    }

    private BudgetSummaryReportDocument.BudgetSummaryReport getBudgetCumulativeReport() {
        BudgetSummaryReportDocument.BudgetSummaryReport budgetSummaryReport = BudgetSummaryReportDocument.BudgetSummaryReport.Factory.newInstance();
        ReportPageType cumulativePageType = ReportPageType.Factory.newInstance();
        BudgetParent budgetParent = this.budget.getBudgetParent();
        ReportHeaderType reportHeaderType = this.getReportHeaderTypeForCumulativeReport(budgetParent);
        budgetSummaryReport.setReportHeader(reportHeaderType);
        cumulativePageType = this.getCumulativeBudgetReportPageType();
        budgetSummaryReport.setCumilativePage(cumulativePageType);
        ReportPageType[] reportPageTypeArray = this.getReportPageTypes();
        budgetSummaryReport.setReportPageArray(reportPageTypeArray);
        return budgetSummaryReport;
    }

    protected ReportHeaderType getReportHeaderTypeForCumulativeReport(BudgetParent budgetParent) {
        String principleInvestigatorName;
        ReportHeaderType reportHeaderType = ReportHeaderType.Factory.newInstance();
        if (budgetParent != null) {
            reportHeaderType.setParentTypeName(budgetParent.getParentTypeName());
            reportHeaderType.setProposalNumber(budgetParent.getParentNumber());
        }
        if (budgetParent != null && budgetParent.getParentTitle() != null) {
            reportHeaderType.setProposalTitle(budgetParent.getParentTitle());
        }
        if ((principleInvestigatorName = budgetParent.getParentPIName()) != null) {
            reportHeaderType.setPIName(principleInvestigatorName);
        }
        if (this.budget.getVersionNumber() != null) {
            reportHeaderType.setBudgetVersion(this.budget.getBudgetVersionNumber().intValue());
        }
        if (this.budget.getStartDate() != null) {
            reportHeaderType.setPeriodStartDate(DateFormatUtils.format((java.util.Date)this.budget.getStartDate(), (String)"dd MMM yyyy"));
        }
        if (this.budget.getEndDate() != null) {
            reportHeaderType.setPeriodEndDate(DateFormatUtils.format((java.util.Date)this.budget.getEndDate(), (String)"dd MMM yyyy"));
        }
        reportHeaderType.setCreateDate(this.dateTimeService.getCurrentDate().toString());
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            reportHeaderType.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
        return reportHeaderType;
    }

    private ReportPageType[] getReportPageTypes() {
        ArrayList<ReportPageType> reportPageTypeList = new ArrayList<ReportPageType>();
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        reportPageType = this.getCumulativeBudgetReportPageType();
        reportPageTypeList.add(reportPageType);
        return reportPageTypeList.toArray(new ReportPageType[0]);
    }

    private ReportPageType getCumulativeBudgetReportPageType() {
        ReportPageType reportPageType = ReportPageType.Factory.newInstance();
        ReportPageType.BudgetSummary budgetSummary = this.getCumulativeBudget();
        ReportPageType.CalculationMethodology calculationMethodology = this.getCumulativeCalculationMethodology();
        reportPageType.setBudgetSummary(budgetSummary);
        reportPageType.setCalculationMethodology(calculationMethodology);
        reportPageType.setPeriod(this.budgetPeriod.getBudgetPeriod().intValue());
        return reportPageType;
    }

    private ReportPageType.BudgetSummary getCumulativeBudget() {
        ReportPageType.BudgetSummary budgetSummary = ReportPageType.BudgetSummary.Factory.newInstance();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        subReportType = this.getCumulativeSalarySummary();
        budgetSummary.setSalarySummaryFromEDI(subReportType);
        subReportType = this.getBudgetCumulativeSummaryNonPersonnel();
        budgetSummary.setBudgetSummaryNonPersonnel(subReportType);
        subReportType = this.getBudgetCumulativeIDCForReport();
        budgetSummary.setBudgetIndirectCostsForReport(subReportType);
        budgetSummary.setTotalDirectCost(this.budget.getTotalDirectCost().doubleValue());
        budgetSummary.setTotalCostToSponsor(this.budget.getTotalCost().doubleValue());
        budgetSummary.setTotalUnderrecoveryAmount(this.budget.getUnderrecoveryAmount().doubleValue());
        budgetSummary.setTotalCostSharingAmount(this.budget.getCostSharingAmount().doubleValue());
        return budgetSummary;
    }

    private ReportPageType.CalculationMethodology getCumulativeCalculationMethodology() {
        ReportPageType.CalculationMethodology calculationMethodology = ReportPageType.CalculationMethodology.Factory.newInstance();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        subReportType = this.getCumulativeBudgetOHExclusions();
        calculationMethodology.setBudgetOHExclusions(subReportType);
        subReportType = this.getCumulativeBudgetLAExclusions();
        calculationMethodology.setBudgetLAExclusions(subReportType);
        subReportType = this.getCumulativeBudgetOHRateBase();
        calculationMethodology.setBudgetOHRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetEBRateBase();
        calculationMethodology.setBudgetEBRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetLARateBase();
        calculationMethodology.setBudgetLARateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetVacRateBase();
        calculationMethodology.setBudgetVacRateBaseForPeriod(subReportType);
        subReportType = this.getCumulativeBudgetOtherRateBase();
        calculationMethodology.setBudgetOtherRateBaseForPeriod(subReportType);
        return calculationMethodology;
    }

    private SubReportType getCumulativeSalarySummary() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList reportTypeList = new ArrayList();
        this.setReportTypeForCumulativeBudgetSalary(reportTypeList);
        this.setBudgetLASalaryForBudgetRateAndBaseForCumulativeReport(reportTypeList);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForCumulativeBudgetSalary(List<ReportType> reportTypeList) {
        ArrayList reportTypeVOList = new ArrayList();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            reportTypeVOList.addAll(this.getReportTypeVOList(budgetPeriod));
        }
        this.setReportTypeListFromReportTypeVoListForCumulativeBudgetSalary(reportTypeList, reportTypeVOList);
    }

    private void setBudgetLASalaryForBudgetRateAndBaseForCumulativeReport(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
                for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                    if (!this.isRateAndBaseOfRateClassTypeLAwithEBVA((AbstractBudgetRateAndBase)budgetRateAndBase)) continue;
                    Date startDate = budgetRateAndBase.getStartDate();
                    Date endDate = budgetRateAndBase.getEndDate();
                    String key = startDate.toString() + endDate.toString();
                    if (laRateBaseMap.containsKey(key)) continue;
                    ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
                    reportTypeVOList.add(reportTypeVO);
                    laRateBaseMap.put(key, budgetRateAndBase);
                }
            }
        }
        this.setReportTypeBudgetLASalary(reportTypeList, reportTypeVOList);
    }

    private void setReportTypeListFromReportTypeVoListForCumulativeBudgetSalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String cumulativeBudgetSalaryKey = this.getKeyForBudgetSalarySummary(reportTypeVO);
            if (reportTypeMap.containsKey(cumulativeBudgetSalaryKey)) continue;
            BudgetDecimal vacationRate = BudgetDecimal.ZERO;
            BudgetDecimal empBenefitRate = BudgetDecimal.ZERO;
            BudgetDecimal fringe = BudgetDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String cumulativeBudgetSalaryTempKey = this.getKeyForBudgetSalarySummary(tempReportTypeVO);
                if (!cumulativeBudgetSalaryTempKey.equals(cumulativeBudgetSalaryKey)) continue;
                if (vacationRate.isLessThan((AbstractKualiDecimal)tempReportTypeVO.getVacationRate())) {
                    vacationRate = tempReportTypeVO.getVacationRate();
                }
                if (empBenefitRate.isLessThan((AbstractKualiDecimal)tempReportTypeVO.getEmployeeBenefitRate())) {
                    empBenefitRate = tempReportTypeVO.getEmployeeBenefitRate();
                }
                fringe = (BudgetDecimal)fringe.add((AbstractKualiDecimal)tempReportTypeVO.getFringe());
            }
            ReportType reportType = this.getReportTypeForCumulativeBudgetSalary(vacationRate, empBenefitRate, fringe, reportTypeVO);
            reportTypeMap.put(cumulativeBudgetSalaryKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForCumulativeBudgetSalary(BudgetDecimal vacationRate, BudgetDecimal empBenefitRate, BudgetDecimal fringe, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setStartDate(reportTypeVO.getStartDate().toString());
        reportType.setEndDate(reportTypeVO.getEndDate().toString());
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setPersonName(reportTypeVO.getPersonName());
        reportType.setVacationRate(vacationRate.toString().concat("%"));
        reportType.setEmployeeBenefitRate(empBenefitRate.toString().concat("%"));
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setInvestigatorFlag(reportTypeVO.getInvestigatorFlag().intValue());
        if (reportTypeVO.getBudgetCategoryCode() != null) {
            reportType.setBudgetCategoryCode(Integer.parseInt(reportTypeVO.getBudgetCategoryCode()));
        }
        reportType.setSalaryRequested(reportTypeVO.getSalaryRequested().doubleValue());
        return reportType;
    }

    private SubReportType getBudgetCumulativeSummaryNonPersonnel() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        String categoryDesc = "Other Direct Costs";
        String costElementDesc = "Allocated Lab Expense";
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            if (this.getUnitNumber() <= 0) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.LAB_ALLOCATION.getRateClassType(), budgetLineItem));
            }
        }
        ReportType reportType = this.getReportTypeForNonPersonnel(categoryDesc, costElementDesc, calculatedCost, null);
        reportTypeList.add(reportType);
        this.setReportTypeForBudgetCumulativeNonPersonnel(reportTypeList);
        Collections.sort(reportTypeList, new /* Unavailable Anonymous Inner Class!! */);
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.category));
        return subReportType;
    }

    private void setReportTypeForBudgetCumulativeNonPersonnel(List<ReportType> reportTypeList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                ReportTypeVO tempReportTypeVO = this.getReportTypeVOForBudgetCumulativeNonPersonnel(budgetLineItem);
                tempReportTypeVOList.add(tempReportTypeVO);
            }
        }
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String cumulativeNonPersKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(cumulativeNonPersKey)) continue;
            BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String cumulativeNonPersTempKey = reportTypeVO1.getCostElementDesc();
                if (!cumulativeNonPersTempKey.equals(cumulativeNonPersKey)) continue;
                calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)reportTypeVO1.getCalculatedCost());
            }
            ReportType reportType = this.getReportTypeForBudgetCumulativeNonPersonnel(calculatedCost, reportTypeVO);
            reportTypeMap.put(cumulativeNonPersKey, reportTypeVO);
            reportTypeList.add(reportType);
        }
    }

    private ReportType getReportTypeForBudgetCumulativeNonPersonnel(BudgetDecimal calculatedCost, ReportTypeVO reportTypeVO) {
        ReportType reportType = ReportType.Factory.newInstance();
        reportType.setBudgetCategoryDescription(reportTypeVO.getBudgetCategoryDesc());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        return reportType;
    }

    private ReportTypeVO getReportTypeVOForBudgetCumulativeNonPersonnel(BudgetLineItem budgetLineItem) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setBudgetCategoryDesc(budgetLineItem.getBudgetCategory().getDescription());
        reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
        reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
        return reportTypeVO;
    }

    private SubReportType getBudgetCumulativeIDCForReport() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        BudgetDecimal calculatedCostForOn = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCostForOff = BudgetDecimal.ZERO;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getOnOffCampusFlag().booleanValue()) {
                    calculatedCostForOn = (BudgetDecimal)calculatedCostForOn.add((AbstractKualiDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
                    continue;
                }
                calculatedCostForOff = (BudgetDecimal)calculatedCostForOff.add((AbstractKualiDecimal)this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem));
            }
        }
        if (!calculatedCostForOn.equals((Object)BudgetDecimal.ZERO)) {
            ReportType reportTypeForOn = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.TRUE, calculatedCostForOn, null);
            reportTypeList.add(reportTypeForOn);
        }
        if (!calculatedCostForOff.equals((Object)BudgetDecimal.ZERO)) {
            ReportType reportTypeForOff = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.FALSE, calculatedCostForOff, null);
            reportTypeList.add(reportTypeForOff);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetOHExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String categoryDesc = null;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.budget.getBudgetLaRates().size() > 0) {
            int sortId = 1;
            categoryDesc = "Allocated Administrative Support";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = "Employee Benefits on Allocated Administrative Support";
            calculatedCost = this.getCalculatedCostForBudgetOHExclusionsSortId2ForCumulativeReport();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            sortId = 3;
            this.setReportTypeOHExclusionForSortIdForCumulativeReport(reportTypeList, sortId);
            sortId = 4;
            categoryDesc = "Allocated Lab Expense";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId4);
        } else {
            int sortId = 1;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private BudgetDecimal getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)this.getCalculatedCostForBudgetExclusionsSortId4());
        }
        return calculatedCost;
    }

    private void setReportTypeOHExclusionForSortIdForCumulativeReport(List<ReportType> reportTypeList, int sortId) {
        ArrayList tempReportTypeVOList = new ArrayList();
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            this.setReportTypeVOListForOHExclusionSortId(tempReportTypeVOList);
        }
        this.setReportTypeListOHExclusionForSortId(reportTypeList, sortId, tempReportTypeVOList);
    }

    private BudgetDecimal getCalculatedCostForBudgetOHExclusionsSortId2ForCumulativeReport() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)this.getCalculatedCostForBudgetOHExclusionsSortId2());
        }
        return calculatedCost;
    }

    private BudgetDecimal getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)this.getCalculatedCostForBudgetExclusionsSortId1());
        }
        return calculatedCost;
    }

    private SubReportType getCumulativeBudgetLAExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String categoryDesc = null;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        if (this.budget.getBudgetLaRates().size() > 0) {
            int sortId = 1;
            categoryDesc = "Allocated Administrative Support";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1ForCumulativeReport();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = "Total Employee Benefits";
            calculatedCost = this.getCalculatedCostForBudgetLAExclusionsSortId2ForCumulativeReport();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            this.setReportTypeForBudgetLAExclusionsSortId3ForCumulativeReport(reportTypeList);
            sortId = 4;
            categoryDesc = "Allocated Lab Expense";
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4ForCumulativeReport();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId4);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private void setReportTypeForBudgetLAExclusionsSortId3ForCumulativeReport(List<ReportType> reportTypeList) {
        ArrayList tempReportTypeVOList = new ArrayList();
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            this.setReportTypeVOListForLAExclusionSortId3(tempReportTypeVOList);
        }
        this.setReportTypeList(reportTypeList, tempReportTypeVOList);
    }

    private BudgetDecimal getCalculatedCostForBudgetLAExclusionsSortId2ForCumulativeReport() {
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        Iterator i$ = this.budget.getBudgetPeriods().iterator();
        while (i$.hasNext()) {
            BudgetPeriod budgetPeriod;
            this.budgetPeriod = budgetPeriod = (BudgetPeriod)i$.next();
            calculatedCost = (BudgetDecimal)calculatedCost.add((AbstractKualiDecimal)this.getCalculatedCostForBudgetLAExclusionsSortId2());
        }
        return calculatedCost;
    }

    private SubReportType getCumulativeBudgetOHRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String rateClassType = RateClassType.OVERHEAD.getRateClassType();
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            }
        }
        this.setReportTypeMapForBudgetOHRateAndBase(tempReportTypeVOList, reportTypeMap);
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetEBRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String rateClassType = RateClassType.EMPLOYEE_BENEFITS.getRateClassType();
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetLARateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String rateClassType = RateClassType.LAB_ALLOCATION.getRateClassType();
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType, RateClassType.LA_SALARIES.getRateClassType());
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType, RateClassType.LA_SALARIES.getRateClassType());
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetVacRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String rateClassType = RateClassType.VACATION.getRateClassType();
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    private SubReportType getCumulativeBudgetOtherRateBase() {
        SubReportType subReportType = SubReportType.Factory.newInstance();
        String rateClassType = RateClassType.OTHER.getRateClassType();
        ArrayList tempReportTypeVOList = new ArrayList();
        HashMap reportTypeMap = new HashMap();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                this.setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
                if (this.isBudgetCategoryPersonnel((BudgetLineItemBase)budgetLineItem)) continue;
                this.setBudgetRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem, rateClassType);
            }
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList reportTypeList = new ArrayList(reportTypeMap.values());
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }
}

