/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetSalaryDocument;
import noNamespace.SalaryType;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryType;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.printing.util.BudgetDataPeriodVO;
import org.kuali.kra.budget.printing.util.SalaryTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseSalaryStream;

public class BudgetSalaryXmlStream
extends BudgetBaseSalaryStream {
    private static final String BUDGET_SALARY = "Budget Salary";
    private BudgetCalculationService budgetCalculationService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        this.budget = (Budget)printableBusinessObject;
        BudgetSalaryDocument budgetSalaryDocument = BudgetSalaryDocument.Factory.newInstance();
        if (this.budget != null) {
            BudgetSalaryDocument.BudgetSalary budgetSalary = this.getSalaryType();
            budgetSalaryDocument.setBudgetSalary(budgetSalary);
            xmlObjectList.put(BUDGET_SALARY, (XmlObject)budgetSalaryDocument);
        }
        return xmlObjectList;
    }

    protected BudgetSalaryDocument.BudgetSalary getSalaryType() {
        ArrayList salaryTypeVoList = new ArrayList();
        this.getBudgetCalculationService().calculateBudgetSummaryTotals(this.budget);
        for (Map.Entry entry : this.budget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            if (!this.isPersonnel(((BudgetCategoryType)entry.getKey()).getBudgetCategoryTypeCode())) continue;
            for (CostElement costElement : (List)entry.getValue()) {
                this.addSalaryDataForCostElement(costElement, salaryTypeVoList);
            }
        }
        boolean includeNonPersonnel = false;
        this.setSalaryTypesForLineItemCalcuAmount(salaryTypeVoList, includeNonPersonnel);
        List salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalaryTypeXmlObject();
        budgetSalary.setSalaryArray(salaryTypeList.toArray(new SalaryType[0]));
        return budgetSalary;
    }

    private void addSalaryDataForCostElement(CostElement costElement, List<SalaryTypeVO> salaryTypeVoList) {
        SalaryTypeVO groupVO = new SalaryTypeVO();
        groupVO.setCostElement(costElement.getDescription());
        salaryTypeVoList.add(groupVO);
        for (BudgetPersonnelDetails details : (List)this.budget.getObjectCodePersonnelList().get(costElement)) {
            SalaryTypeVO salaryTypeVoPerPerson = new SalaryTypeVO();
            salaryTypeVoPerPerson.setName(details.getBudgetPerson().getPersonName());
            salaryTypeVoPerPerson.setBudgetPeriodVOs(this.getBudgetPeriodData((List)this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement() + "," + details.getPersonId())));
            salaryTypeVoList.add(salaryTypeVoPerPerson);
        }
        if (this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement()) != null) {
            SalaryTypeVO salaryTypeVoPerPerson = new SalaryTypeVO();
            salaryTypeVoPerPerson.setName("Summary Line Item");
            salaryTypeVoPerPerson.setBudgetPeriodVOs(this.getBudgetPeriodData((List)this.budget.getObjectCodePersonnelSalaryTotals().get(costElement.getCostElement())));
            salaryTypeVoList.add(salaryTypeVoPerPerson);
        }
    }

    private List<BudgetDataPeriodVO> getBudgetPeriodData(List<BudgetDecimal> costs) {
        ArrayList<BudgetDataPeriodVO> budgetDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodId = 1;
        for (BudgetDecimal cost : costs) {
            BudgetDataPeriodVO periodData = new BudgetDataPeriodVO();
            periodData.setBudgetPeriodId(budgetPeriodId++);
            periodData.setPeriodCost(cost);
            budgetDataList.add(periodData);
        }
        return budgetDataList;
    }

    protected BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }
}

