/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.printing.xmlstream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.BudgetSalaryDocument;
import noNamespace.SalaryType;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.util.BudgetDataPeriodVO;
import org.kuali.kra.budget.printing.util.SalaryTypeVO;
import org.kuali.kra.budget.printing.xmlstream.BudgetBaseSalaryStream;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;

public class IndustrialCumBudgetXmlStream
extends BudgetBaseSalaryStream {
    private static final String CUM_INDSTRL_BUDGET = "Cumulative Industrial Budget";

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        this.budget = (Budget)printableBusinessObject;
        BudgetSalaryDocument budgetSalaryDocument = BudgetSalaryDocument.Factory.newInstance();
        if (this.budget != null) {
            BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalary();
            budgetSalaryDocument.setBudgetSalary(budgetSalary);
        }
        xmlObjectList.put(CUM_INDSTRL_BUDGET, (XmlObject)budgetSalaryDocument);
        return xmlObjectList;
    }

    private BudgetSalaryDocument.BudgetSalary getBudgetSalary() {
        BudgetSalaryDocument.BudgetSalary budgetSalary = this.getBudgetSalaryTypeXmlObject();
        budgetSalary.setHeaderTitle(CUM_INDSTRL_BUDGET);
        budgetSalary.setSalaryArray(this.getIndustrialCumBudgetSalaryTypes());
        return budgetSalary;
    }

    private SalaryType[] getIndustrialCumBudgetSalaryTypes() {
        ArrayList<SalaryTypeVO> salaryTypeVoList = new ArrayList<SalaryTypeVO>();
        HashMap<String, String> lineItems = new HashMap<String, String>();
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                String budgetPeronnelCostEleDesc;
                if (budgetLineItem.getCostElementBO() == null || (budgetPeronnelCostEleDesc = budgetLineItem.getCostElementBO().getDescription()) == null || lineItems.containsKey(budgetPeronnelCostEleDesc) || budgetLineItem.getCostElementBO().getCostElement() == null) continue;
                lineItems.put(budgetPeronnelCostEleDesc, budgetLineItem.getCostElementBO().getCostElement());
            }
        }
        for (String costElemetDesc : lineItems.keySet()) {
            salaryTypeVoList.add(this.getSalaryTypeVOForCostElementForIndustrialCumBudget(costElemetDesc, (String)lineItems.get(costElemetDesc)));
        }
        List salaryTypeList = this.getListOfSalaryTypeXmlObjects(salaryTypeVoList);
        return salaryTypeList.toArray(new SalaryType[0]);
    }

    private SalaryTypeVO getSalaryTypeVOForCostElementForIndustrialCumBudget(String costElemetDesc, String costElementCode) {
        SalaryTypeVO salaryTypeVO = new SalaryTypeVO();
        salaryTypeVO.setCostElement(costElemetDesc);
        salaryTypeVO.setCostElementCode(costElementCode);
        salaryTypeVO.setName(costElemetDesc);
        salaryTypeVO.setBudgetPeriodVOs(this.getBudgetDataPeriodVOsForCostElementForIndustrialCumBudget(costElementCode));
        return salaryTypeVO;
    }

    private List<BudgetDataPeriodVO> getBudgetDataPeriodVOsForCostElementForIndustrialCumBudget(String costElementCode) {
        ArrayList<BudgetDataPeriodVO> budgetPeriodDataList = new ArrayList<BudgetDataPeriodVO>();
        int budgetPeriodDataId = 0;
        for (BudgetPeriod budgetPeriod : this.budget.getBudgetPeriods()) {
            BudgetDataPeriodVO budgetDataPeriodVO = new BudgetDataPeriodVO();
            budgetDataPeriodVO.setBudgetPeriodId(++budgetPeriodDataId);
            BudgetDecimal periodCost = BudgetDecimal.ZERO;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (!budgetLineItem.getCostElementBO().getCostElement().equals(costElementCode)) continue;
                periodCost = (BudgetDecimal)periodCost.add((AbstractKualiDecimal)budgetLineItem.getLineItemCost());
                periodCost = (BudgetDecimal)periodCost.add((AbstractKualiDecimal)this.getBudgetDataPeriodsForCalculatedAmountsForIndustrialCumBudget(budgetLineItem));
            }
            budgetDataPeriodVO.setPeriodCost(periodCost);
            budgetPeriodDataList.add(budgetDataPeriodVO);
        }
        return budgetPeriodDataList;
    }

    private BudgetDecimal getBudgetDataPeriodsForCalculatedAmountsForIndustrialCumBudget(BudgetLineItem budgetLineItem) {
        BudgetDecimal periodCost = BudgetDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            periodCost = (BudgetDecimal)periodCost.add((AbstractKualiDecimal)budgetLineItemCalcAmount.getCalculatedCost());
        }
        return periodCost;
    }
}

