/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.rates;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.budget.rates.UnitFormulatedCost;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.kra.rules.KraMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class UnitFormulatedCostRule
extends KraMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkForUnitCostExistence(document);
    }

    private boolean checkForUnitCostExistence(MaintenanceDocument maintenanceDocument) {
        boolean valid = true;
        UnitFormulatedCost newCost = (UnitFormulatedCost)maintenanceDocument.getNewMaintainableObject().getDataObject();
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("formulatedTypeCode", newCost.getFormulatedTypeCode());
        values.put("unitNumber", newCost.getUnitNumber());
        Collection costs = businessObjectService.findMatching(UnitFormulatedCost.class, values);
        for (UnitFormulatedCost cost : costs) {
            if (ObjectUtils.equals((Object)newCost.getUnitFormulatedCostId(), (Object)cost.getUnitFormulatedCostId())) continue;
            ErrorReporter errorReporter = new ErrorReporter();
            errorReporter.reportError("document.newMaintainableObject.formulatedTypeCode", "error.invalid.budget.formulated.duplicate", new String[0]);
            return false;
        }
        return true;
    }
}

