/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.summary;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.OnOffCampusFlagConstants;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.service.DeepCopyPostProcessor;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetSummaryServiceImpl
implements BudgetSummaryService {
    private BusinessObjectService businessObjectService;
    private BudgetCalculationService budgetCalculationService;
    private static final String BUDGET_DATE_CHANGE_WARNING_MSG = "Changing the budget period dates will result in changes being made to line item Expenses & recalculation of the budget, Do you want to proceed? ";
    private static final String BUDGET_DATE_CHANGE_AND_DELETE_WARNING_MSG = "Changing the budget period dates will result in changes being made to line item Expenses & recalculation of the budget, and one or more periods to be deleted have expense line items that will be deleted. Are you sure you want to proceed? ";
    private static final String BUDGET_PERIOD_DELETE_WARNING_MSG = "One or more periods to be deleted have expense line items that will be deleted. Are you sure you want to proceed?";

    public Collection<BudgetLineItem> getBudgetLineItemForPeriod(Budget budget, int budgetPeriodNumber) {
        HashMap<String, Integer> budgetLineItemMap = new HashMap<String, Integer>();
        ArrayList<BudgetLineItem> periodLineItems = new ArrayList();
        budgetLineItemMap.put("budgetPeriod", budgetPeriodNumber);
        periodLineItems = this.businessObjectService.findMatching(BudgetLineItem.class, budgetLineItemMap);
        return periodLineItems;
    }

    public Collection<BudgetPersonnelDetails> getBudgetPersonnelDetailsForPeriod(Budget budget, int budgetPeriodNumber) {
        HashMap<String, Integer> budgetLineItemMap = new HashMap<String, Integer>();
        ArrayList<BudgetPersonnelDetails> periodPersonnelDetails = new ArrayList();
        budgetLineItemMap.put("budgetPeriod", budgetPeriodNumber);
        periodPersonnelDetails = this.businessObjectService.findMatching(BudgetPersonnelDetails.class, budgetLineItemMap);
        return periodPersonnelDetails;
    }

    public void generateAllPeriods(Budget budget) {
        List budgetPeriods = budget.getBudgetPeriods();
        List budgetLineItems = new ArrayList();
        int period1Duration = 0;
        BudgetPeriod budgetPeriod1 = null;
        block3: for (BudgetPeriod budgetPeriod : budgetPeriods) {
            Integer budPeriod = budgetPeriod.getBudgetPeriod();
            Long budgetPeriodId = budgetPeriod.getBudgetPeriodId();
            int lineDuration = 0;
            int currentPeriodDuration = 0;
            int gap = 0;
            ArrayList<Date> startEndDates = new ArrayList<Date>();
            switch (budPeriod) {
                case 1: {
                    budgetPeriod1 = budgetPeriod;
                    budgetLineItems = budgetPeriod.getBudgetLineItems();
                    period1Duration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
                    continue block3;
                }
            }
            budgetPeriod.setNumberOfParticipants(budgetPeriod1.getNumberOfParticipants());
            for (BudgetLineItem periodLineItem : budgetLineItems) {
                BudgetLineItem budgetLineItem = (BudgetLineItem)((DeepCopyPostProcessor)KraServiceLocator.getService(DeepCopyPostProcessor.class)).processDeepCopyWithDeepCopyIgnore((Serializable)periodLineItem);
                budgetLineItem.setBudgetId(budget.getBudgetId());
                budgetLineItem.getBudgetCalculatedAmounts().clear();
                budgetLineItem.setBudgetPeriod(budPeriod);
                budgetLineItem.setBudgetPeriodId(budgetPeriodId);
                budgetLineItem.setBudgetPeriodBO(budgetPeriod);
                boolean isLeapDateInPeriod = this.isLeapDaysInPeriod(budgetLineItem.getStartDate(), budgetLineItem.getEndDate());
                gap = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)budgetPeriod1.getStartDate(), (java.util.Date)budgetLineItem.getStartDate(), false);
                boolean isLeapDayInGap = this.isLeapDaysInPeriod(budgetPeriod1.getStartDate(), budgetLineItem.getStartDate());
                lineDuration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)budgetLineItem.getStartDate(), (java.util.Date)budgetLineItem.getEndDate(), false);
                currentPeriodDuration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)budgetPeriod.getStartDate(), (java.util.Date)budgetPeriod.getEndDate(), false);
                if (period1Duration == lineDuration || lineDuration > currentPeriodDuration) {
                    budgetLineItem.setStartDate(budgetPeriod.getStartDate());
                    budgetLineItem.setEndDate(budgetPeriod.getEndDate());
                } else {
                    startEndDates.add(0, budgetPeriod.getStartDate());
                    startEndDates.add(1, budgetPeriod.getEndDate());
                    List dates = this.getNewStartEndDates(startEndDates, gap, lineDuration, budgetLineItem.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetLineItem.setStartDate((Date)dates.get(0));
                    budgetLineItem.setEndDate((Date)dates.get(1));
                }
                budgetLineItem.setBasedOnLineItem(budgetLineItem.getLineItemNumber());
                lineDuration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)periodLineItem.getStartDate(), (java.util.Date)periodLineItem.getEndDate(), false);
                int personnelDuration = 0;
                List budgetPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    budgetPersonnelDetail.setBudgetPersonnelLineItemId(null);
                    budgetPersonnelDetail.getBudgetCalculatedAmounts().clear();
                    personnelDuration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)budgetPersonnelDetail.getStartDate(), (java.util.Date)budgetPersonnelDetail.getEndDate(), false);
                    budgetPersonnelDetail.setBudgetPeriod(budPeriod);
                    budgetPersonnelDetail.setBudgetPeriodId(budgetPeriodId);
                    gap = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)periodLineItem.getStartDate(), (java.util.Date)budgetPersonnelDetail.getStartDate(), false);
                    isLeapDayInGap = this.isLeapDaysInPeriod(periodLineItem.getStartDate(), budgetPersonnelDetail.getStartDate());
                    if (period1Duration == personnelDuration || personnelDuration >= lineDuration) {
                        budgetPersonnelDetail.setStartDate(budgetLineItem.getStartDate());
                        budgetPersonnelDetail.setEndDate(budgetLineItem.getEndDate());
                        continue;
                    }
                    startEndDates.add(0, budgetLineItem.getStartDate());
                    startEndDates.add(1, budgetLineItem.getEndDate());
                    isLeapDateInPeriod = this.isLeapDaysInPeriod(budgetPersonnelDetail.getStartDate(), budgetPersonnelDetail.getEndDate());
                    List dates = this.getNewStartEndDates(startEndDates, gap, personnelDuration, budgetPersonnelDetail.getStartDate(), isLeapDateInPeriod, isLeapDayInGap);
                    budgetPersonnelDetail.setStartDate((Date)dates.get(0));
                    budgetPersonnelDetail.setEndDate((Date)dates.get(1));
                }
                budgetPeriod.getBudgetLineItems().add(budgetLineItem);
            }
        }
        BudgetPeriod firstPeriod = (BudgetPeriod)budgetPeriods.get(0);
        List firstPerLineItems = firstPeriod.getBudgetLineItems();
        for (BudgetLineItem budgetLineItem : firstPerLineItems) {
            this.budgetCalculationService.applyToLaterPeriods(budget, firstPeriod, budgetLineItem);
        }
    }

    public void generateBudgetPeriods(Budget budget, List<BudgetPeriod> budgetPeriods) {
        Date projectStartDate = budget.getStartDate();
        Date projectEndDate = budget.getEndDate();
        boolean budgetPeriodExists = true;
        Calendar cl = Calendar.getInstance();
        Date periodStartDate = projectStartDate;
        int budgetPeriodNum = 1;
        while (budgetPeriodExists) {
            cl.setTime(periodStartDate);
            cl.add(1, 1);
            Date nextPeriodStartDate = new Date(cl.getTime().getTime());
            cl.add(5, -1);
            Date periodEndDate = new Date(cl.getTime().getTime());
            switch (periodEndDate.compareTo(projectEndDate)) {
                case 1: {
                    periodEndDate = projectEndDate;
                }
                case 0: {
                    budgetPeriodExists = false;
                }
            }
            BudgetPeriod budgetPeriod = budget.getNewBudgetPeriod();
            budgetPeriod.setBudgetPeriod(Integer.valueOf(budgetPeriodNum));
            budgetPeriod.setStartDate(periodStartDate);
            budgetPeriod.setEndDate(periodEndDate);
            budgetPeriod.setBudget(budget);
            budgetPeriod.setBudgetId(budget.getBudgetId());
            budgetPeriods.add(budgetPeriod);
            periodStartDate = nextPeriodStartDate;
            ++budgetPeriodNum;
        }
    }

    public void defaultBudgetPeriods(Budget budget) {
        ArrayList newPeriods = new ArrayList();
        this.generateBudgetPeriods(budget, newPeriods);
        while (budget.getBudgetPeriods().size() > newPeriods.size()) {
            this.deleteBudgetPeriod(budget, budget.getBudgetPeriods().size() - 1);
        }
        for (int i = 0; i < newPeriods.size(); ++i) {
            BudgetPeriod newPeriod = (BudgetPeriod)newPeriods.get(i);
            if (i < budget.getBudgetPeriods().size()) {
                BudgetPeriod curPeriod = budget.getBudgetPeriod(i);
                curPeriod.setStartDate(newPeriod.getStartDate());
                curPeriod.setEndDate(newPeriod.getEndDate());
                curPeriod.setCostSharingAmount(null);
                curPeriod.setDirectCostLimit(null);
                curPeriod.setExpenseTotal(null);
                curPeriod.setTotalCost(null);
                curPeriod.setTotalCostLimit(null);
                curPeriod.setTotalDirectCost(null);
                curPeriod.setTotalIndirectCost(null);
                curPeriod.setUnderrecoveryAmount(null);
                continue;
            }
            budget.getBudgetPeriods().add(newPeriod);
        }
        this.adjustStartEndDatesForLineItems(budget);
        this.calculateBudget(budget);
    }

    public boolean budgetLineItemExists(Budget budget, Integer budgetPeriod) {
        boolean lineItemExists = false;
        List budgetLineItems = budget.getBudgetPeriod(budgetPeriod.intValue()).getBudgetLineItems();
        block0: for (BudgetLineItem periodLineItem : budgetLineItems) {
            Integer lineItemPeriod = periodLineItem.getBudgetPeriod();
            if (budgetPeriod + 1 == lineItemPeriod) {
                lineItemExists = true;
                break;
            }
            List budgetPersonnelDetailsList = periodLineItem.getBudgetPersonnelDetailsList();
            for (BudgetPersonnelDetails periodPersonnelLineItem : budgetPersonnelDetailsList) {
                lineItemPeriod = periodPersonnelLineItem.getBudgetPeriod();
                if (budgetPeriod + 1 != lineItemPeriod) continue;
                lineItemExists = true;
                continue block0;
            }
        }
        return lineItemExists;
    }

    protected void updateBudgetPeriods(Budget budget, List<BudgetPeriod> budgetPeriods, int checkPeriod, boolean deletePeriod) {
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            Integer budPeriod = budgetPeriod.getBudgetPeriod();
            if (budPeriod < checkPeriod) continue;
            int newPeriod = 0;
            newPeriod = deletePeriod ? budPeriod - 1 : budPeriod + 1;
            budgetPeriod.setBudgetPeriod(Integer.valueOf(newPeriod));
            List budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem periodLineItem : budgetLineItems) {
                periodLineItem.setBudgetPeriod(Integer.valueOf(newPeriod));
                List budgetPersonnelDetails = periodLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    budgetPersonnelDetail.setBudgetPeriod(Integer.valueOf(newPeriod));
                }
            }
        }
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            for (BudgetSubAwardPeriodDetail detail : subAward.getBudgetSubAwardPeriodDetails()) {
                if (detail.getBudgetPeriod() < checkPeriod) continue;
                if (deletePeriod) {
                    detail.setBudgetPeriod(Integer.valueOf(detail.getBudgetPeriod() - 1));
                    continue;
                }
                detail.setBudgetPeriod(Integer.valueOf(detail.getBudgetPeriod() + 1));
            }
        }
    }

    public void calculateBudget(Budget budget) {
        this.getBudgetCommonService(budget.getBudgetDocument().getParentDocument()).recalculateBudget(budget);
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance((BudgetParentDocument)parentBudgetDocument);
    }

    public void deleteBudgetPeriod(Budget budget, int delPeriod) {
        List budgetPeriods = budget.getBudgetPeriods();
        BudgetPeriod deletedPeriod = (BudgetPeriod)budgetPeriods.remove(delPeriod);
        this.deleteSubAwardPeriodDetails(deletedPeriod);
        this.updateBudgetPeriods(budget, budgetPeriods, delPeriod + 1, true);
    }

    protected void deleteSubAwardPeriodDetails(BudgetPeriod deletedPeriod) {
        Budget budget = deletedPeriod.getBudget();
        for (BudgetSubAwards subAward : budget.getBudgetSubAwards()) {
            Iterator iter = subAward.getBudgetSubAwardPeriodDetails().iterator();
            while (iter.hasNext()) {
                BudgetSubAwardPeriodDetail detail = (BudgetSubAwardPeriodDetail)iter.next();
                if (!ObjectUtils.equals((Object)detail.getBudgetPeriod(), (Object)deletedPeriod.getBudgetPeriod())) continue;
                iter.remove();
            }
        }
    }

    public void addBudgetPeriod(Budget budget, BudgetPeriod newBudgetPeriod) {
        List budgetPeriods = budget.getBudgetPeriods();
        Integer newPeriodIndex = newBudgetPeriod.getBudgetPeriod();
        int totalPeriods = budgetPeriods.size();
        if (newPeriodIndex > totalPeriods) {
            budgetPeriods.add(newBudgetPeriod);
        } else {
            this.updateBudgetPeriods(budget, budgetPeriods, newPeriodIndex.intValue(), false);
            budgetPeriods.add(newPeriodIndex - 1, newBudgetPeriod);
        }
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public final BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public final void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public void updateOnOffCampusFlag(Budget budget, String onOffCampusFlag) {
        List budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            if (budgetPeriod.getBudgetLineItems() == null) continue;
            for (BudgetLineItem periodLineItem : budgetPeriod.getBudgetLineItems()) {
                if (onOffCampusFlag.equalsIgnoreCase("D")) {
                    if (periodLineItem.getCostElementBO() == null) {
                        periodLineItem.refreshReferenceObject("costElementBO");
                    }
                    periodLineItem.setOnOffCampusFlag(periodLineItem.getCostElementBO().getOnOffCampusFlag());
                } else {
                    periodLineItem.setOnOffCampusFlag(Boolean.valueOf(onOffCampusFlag.equalsIgnoreCase("N")));
                }
                for (BudgetPersonnelDetails periodPersonnelDetail : periodLineItem.getBudgetPersonnelDetailsList()) {
                    if (onOffCampusFlag.equalsIgnoreCase("D")) {
                        if (periodLineItem.getCostElementBO() == null) {
                            periodLineItem.refreshReferenceObject("costElementBO");
                        }
                        periodPersonnelDetail.setOnOffCampusFlag(periodLineItem.getCostElementBO().getOnOffCampusFlag());
                        continue;
                    }
                    periodPersonnelDetail.setOnOffCampusFlag(Boolean.valueOf(onOffCampusFlag.equalsIgnoreCase("N")));
                }
            }
        }
    }

    public void adjustStartEndDatesForLineItems(Budget budget) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getOldStartDate() != null && budgetPeriod.getStartDate().compareTo(budgetPeriod.getOldStartDate()) != 0 || budgetPeriod.getOldEndDate() != null && budgetPeriod.getEndDate().compareTo(budgetPeriod.getOldEndDate()) != 0) {
                List budgetLineItems = budgetPeriod.getBudgetLineItems();
                this.setupOldStartEndDate(budgetLineItems);
                for (BudgetLineItem budgetLineItem : budgetLineItems) {
                    Date newStartDate = budgetLineItem.getStartDate();
                    Date newEndDate = budgetLineItem.getEndDate();
                    ArrayList<Date> startEndDates = new ArrayList<Date>();
                    startEndDates.add(0, budgetLineItem.getStartDate());
                    startEndDates.add(1, budgetLineItem.getEndDate());
                    this.getNewStartEndDates(budgetPeriod.getStartDate(), budgetPeriod.getOldStartDate(), budgetPeriod.getEndDate(), budgetPeriod.getOldEndDate(), startEndDates);
                    newStartDate = (Date)startEndDates.get(0);
                    newEndDate = (Date)startEndDates.get(1);
                    budgetLineItem.setStartDate(newStartDate);
                    budgetLineItem.setEndDate(newEndDate);
                    budgetLineItem.setBasedOnLineItem(budgetLineItem.getLineItemNumber());
                }
                this.adjustStartEndDatesForPersonnelLineItems(budgetLineItems);
            }
            budgetPeriod.setOldStartDate(budgetPeriod.getStartDate());
            budgetPeriod.setOldEndDate(budgetPeriod.getEndDate());
        }
    }

    public void adjustStartEndDatesForPersonnelLineItems(List<BudgetLineItem> budgetLineItems) {
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (budgetLineItem.getOldStartDate() != null && budgetLineItem.getStartDate().compareTo(budgetLineItem.getOldStartDate()) != 0 || budgetLineItem.getOldEndDate() != null && budgetLineItem.getEndDate().compareTo(budgetLineItem.getOldEndDate()) != 0) {
                List budgetPersonnelDetails = budgetLineItem.getBudgetPersonnelDetailsList();
                for (BudgetPersonnelDetails budgetPersonnelDetail : budgetPersonnelDetails) {
                    Date newStartDate = budgetPersonnelDetail.getStartDate();
                    Date newEndDate = budgetPersonnelDetail.getEndDate();
                    ArrayList<Date> startEndDates = new ArrayList<Date>();
                    startEndDates.add(0, budgetPersonnelDetail.getStartDate());
                    startEndDates.add(1, budgetPersonnelDetail.getEndDate());
                    this.getNewStartEndDates(budgetLineItem.getStartDate(), budgetLineItem.getOldStartDate(), budgetLineItem.getEndDate(), budgetLineItem.getOldEndDate(), startEndDates);
                    newStartDate = (Date)startEndDates.get(0);
                    newEndDate = (Date)startEndDates.get(1);
                    budgetPersonnelDetail.setStartDate(newStartDate);
                    budgetPersonnelDetail.setEndDate(newEndDate);
                }
            }
            budgetLineItem.setOldStartDate(budgetLineItem.getStartDate());
            budgetLineItem.setOldEndDate(budgetLineItem.getEndDate());
        }
    }

    public void setupOldStartEndDate(Budget budget, boolean resetAll) {
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getOldStartDate() != null && budgetPeriod.getOldEndDate() != null && !resetAll) continue;
            budgetPeriod.setOldStartDate(budgetPeriod.getStartDate());
            budgetPeriod.setOldEndDate(budgetPeriod.getEndDate());
        }
    }

    public void setupOldStartEndDate(List<BudgetLineItem> budgetLineItems) {
        for (BudgetLineItem budgetLineItem : budgetLineItems) {
            if (budgetLineItem.getOldStartDate() != null && budgetLineItem.getOldEndDate() != null) continue;
            budgetLineItem.setOldStartDate(budgetLineItem.getStartDate());
            budgetLineItem.setOldEndDate(budgetLineItem.getEndDate());
        }
    }

    protected Date add(Date date, int days) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(new java.util.Date(date.getTime()));
        c1.add(5, days);
        return new Date(c1.getTime().getTime());
    }

    protected List<Date> getNewStartEndDates(Date parentStartDate, Date oldStartDate, Date parentEndDate, Date oldEndDate, List<Date> startEndDates) {
        Date startDate = startEndDates.get(0);
        Date endDate = startEndDates.get(1);
        Date newStartDate = startDate;
        Date newEndDate = endDate;
        if (startDate.compareTo(oldStartDate) == 0 && endDate.compareTo(oldEndDate) == 0) {
            newStartDate = parentStartDate;
            newEndDate = parentEndDate;
        } else if (parentStartDate.compareTo(oldStartDate) != 0) {
            if ((newStartDate = this.add(newStartDate, ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)oldStartDate, (java.util.Date)parentStartDate, false))).after(parentEndDate)) {
                newStartDate = parentStartDate;
            } else if (newStartDate.after(parentStartDate)) {
                int parentDuration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)parentStartDate, (java.util.Date)parentEndDate, false);
                int duration = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false);
                int daysTOEndDate = ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)newStartDate, (java.util.Date)parentEndDate, false);
                if (daysTOEndDate < duration) {
                    if (parentDuration > duration) {
                        newEndDate = parentEndDate;
                        newStartDate = this.add(newEndDate, duration * -1);
                    } else {
                        newStartDate = parentStartDate;
                    }
                }
            }
            newEndDate = this.add(newStartDate, ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false));
            if (newEndDate.after(parentEndDate)) {
                newEndDate = parentEndDate;
            }
        } else if (parentEndDate.compareTo(oldStartDate) != 0 && parentEndDate.before(endDate)) {
            if (parentEndDate.after(startDate) && parentEndDate.before(endDate)) {
                newEndDate = parentEndDate;
                newStartDate = this.add(newEndDate, ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)endDate, (java.util.Date)startDate, false));
                if (newStartDate.before(parentStartDate)) {
                    newStartDate = parentStartDate;
                }
            } else if (parentEndDate.before(startDate) && (newEndDate = this.add(newStartDate = parentStartDate, ((DateTimeService)KraServiceLocator.getService(DateTimeService.class)).dateDiff((java.util.Date)startDate, (java.util.Date)endDate, false))).after(parentEndDate)) {
                newEndDate = parentEndDate;
            }
        }
        startEndDates.clear();
        startEndDates.add(0, newStartDate);
        startEndDates.add(1, newEndDate);
        return startEndDates;
    }

    public List<Date> getNewStartEndDates(List<Date> startEndDates, int gap, int duration, Date prevDate, boolean leapDayInPeriod, boolean leapDayInGap) {
        Date startDate = startEndDates.get(0);
        Date endDate = startEndDates.get(1);
        Date newStartDate = startDate;
        Date newEndDate = endDate;
        boolean endDateAdjusted = false;
        if (gap == 0) {
            newEndDate = this.add(startDate, duration);
        } else {
            newStartDate = this.add(startDate, gap);
            newEndDate = this.add(newStartDate, duration);
            if (newStartDate.after(endDate)) {
                newStartDate = startDate;
                newEndDate = this.add(startDate, duration);
            } else if (newEndDate.after(endDate)) {
                endDateAdjusted = true;
                newEndDate = endDate;
                newStartDate = this.add(endDate, duration * -1);
            }
        }
        boolean isLeapDayInNewGap = this.isLeapDaysInPeriod(startDate, newStartDate);
        startEndDates.clear();
        if (leapDayInGap && !endDateAdjusted) {
            if (newStartDate.after(startDate)) {
                newStartDate = this.add(newStartDate, -1);
                newEndDate = this.add(newEndDate, -1);
            }
        } else if (isLeapDayInNewGap && newEndDate.before(endDate)) {
            newStartDate = this.add(newStartDate, 1);
            newEndDate = this.add(newEndDate, 1);
        }
        boolean isLeapDayInNewPeriod = this.isLeapDaysInPeriod(newStartDate, newEndDate);
        if (leapDayInPeriod && !isLeapDayInNewPeriod) {
            newEndDate = this.add(newEndDate, -1);
        } else if (!leapDayInPeriod && isLeapDayInNewPeriod) {
            if (endDate.after(newEndDate)) {
                newEndDate = this.add(newEndDate, 1);
            } else if (startDate.before(newStartDate)) {
                newStartDate = this.add(newStartDate, 1);
            }
        }
        startEndDates.add(0, newStartDate);
        startEndDates.add(1, newEndDate);
        return startEndDates;
    }

    protected boolean isLeapYear(Date date) {
        int year = this.getYear(date);
        return this.isLeapYear(year);
    }

    protected boolean isLeapYear(int year) {
        boolean isLeapYear = year % 4 == 0;
        isLeapYear = isLeapYear && year % 100 != 0;
        isLeapYear = isLeapYear || year % 400 == 0;
        return isLeapYear;
    }

    protected int getYear(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(new java.util.Date(date.getTime()));
        return c1.get(1);
    }

    protected Date getLeapDay(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.clear();
        c1.set(this.getYear(date), 1, 29);
        return new Date(c1.getTime().getTime());
    }

    public boolean isLeapDaysInPeriod(Date sDate, Date eDate) {
        int sYear = this.getYear(sDate);
        int eYear = this.getYear(eDate);
        if (this.isLeapYear(sDate)) {
            Calendar c1 = Calendar.getInstance();
            c1.clear();
            c1.set(sYear, 1, 29);
            Date leapDate = new Date(c1.getTime().getTime());
            if (sDate.before(leapDate) ? eDate.compareTo(leapDate) >= 0 : sDate.equals(leapDate)) {
                return true;
            }
        } else if (this.isLeapYear(eDate)) {
            Calendar c1 = Calendar.getInstance();
            c1.set(eYear, 1, 29);
            Date leapDate = new Date(c1.getTime().getTime());
            if (eDate.compareTo(leapDate) >= 0) {
                return true;
            }
        } else {
            ++sYear;
            while (eYear > sYear) {
                if (this.isLeapYear(sYear)) {
                    return true;
                }
                ++sYear;
            }
        }
        return false;
    }

    public String getOnOffCampusFlagDescription(String onOffCampusFlag) {
        String retValue = null;
        for (OnOffCampusFlagConstants onOffCampusFlagConstants : OnOffCampusFlagConstants.values()) {
            if (!onOffCampusFlagConstants.code().equalsIgnoreCase(onOffCampusFlag)) continue;
            retValue = onOffCampusFlagConstants.description();
            break;
        }
        return retValue;
    }

    public String defaultWarningMessage(Budget budget) {
        ArrayList budgetPeriods = new ArrayList();
        boolean dateChanged = false;
        boolean deletePeriodWithLineItem = false;
        this.generateBudgetPeriods(budget, budgetPeriods);
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            if (budgetPeriod.getBudgetPeriod() <= budgetPeriods.size()) {
                if (!CollectionUtils.isNotEmpty((Collection)budgetPeriod.getBudgetLineItems()) || budgetPeriod.getStartDate().compareTo(((BudgetPeriod)budgetPeriods.get(budgetPeriod.getBudgetPeriod() - 1)).getStartDate()) == 0 && budgetPeriod.getEndDate().compareTo(((BudgetPeriod)budgetPeriods.get(budgetPeriod.getBudgetPeriod() - 1)).getEndDate()) == 0) continue;
                dateChanged = true;
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)budgetPeriod.getBudgetLineItems())) continue;
            deletePeriodWithLineItem = true;
        }
        if (dateChanged) {
            if (deletePeriodWithLineItem) {
                return BUDGET_DATE_CHANGE_AND_DELETE_WARNING_MSG;
            }
            return BUDGET_DATE_CHANGE_WARNING_MSG;
        }
        if (deletePeriodWithLineItem) {
            return BUDGET_PERIOD_DELETE_WARNING_MSG;
        }
        return "";
    }
}

