/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.versions;

import java.sql.Date;
import java.util.HashMap;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.service.BusinessObjectService;

public class BudgetVersionOverview
extends KraPersistableBusinessObjectBase
implements Comparable<BudgetVersionOverview> {
    private static final long serialVersionUID = -4997453399414404715L;
    private Integer budgetVersionNumber;
    @DeepCopyIgnore
    private Long budgetId;
    private String documentNumber;
    private String documentDescription;
    private BudgetDecimal costSharingAmount;
    private Date endDate;
    private Date startDate;
    private boolean finalVersionFlag;
    private String ohRateTypeCode;
    private String ohRateClassCode;
    private BudgetDecimal residualFunds;
    private BudgetDecimal totalCost;
    private BudgetDecimal totalDirectCost;
    private BudgetDecimal totalIndirectCost;
    private BudgetDecimal totalCostLimit;
    private BudgetDecimal totalDirectCostLimit;
    private BudgetDecimal underrecoveryAmount;
    private String comments;
    private boolean descriptionUpdatable;
    private RateClass rateClass;
    private String name;
    private String budgetStatus;
    private Boolean modularBudgetFlag;
    private String urRateClassCode;
    private String onOffCampusFlag;
    private String printBudgetCommentFlag;
    private Boolean submitCostSharingFlag = Boolean.TRUE;
    private RateClass urRateClass;

    public Integer getBudgetVersionNumber() {
        return this.budgetVersionNumber;
    }

    public void setBudgetVersionNumber(Integer budgetVersionNumber) {
        this.budgetVersionNumber = budgetVersionNumber;
    }

    public BudgetDecimal getCostSharingAmount() {
        return this.costSharingAmount == null ? BudgetDecimal.ZERO : this.costSharingAmount;
    }

    public void setCostSharingAmount(BudgetDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    public boolean isFinalVersionFlag() {
        return this.finalVersionFlag;
    }

    public void setFinalVersionFlag(boolean finalVersionFlag) {
        this.finalVersionFlag = finalVersionFlag;
    }

    public String getOhRateTypeCode() {
        return this.ohRateTypeCode;
    }

    public void setOhRateTypeCode(String ohRateTypeCode) {
        this.ohRateTypeCode = ohRateTypeCode;
    }

    public String getOhRateClassCode() {
        return this.ohRateClassCode;
    }

    public void setOhRateClassCode(String ohRateClassCode) {
        this.ohRateClassCode = ohRateClassCode;
    }

    public RateClass getRateClass() {
        return this.rateClass;
    }

    public void setRateClass(RateClass rateClass) {
        this.rateClass = rateClass;
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public BudgetDecimal getResidualFunds() {
        return this.residualFunds;
    }

    public void setResidualFunds(BudgetDecimal residualFunds) {
        this.residualFunds = residualFunds;
    }

    public BudgetDecimal getTotalCost() {
        return this.totalCost == null ? BudgetDecimal.ZERO : this.totalCost;
    }

    public void setTotalCost(BudgetDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public void setTotalDirectCost(BudgetDecimal totalDirectCost) {
        this.totalDirectCost = totalDirectCost;
    }

    public void setTotalIndirectCost(BudgetDecimal totalIndirectCost) {
        this.totalIndirectCost = totalIndirectCost;
    }

    public void setUnderrecoveryAmount(BudgetDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBudgetStatus() {
        return this.budgetStatus;
    }

    public void setBudgetStatus(String budgetStatus) {
        this.budgetStatus = budgetStatus;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public BudgetDecimal getTotalCostLimit() {
        return this.totalCostLimit == null ? BudgetDecimal.ZERO : this.totalCostLimit;
    }

    public void setTotalCostLimit(BudgetDecimal totalCostLimit) {
        this.totalCostLimit = totalCostLimit;
    }

    public BudgetDecimal getTotalDirectCost() {
        return this.totalDirectCost == null ? new BudgetDecimal(0) : this.totalDirectCost;
    }

    public BudgetDecimal getTotalIndirectCost() {
        return this.totalIndirectCost == null ? new BudgetDecimal(0) : this.totalIndirectCost;
    }

    public BudgetDecimal getUnderrecoveryAmount() {
        return this.underrecoveryAmount == null ? new BudgetDecimal(0) : this.underrecoveryAmount;
    }

    public String getDocumentDescription() {
        return this.documentDescription;
    }

    public void setDocumentDescription(String documentDescription) {
        this.documentDescription = documentDescription;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isDescriptionUpdatable() {
        return this.descriptionUpdatable;
    }

    public String getDescriptionUpdatable() {
        return this.descriptionUpdatable ? "Yes" : "No";
    }

    public void setDescriptionUpdatable(boolean descriptionUpdatable) {
        this.descriptionUpdatable = descriptionUpdatable;
    }

    protected void postLoad() {
        super.postLoad();
        DocumentHeader docHeader = this.getDocHeader();
        if (docHeader != null) {
            this.documentDescription = docHeader.getDocumentDescription();
        }
    }

    protected DocumentHeader getDocHeader() {
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("documentNumber", this.documentNumber);
        DocumentHeader docHeader = (DocumentHeader)boService.findByPrimaryKey(DocumentHeader.class, keyMap);
        return docHeader;
    }

    @Override
    public int compareTo(BudgetVersionOverview otherVersion) {
        return this.budgetVersionNumber.compareTo(otherVersion.getBudgetVersionNumber());
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Boolean getModularBudgetFlag() {
        return this.modularBudgetFlag;
    }

    public void setModularBudgetFlag(Boolean modularBudgetFlag) {
        this.modularBudgetFlag = modularBudgetFlag;
    }

    public String getUrRateClassCode() {
        return this.urRateClassCode;
    }

    public void setUrRateClassCode(String urRateClassCode) {
        this.urRateClassCode = urRateClassCode;
    }

    public String getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    public void setOnOffCampusFlag(String onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.budgetId == null ? 0 : this.budgetId.hashCode());
        result = 31 * result + (this.budgetStatus == null ? 0 : this.budgetStatus.hashCode());
        result = 31 * result + (this.budgetVersionNumber == null ? 0 : this.budgetVersionNumber.hashCode());
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.costSharingAmount == null ? 0 : this.costSharingAmount.hashCode());
        result = 31 * result + (this.descriptionUpdatable ? 1231 : 1237);
        result = 31 * result + (this.documentDescription == null ? 0 : this.documentDescription.hashCode());
        result = 31 * result + (this.documentNumber == null ? 0 : this.documentNumber.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.finalVersionFlag ? 1231 : 1237);
        result = 31 * result + (this.modularBudgetFlag == null ? 0 : this.modularBudgetFlag.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ohRateClassCode == null ? 0 : this.ohRateClassCode.hashCode());
        result = 31 * result + (this.ohRateTypeCode == null ? 0 : this.ohRateTypeCode.hashCode());
        result = 31 * result + (this.onOffCampusFlag == null ? 0 : this.onOffCampusFlag.hashCode());
        result = 31 * result + (this.rateClass == null ? 0 : this.rateClass.hashCode());
        result = 31 * result + (this.residualFunds == null ? 0 : this.residualFunds.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.totalCost == null ? 0 : this.totalCost.hashCode());
        result = 31 * result + (this.totalCostLimit == null ? 0 : this.totalCostLimit.hashCode());
        result = 31 * result + (this.totalDirectCost == null ? 0 : this.totalDirectCost.hashCode());
        result = 31 * result + (this.totalIndirectCost == null ? 0 : this.totalIndirectCost.hashCode());
        result = 31 * result + (this.underrecoveryAmount == null ? 0 : this.underrecoveryAmount.hashCode());
        result = 31 * result + (this.urRateClassCode == null ? 0 : this.urRateClassCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BudgetVersionOverview other = (BudgetVersionOverview)obj;
        if (this.budgetId == null ? other.budgetId != null : !this.budgetId.equals(other.budgetId)) {
            return false;
        }
        if (this.budgetStatus == null ? other.budgetStatus != null : !this.budgetStatus.equals(other.budgetStatus)) {
            return false;
        }
        if (this.budgetVersionNumber == null ? other.budgetVersionNumber != null : !this.budgetVersionNumber.equals(other.budgetVersionNumber)) {
            return false;
        }
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.costSharingAmount == null ? other.costSharingAmount != null : !this.costSharingAmount.equals((Object)other.costSharingAmount)) {
            return false;
        }
        if (this.descriptionUpdatable != other.descriptionUpdatable) {
            return false;
        }
        if (this.documentDescription == null ? other.documentDescription != null : !this.documentDescription.equals(other.documentDescription)) {
            return false;
        }
        if (this.documentNumber == null ? other.documentNumber != null : !this.documentNumber.equals(other.documentNumber)) {
            return false;
        }
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        if (this.finalVersionFlag != other.finalVersionFlag) {
            return false;
        }
        if (this.modularBudgetFlag == null ? other.modularBudgetFlag != null : !this.modularBudgetFlag.equals(other.modularBudgetFlag)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ohRateClassCode == null ? other.ohRateClassCode != null : !this.ohRateClassCode.equals(other.ohRateClassCode)) {
            return false;
        }
        if (this.ohRateTypeCode == null ? other.ohRateTypeCode != null : !this.ohRateTypeCode.equals(other.ohRateTypeCode)) {
            return false;
        }
        if (this.onOffCampusFlag == null ? other.onOffCampusFlag != null : !this.onOffCampusFlag.equals(other.onOffCampusFlag)) {
            return false;
        }
        if (this.rateClass == null ? other.rateClass != null : !this.rateClass.equals(other.rateClass)) {
            return false;
        }
        if (this.residualFunds == null ? other.residualFunds != null : !this.residualFunds.equals((Object)other.residualFunds)) {
            return false;
        }
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        if (this.totalCost == null ? other.totalCost != null : !this.totalCost.equals((Object)other.totalCost)) {
            return false;
        }
        if (this.totalCostLimit == null ? other.totalCostLimit != null : !this.totalCostLimit.equals((Object)other.totalCostLimit)) {
            return false;
        }
        if (this.totalDirectCost == null ? other.totalDirectCost != null : !this.totalDirectCost.equals((Object)other.totalDirectCost)) {
            return false;
        }
        if (this.totalIndirectCost == null ? other.totalIndirectCost != null : !this.totalIndirectCost.equals((Object)other.totalIndirectCost)) {
            return false;
        }
        if (this.underrecoveryAmount == null ? other.underrecoveryAmount != null : !this.underrecoveryAmount.equals((Object)other.underrecoveryAmount)) {
            return false;
        }
        return !(this.urRateClassCode == null ? other.urRateClassCode != null : !this.urRateClassCode.equals(other.urRateClassCode));
    }

    public BudgetDecimal getTotalDirectCostLimit() {
        return this.totalDirectCostLimit == null ? BudgetDecimal.ZERO : this.totalDirectCostLimit;
    }

    public void setTotalDirectCostLimit(BudgetDecimal totalDirectCostLimit) {
        this.totalDirectCostLimit = totalDirectCostLimit;
    }

    public void setPrintBudgetCommentFlag(String printBudgetCommentFlag) {
        this.printBudgetCommentFlag = printBudgetCommentFlag;
    }

    public String getPrintBudgetCommentFlag() {
        return this.printBudgetCommentFlag;
    }

    public Boolean getSubmitCostSharingFlag() {
        return this.submitCostSharingFlag;
    }

    public void setSubmitCostSharingFlag(Boolean submitCostSharingFlag) {
        this.submitCostSharingFlag = submitCostSharingFlag;
    }

    public RateClass getUrRateClass() {
        return this.urRateClass;
    }

    public void setUrRateClass(RateClass urRateClass) {
        this.urRateClass = urRateClass;
    }
}

