/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.versions;

import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.versions.AddBudgetVersionEvent;
import org.kuali.kra.budget.versions.AddBudgetVersionRule;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionCollection;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.StringUtils;

public class BudgetVersionRule
implements AddBudgetVersionRule {
    public boolean processAddBudgetVersionName(AddBudgetVersionEvent event) {
        BudgetVersionCollection versionCollection = (BudgetVersionCollection)event.getDocument();
        boolean retval = true;
        if (!this.isNameValid(event.getVersionName())) {
            retval = false;
            GlobalVariables.getMessageMap().putError("document.parentDocument.budgetDocumentVersion", "error.budgetVersion.documentDescription.required", new String[]{"Name"});
        }
        if (this.containsVersionOverview(versionCollection, event.getVersionName())) {
            retval = false;
            GlobalVariables.getMessageMap().putError("document.parentDocument.budgetDocumentVersion", "error.budgetVersion.exists", new String[0]);
        }
        return retval;
    }

    private boolean isNameValid(String newBudgetVersionName) {
        return StringUtils.hasText((String)newBudgetVersionName);
    }

    private boolean containsVersionOverview(BudgetVersionCollection document, String versionName) {
        for (BudgetDocumentVersion budgetDocumentVersion : document.getBudgetDocumentVersions()) {
            BudgetVersionOverview version = budgetDocumentVersion.getBudgetVersionOverview();
            BufferedLogger.info((Object[])new Object[]{"Comparing ", version.getDocumentDescription(), " to ", versionName});
            if (!version.getDocumentDescription().equals(versionName)) continue;
            return true;
        }
        return false;
    }

    public boolean processAddBudgetVersion(AddBudgetVersionEvent event) throws WorkflowException {
        Budget budget = event.getBudget();
        boolean success = true;
        if (budget.getStartDate() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.budgetVersion.startDate.required", new String[]{"Name"});
            success &= false;
        }
        if (budget.getEndDate() == null) {
            GlobalVariables.getMessageMap().putError(event.getErrorPathPrefix(), "error.budgetVersion.endDate.required", new String[]{"Name"});
            success &= false;
        }
        return success;
    }
}

