/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.calculator.BudgetCalculationService;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.lookup.keyvalue.BudgetCategoryTypeValuesFinder;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonService;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.HierarchyPersonnelSummary;
import org.kuali.kra.budget.personnel.PersonRolodex;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.service.BudgetLockService;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularService;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetPrintService;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetSubAwardService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.ProposalHierarcyActionHelper;
import org.kuali.kra.proposaldevelopment.service.ProposalStatusService;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.web.struts.action.BudgetActionBase;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentAuditEvent;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class BudgetAction
extends BudgetActionBase {
    private static final Log LOG = LogFactory.getLog(BudgetAction.class);
    private static final String DOCUMENT_REJECT_QUESTION = "DocReject";
    protected static final String CONFIRM_SYNCH_BUDGET_RATE = "confirmSynchBudgetRate";
    protected static final String NO_SYNCH_BUDGET_RATE = "noSynchBudgetRate";
    protected static final String CONFIRM_SYNCH_AWARD_RATES = "confirmSynchAwardRates";
    protected static final String NO_SYNCH_AWARD_RATES = "noSynchAwardRates";
    private ProposalHierarcyActionHelper hierarchyHelper;

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.docHandler(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        if ("initiate".equals(budgetForm.getCommand())) {
            budgetForm.getBudgetDocument().initialize();
        } else {
            budgetForm.initialize();
        }
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        if (budgetDocument.isBudgetDeleted()) {
            return mapping.findForward("deleted");
        }
        Budget budget = budgetDocument.getBudget();
        this.copyLineItemToPersonnelDetails(budgetDocument);
        if (budget.getActivityTypeCode().equals("x")) {
            budget.setActivityTypeCode(((BudgetService)KraServiceLocator.getService(BudgetService.class)).getActivityTypeForBudget(budgetDocument));
        }
        if (budget.getOhRateClassCode() != null && (BudgetForm)KNSGlobalVariables.getKualiForm() != null) {
            ((BudgetForm)KNSGlobalVariables.getKualiForm()).setOhRateClassCodePrevValue(budget.getOhRateClassCode());
        }
        if (budget.getUrRateClassCode() != null && (BudgetForm)KNSGlobalVariables.getKualiForm() != null) {
            ((BudgetForm)KNSGlobalVariables.getKualiForm()).setUrRateClassCodePrevValue(budget.getUrRateClassCode());
        }
        if (this.isAwardBudget(budgetDocument) && StringUtils.isNotBlank((String)budgetForm.getSyncBudgetRate()) && budgetForm.getSyncBudgetRate().equals("Y")) {
            this.getBudgetRatesService().syncParentDocumentRates(budgetDocument);
            this.getBudgetCommonService(budgetDocument.getParentDocument()).recalculateBudget(budget);
        }
        this.reconcileBudgetStatus(budgetForm);
        if ("Personnel".equals(budgetForm.getActivePanelName())) {
            forward = this.personnel(mapping, (ActionForm)budgetForm, request, response);
        }
        return forward;
    }

    protected StrutsConfirmation syncAwardBudgetRateConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String message) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNCH_AWARD_RATES, message, new String[]{""});
    }

    public ActionForward confirmSynchAwardRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchAwardBudgetRate(mapping, form, request, response, true);
    }

    public ActionForward noSynchAwardRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.synchAwardBudgetRate(mapping, form, request, response, false);
    }

    private ActionForward synchAwardBudgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean confirm) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        BudgetParentDocument pdDoc = budgetDoc.getParentDocument();
        String routeHeaderId = budgetDoc.getDocumentHeader().getWorkflowDocument().getDocumentId();
        String forward = this.buildForwardUrl(routeHeaderId);
        if (confirm) {
            forward = forward.replace("awardBudgetParameters.do?", "awardBudgetParameters.do?syncBudgetRate=Y&");
        }
        return new ActionForward(forward, true);
    }

    protected boolean isAwardBudget(BudgetDocument budgetDocument) {
        return !Boolean.parseBoolean(budgetDocument.getParentDocument().getProposalBudgetFlag());
    }

    private BudgetRatesService<BudgetParent> getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public List<HeaderNavigation> getBudgetHeaderNavigatorList() {
        DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService((String)"dataDictionaryService");
        KNSDocumentEntry docEntry = (KNSDocumentEntry)dataDictionaryService.getDataDictionary().getDocumentEntry(BudgetDocument.class.getName());
        return docEntry.getHeaderNavigationList();
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        if (budgetForm.getMethodToCall().equals("close")) {
            this.setupDocumentExit();
        }
        ActionForward actionForward = null;
        actionForward = super.execute(mapping, (ActionForm)budgetForm, request, response);
        if (actionForward != null && "summaryTotals".equals(actionForward.getName())) {
            budgetForm.suppressButtonsForTotalPage();
        }
        if (budgetForm.isAuditActivated() && !"route".equals(((KualiForm)form).getMethodToCall())) {
            ((KualiRuleService)KraServiceLocator.getService(KualiRuleService.class)).applyRules((KualiDocumentEvent)new DocumentAuditEvent((Document)budgetForm.getBudgetDocument()));
        }
        return actionForward;
    }

    private void setAdditionalDocumentHeaderInfo(BudgetForm budgetForm) {
        assert (budgetForm != null) : "the budgetForm is null";
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        if (budget != null && parentDocument != null && parentDocument.getBudgetDocumentVersions() != null) {
            boolean setAdditionalInfo = false;
            for (BudgetDocumentVersion budgetVersion : parentDocument.getBudgetDocumentVersions()) {
                if (budgetVersion.getBudgetVersionOverview().getBudgetVersionNumber().equals(budget.getBudgetVersionNumber())) {
                    budgetForm.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.budgetName", budgetVersion.getBudgetVersionOverview().getDocumentDescription()));
                    setAdditionalInfo = true;
                    break;
                }
                budgetForm.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.budgetName", ""));
            }
            if (!setAdditionalInfo) {
                budgetForm.getDocInfo().add(new HeaderField("DataDictionary.KraAttributeReferenceDummy.attributes.budgetName", ""));
            }
            if (budget.getBudgetVersionNumber() != null) {
                budgetForm.getDocInfo().add(new HeaderField("DataDictionary.Budget.attributes.budgetVersionNumber", budget.getBudgetVersionNumber().toString()));
            } else {
                budgetForm.getDocInfo().add(new HeaderField("DataDictionary.Budget.attributes.budgetVersionNumber", ""));
            }
        }
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDoc = budgetForm.getBudgetDocument();
        this.fixDocHeaderVersion(budgetDoc);
        Budget budget = budgetDoc.getBudget();
        this.getBudgetCommonService(budgetDoc.getParentDocument()).calculateBudgetOnSave(budget);
        ActionForward forward = super.save(mapping, form, request, response);
        BudgetForm savedBudgetForm = (BudgetForm)form;
        BudgetDocument savedBudgetDoc = savedBudgetForm.getBudgetDocument();
        this.refreshBudgetDocumentVersion(savedBudgetDoc);
        this.getBusinessObjectService().save(savedBudgetDoc.getParentDocument().getBudgetDocumentVersions());
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        if (budgetForm.toBudgetVersionsPage() || "BudgetVersionsAction".equals(budgetForm.getActionName())) {
            GlobalVariables.getMessageMap().addToErrorPath("document.proposal");
            tdcValidator.validateGeneratingErrorsAndWarnings(budgetDoc.getParentDocument());
        } else {
            tdcValidator.validateGeneratingWarnings(budgetDoc.getParentDocument());
        }
        if (budgetForm.getMethodToCall().equals("save") && budgetForm.isAuditActivated()) {
            forward = mapping.findForward("budgetActions");
        }
        return forward;
    }

    private void refreshBudgetDocumentVersion(BudgetDocument savedBudgetDoc) {
        Budget budget = savedBudgetDoc.getBudget();
        for (BudgetDocumentVersion documentVersion : savedBudgetDoc.getParentDocument().getBudgetDocumentVersions()) {
            documentVersion.refreshReferenceObject("documentHeader");
            BudgetVersionOverview version = documentVersion.getBudgetVersionOverview();
            if (!budget.getBudgetVersionNumber().equals(version.getBudgetVersionNumber())) continue;
            documentVersion.refreshReferenceObject("budgetVersionOverviews");
        }
    }

    protected void fixDocHeaderVersion(BudgetDocument budgetDoc) throws WorkflowException {
        DocumentService docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument updatedDoc = (BudgetDocument)docService.getByDocumentHeaderId(budgetDoc.getDocumentNumber());
        budgetDoc.getDocumentHeader().setVersionNumber(updatedDoc.getDocumentHeader().getVersionNumber());
        for (int i = 0; i < budgetDoc.getParentDocument().getBudgetDocumentVersions().size(); ++i) {
            BudgetDocumentVersion bdVersion = budgetDoc.getParentDocument().getBudgetDocumentVersion(i);
            BudgetDocumentVersion updatedVersion = updatedDoc.getParentDocument().getBudgetDocumentVersion(i);
            if (bdVersion == null || updatedVersion == null || bdVersion.getDocumentHeader().getVersionNumber() >= updatedVersion.getDocumentHeader().getVersionNumber()) continue;
            bdVersion.getDocumentHeader().setVersionNumber(updatedVersion.getDocumentHeader().getVersionNumber());
        }
    }

    protected BudgetSummaryService getBudgetSummaryService() {
        return (BudgetSummaryService)KraServiceLocator.getService(BudgetSummaryService.class);
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        this.updateBudgetAttributes(form, request);
        return forward;
    }

    public ActionForward reloadWithoutWarning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reloadWithoutWarning(mapping, form, request, response);
        this.updateBudgetAttributes(form, request);
        return forward;
    }

    protected void updateBudgetAttributes(ActionForm form, HttpServletRequest request) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        budgetForm.setFinalBudgetVersion(this.getFinalBudgetVersion(parentDocument.getBudgetDocumentVersions()));
        this.setBudgetStatuses(budgetDocument.getParentDocument());
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        tdcValidator.validateGeneratingWarnings(budgetDocument.getParentDocument());
        this.populateBudgetPrintForms(budgetDocument.getBudget());
    }

    public ActionForward versions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
        budgetForm.setFinalBudgetVersion(this.getFinalBudgetVersion(parentDocument.getBudgetDocumentVersions()));
        this.setBudgetStatuses(parentDocument);
        return mapping.findForward("versions");
    }

    public ActionForward parameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.reconcileBudgetStatus((BudgetForm)form);
        BudgetDocument budgetDocument = ((BudgetForm)form).getBudgetDocument();
        this.getBudgetSummaryService().setupOldStartEndDate(budgetDocument.getBudget(), false);
        return mapping.findForward("parameters");
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        this.populatePersonnelHierarchySummary(budgetForm);
        this.populatePersonnelCategoryTypeCodes(budgetForm);
        if (budgetForm.getBudgetDocument().getBudget().getBudgetPersons().isEmpty()) {
            ((BudgetPersonService)KraServiceLocator.getService(BudgetPersonService.class)).synchBudgetPersonsToProposal(budgetForm.getBudgetDocument().getBudget());
        }
        this.reconcilePersonnelRoles(budgetForm.getBudgetDocument());
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : period.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                    ObjectUtils.materializeObjects((Collection)budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts());
                    for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                        if (budgetPersonnelCalculatedAmount.getRateClass() != null) continue;
                        budgetPersonnelCalculatedAmount.refreshReferenceObject("rateClass");
                    }
                }
                for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (lineItemCalculatedAmount.getRateClass() != null) continue;
                    lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                }
            }
        }
        ParameterService parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        String enableBudgetSalaryByPeriod = parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "enableBudgetCalculatedSalary");
        budgetForm.setEnableBudgetSalaryByPeriod(enableBudgetSalaryByPeriod);
        return mapping.findForward("personnel");
    }

    protected void populatePersonnelHierarchySummary(BudgetForm budgetForm) {
        if (Boolean.valueOf(budgetForm.getBudgetDocument().getParentDocument().getProposalBudgetFlag()).booleanValue()) {
            ProposalDevelopmentDocument parentDocument = (ProposalDevelopmentDocument)budgetForm.getBudgetDocument().getParentDocument();
            String proposalNumber = parentDocument.getDevelopmentProposal().getProposalNumber();
            budgetForm.setHierarchyPersonnelSummaries(this.getHierarchyHelper().getHierarchyPersonnelSummaries(proposalNumber));
            for (HierarchyPersonnelSummary hierarchyPersonnelSummary : budgetForm.getHierarchyPersonnelSummaries()) {
                for (Budget budget : hierarchyPersonnelSummary.getHierarchyBudgets()) {
                    this.reconcilePersonnelRoles(budget.getBudgetDocument());
                }
            }
        }
    }

    private String getPersonnelBudgetCategoryTypeCode() {
        return this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetCategoryType.personnel");
    }

    protected void populatePersonnelCategoryTypeCodes(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        ArrayList<KeyValue> budgetCategoryTypes = new ArrayList<KeyValue>();
        String personnelBudgetCategoryTypeCode = this.getPersonnelBudgetCategoryTypeCode();
        for (KeyValue budgetCategoryType : budgetCategoryTypeValuesFinder.getKeyValues()) {
            String budgetCategoryTypeCode = budgetCategoryType.getKey();
            if (!StringUtils.isNotBlank((String)budgetCategoryTypeCode) || !StringUtils.equalsIgnoreCase((String)budgetCategoryTypeCode, (String)personnelBudgetCategoryTypeCode)) continue;
            budgetCategoryTypes.add(budgetCategoryType);
            BudgetLineItem newBudgetLineItem = budget.getNewBudgetLineItem();
            if (budgetForm.getNewBudgetLineItems() == null) {
                budgetForm.setNewBudgetLineItems(new ArrayList());
            }
            budgetForm.getNewBudgetLineItems().add(newBudgetLineItem);
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
    }

    protected void populateNonPersonnelCategoryTypeCodes(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        ArrayList<KeyValue> budgetCategoryTypes = new ArrayList<KeyValue>();
        String personnelBudgetCategoryTypeCode = this.getPersonnelBudgetCategoryTypeCode();
        for (KeyValue budgetCategoryType : budgetCategoryTypeValuesFinder.getKeyValues()) {
            String budgetCategoryTypeCode = budgetCategoryType.getKey();
            if (!StringUtils.isNotBlank((String)budgetCategoryTypeCode) || StringUtils.equalsIgnoreCase((String)budgetCategoryTypeCode, (String)personnelBudgetCategoryTypeCode)) continue;
            budgetCategoryTypes.add(budgetCategoryType);
            BudgetLineItem newBudgetLineItem = budget.getNewBudgetLineItem();
            budgetForm.getNewBudgetLineItems().add(newBudgetLineItem);
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
    }

    public ActionForward expenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        this.populateNonPersonnelCategoryTypeCodes(budgetForm);
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        budget.refreshReferenceObject("budgetPeriods");
        return mapping.findForward("expenses");
    }

    public ActionForward rates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("rates");
    }

    public ActionForward distributionAndIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetDistributionAndIncomeService budgetDistributionAndIncomeService = (BudgetDistributionAndIncomeService)KraServiceLocator.getService(BudgetDistributionAndIncomeService.class);
        budgetDistributionAndIncomeService.initializeCollectionDefaults(((BudgetForm)form).getBudgetDocument().getBudget());
        return mapping.findForward("distributionAndIncome");
    }

    public ActionForward modularBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetModularService budgetModularService = (BudgetModularService)KraServiceLocator.getService(BudgetModularService.class);
        budgetForm.setBudgetModularSummary(budgetModularService.generateModularSummary(budgetForm.getBudgetDocument().getBudget()));
        return mapping.findForward("modularBudget");
    }

    protected void populatePersonnelRoles(BudgetDocument budgetDocument) {
        BudgetParent budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        List budgetPersons = budgetDocument.getBudget().getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            ContactRole role;
            PersonRolodex person;
            String roleDesc = "";
            if (budgetPerson.getRolodexId() != null) {
                person = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId());
                role = budgetParent.getProposalNonEmployeeRole(budgetPerson.getRolodexId());
                if (role != null) {
                    roleDesc = person.getInvestigatorRoleDescription();
                    if (person != null && StringUtils.equals((String)"KP", (String)role.getRoleCode()) && StringUtils.isNotEmpty((String)person.getProjectRole())) {
                        roleDesc = person.getProjectRole();
                    }
                }
            } else if (budgetPerson.getPersonId() != null) {
                person = budgetParent.getProposalEmployee(budgetPerson.getPersonId());
                role = budgetParent.getProposalEmployeeRole(budgetPerson.getPersonId());
                if (role != null) {
                    roleDesc = person.getInvestigatorRoleDescription();
                    if (person != null && StringUtils.equals((String)"KP", (String)role.getRoleCode()) && StringUtils.isNotEmpty((String)person.getProjectRole())) {
                        roleDesc = person.getProjectRole();
                    }
                }
            }
            budgetPerson.setRole(roleDesc);
        }
    }

    public ActionForward summaryTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        this.populatePersonnelRoles(budgetDocument);
        Budget budget = budgetDocument.getBudget();
        for (BudgetPeriod period : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : period.getBudgetLineItems()) {
                for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                }
            }
        }
        budget.getBudgetTotals();
        budgetForm.setProposalHierarchyIndirectObjectCode(this.getParameterService().getParameterValueAsString(BudgetDocument.class, "proposalHierarchySubProjectIndirectCostElement"));
        return mapping.findForward("summaryTotals");
    }

    public ActionForward proposalHierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("proposalHierarchy");
    }

    public ActionForward hierarchy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        ProposalDevelopmentDocument aDoc = (ProposalDevelopmentDocument)budgetForm.getBudgetDocument().getParentDocument();
        budgetForm.setHierarchyProposalSummaries(this.getHierarchyHelper().getHierarchyProposalSummaries(aDoc.getDevelopmentProposal().getProposalNumber()));
        return mapping.findForward("hierarchy");
    }

    public ActionForward budgetActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        this.populateBudgetPrintForms(budget);
        ((BudgetSubAwardService)KraServiceLocator.getService(BudgetSubAwardService.class)).prepareBudgetSubAwards(budget);
        return mapping.findForward("budgetActions");
    }

    protected ProposalHierarcyActionHelper getHierarchyHelper() {
        if (this.hierarchyHelper == null) {
            this.hierarchyHelper = new ProposalHierarcyActionHelper();
        }
        return this.hierarchyHelper;
    }

    private void populateBudgetPrintForms(Budget budget) {
        if (budget.getBudgetPrintForms().isEmpty()) {
            BudgetPrintService budgetPrintService = (BudgetPrintService)KraServiceLocator.getService(BudgetPrintService.class);
            budgetPrintService.populateBudgetPrintForms(budget);
        }
    }

    public ActionForward returnToProposal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward forward = null;
        if (!StringUtils.equalsIgnoreCase((String)((String)budgetForm.getEditingMode().get("viewOnly")), (String)"TRUE")) {
            forward = this.save(mapping, form, request, response);
        }
        this.setupDocumentExit();
        if (forward == null || !forward.getPath().contains("questionPrompt.do")) {
            return this.getReturnToProposalForward(budgetForm);
        }
        return forward;
    }

    public ActionForward returnToAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward forward = null;
        if (!"true".equals(budgetForm.getEditingMode().get("viewOnly"))) {
            forward = this.save(mapping, form, request, response);
        }
        this.setupDocumentExit();
        if (forward == null || !forward.getPath().contains("questionPrompt.do")) {
            return this.getReturnToAwardForward(budgetForm);
        }
        return forward;
    }

    private ActionForward getReturnToAwardForward(BudgetForm budgetForm) throws Exception {
        assert (budgetForm != null) : "the form is null";
        DocumentService docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        Award award = ((AwardDocument)budgetForm.getBudgetDocument().getParentDocument()).getAward();
        String docNumber = budgetForm.getBudgetDocument().getParentDocument().getDocumentNumber();
        List versions = ((VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class)).loadVersionHistory(Award.class, award.getAwardNumber());
        for (VersionHistory version : versions) {
            if (version.getSequenceOwnerSequenceNumber() <= award.getSequenceNumber() || version.getStatus() == VersionStatus.CANCELED) continue;
            docNumber = ((Award)version.getSequenceOwner()).getAwardDocument().getDocumentNumber();
        }
        AwardDocument awardDocument = (AwardDocument)docService.getByDocumentHeaderId(docNumber);
        String forwardUrl = this.buildForwardUrl(awardDocument.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (budgetForm.isAuditActivated()) {
            forwardUrl = StringUtils.replace((String)forwardUrl, (String)"Award.do?", (String)"Actions.do?");
        }
        forwardUrl = StringUtils.replace((String)forwardUrl, (String)".do?", (String)(".do?showAllBudgetVersions=" + budgetForm.isShowAllBudgetVersions() + "&"));
        return new ActionForward(forwardUrl, true);
    }

    private ActionForward getReturnToProposalForward(BudgetForm form) throws WorkflowException {
        assert (form != null) : "the form is null";
        DocumentService docService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        String docNumber = form.getBudgetDocument().getParentDocument().getDocumentNumber();
        ProposalDevelopmentDocument pdDoc = (ProposalDevelopmentDocument)docService.getByDocumentHeaderId(docNumber);
        String forwardUrl = this.buildForwardUrl(pdDoc.getDocumentHeader().getWorkflowDocument().getDocumentId());
        if (form.isAuditActivated()) {
            forwardUrl = StringUtils.replace((String)forwardUrl, (String)"Proposal.do?", (String)"Actions.do?auditActivated=true&");
        }
        forwardUrl = forwardUrl + "&methodToCallAttribute=methodToCall.reload";
        return new ActionForward(forwardUrl, true);
    }

    public void reconcilePersonnelRoles(BudgetDocument budgetDocument) {
        Budget budget = budgetDocument.getBudget();
        BudgetParent budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        List budgetPersons = budget.getBudgetPersons();
        for (BudgetPerson budgetPerson : budgetPersons) {
            PersonRolodex person;
            if (budgetPerson.getRolodexId() != null) {
                person = budgetParent.getProposalNonEmployee(budgetPerson.getRolodexId());
                if (person == null) continue;
                budgetPerson.setRole(person.getInvestigatorRoleDescription());
                continue;
            }
            if (budgetPerson.getPersonId() == null || (person = budgetParent.getProposalEmployee(budgetPerson.getPersonId())) == null) continue;
            budgetPerson.setRole(person.getInvestigatorRoleDescription());
        }
    }

    protected void reconcileBudgetStatus(BudgetForm budgetForm) {
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetParent budgetParent = budgetDocument.getParentDocument().getBudgetParent();
        if (budgetParent instanceof DevelopmentProposal) {
            DevelopmentProposal proposal = (DevelopmentProposal)budgetParent;
            ((ProposalStatusService)KraServiceLocator.getService(ProposalStatusService.class)).loadBudgetStatus(proposal);
        }
        if (budget.getFinalVersionFlag() != null && Boolean.TRUE.equals(budget.getFinalVersionFlag())) {
            budget.setBudgetStatus(budgetParent.getBudgetStatus());
        } else {
            String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
            budget.setBudgetStatus(budgetStatusIncompleteCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamToResponse(AttachmentDataSource attachmentDataSource, HttpServletResponse response) throws Exception {
        byte[] xbts = attachmentDataSource.getContent();
        ByteArrayOutputStream baos = null;
        if (xbts != null) {
            try {
                baos = new ByteArrayOutputStream(xbts.length);
                baos.write(xbts);
                WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)attachmentDataSource.getContentType(), (ByteArrayOutputStream)baos, (String)attachmentDataSource.getFileName());
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                        baos = null;
                    }
                }
                catch (IOException ioEx) {
                    LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
                }
            }
        }
    }

    private void copyLineItemToPersonnelDetails(BudgetDocument budgetDocument) {
        for (BudgetPeriod budgetPeriod : budgetDocument.getBudget().getBudgetPeriods()) {
            if (budgetPeriod.getBudgetLineItems() == null || budgetPeriod.getBudgetLineItems().isEmpty()) continue;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                if (budgetLineItem.getBudgetPersonnelDetailsList() == null || budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) continue;
                for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    budgetPersonnelDetails.setBudgetId(budgetLineItem.getBudgetId());
                    budgetPersonnelDetails.setBudgetPeriod(budgetLineItem.getBudgetPeriod());
                    budgetPersonnelDetails.setLineItemNumber(budgetLineItem.getLineItemNumber());
                    budgetPersonnelDetails.setCostElement(budgetLineItem.getCostElement());
                    budgetPersonnelDetails.setCostElementBO(budgetLineItem.getCostElementBO());
                }
            }
        }
    }

    protected PessimisticLockService getPessimisticLockService() {
        return (PessimisticLockService)KraServiceLocator.getService(BudgetLockService.class);
    }

    public ActionForward reject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        String question = request.getParameter("questionIndex");
        String buttonClicked = request.getParameter("buttonClicked");
        String reason = request.getParameter("reason");
        String methodToCall = ((KualiForm)form).getMethodToCall();
        String questionText = "Are you sure you want to reject this document?";
        if (question == null) {
            forward = this.performQuestionWithInput(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to reject this document?", "confirmationQuestion", methodToCall, "");
        } else if (DOCUMENT_REJECT_QUESTION.equals(question) && "1".equals(buttonClicked)) {
            forward = mapping.findForward("basic");
        } else if (StringUtils.isEmpty((String)reason)) {
            String context = "";
            String errorKey = "error.budget.reject.noReason";
            String errorPropertyName = DOCUMENT_REJECT_QUESTION;
            String errorParameter = "";
            reason = reason == null ? "" : reason;
            forward = this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, DOCUMENT_REJECT_QUESTION, "Are you sure you want to reject this document?", "confirmationQuestion", methodToCall, context, reason, errorKey, errorPropertyName, errorParameter);
        } else {
            BudgetDocument document = ((BudgetForm)form).getBudgetDocument();
            document.documentHasBeenRejected(reason);
            ((KraDocumentRejectionService)KraServiceLocator.getService(KraDocumentRejectionService.class)).reject(document.getDocumentNumber(), reason, GlobalVariables.getUserSession().getPrincipalId());
            forward = super.returnToSender(request, mapping, kualiDocumentFormBase);
        }
        return forward;
    }

    protected BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance((BudgetParentDocument)parentBudgetDocument);
    }

    protected void recalculateBudgetPeriod(BudgetForm budgetForm, Budget budget, BudgetPeriod budgetPeriod) {
        this.getBudgetCommonService(budgetForm.getBudgetDocument().getParentDocument()).recalculateBudgetPeriod(budget, budgetPeriod);
    }

    protected void calculateBudgetPeriod(Budget budget, BudgetPeriod budgetPeriod) {
        this.getCalculationService().calculateBudgetPeriod(budget, budgetPeriod);
    }

    protected BudgetCalculationService getCalculationService() {
        return (BudgetCalculationService)KraServiceLocator.getService(BudgetCalculationService.class);
    }
}

