/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.award.budget.AwardBudgetForm;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.BudgetException;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationService;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationServiceImpl;
import org.kuali.kra.budget.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.action.BudgetTDCValidator;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.external.budget.BudgetAdjustmentClient;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetPrintForm;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardFiles;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardPeriodDetail;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwards;
import org.kuali.kra.proposaldevelopment.budget.bo.BudgetSubAwardsRule;
import org.kuali.kra.proposaldevelopment.budget.bo.ProposalDevelopmentBudgetExt;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetPrintService;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetSubAwardService;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class BudgetActionsAction
extends BudgetAction
implements AuditModeAction {
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String XML_FILE_EXTENSION = "xml";
    private static final String CONTENT_TYPE_PDF = "application/pdf";
    private static final String SUBAWARD_BUDGET_EDIT_LINE_STARTER = "document.budget.budgetSubAwards[";
    private static final String SUBAWARD_BUDGET_EDIT_LINE_ENDER = "]";
    private static final String UPDATE_COST_LIMITS_QUESTION = "UpdateCostLimitsQuestion";
    private BudgetJustificationService budgetJustificationService;
    private BudgetSubAwardService budgetSubAwardService;
    private static final Log LOG = LogFactory.getLog(BudgetActionsAction.class);
    private BudgetAdjustmentClient budgetAdjustmentClient = null;

    public BudgetActionsAction() {
        this.setBudgetJustificationService((BudgetJustificationService)new BudgetJustificationServiceImpl());
    }

    public ActionForward consolidateExpenseJustifications(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        try {
            this.budgetJustificationService.consolidateExpenseJustifications(budget, this.getBudgetJusticationWrapper(form));
        }
        catch (BudgetException exc) {
            GlobalVariables.getMessageMap().putError("budgetJustificationWrapper.justificationText", "error.custom", new String[]{"There are no line item budget justifications"});
        }
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        this.budgetJustificationService.preSave(budget, this.getBudgetJusticationWrapper(form));
        return super.save(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        for (BudgetSubAwards subAward : budgetForm.getBudgetDocument().getBudget().getBudgetSubAwards()) {
            subAward.computePeriodDetails();
        }
        return super.execute(mapping, (ActionForm)budgetForm, request, response);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        if (docForm.getDocumentActions().containsKey("canSave")) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            }
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudgetDocument().getBudget();
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                this.budgetJustificationService.preSave(budget, this.getBudgetJusticationWrapper(form));
            }
        }
        return super.close(mapping, form, request, response);
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        this.getBudgetSubAwardService().populateBudgetSubAwardAttachments(budget);
        return forward;
    }

    public ActionForward addSubAward(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards newBudgetSubAward = budgetForm.getNewSubAward();
        newBudgetSubAward.setBudgetId(budgetDocument.getBudget().getBudgetId());
        newBudgetSubAward.setSubAwardNumber(this.generateSubAwardNumber(budgetDocument));
        newBudgetSubAward.setBudgetVersionNumber(budgetDocument.getBudget().getBudgetVersionNumber());
        newBudgetSubAward.setSubAwardStatusCode(Integer.valueOf(1));
        newBudgetSubAward.getBudgetSubAwardPeriodDetails().clear();
        for (BudgetPeriod period : budgetDocument.getBudget().getBudgetPeriods()) {
            newBudgetSubAward.getBudgetSubAwardPeriodDetails().add(new BudgetSubAwardPeriodDetail(newBudgetSubAward, period));
        }
        boolean success = true;
        if (newBudgetSubAward.getNewSubAwardFile() != null) {
            String fileName = newBudgetSubAward.getNewSubAwardFile().getFileName();
            byte[] fileData = newBudgetSubAward.getNewSubAwardFile().getFileData();
            success = this.updateBudgetAttachment(budgetDocument.getBudget(), newBudgetSubAward, fileName, fileData, "newSubAward");
        }
        String contentType = newBudgetSubAward.getNewSubAwardFile().getContentType();
        if (success && contentType.equalsIgnoreCase(CONTENT_TYPE_PDF)) {
            budgetForm.setNewSubAward(new BudgetSubAwards());
            budgetDocument.getBudget().getBudgetSubAwards().add(newBudgetSubAward);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewXFD(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        subAward.refreshNonUpdateableReferences();
        if (subAward.getBudgetSubAwardFiles().isEmpty()) {
            return mapping.findForward("basic");
        }
        BudgetSubAwardFiles subAwardFiles = (BudgetSubAwardFiles)subAward.getBudgetSubAwardFiles().get(0);
        this.downloadFile(form, request, response, subAwardFiles.getSubAwardXfdFileData(), subAward.getSubAwardXfdFileName(), CONTENT_TYPE_PDF);
        return null;
    }

    public ActionForward viewXML(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        subAward.refreshNonUpdateableReferences();
        if (!subAward.getBudgetSubAwardFiles().isEmpty()) {
            BudgetSubAwardFiles subAwardFiles = (BudgetSubAwardFiles)subAward.getBudgetSubAwardFiles().get(0);
            this.downloadFile(form, request, response, subAwardFiles.getSubAwardXmlFileData().getBytes(), this.createXMLFileName(subAward), CONTENT_TYPE_XML);
        }
        return null;
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        BudgetSubAwards subAward = (BudgetSubAwards)budgetDocument.getBudget().getBudgetSubAwards().get(selectedLineNumber);
        for (BudgetPeriod period : budgetDocument.getBudget().getBudgetPeriods()) {
            Iterator iter = period.getBudgetLineItems().iterator();
            while (iter.hasNext()) {
                BudgetLineItem item = (BudgetLineItem)iter.next();
                if (!ObjectUtils.equals((Object)subAward.getSubAwardNumber(), (Object)item.getSubAwardNumber())) continue;
                iter.remove();
            }
        }
        budgetDocument.getBudget().getBudgetSubAwards().remove(selectedLineNumber);
        Collections.sort(budgetDocument.getBudget().getBudgetSubAwards());
        return mapping.findForward("basic");
    }

    public ActionForward deleteSubAwardAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        BudgetSubAwards subAward = (BudgetSubAwards)budgetDocument.getBudget().getBudgetSubAwards().get(selectedLineNumber);
        this.getBudgetSubAwardService().removeSubAwardAttachment(subAward);
        return mapping.findForward("basic");
    }

    public ActionForward updateBudgetAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        FormFile subAwardFile = subAward.getNewSubAwardFile();
        byte[] subAwardData = subAwardFile.getFileData();
        String subAwardFileName = subAwardFile.getFileName();
        this.updateBudgetAttachment(budgetDocument.getBudget(), subAward, subAwardFileName, subAwardData, SUBAWARD_BUDGET_EDIT_LINE_STARTER + this.getSelectedLine(request) + SUBAWARD_BUDGET_EDIT_LINE_ENDER);
        Collections.sort(budgetDocument.getBudget().getBudgetSubAwards());
        return mapping.findForward("basic");
    }

    public ActionForward syncFromBudgetAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetSubAwards subAward = this.getSelectedBudgetSubAward(form, request);
        String errorPath = SUBAWARD_BUDGET_EDIT_LINE_STARTER + this.getSelectedLine(request) + SUBAWARD_BUDGET_EDIT_LINE_ENDER;
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        this.updateSubAwardBudgetDetails(budgetDocument.getBudget(), subAward);
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        return mapping.findForward("basic");
    }

    protected boolean updateSubAwardBudgetDetails(Budget budget, BudgetSubAwards subAward) throws Exception {
        ArrayList errorMessages = new ArrayList();
        BudgetSubAwardsRule rule = new BudgetSubAwardsRule(subAward);
        boolean success = true;
        if (subAward.getNewSubAwardFile().getFileData().length == 0) {
            success = false;
        }
        if (rule.processXFDAttachment()) {
            success = this.getBudgetSubAwardService().updateSubAwardBudgetDetails(budget, subAward, errorMessages);
        }
        if (!errorMessages.isEmpty()) {
            for (String[] message : errorMessages) {
                String[] messageParameters = null;
                if (message.length > 1) {
                    messageParameters = Arrays.copyOfRange(message, 1, message.length);
                }
                if (success) {
                    GlobalVariables.getMessageMap().putWarning("subAwardFile", message[0], messageParameters);
                    continue;
                }
                GlobalVariables.getMessageMap().putError("subAwardFile", message[0], messageParameters);
            }
        }
        if (success && errorMessages.isEmpty() && rule.processNonXFDAttachment()) {
            GlobalVariables.getMessageMap().putInfo("subAwardFile", "newSubAward.subAwardFile.detailsUpdated", new String[0]);
        }
        return success;
    }

    protected boolean updateBudgetAttachment(Budget budget, BudgetSubAwards subAward, String fileName, byte[] fileData, String errorPath) throws Exception {
        GlobalVariables.getMessageMap().addToErrorPath(errorPath);
        subAward.setSubAwardXmlFileData(null);
        subAward.setFormName(null);
        subAward.setNamespace(null);
        if (subAward.getNewSubAwardFile().getContentType().equalsIgnoreCase(CONTENT_TYPE_PDF)) {
            this.getBudgetSubAwardService().populateBudgetSubAwardFiles(budget, subAward, fileName, fileData);
        }
        boolean success = this.updateSubAwardBudgetDetails(budget, subAward);
        BudgetSubAwardsRule rule = new BudgetSubAwardsRule(subAward);
        if ((success &= rule.processXFDAttachment()) && rule.checkSpecialCharacters(subAward.getSubAwardXmlFileData().toString())) {
            ((BudgetSubAwardFiles)subAward.getBudgetSubAwardFiles().get(0)).setSubAwardXmlFileData(((KcAttachmentService)KraServiceLocator.getService(KcAttachmentService.class)).checkAndReplaceSpecialCharacters(((BudgetSubAwardFiles)subAward.getBudgetSubAwardFiles().get(0)).getSubAwardXmlFileData().toString()));
            subAward.setSubAwardXmlFileData(((BudgetSubAwardFiles)subAward.getBudgetSubAwardFiles().get(0)).getSubAwardXmlFileData());
        }
        GlobalVariables.getMessageMap().removeFromErrorPath(errorPath);
        if (rule.processNonXFDAttachment()) {
            success = rule.processNonXFDAttachment();
        }
        return success;
    }

    protected ErrorMessage convertStringArrayToErrorMessage(String[] message) {
        ErrorMessage error = new ErrorMessage();
        error.setErrorKey(message[0]);
        if (message.length > 1) {
            error.setMessageParameters(Arrays.copyOfRange(message, 1, message.length - 1));
        }
        return error;
    }

    public ActionForward printBudgetForm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AttachmentDataSource dataStream;
        String[] forms;
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        Integer selectedLine = this.getSelectedLine(request);
        String budgetFormToPrint = ((BudgetPrintForm)budget.getBudgetPrintForms().get(selectedLine)).getBudgetReportId();
        if (budgetForm.getSelectedToPrintComment() != null && budgetFormToPrint != null && (forms = budgetForm.getSelectedToPrintComment())[0].equals(budgetFormToPrint)) {
            budget.setPrintBudgetCommentFlag("true");
        }
        budgetForm.setSelectedToPrintComment(null);
        BudgetPrintService budgetPrintService = (BudgetPrintService)KraServiceLocator.getService(BudgetPrintService.class);
        ActionForward forward = mapping.findForward("basic");
        if (budgetFormToPrint != null && (dataStream = budgetPrintService.readBudgetPrintStream(budget, budgetFormToPrint)).getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public void setBudgetJustificationService(BudgetJustificationService budgetJustificationService) {
        this.budgetJustificationService = budgetJustificationService;
    }

    private String createXMLFileName(BudgetSubAwards subAward) {
        return subAward.getSubAwardXfdFileName().substring(0, subAward.getSubAwardXfdFileName().lastIndexOf(".") + 1) + XML_FILE_EXTENSION;
    }

    private Integer generateSubAwardNumber(BudgetDocument budgetDocument) {
        return budgetDocument.getHackedDocumentNextValue("subAwardNumber") != null ? budgetDocument.getHackedDocumentNextValue("subAwardNumber") : 1;
    }

    private BudgetDocument getDocument(ActionForm form) {
        return ((BudgetForm)form).getBudgetDocument();
    }

    private BudgetJustificationWrapper getBudgetJusticationWrapper(ActionForm form) {
        return ((BudgetForm)form).getBudgetJustification();
    }

    private BudgetSubAwards getSelectedBudgetSubAward(ActionForm form, HttpServletRequest request) {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int selectedLineNumber = this.getSelectedLine(request);
        return (BudgetSubAwards)budget.getBudgetSubAwards().get(selectedLineNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(ActionForm form, HttpServletRequest request, HttpServletResponse response, byte[] bytesToDownload, String fileName, String contentType) throws Exception {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(bytesToDownload.length);
            baos.write(bytesToDownload);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)contentType, (ByteArrayOutputStream)baos, (String)fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.warn((Object)ioEx.getMessage(), (Throwable)ioEx);
            }
        }
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        Award currentAward = this.getAwardBudgetService().getActiveOrNewestAward(((AwardDocument)awardBudgetDocument.getParentDocument()).getAward().getAwardNumber());
        BudgetDecimal newCostLimit = this.getAwardBudgetService().getTotalCostLimit(currentAward.getAwardDocument());
        if (!newCostLimit.equals((Object)awardBudgetDocument.getBudget().getTotalCostLimit()) || !this.limitsMatch(currentAward.getAwardBudgetLimits(), awardBudgetDocument.getAwardBudget().getAwardBudgetLimits())) {
            String question = request.getParameter("questionIndex");
            String buttonClicked = request.getParameter("buttonClicked");
            String methodToCall = ((KualiForm)form).getMethodToCall();
            if (question == null) {
                ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
                return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, UPDATE_COST_LIMITS_QUESTION, "document.question.totalCostLimit.changed", new String[0]), methodToCall, methodToCall);
            }
            if (UPDATE_COST_LIMITS_QUESTION.equals(question) && "0".equals(buttonClicked)) {
                this.getAwardBudgetService().setBudgetLimits(awardBudgetDocument, currentAward.getAwardDocument());
                return mapping.findForward("basic");
            }
        }
        ((AwardBudgetForm)form).setAuditActivated(true);
        AuditActionHelper.ValidationState state = new AuditActionHelper().isValidSubmission((KualiDocumentFormBase)((AwardBudgetForm)form), true);
        if (state != AuditActionHelper.ValidationState.ERROR) {
            this.getAwardBudgetService().processSubmision(awardBudgetDocument);
            return super.route(mapping, form, request, response);
        }
        GlobalVariables.getMessageMap().clearErrorMessages();
        GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
        return mapping.findForward("basic");
    }

    protected boolean limitsMatch(List<AwardBudgetLimit> awardLimits, List<AwardBudgetLimit> budgetLimits) {
        if (awardLimits.size() < budgetLimits.size()) {
            return false;
        }
        for (AwardBudgetLimit limit : awardLimits) {
            AwardBudgetLimit budgetLimit = this.getBudgetLimit(limit.getLimitType(), budgetLimits);
            if (ObjectUtils.equals((Object)limit.getLimit(), (Object)budgetLimit.getLimit())) continue;
            return false;
        }
        return true;
    }

    protected AwardBudgetLimit getBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type, List<AwardBudgetLimit> budgetLimits) {
        for (AwardBudgetLimit limit : budgetLimits) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    private AwardBudgetService getAwardBudgetService() {
        return (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        boolean success = this.isValidForSubmission(awardBudgetDocument);
        ActionForward actionForward = super.approve(mapping, form, request, response);
        this.getAwardBudgetService().processApproval(awardBudgetDocument);
        return actionForward;
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        boolean auditPassed = new AuditActionHelper().auditUnconditionally((Document)awardBudgetDocument);
        this.getAwardBudgetService().processDisapproval(awardBudgetDocument);
        return super.disapprove(mapping, form, request, response);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        WorkflowDocument workflowDoc = awardBudgetDocument.getDocumentHeader().getWorkflowDocument();
        if (workflowDoc.isEnroute() && StringUtils.equals((String)GlobalVariables.getUserSession().getPrincipalId(), (String)workflowDoc.getRoutedByPrincipalId())) {
            workflowDoc.superUserCancel("Cancelled by Routed By User");
            return mapping.findForward("basic");
        }
        return super.cancel(mapping, form, request, response);
    }

    private boolean isValidForSubmission(AwardBudgetDocument awardBudgetDocument) {
        return false;
    }

    public ActionForward postAwardBudget(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        if (this.isFinancialIntegrationOn(awardBudgetDocument)) {
            if (this.isValidForPostingToFinancialSystem(awardBudgetDocument)) {
                BudgetAdjustmentClient client = this.getBudgetAdjustmentClient();
                client.createBudgetAdjustmentDocument(awardBudgetDocument);
                if (!this.isValidForPostingToFinancialSystem(awardBudgetDocument)) {
                    this.getAwardBudgetService().post(awardBudgetDocument);
                    String docNumber = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
                    KNSGlobalVariables.getMessageList().add("message.award.budget.adjustment.budget.posted", new String[]{docNumber});
                }
            } else {
                String budgetAdjustmentDocNbr = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.budget.adjustment.document.exists", new String[]{budgetAdjustmentDocNbr});
                LOG.info((Object)"Cannot post budget. There is already a budget adjustment document linked to this budget.");
            }
            return mapping.findForward("budgetActions");
        }
        this.getAwardBudgetService().post(awardBudgetDocument);
        this.setupDocumentExit();
        return this.returnToSender(request, mapping, (KualiDocumentFormBase)((AwardBudgetForm)form));
    }

    protected BudgetAdjustmentClient getBudgetAdjustmentClient() {
        if (this.budgetAdjustmentClient == null) {
            this.budgetAdjustmentClient = (BudgetAdjustmentClient)KraServiceLocator.getService((String)"budgetAdjustmentClient");
        }
        return this.budgetAdjustmentClient;
    }

    protected boolean isValidForPostingToFinancialSystem(AwardBudgetDocument awardBudgetDocument) {
        String budgetAdjustmentDocumentNumber = awardBudgetDocument.getBudget().getBudgetAdjustmentDocumentNumber();
        return org.kuali.rice.krad.util.ObjectUtils.isNull((Object)budgetAdjustmentDocumentNumber) || StringUtils.isEmpty((String)budgetAdjustmentDocumentNumber);
    }

    protected boolean isFinancialIntegrationOn(AwardBudgetDocument awardBudgetDocument) {
        String parameterValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "FIN_SYSTEM_INTEGRATION_ON");
        return StringUtils.containsIgnoreCase((String)parameterValue, (String)"ON");
    }

    public ActionForward toggleAwardBudgetStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardBudgetDocument awardBudgetDocument = ((AwardBudgetForm)form).getAwardBudgetDocument();
        this.getAwardBudgetService().toggleStatus(awardBudgetDocument);
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = form instanceof AwardBudgetForm ? new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardBudgetForm)form), true) : new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((BudgetForm)form), true);
        return forward;
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = form instanceof AwardBudgetForm ? new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((AwardBudgetForm)form), false) : new AuditActionHelper().setAuditMode(mapping, (KualiDocumentFormBase)((BudgetForm)form), false);
        return forward;
    }

    public ActionForward budgetDistributionAndIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.distributionAndIncome(mapping, form, request, response);
    }

    public ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.parameters(mapping, form, request, response);
    }

    public ActionForward budgetExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.expenses(mapping, form, request, response);
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.personnel(mapping, form, request, response);
    }

    public ActionForward parameters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.parameters(mapping, form, request, response);
    }

    public ActionForward budgetRate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return super.rates(mapping, form, request, response);
    }

    public ActionForward syncBudgetToParent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        DevelopmentProposal childProposal = (DevelopmentProposal)budgetForm.getBudgetDocument().getParentDocument().getBudgetParent();
        this.getHierarchyHelper().syncBudgetToParent((ProposalDevelopmentBudgetExt)budgetForm.getBudgetDocument().getBudget(), childProposal, false);
        if (GlobalVariables.getMessageMap().containsMessageKey("question.hierarchy.extendDate.confirm")) {
            return this.doEndDateConfirmation(mapping, form, request, response, "syncBudgetToParent", "syncToHierarchyParentConfirm");
        }
        return mapping.findForward("basic");
    }

    private ActionForward doEndDateConfirmation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String questionId, String yesMethodName) throws Exception {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getErrorMessagesForProperty("newHierarchyChildProposalNumber");
        ArrayList<String> proposalNumbers = new ArrayList<String>();
        for (ErrorMessage error : errors) {
            if (!error.getErrorKey().equals("question.hierarchy.extendDate.confirm")) continue;
            proposalNumbers.add(error.getMessageParameters()[0]);
        }
        String proposalNumberList = StringUtils.join(proposalNumbers, (char)',');
        StrutsConfirmation question = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, questionId, "question.hierarchy.extendDate.confirm", new String[]{proposalNumberList});
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        GlobalVariables.getMessageMap().getWarningMessages().clear();
        GlobalVariables.getMessageMap().getInfoMessages().clear();
        return this.confirm(question, yesMethodName, "hierarchyActionCanceled");
    }

    public ActionForward syncBudgetToParentConfirm(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        DevelopmentProposal childProposal = (DevelopmentProposal)budgetForm.getBudgetDocument().getParentDocument().getBudgetParent();
        this.getHierarchyHelper().syncBudgetToParent((ProposalDevelopmentBudgetExt)budgetForm.getBudgetDocument().getBudget(), childProposal, true);
        return mapping.findForward("basic");
    }

    public BudgetSubAwardService getBudgetSubAwardService() {
        if (this.budgetSubAwardService == null) {
            this.budgetSubAwardService = (BudgetSubAwardService)KraServiceLocator.getService(BudgetSubAwardService.class);
        }
        return this.budgetSubAwardService;
    }

    public void setBudgetSubAwardService(BudgetSubAwardService budgetSubAwardService) {
        this.budgetSubAwardService = budgetSubAwardService;
    }

    public ActionForward budgetVersions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BudgetForm budgetForm = (BudgetForm)form;
        String headerTabCall = this.getHeaderTabDispatch(request);
        if (StringUtils.isEmpty((String)headerTabCall)) {
            budgetForm.getDocument().refreshPessimisticLocks();
        }
        BudgetTDCValidator tdcValidator = new BudgetTDCValidator(request);
        return mapping.findForward("versions");
    }
}

