/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.AddBudgetCostShareEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetProjectIncomeEvent;
import org.kuali.kra.budget.distributionincome.AddBudgetUnrecoveredFandAEvent;
import org.kuali.kra.budget.distributionincome.BudgetCostShare;
import org.kuali.kra.budget.distributionincome.BudgetDistributionAndIncomeService;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.distributionincome.BudgetUnrecoveredFandA;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class BudgetDistributionAndIncomeAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetDistributionAndIncomeAction.class);
    private BudgetDistributionAndIncomeService bdiService = (BudgetDistributionAndIncomeService)KraServiceLocator.getService(BudgetDistributionAndIncomeService.class);

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.reload(mapping, form, request, response);
        Budget budget = ((BudgetForm)form).getBudgetDocument().getBudget();
        this.bdiService.initializeCollectionDefaults(budget);
        return forward;
    }

    public ActionForward addCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetCostShare budgetCostShare = budgetForm.getNewBudgetCostShare();
        boolean passed = this.getKualiRuleService().applyRules((KualiDocumentEvent)this.createAddRuleEvent(budgetForm, budgetCostShare));
        if (passed) {
            this.setCostShareAddRowDefaults(budget, budgetCostShare);
            budget.add(budgetCostShare);
            budgetForm.setNewBudgetCostShare(new BudgetCostShare());
            LOG.debug((Object)("Added new BudgetCostShare: " + budgetCostShare));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addProjectIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetProjectIncome budgetProjectIncome = budgetForm.getNewBudgetProjectIncome();
        boolean passed = this.getKualiRuleService().applyRules((KualiDocumentEvent)this.createRuleEvent(budgetForm, budgetProjectIncome));
        if (passed) {
            budgetForm.getBudgetDocument().getBudget().add(budgetProjectIncome);
            budgetForm.setNewBudgetProjectIncome(new BudgetProjectIncome());
            LOG.debug((Object)("Added new BudgetProjectIncome: " + budgetProjectIncome));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addUnrecoveredFandA(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        BudgetUnrecoveredFandA budgetUnrecoveredFandA = budgetForm.getNewBudgetUnrecoveredFandA();
        boolean passed = this.getKualiRuleService().applyRules((KualiDocumentEvent)this.createRuleEvent(budgetForm, budgetUnrecoveredFandA));
        if (passed) {
            this.setUnrecoveredFandAAddRowDefaults(budgetDocument, budgetUnrecoveredFandA);
            budgetForm.getBudgetDocument().getBudget().add(budgetUnrecoveredFandA);
            budgetForm.setNewBudgetUnrecoveredFandA(new BudgetUnrecoveredFandA());
            LOG.debug((Object)("Added new BudgetCostShare: " + budgetUnrecoveredFandA));
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteCostShare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetCostShare(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectIncome(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetProjectIncome(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteUnrecoveredFandA(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ((BudgetForm)form).getBudgetDocument().getBudget().removeBudgetUnrecoveredFandA(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward refreshTotals(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward resetCostSharingToDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget budget = this.getDocument(form).getBudget();
        budget.getBudgetCostShares().clear();
        this.bdiService.initializeCostSharingCollectionDefaults(budget);
        return mapping.findForward("basic");
    }

    public ActionForward resetUnrecoveredFandAToDefault(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Budget budget = this.getDocument(form).getBudget();
        budget.getBudgetUnrecoveredFandAs().clear();
        this.bdiService.initializeUnrecoveredFandACollectionDefaults(budget);
        return mapping.findForward("basic");
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    private AddBudgetCostShareEvent createAddRuleEvent(BudgetForm budgetForm, BudgetCostShare budgetCostShare) {
        return new AddBudgetCostShareEvent("Add BudgetCostShare Event", "", (Document)budgetForm.getBudgetDocument(), budgetCostShare, budgetForm.getBudgetDocument());
    }

    private AddBudgetProjectIncomeEvent createRuleEvent(BudgetForm budgetForm, BudgetProjectIncome budgetProjectIncome) {
        return new AddBudgetProjectIncomeEvent("Add BudgetProjectIncome Event", "", (Document)budgetForm.getBudgetDocument(), budgetProjectIncome);
    }

    private AddBudgetUnrecoveredFandAEvent createRuleEvent(BudgetForm budgetForm, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        return new AddBudgetUnrecoveredFandAEvent("Add BudgetUnrecoveredFandA Event", "", (Document)budgetForm.getBudgetDocument(), budgetUnrecoveredFandA);
    }

    private BudgetDocument getDocument(ActionForm form) {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        return budgetDocument;
    }

    private void setCostShareAddRowDefaults(Budget budget, BudgetCostShare budgetCostShare) {
        BudgetDecimal defaultValue = BudgetDecimal.ZERO;
        if (budgetCostShare.getProjectPeriod() == null) {
            budgetCostShare.setProjectPeriod(Integer.valueOf(0));
        }
        if (budgetCostShare.getShareAmount() == null) {
            BudgetDecimal shareAmount = budgetCostShare.getProjectPeriod() == 0 ? defaultValue : budget.findCostSharingForFiscalYear(budgetCostShare.getProjectPeriod());
            budgetCostShare.setShareAmount(shareAmount);
        }
        if (budgetCostShare.getSharePercentage() == null) {
            budgetCostShare.setSharePercentage(defaultValue);
        }
    }

    private void setUnrecoveredFandAAddRowDefaults(BudgetDocument budgetDocument, BudgetUnrecoveredFandA budgetUnrecoveredFandA) {
        if (budgetUnrecoveredFandA.getFiscalYear() == null) {
            budgetUnrecoveredFandA.setFiscalYear(Integer.valueOf(0));
        }
        if (budgetUnrecoveredFandA.getAmount() == null) {
            BudgetDecimal shareAmount = budgetUnrecoveredFandA.getFiscalYear() == 0 ? BudgetDecimal.ZERO : budgetDocument.getBudget().findUnrecoveredFandAForFiscalYear(budgetUnrecoveredFandA.getFiscalYear());
            budgetUnrecoveredFandA.setAmount(shareAmount);
        }
        if (budgetUnrecoveredFandA.getApplicableRate() == null) {
            budgetUnrecoveredFandA.setApplicableRate(BudgetDecimal.ZERO);
        }
    }
}

