/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetExpenseRule;
import org.kuali.kra.budget.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.printing.BudgetPrintType;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.budget.service.BudgetPrintService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetExpensesAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetExpensesAction.class);

    public ActionForward updateBudgetPeriodView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.calculateCurrentBudgetPeriod((BudgetForm)form, false);
        return mapping.findForward("basic");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        ActionForward forward = super.execute(mapping, form, request, response);
        if (budget.getBudgetCategoryTypeCodes() == null || budget.getBudgetCategoryTypeCodes().size() == 0) {
            this.populateNonPersonnelCategoryTypeCodes(budgetForm);
        }
        if (StringUtils.isNotBlank((String)budgetForm.getActivePanelName())) {
            this.populateTabState((KualiForm)budgetForm, budgetForm.getActivePanelName());
        }
        return forward;
    }

    public ActionForward addBudgetLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Integer budgetCategoryTypeIndex = Integer.parseInt(this.getBudgetCategoryTypeIndex(request));
        BudgetLineItem newBudgetLineItem = (BudgetLineItem)budgetForm.getNewBudgetLineItems().get(budgetCategoryTypeIndex);
        Budget budget = budgetDocument.getBudget();
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        if (budgetForm.getViewBudgetPeriod() == null || StringUtils.equalsIgnoreCase((String)budgetForm.getViewBudgetPeriod().toString(), (String)"0")) {
            GlobalVariables.getMessageMap().putError("viewBudgetPeriod", "error.viewBudgetPeriod.notSelected", new String[0]);
        } else if (newBudgetLineItem.getCostElement() == null || StringUtils.equalsIgnoreCase((String)newBudgetLineItem.getCostElement(), (String)"")) {
            GlobalVariables.getMessageMap().putError("newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement", "error.costElement.notSelected", new String[0]);
        } else if (newBudgetLineItem.getCostElement() == null || StringUtils.equalsIgnoreCase((String)newBudgetLineItem.getCostElement(), (String)"")) {
            GlobalVariables.getMessageMap().putError("newBudgetLineItems[" + budgetCategoryTypeIndex + "].costElement", "error.costElement.notSelected", new String[0]);
        } else if (newBudgetLineItem.getQuantity() != null && newBudgetLineItem.getQuantity() < 0) {
            GlobalVariables.getMessageMap().putError("newBudgetLineItems[" + budgetCategoryTypeIndex + "].quantity", "error.negativeAmount", new String[]{"Quantity"});
        } else {
            HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
            primaryKeys.put("budgetId", budget.getBudgetId());
            primaryKeys.put("budgetPeriod", budgetForm.getViewBudgetPeriod().toString());
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            List budgetPeriods = budget.getBudgetPeriods();
            BudgetPeriod budgetPeriod = null;
            for (BudgetPeriod tempBudgetPeriod : budgetPeriods) {
                if (!tempBudgetPeriod.getBudgetPeriod().equals(budgetForm.getViewBudgetPeriod())) continue;
                budgetPeriod = tempBudgetPeriod;
            }
            budgetService.populateNewBudgetLineItem(newBudgetLineItem, budgetPeriod);
            budgetPeriod.getBudgetLineItems().add(newBudgetLineItem);
            this.getCalculationService().populateCalculatedAmount(budget, newBudgetLineItem);
            this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(budgetPeriod.getBudgetPeriod() - 1));
            BudgetLineItem newLineItemToAdd = budgetPeriod.getNewBudgetLineItem();
            budgetForm.getNewBudgetLineItems().set(budgetCategoryTypeIndex, newLineItemToAdd);
            this.populateTabState((KualiForm)budgetForm, budgetService.getBudgetExpensePanelName(budgetPeriod, newBudgetLineItem));
        }
        return mapping.findForward("basic");
    }

    private boolean isBudgetFormulatedCostEnabled() {
        String formulatedCostEnabled = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "enableFormulatedCostCalculation");
        return formulatedCostEnabled != null && formulatedCostEnabled.equalsIgnoreCase("Y");
    }

    private List<String> getFormulatedCostElements() {
        String formulatedCEsValue = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "formulatedCostElements");
        String[] formulatedCEs = formulatedCEsValue == null ? new String[]{} : formulatedCEsValue.split(",");
        return Arrays.asList(formulatedCEs);
    }

    public ActionForward addBudgetFormulatedCost(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetFormulatedCostDetail newBudgetFormulatedCost = budgetForm.getNewBudgetFormulatedCost();
        int lineItemNumber = this.getImagePropertyValue(request, ".budgetLineItemNumber", ".");
        int budgetPeriod = this.getImagePropertyValue(request, ".budgetPeriod", ".budgetLineItemNumber");
        if (new BudgetExpenseRule().processBudgetFormulatedCostValidations(newBudgetFormulatedCost, budgetPeriod, lineItemNumber, "newBudgetFormulatedCost")) {
            BudgetPeriod budgetPeriodBO = budget.getBudgetPeriod(budgetPeriod - 1);
            BudgetLineItem budgetLineItem = budgetPeriodBO.getBudgetLineItem(lineItemNumber);
            newBudgetFormulatedCost.setFormulatedNumber(budgetDocument.getHackedDocumentNextValue("BUDGET_FORMULATED_NUMBER"));
            newBudgetFormulatedCost.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
            this.calculateBudgetFormulatedCost(newBudgetFormulatedCost);
            budgetLineItem.getBudgetFormulatedCosts().add(newBudgetFormulatedCost);
            budgetForm.setNewBudgetFormulatedCost(new BudgetFormulatedCostDetail());
            budgetLineItem.setLineItemCost(this.getFormulatedCostsTotal(budgetLineItem));
            this.recalculateBudgetPeriod(budgetForm, budget, budgetPeriodBO);
        }
        return mapping.findForward("basic");
    }

    private BudgetDecimal getFormulatedCostsTotal(BudgetLineItem budgetLineItem) {
        List budgetFormulatedCosts = budgetLineItem.getBudgetFormulatedCosts();
        BudgetDecimal formulatedExpenses = BudgetDecimal.ZERO;
        for (BudgetFormulatedCostDetail budgetFormulatedCostDetail : budgetFormulatedCosts) {
            this.calculateBudgetFormulatedCost(budgetFormulatedCostDetail);
            formulatedExpenses = (BudgetDecimal)formulatedExpenses.add((AbstractKualiDecimal)budgetFormulatedCostDetail.getCalculatedExpenses());
        }
        return formulatedExpenses;
    }

    private int getImagePropertyValue(HttpServletRequest request, String open, String close) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)open, (String)close);
            if (StringUtils.isEmpty((String)lineNumber)) {
                return selectedLine;
            }
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    private void calculateBudgetFormulatedCost(BudgetFormulatedCostDetail budgetFormulatedCost) {
        BudgetDecimal unitCost = budgetFormulatedCost.getUnitCost();
        BudgetDecimal count = new BudgetDecimal(budgetFormulatedCost.getCount().intValue());
        BudgetDecimal frequency = new BudgetDecimal(budgetFormulatedCost.getFrequency().intValue());
        BudgetDecimal calculatedExpense = unitCost.multiply(count).multiply(frequency).setScale();
        budgetFormulatedCost.setCalculatedExpenses(calculatedExpense);
    }

    public ActionForward deleteBudgetFormulatedCost(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedLine = this.getSelectedLine(request);
        int lineItemNumber = this.getImagePropertyValue(request, ".budgetLineItemNumber", ".");
        int budgetPeriod = this.getImagePropertyValue(request, ".budgetPeriod", ".budgetLineItemNumber");
        BudgetPeriod budgetPeriodBO = budget.getBudgetPeriod(budgetPeriod - 1);
        BudgetLineItem budgetLineItem = budgetPeriodBO.getBudgetLineItem(lineItemNumber);
        budgetLineItem.getBudgetFormulatedCosts().remove(selectedLine);
        budgetLineItem.setLineItemCost(this.getFormulatedCostsTotal(budgetLineItem));
        return mapping.findForward("basic");
    }

    public ActionForward deleteBudgetLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        int sltdBudgetLineItem = this.getLineToDelete(request);
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(sltdBudgetPeriod);
        BudgetLineItem budgetLineItem = (BudgetLineItem)budgetPeriod.getBudgetLineItems().get(sltdBudgetLineItem);
        BudgetService budgetService = (BudgetService)KraServiceLocator.getService(BudgetService.class);
        if (new BudgetExpenseRule().processCheckExistBudgetPersonnelDetailsBusinessRules(budgetForm.getBudgetDocument(), (BudgetLineItem)budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItems().get(this.getLineToDelete(request)), this.getLineToDelete(request))) {
            budgetPeriod.getBudgetLineItems().remove(sltdBudgetLineItem);
            this.recalculateBudgetPeriod(budgetForm, budget, budget.getBudgetPeriod(sltdBudgetPeriod));
            this.populateTabState((KualiForm)budgetForm, budgetService.getBudgetExpensePanelName(budgetPeriod, budgetLineItem));
        }
        return mapping.findForward("basic");
    }

    protected String getSelectedBudgetCategoryType(HttpServletRequest request) {
        String selectedCategoryTypeCode = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedCategoryTypeCode = StringUtils.substringBetween((String)parameterName, (String)".budgetCategoryTypeCode", (String)".");
        }
        return selectedCategoryTypeCode;
    }

    protected String getBudgetCategoryTypeIndex(HttpServletRequest request) {
        String selectedBudgetCategoryTypeIndex = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedBudgetCategoryTypeIndex = StringUtils.substringBetween((String)parameterName, (String)".catTypeIndex", (String)".");
        }
        return selectedBudgetCategoryTypeIndex;
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        this.populateNonPersonnelCategoryTypeCodes(budgetForm);
        return actionForward;
    }

    public ActionForward calculateCurrentPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        this.calculateCurrentBudgetPeriod(budgetForm, true);
        return mapping.findForward("basic");
    }

    public ActionForward viewPersonnelSalaries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetPrintService budgetPrintService = (BudgetPrintService)KraServiceLocator.getService(BudgetPrintService.class);
        try {
            AttachmentDataSource dataStream = budgetPrintService.readBudgetPrintStream(budget, BudgetPrintType.BUDGET_SALARY_REPORT.getBudgetPrintType());
            this.streamToResponse(dataStream, response);
        }
        catch (Exception ex) {
            LOG.error((Object)"Error getting salary report", (Throwable)ex);
            return mapping.findForward("basic");
        }
        return null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        ArrayList formulatedCostElements = null;
        formulatedCostElements = this.isBudgetFormulatedCostEnabled() ? this.getFormulatedCostElements() : new ArrayList();
        int budgetPeriodIndex = -1;
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            ++budgetPeriodIndex;
            int lineItemNumber = -1;
            for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
                ++lineItemNumber;
                if (!StringUtils.equalsIgnoreCase((String)budgetLineItem.getCostElement(), (String)budgetLineItem.getCostElementBO().getCostElement())) {
                    if (formulatedCostElements.contains(budgetLineItem.getCostElement())) {
                        budgetLineItem.setFormulatedCostElementFlag(Boolean.valueOf(true));
                    }
                    budgetLineItem.refreshReferenceObject("costElementBO");
                    budgetLineItem.setBudgetCategoryCode(budgetLineItem.getCostElementBO().getBudgetCategoryCode());
                }
                if (!this.processBudgetFormulatedCostValidations(budgetLineItem, budgetPeriodIndex, lineItemNumber)) {
                    return mapping.findForward("basic");
                }
                this.calculateAndUpdateFormulatedCost(budgetLineItem);
                this.getCalculationService().updatePersonnelBudgetRate(budgetLineItem);
            }
        }
        if (new BudgetExpenseRule().processCheckLineItemDates(budgetForm.getBudgetDocument())) {
            ActionForward actionForward = super.save(mapping, form, request, response);
            budget.setBudgetLineItemDeleted(false);
            return actionForward;
        }
        return mapping.findForward("basic");
    }

    private boolean processBudgetFormulatedCostValidations(BudgetLineItem budgetLineItem, int budgetPeriodIndex, int lineItemNumber) {
        List budgetFormulatedCosts = budgetLineItem.getBudgetFormulatedCosts();
        boolean valid = true;
        int index = -1;
        String errorKey = "document.budget.budgetPeriod[" + budgetPeriodIndex + "].budgetLineItem[" + lineItemNumber + "].";
        for (BudgetFormulatedCostDetail budgetFormulatedCostDetail : budgetFormulatedCosts) {
            valid &= new BudgetExpenseRule().processBudgetFormulatedCostValidations(budgetFormulatedCostDetail, budgetPeriodIndex, lineItemNumber, errorKey + "budgetFormulatedCosts[" + ++index + "]");
        }
        return valid;
    }

    private void calculateAndUpdateFormulatedCost(BudgetLineItem budgetLineItem) {
        BudgetDecimal formulatedCostTotal;
        if (budgetLineItem.getFormulatedCostElementFlag().booleanValue() && (formulatedCostTotal = this.getFormulatedCostsTotal(budgetLineItem)) != null) {
            budgetLineItem.setLineItemCost(formulatedCostTotal);
        }
    }

    public ActionForward syncCostLimitYes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int sltdLineItem = this.getSelectedLine(request);
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(sltdBudgetPeriod);
        if (new BudgetExpenseRule().processCheckLineItemDates(budgetPeriod, sltdLineItem)) {
            this.getCalculationService().syncToPeriodCostLimit(budget, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem));
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncDirectCostLimitYes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int sltdLineItem = this.getSelectedLine(request);
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(sltdBudgetPeriod);
        if (new BudgetExpenseRule().processCheckLineItemDates(budgetPeriod, sltdLineItem)) {
            this.getCalculationService().syncToPeriodDirectCostLimit(budget, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem));
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncToPeriodCostLimit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int sltdBudgetPeriod;
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1);
        if (budgetPeriod.getTotalCost().isGreaterThan((AbstractKualiDecimal)budgetPeriod.getTotalCostLimit())) {
            return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "syncCostLimitYes", "confirmation.periodTotal.greaterThan.costLimit", new String[0]), "syncCostLimitYes", "");
        }
        return this.syncCostLimitYes(mapping, form, request, response);
    }

    public ActionForward syncToPeriodDirectCostLimit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int sltdBudgetPeriod;
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1);
        if (budgetPeriod.getTotalDirectCost().isGreaterThan((AbstractKualiDecimal)budgetPeriod.getDirectCostLimit())) {
            return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "syncDirectCostLimitYes", "confirmation.periodTotalDirectCost.greaterThan.costLimit", new String[0]), "syncDirectCostLimitYes", "");
        }
        return this.syncDirectCostLimitYes(mapping, form, request, response);
    }

    public ActionForward applyToLaterPeriods(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int sltdLineItem = this.getSelectedLine(request);
        int sltdBudgetPeriod = budgetForm.getViewBudgetPeriod() - 1;
        BudgetExpenseRule budgetExpenseRule = new BudgetExpenseRule();
        if (budgetExpenseRule.processApplyToLaterPeriodsWithPersonnelDetails(budgetForm.getBudgetDocument(), budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem), sltdLineItem) && budgetExpenseRule.processCheckLineItemDates(budget.getBudgetPeriod(sltdBudgetPeriod), sltdLineItem)) {
            this.getCalculationService().applyToLaterPeriods(budget, budget.getBudgetPeriod(sltdBudgetPeriod), budget.getBudgetPeriod(sltdBudgetPeriod).getBudgetLineItem(sltdLineItem));
        }
        return mapping.findForward("basic");
    }

    private void calculateCurrentBudgetPeriod(BudgetForm budgetForm, boolean forceCalculation) {
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        int selectedPeriod = budgetForm.getViewBudgetPeriod();
        BudgetPeriod budgetPeriod = budget.getBudgetPeriod(selectedPeriod - 1);
        budgetPeriod.setBudget(budget);
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            this.getCalculationService().updatePersonnelBudgetRate(budgetLineItem);
            if (!budgetLineItem.getFormulatedCostElementFlag().booleanValue()) continue;
            this.calculateAndUpdateFormulatedCost(budgetLineItem);
        }
        if (new BudgetExpenseRule().processCheckLineItemDates(budgetForm.getBudgetDocument())) {
            if (forceCalculation) {
                this.recalculateBudgetPeriod(budgetForm, budget, budgetPeriod);
            } else {
                this.calculateBudgetPeriod(budget, budgetPeriod);
            }
        }
    }
}

