/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularService;
import org.kuali.kra.proposaldevelopment.budget.modular.SyncModularBudgetEvent;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class BudgetModularBudgetAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetModularBudgetAction.class);
    private static final String CONFIRM_SYNC_BUDGET_MODULAR = "confirmSyncBudgetModular";

    public ActionForward updateView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        this.generateModularPeriod(budgetForm);
        return mapping.findForward("basic");
    }

    public ActionForward add(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        BudgetModularIdc newBudgetModularIdc = budgetForm.getNewBudgetModularIdc();
        newBudgetModularIdc.setRateNumber(budgetDocument.getHackedDocumentNextValue("rateNumber"));
        newBudgetModularIdc.calculateFundsRequested();
        BudgetModular budgetModular = ((BudgetPeriod)budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1)).getBudgetModular();
        budgetModular.addNewBudgetModularIdc(newBudgetModularIdc);
        this.generateModularPeriod(budgetForm);
        budgetForm.setNewBudgetModularIdc(new BudgetModularIdc());
        return mapping.findForward("basic");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetModular budgetModular = ((BudgetPeriod)budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1)).getBudgetModular();
        budgetModular.getBudgetModularIdcs().remove(this.getLineToDelete(request));
        this.generateModularPeriod(budgetForm);
        return mapping.findForward("basic");
    }

    public ActionForward recalculate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        if (!budgetForm.getModularSelectedPeriod().equals(0)) {
            this.generateModularPeriod(budgetForm);
        }
        return mapping.findForward("basic");
    }

    public ActionForward sync(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean passed = this.getKualiRuleService().applyRules((KualiDocumentEvent)this.createSyncModularBudgetEvent(((BudgetForm)form).getBudgetDocument()));
        if (passed) {
            return this.confirm(this.buildSyncBudgetModularConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_BUDGET_MODULAR, "");
        }
        return mapping.findForward("basic");
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.reload(mapping, form, request, response);
        this.generateModularPeriod((BudgetForm)form);
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.save(mapping, form, request, response);
        this.generateModularPeriod((BudgetForm)form);
        return mapping.findForward("basic");
    }

    public ActionForward confirmSyncBudgetModular(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_BUDGET_MODULAR.equals(question)) {
            BudgetModularService budgetModularService = (BudgetModularService)KraServiceLocator.getService(BudgetModularService.class);
            BudgetForm budgetForm = (BudgetForm)form;
            Budget budget = budgetForm.getBudgetDocument().getBudget();
            budgetModularService.synchModularBudget(budget);
            budgetForm.setBudgetModularSummary(budgetModularService.generateModularSummary(budget));
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildSyncBudgetModularConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_BUDGET_MODULAR, "document.question.syncBudgetModular.text", new String[]{""});
    }

    private void generateModularPeriod(BudgetForm budgetForm) {
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        BudgetModularService budgetModularService = (BudgetModularService)KraServiceLocator.getService(BudgetModularService.class);
        if (budgetForm.getModularSelectedPeriod().equals(0)) {
            budgetForm.setBudgetModularSummary(budgetModularService.generateModularSummary(budget));
            return;
        }
        BudgetPeriod budgetPeriod = (BudgetPeriod)budget.getBudgetPeriods().get(budgetForm.getModularSelectedPeriod() - 1);
        budgetModularService.generateModularPeriod(budgetPeriod);
        budgetForm.setBudgetModularSummary(budgetModularService.generateModularSummary(budget));
    }

    protected SyncModularBudgetEvent createSyncModularBudgetEvent(BudgetDocument budgetDocument) {
        return new SyncModularBudgetEvent("SyncModularBudgetEvent", "", (Document)budgetDocument);
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }
}

