/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.List;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCommonService;
import org.kuali.kra.budget.core.BudgetCommonServiceFactory;
import org.kuali.kra.budget.core.BudgetParent;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.service.DocumentService;

public class BudgetParentActionBase
extends KraTransactionalDocumentActionBase {
    protected static final String COPY_BUDGET_PERIOD_QUESTION = "copyBudgetQuestion";
    protected static final String QUESTION_TYPE = "copyPeriodsQuestion";
    protected static final String QUESTION_TEXT = "A new version of the budget will be created based on version ";

    protected void setFinalBudgetVersion(Integer finalBudgetVersion, List<BudgetVersionOverview> budgetVersions) {
        for (BudgetVersionOverview budgetVersion : budgetVersions) {
            if (budgetVersion.getBudgetVersionNumber().equals(finalBudgetVersion)) {
                budgetVersion.setFinalVersionFlag(true);
                continue;
            }
            budgetVersion.setFinalVersionFlag(false);
        }
    }

    protected Integer getFinalBudgetVersion(List<BudgetDocumentVersion> budgetVersions) {
        for (BudgetDocumentVersion budgetVersion : budgetVersions) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            return budgetVersion.getBudgetVersionOverview().getBudgetVersionNumber();
        }
        return null;
    }

    protected void setBudgetParentStatus(BudgetParentDocument parentDocument) {
        for (BudgetDocumentVersion budgetVersion : parentDocument.getBudgetDocumentVersions()) {
            if (!budgetVersion.getBudgetVersionOverview().isFinalVersionFlag()) continue;
            parentDocument.getBudgetParent().setBudgetStatus(budgetVersion.getBudgetVersionOverview().getBudgetStatus());
            return;
        }
    }

    protected void setBudgetStatuses(BudgetParentDocument parentDocument) {
        String budgetStatusIncompleteCode = this.getParameterService().getParameterValueAsString(BudgetDocument.class, "budgetStatusIncompleteCode");
        for (BudgetDocumentVersion budgetDocumentVersion : parentDocument.getBudgetDocumentVersions()) {
            BudgetVersionOverview budgetVersion = budgetDocumentVersion.getBudgetVersionOverview();
            if (budgetVersion.isFinalVersionFlag()) {
                budgetVersion.setBudgetStatus(parentDocument.getBudgetParent().getBudgetStatus());
                continue;
            }
            budgetVersion.setBudgetStatus(budgetStatusIncompleteCode);
        }
    }

    protected void copyBudget(BudgetParentDocument budgetParentDocument, BudgetVersionOverview budgetToCopy, boolean copyPeriodOneOnly) throws WorkflowException {
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        BudgetDocument budgetDocToCopy = (BudgetDocument)documentService.getByDocumentHeaderId(budgetToCopy.getDocumentNumber());
        Budget budget = budgetDocToCopy.getBudget();
        BudgetCommonService budgetService = this.getBudgetCommonService(budgetParentDocument);
        BudgetDocument newBudgetDoc = budgetService.copyBudgetVersion(budgetDocToCopy, copyPeriodOneOnly);
        budgetParentDocument.refreshBudgetDocumentVersions();
        List budgetVersions = budgetParentDocument.getBudgetDocumentVersions();
        for (BudgetDocumentVersion budgetDocumentVersion : budgetVersions) {
            BudgetVersionOverview versionOverview = budgetDocumentVersion.getBudgetVersionOverview();
            if (versionOverview.getBudgetVersionNumber().intValue() != budget.getBudgetVersionNumber().intValue()) continue;
            versionOverview.setDescriptionUpdatable(true);
            versionOverview.setDocumentDescription(budgetToCopy.getDocumentDescription() + " " + budgetToCopy.getBudgetVersionNumber() + " copy");
        }
    }

    private BudgetCommonService<BudgetParent> getBudgetCommonService(BudgetParentDocument parentBudgetDocument) {
        return BudgetCommonServiceFactory.createInstance((BudgetParentDocument)parentBudgetDocument);
    }

    protected void populateTabState(KualiForm form, String tabTitle) {
        form.getTabStates().put(WebUtils.generateTabKey((String)tabTitle), "OPEN");
    }
}

