/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.lookup.keyvalue.BudgetCategoryTypeValuesFinder;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelBudgetService;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class BudgetPersonnelBudgetAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetPersonnelBudgetAction.class);

    public ActionForward updatePersonnelBudgetView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("personnelBudget");
    }

    public ActionForward addBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetPersonnelDetails newBudgetPersonnelDetails = budgetForm.getNewBudgetPersonnelDetails();
        boolean errorFound = false;
        if (newBudgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (newBudgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (newBudgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)newBudgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        if (StringUtils.isBlank((String)budgetForm.getNewBudgetPersonnelDetails().getPeriodTypeCode())) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.periodTypeCode", "error.required", new String[]{"Period Type (Period Type)"});
            errorFound = true;
        }
        if (budgetForm.getNewBudgetPersonnelDetails().getPersonSequenceNumber() == null) {
            GlobalVariables.getMessageMap().putError("newBudgetPersonnelDetails.personSequenceNumber", "error.required", new String[]{"Person (Person)"});
            errorFound = true;
        }
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        if (!errorFound) {
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = (BudgetPersonnelBudgetService)KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
            for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
                if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
                uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
                ++qty;
            }
            budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
            this.updatePersonnelBudgetRate(budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex));
            this.getCalculationService().calculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        }
        return mapping.findForward("basic");
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        ActionForward actionForward = super.reload(mapping, form, request, response);
        BusinessObjectService bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("budgetId", budget.getBudgetId());
        Collection budgetPersons = bos.findMatching(BudgetPerson.class, queryMap);
        budget.setBudgetPersons(budgetPersons == null ? new ArrayList() : (List)budgetPersons);
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        List budgetCategoryTypes = new ArrayList();
        budgetCategoryTypes = budgetCategoryTypeValuesFinder.getKeyValues();
        for (int i = 0; i < budgetCategoryTypes.size(); ++i) {
            budgetForm.getNewBudgetLineItems().add(budget.getNewBudgetLineItem());
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
        return actionForward;
    }

    public ActionForward deleteBudgetPersonnelDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetPersonnelBudgetService budgetPersonnelBudgetService = (BudgetPersonnelBudgetService)KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
        budgetPersonnelBudgetService.deleteBudgetPersonnelDetails(budget, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getLineToDelete(request));
        HashMap<Integer, String> uniqueBudgetPersonnelCount = new HashMap<Integer, String>();
        int qty = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).getBudgetPersonnelDetailsList()) {
            if (uniqueBudgetPersonnelCount.containsValue(budgetPersonnelDetails.getPersonId())) continue;
            uniqueBudgetPersonnelCount.put(qty, budgetPersonnelDetails.getPersonId());
            ++qty;
        }
        budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex).setQuantity(new Integer(qty));
        this.getCalculationService().calculateBudgetPeriod(budget, budget.getBudgetPeriod(selectedBudgetPeriodIndex));
        return mapping.findForward("basic");
    }

    public ActionForward returnToExpenses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (errorFound) {
            return mapping.findForward("basic");
        }
        this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
        BudgetCategoryTypeValuesFinder budgetCategoryTypeValuesFinder = new BudgetCategoryTypeValuesFinder();
        List budgetCategoryTypes = new ArrayList();
        budgetCategoryTypes = budgetCategoryTypeValuesFinder.getKeyValues();
        for (int i = 0; i < budgetCategoryTypes.size(); ++i) {
            budgetForm.getNewBudgetLineItems().add(budget.getNewBudgetLineItem());
        }
        budget.setBudgetCategoryTypeCodes(budgetCategoryTypes);
        request.setAttribute("fromPersonnelBudget" + budgetForm.getViewBudgetPeriod() + "" + selectedBudgetLineItemIndex, (Object)true);
        return mapping.findForward("expenses");
    }

    public ActionForward calculateLineItem(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
                errorFound = true;
            }
            if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
                errorFound = true;
            }
            if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)budgetPersonnelDetails.getPercentEffort())) {
                GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + k + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
                errorFound = true;
            }
            errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (!errorFound) {
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
        }
        return mapping.findForward("basic");
    }

    public ActionForward calculateSalary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        BudgetPersonnelDetails budgetPersonnelDetails = (BudgetPersonnelDetails)selectedBudgetLineItem.getBudgetPersonnelDetailsList().get(this.getLineToDelete(request));
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        if (budgetPersonnelDetails.getPercentEffort().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentEffort", "error.percentage", new String[]{"Percent Effort"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)new BudgetDecimal(100))) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentCharged", "error.percentage", new String[]{"Percent Charged"});
            errorFound = true;
        }
        if (budgetPersonnelDetails.getPercentCharged().isGreaterThan((AbstractKualiDecimal)budgetPersonnelDetails.getPercentEffort())) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + this.getLineToDelete(request) + "].percentCharged", "error.percentEffort.lessThan.percentCharged", new String[0]);
            errorFound = true;
        }
        boolean bl = errorFound = errorFound || this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, this.getLineToDelete(request));
        if (!errorFound) {
            BudgetPersonnelBudgetService budgetPersonnelBudgetService = (BudgetPersonnelBudgetService)KraServiceLocator.getService(BudgetPersonnelBudgetService.class);
            budgetPersonnelBudgetService.calculateBudgetPersonnelBudget(budget, selectedBudgetLineItem, budgetPersonnelDetails, this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        int selectedBudgetPeriodIndex = budgetForm.getViewBudgetPeriod() - 1;
        int selectedBudgetLineItemIndex = budgetForm.getSelectedBudgetLineItemIndex();
        BudgetLineItem selectedBudgetLineItem = budget.getBudgetPeriod(selectedBudgetPeriodIndex).getBudgetLineItem(selectedBudgetLineItemIndex);
        int k = 0;
        boolean errorFound = false;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        for (BudgetPersonnelDetails budgetPersonnelDetails : selectedBudgetLineItem.getBudgetPersonnelDetailsList()) {
            errorFound |= this.personnelDatesCheck(selectedBudgetLineItem, budgetPersonnelDetails, selectedBudgetPeriodIndex, selectedBudgetLineItemIndex, k);
            ++k;
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        if (errorFound) {
            this.getCalculationService().calculateBudgetLineItem(budget, selectedBudgetLineItem);
            return mapping.findForward("basic");
        }
        ActionForward actionForward = super.save(mapping, form, request, response);
        selectedBudgetLineItem.setBudgetPersonnelLineItemDeleted(false);
        return actionForward;
    }

    private boolean personnelDatesCheck(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersonnelDetails, int selectedBudgetPeriodIndex, int selectedBudgetLineItemIndex, int detailIndex) {
        boolean errorFound = false;
        if (budgetPersonnelDetails.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.dates", new String[0]);
            errorFound = true;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getEndDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be after", "end date"});
            errorFound = true;
        }
        if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getEndDate()) > 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].endDate", "error.personnel.detail.end.date", new String[]{"can not be before", "start date"});
            errorFound = true;
        }
        if (budgetLineItem.getStartDate().compareTo(budgetPersonnelDetails.getStartDate()) > 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be before", "start date"});
            errorFound = true;
        }
        if (budgetLineItem.getEndDate().compareTo(budgetPersonnelDetails.getStartDate()) < 0) {
            GlobalVariables.getMessageMap().putError("budgetPeriod[" + selectedBudgetPeriodIndex + "].budgetLineItems[" + selectedBudgetLineItemIndex + "].budgetPersonnelDetailsList[" + detailIndex + "].startDate", "error.personnel.detail.start.date", new String[]{"can not be after", "end date"});
            errorFound = true;
        }
        return errorFound;
    }

    private void updatePersonnelBudgetRate(BudgetLineItem budgetLineItem) {
        int j = 0;
        for (BudgetPersonnelDetails budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
            j = 0;
            for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : budgetPersonnelDetails.getBudgetPersonnelCalculatedAmounts()) {
                budgetPersonnelCalculatedAmount.setApplyRateFlag(((BudgetLineItemCalculatedAmount)budgetLineItem.getBudgetLineItemCalculatedAmounts().get(j)).getApplyRateFlag());
                ++j;
            }
        }
    }
}

