/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.BudgetRatesService;
import org.kuali.kra.budget.rates.RateClassType;
import org.kuali.kra.budget.web.struts.action.BudgetAction;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class BudgetRatesAction
extends BudgetAction {
    private static final Log LOG = LogFactory.getLog(BudgetRatesAction.class);
    private static final String CONFIRM_SYNC_RATES = "confirmSyncRates";
    private static final String CONFIRM_SYNC_ALL_RATES = "confirmSyncAllRates";
    private static final String CONFIRM_RESET_RATES = "confirmResetRates";
    private static final String CONFIRM_RESET_ALL_RATES = "confirmResetAllRates";
    private static final String CONFIRM_RATE_CHANGE = "confirmRateChange";
    private static final String REJECT_RATE_CHANGE = "rejectRateChange";

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        if (KNSGlobalVariables.getKualiForm() == null) {
            KNSGlobalVariables.setKualiForm((KualiForm)((KualiForm)form));
        }
        budget.setRateSynced(false);
        if (this.haveRatesBeenChanged(budget)) {
            return this.askConfirmRateChange(mapping, (ActionForm)budgetForm, request, response);
        }
        ActionForward forward = super.save(mapping, form, request, response);
        if (!budgetForm.getMethodToCall().equals("save") && budgetForm.isAuditActivated()) {
            forward = mapping.findForward("rates_save");
        }
        return forward;
    }

    public ActionForward resetRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildResetRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_RESET_RATES, "");
    }

    private StrutsConfirmation buildResetRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RESET_RATES, "document.question.resetRates.text", new String[]{""});
    }

    public ActionForward confirmResetRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RESET_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
            Budget budget = budgetDocument.getBudget();
            RateClassType rateClassT = (RateClassType)budget.getRateClassTypes().get(this.getSelectedLine(request));
            String rateClassType = rateClassT.getRateClassType();
            budget.getBudgetRatesService().resetBudgetRatesForRateClassType(rateClassType, budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward syncRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_RATES, "");
    }

    private StrutsConfirmation buildSyncRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_RATES, "document.question.syncRates.text", new String[]{""});
    }

    public ActionForward confirmSyncRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
            Budget budget = budgetDocument.getBudget();
            RateClassType rateClassT = (RateClassType)budget.getRateClassTypes().get(this.getSelectedLine(request));
            String rateClassType = rateClassT.getRateClassType();
            this.getBudgetRatesService().syncBudgetRatesForRateClassType(rateClassType, budgetDocument);
            budget.setRateClassTypesReloaded(false);
            if (rateClassType.equals("O")) {
                budget.setRateSynced(true);
            }
        }
        return mapping.findForward("basic");
    }

    private BudgetRatesService getBudgetRatesService() {
        return (BudgetRatesService)KraServiceLocator.getService(BudgetRatesService.class);
    }

    public ActionForward syncAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncAllRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_ALL_RATES, "");
    }

    private StrutsConfirmation buildSyncAllRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_ALL_RATES, "document.question.syncAllRates.text", new String[]{""});
    }

    public ActionForward confirmSyncAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SYNC_ALL_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
            Budget budget = budgetDocument.getBudget();
            budget.setRateClassTypesReloaded(true);
            budget.getBudgetRatesService().syncAllBudgetRates(budgetDocument);
            budget.setRateSynced(true);
            BudgetParentDocument parentDocument = budgetDocument.getParentDocument();
            if (!budget.getActivityTypeCode().equals(parentDocument.getBudgetParent().getActivityTypeCode())) {
                budget.setActivityTypeCode(parentDocument.getBudgetParent().getActivityTypeCode());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildResetAllRatesConfirmationQuestion(mapping, form, request, response), CONFIRM_RESET_ALL_RATES, "");
    }

    private StrutsConfirmation buildResetAllRatesConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RESET_ALL_RATES, "document.question.resetAllRates.text", new String[]{""});
    }

    public ActionForward confirmResetAllRates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_RESET_ALL_RATES.equals(question)) {
            BudgetForm budgetForm = (BudgetForm)form;
            BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
            Budget budget = budgetDocument.getBudget();
            this.getBudgetRatesService().resetAllBudgetRates(budget);
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateRatesView(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        BudgetDocument budgetDocument = budgetForm.getBudgetDocument();
        Budget budget = budgetDocument.getBudget();
        this.getBudgetRatesService().viewLocation(budgetForm.getViewLocation(), budgetForm.getViewBudgetPeriod(), budget);
        return mapping.findForward("basic");
    }

    private boolean haveRatesBeenChanged(Budget budget) {
        for (BudgetRate rate : budget.getBudgetRates()) {
            if (!rate.isRateChanged()) continue;
            return true;
        }
        return false;
    }

    public ActionForward askConfirmRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_RATE_CHANGE, "document.question.saveRates.text", new String[0]), CONFIRM_RATE_CHANGE, REJECT_RATE_CHANGE);
    }

    public ActionForward confirmRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        for (BudgetRate rate : budget.getBudgetRates()) {
            rate.setRateChanged(false);
        }
        return this.save(mapping, (ActionForm)budgetForm, request, response);
    }

    public ActionForward rejectRateChange(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BudgetForm budgetForm = (BudgetForm)form;
        Budget budget = budgetForm.getBudgetDocument().getBudget();
        for (BudgetRate rate : budget.getBudgetRates()) {
            rate.setRateChanged(false);
            rate.setExactApplicableRate(rate.getOldApplicableRate());
        }
        return mapping.findForward("basic");
    }
}

