/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.budget.web.struts.action;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.proposaldevelopment.rules.BudgetModularTotalDirectCostRule;

public class BudgetTDCValidator {
    public static final String TDC_WARNINGS_ATTRIBUTE_NAME = "budgetModularWarnings";
    private final HttpServletRequest request;

    public BudgetTDCValidator(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("the request is null.");
        }
        this.request = request;
    }

    public void validateGeneratingErrorsAndWarnings(BudgetParentDocument proposalDocument) {
        if (proposalDocument == null) {
            throw new NullPointerException("the request is null.");
        }
        BudgetModularTotalDirectCostRule tdcRule = new BudgetModularTotalDirectCostRule();
        HashSet warnings = new HashSet();
        boolean passedWithoutErrors = tdcRule.validateTotalDirectCost(proposalDocument, true, warnings);
        if (passedWithoutErrors) {
            this.request.setAttribute(TDC_WARNINGS_ATTRIBUTE_NAME, warnings);
        }
    }

    public void validateGeneratingWarnings(BudgetParentDocument proposalDocument) {
        if (proposalDocument == null) {
            throw new NullPointerException("the request is null.");
        }
        BudgetModularTotalDirectCostRule tdcRule = new BudgetModularTotalDirectCostRule();
        HashSet warnings = new HashSet();
        tdcRule.validateTotalDirectCost(proposalDocument, false, warnings);
        this.request.setAttribute(TDC_WARNINGS_ATTRIBUTE_NAME, warnings);
    }
}

